
;--- common definitions for both Jemm32 and Jemm16

ifndef ?MASM
?MASM equ 1
endif

LF				EQU 0AH
CR				EQU 0DH

?VERSIONHIGH	equ 5
?VERSIONLOW		equ 63

ifndef ?INTEGRATED
?INTEGRATED		EQU 0		; 1=integrated version (XMS + EMM)
endif
?DMA			EQU 1		; 1=enable DMA support
?VDS			EQU 1		; 1=enable VDS support
?VCPI			EQU 1		; 1=enable VCPI support
?EMX			EQU 1		; 1=EMX compat switch supported
?SB 			EQU 1		; 1=SB compat switch supported (useful?)
?EMMXXXX0		EQU 1		; 1=implement EMMXXXX0 IOCTL
?A20XMS 		EQU 1		; 1=emu A20 by trapping XMS functions
?A20PORTS		EQU 1		; 1=emu A20 by trapping ports (92, 64, 60)
?VME			EQU 1		; 1=support P1+ VME extension
?LOAD			EQU 1		; 1=support LOAD command line option
?PGE			EQU 1		; 1=support PGE on P3+ (requires ?INVLPG!) 
?MOVEHIGH		EQU 1		; 1=support moving in first UMB
?UNLOAD			EQU 1		; 1=support UNLOAD option
?FASTBOOT		EQU 1		; 1=support FASTBOOT option

?STKSIZE 		EQU 200H	; Size monitor stack for non-reentrant execution
?HLPSTKSIZE		EQU 80h		; size of help stack for VCPI

?GDTOFS			equ ?HLPSTKSIZE

?BPOPC			equ 0F4h			; opcode used for breakpoints (HLT)
;?BPOPC			equ 063h			; this should also work (ARPL)

;--- XMS

XMS_HANDLE struc
xh_flags	DB	?
xh_locks	DB	?
xh_baseK	DD	?
xh_sizeK	DD	?
XMS_HANDLE ends

if ?MASM
LPXMS_HANDLE typedef ptr XMS_HANDLE
endif

;--- XMS handle flags

XMSF_FREE	equ 1	;handle describes a free EMB
XMSF_USED	equ 2	;handle describes a used EMB
XMSF_INPOOL	equ 4	;handle is free


XMS_HANDLETABLE struc
xht_sig			DB	?
xht_sizeof		DB	?
xht_numhandles	DW	?
xht_pArray		DD	?	;converted to linear address!
XMS_HANDLETABLE ends

BLOCKSIZE       equ 2000h   ;std 2000h, block size moved to/from ext. memory

if ?INTEGRATED

XMS_MOVE struc   
  len           dd  ?       ;  +0 block length in bytes
  src_handle    dw  ?       ;  +4 source handle
  src_offset    dd  ?       ;  +6 offset into source
  dest_handle   dw  ?       ; +10 destination handle
  dest_offset   dd  ?       ; +12 offset into destination
XMS_MOVE ends    

;--- A20 switch methods (must match order in "methods" table)

A20_KBC     equ 0
A20_PS2     equ 1
A20_BIOS    equ 2
A20_ALWAYSON equ 3
A20_FAST    equ 4
A20_PORT92  equ 5

DRIVER_VER		equ 300h+29
INTERFACE_VER	equ 300h

;--- XMS error codes

XMS_NOT_IMPLEMENTED             equ 80h
XMS_VDISK_DETECTED              equ 81h
XMS_A20_FAILURE                 equ 82h
XMS_DRIVER_FAILURE              equ 8eh
XMS_DRIVER_FATAL                equ 8fh
XMS_HMA_NOT_THERE               equ 90h
XMS_HMA_IN_USE                  equ 91h
XMS_HMAREQ_TOO_SMALL            equ 92h
XMS_HMA_NOT_USED                equ 93h
XMS_A20_STILL_ENABLED           equ 94h
XMS_ALL_MEM_ALLOCATED           equ 0a0h
XMS_NO_HANDLE_LEFT              equ 0a1h
XMS_INVALID_HANDLE              equ 0a2h
XMS_INVALID_SOURCE_HANDLE       equ 0a3h
XMS_INVALID_SOURCE_OFFSET       equ 0a4h
XMS_INVALID_DESTINATION_HANDLE  equ 0a5h
XMS_INVALID_DESTINATION_OFFSET  equ 0a6h
XMS_INVALID_LENGTH              equ 0a7h
XMS_INVALID_OVERLAP             equ 0a8h
XMS_PARITY_ERROR                equ 0a9h
XMS_BLOCK_NOT_LOCKED            equ 0aah
XMS_BLOCK_LOCKED                equ 0abh
XMS_LOCK_COUNT_OVERFLOW         equ 0ach
XMS_LOCK_FAILED                 equ 0adh
XMS_ONLY_SMALLER_UMB            equ 0b0h
XMS_NO_UMB_AVAILABLE            equ 0b1h
XMS_UMB_SEGMENT_NR_INVALID      equ 0b2h

endif

if ?EMMXXXX0

;--- structure returned by Jemm386 if an "INFO" request was made
;--- for device "EMMXXXX0"

EMX06 struc
e06_NoEMS	 	db ? ;+0
e06_Frame		dw ? ;+1 segment
e06_NoVCPI		db ? ;+3
e06_DMABuff		dd ? ;+4 physical address DMA buffer
e06_NoPGE 		db ? ;+8
				db ?
				db ?
				db ?
e06_DMASize		dw ? ;+12 in KB
e06_NoVME 		db ? ;+14
e06_NoA20 		db ? ;+15
e06_VCPITotal	dd ? ;+16 VCPI pages total (def 120 MB)
e06_VCPIUsed	dd ? ;+20 VCPI pages allocated
EMX06 ends

;--- this is the structure for a "Get VMM info" request

EMX08 struc
e08_ServiceTable	dd ?
e08_BPTable			dd ?
e08_BPTableRM   	dd ?
e08_GDTR			df ?
e08_IDTR			df ?
e08_TR				dw ?
e08_FlatCS  		dw ?
EMX08 ends

;--- this is the structure for an "UPDATE" request with IoctlWrite

EMX15W struc
e15_bVME	db ?
e15_bA20	db ?
e15_bVCPI	db ?
e15_bPGE	db ?
EMX15W ends

endif

;--- data for monitor initialization
;--- this structure is also defined in C (jemm386.c)!!!

JEMMINIT struc
jiMonitorStart		dd ?	;memory block start address (XMS/I15)
jiMonitorEnd		dd ?	;memory block end address (XMS/I15)
jiTotalMemory 		dd ?	;highest physical memory address (XMS/I15)
jiMaxMem16k			dd ?	;MAX mem in 16 kB units (default 7680)
jiMinMem16k			dd ?	;MIN mem in 16 kB units (default 0)
jiXMSHandleTable	dd ?	;XMS handle table (FAR16)
jiPageMap			dd ?	;conventional memory page map
jiMaxEMSPages		dw ?	;EMS max 16 kB pages (default 2048)
jiXMSControlHandle	dw ?	;XMS memory block handle (or 0000 if I15)
jiDMABufferSize		dw ?	;DMA buffer size in kB
jiFrame				dw ?	;EMS page frame (default E000)
jiBorder			dw ?	;EMS border for mappable pages (default 4000)
jiNoEMS				db ?
jiNoFrame			db ?
jiNoPool			db ?
jiAltBoot 			db ?
jiNoVME				db ?
jiNoVDS				db ?
jiNoPGE				db ?
jiNoA20				db ?
jiNoVCPI			db ?
jiNoInvlPg			db ?
jiV86Flags			db ?
jiNoRAM				db ?
jiNoHigh			db ?
jiResUMB			db ?	;UMB where the resident part has been moved to
jiNumUMBs   		db ?	;number of UMBs installed
if ?INTEGRATED
jiA20Method			db ?
jiHmaMin			dw ?	;min request in KB for HMA
jiX2Max             dw ?
endif
JEMMINIT ends

;--- this is the table of RSEG offsets 
;--- the values are offsets in the RSEG segment
;--- there is just one instance defined in jemm16.asm.

RSOFS struc
wSizeRes	dw ?	;size resident part
wBpTab		dw ?	;offset of BP table
if ?DMA
wRFlags		dw ?	;offset of DMA flags
endif
RSOFS ends

;--- max number of UMB blocks
;--- this constant is also defined in Jemm386c.c

UMB_MAX_BLOCKS	equ 8

UMBBLK struc
wSegm	dw ?	;segment address
wSize	dw ?	;size in paras, high bit used as flag free/allocated
UMBBLK ends

;--- macros

@BPOPC macro
	db ?BPOPC
	endm

