
;--- EMS/VCPI implementation
;--- the EMS 3.2 part is copyright Harald Albrecht/Tom Ehlert

;--- EMS 4.0 and VCPI part is Public Domain
;--- originally written by Michael Devore
;--- extended and modified for Jemm by Japheth 


		.486P

		include jemm.inc		;common declarations
		include jemm32.inc		;declarations for Jemm32
		include debug.inc

;--- equates

DEVICE_NAME equ 000Ah	; offset device name in RSEG

;--- assembly time constants

?MAXPHYSPG	equ 56		; std=56, max physical pages (don't set below 4!)
?YIELDOPEN	equ 0		; std=0, 1=yield on handle open
?LIM32		equ 0		; std=0, 1=support LIM EMS 3.2 only
?SUPP5B		equ 1		; std=1, 1=support int 67h, ax=5Bxxh

MAX_EMS_PAGES_POSSIBLE	equ 8000h

ife ?MASM
		LOCALS
else
		option proc:private
  		option dotname
endif

if ?FLAT
		.model FLAT
endif

		include external.inc

if ?CODEIN2PAGE
	@seg .text$02,<PAGE>
else
	@seg .text$02,<PARA>
endif
.text$02 ENDS

ife ?MASM
FLAT group .text$02
		assume CS:FLAT
endif      
		assume SS:FLAT,DS:FLAT,ES:FLAT

EMM59 struc
e59_pgsize	dw ?	;raw page size in paragraphs
e59_altsets dw ?	;number of alternate register sets
e59_sizcont dw ?	;size of mapping context save area in bytes
e59_dmasets dw ?	;dma register sets
e59_dmaflgs dw ?	;dma flags
EMM59 ends

.text$01 SEGMENT

;--- EMS variables

EMSHandleTable	DD	0	; table of EMS handles (4 bytes/handle)
EMSNameTable	DD	0	; table of EMS handle names (8 bytes/handle)
EMSStateTable	DD  0	; table of EMS status saves (16 bytes/handle)
EMSPagesMax		DD	0	; max EMS pages (default 2048)
EMSPagesUsed	DD	0	; used EMS pages

EMSPage2Segm	DB	?MAXPHYSPG DUP (0)	; segments mapped to phys.pgs
;EMSMappedPages	DW	?MAXPHYSPG DUP (-1)	; log. EMS pgs mapped to phys. pgs

				align 4

;--- table of EMS page descriptors (EMSPD), one item for each EMS page
;--- initialized with -1

EMSPageAllocationStart DD	0
EMSPageAllocationEnd   DD	0

emm59_ EMM59 <1024,0,0,0,0>
if ?SUPP5B
mapptr			DD 0	; pointer supplied by "OS"
endif

bEmsPhysPages	DB	0	; current physical pages
bPagesConv		DB  0	; physical pages in conv. memory
bNoEMS			DB	0	; flags no EMS services
bNoFrame		DB	0	; flags no page frame
bNoVCPI			DB	0	; flags no VCPI services

;--- this is 16-bit code which is copied onto the client's stack
;--- to restore the page mapping in int 67h, ah=56h

clproc label byte
	db 1Eh			; push ds
    db 51h			; push cx
    db 52h          ; push dx
    db 56h			; push si
    db 0B9h			; mov cx,zzzz
_clcx dw 0
    db 0BAh			; mov dx,zzzz
_cldx dw 0
    db 0BEh			; mov si,yyyy
_clsi dw 0
    db 068h			; push xxxx
_clds dw 0
    db 1Fh			; pop ds
    db 0B8h    		; mov ax,50wwh
_clal db 00,50h
    db 0CDh, 67h	; int 67h
    db 5Eh			; pop si
    db 5Ah          ; pop dx
    db 59h			; pop cx
    db 1Fh			; pop ds
    db 0CAh			; retf sizeclproc
    dw sizeclproc
    db 0            ; alignment byte
sizeclproc equ $ - offset clproc

.text$01 ends

.text$03 segment

	align 4
	
EMS_Call_Table label dword
	Dd EMS_GET_STATUS			; 40h
	Dd EMS_GET_PAGE_FRAME_ADDRESS		;41h
	Dd EMS_GET_UNALLOCATED_PAGE_COUNT	;42h
	Dd EMS_ALLOCATE_PAGES		; 43h
	Dd EMS_MAP_HANDLE_PAGE		; 44h
	Dd EMS_DEALLOCATE_PAGES		; 45h
	Dd EMS_GET_VERSION			; 46h
	Dd EMS_SAVE_PAGES			; 47h
	Dd EMS_RESTORE_PAGES		; 48h
	Dd EMS_NOT_IMPL				; 49h (get io port addresses)
	Dd EMS_NOT_IMPL				; 4ah (get translation array)
	Dd EMS_GET_OPEN_HANDLES_COUNT		; 4bh
	Dd EMS_GET_PAGES_ONE_HANDLE	; 4ch
	Dd EMS_GET_PAGES_ALL_HANDLES; 4dh
	Dd EMS_GET_SET_PAGE_MAP		; 4eh
ife ?LIM32    
	Dd ems4_get_set_partial_page_map	; 4fh
	Dd ems4_map_multiple		; 50h
	Dd ems4_realloc				; 51h
	Dd ems4_attribute			; 52h
	Dd ems4_get_set_handle_name	; 53h
	Dd ems4_get_handle_info		; 54h
	Dd ems4_alter_map_jump		; 55h
	Dd ems4_alter_map_call		; 56h
	Dd ems4_move_memory			; 57h
	Dd ems4_get_mappable_info	; 58h
	Dd ems4_get_config			; 59h
	Dd ems4_allocate_pages		; 5ah
	Dd ems4_alt_map_reg_set 	; 5bh
	Dd EMS_NOT_IMPL				; 5ch (4: prepare EMS for warm boot)
	Dd EMS_NOT_IMPL				; 5dh (4: enable/disable OS functions)
endif    
EMS_MAX equ ($ - EMS_Call_Table) / 4

if ?VCPI

VCPI_Call_Table label dword
	Dd VCPI_Presence	; 0
	Dd VCPI_GetInterface
	Dd VCPI_GetMax		; 2
	Dd VCPI_GetFreePages
	Dd VCPI_Allocate4K	; 4
	Dd VCPI_Free4K
	Dd VCPI_GetAddress	; 6
	Dd VCPI_GetCR0
	Dd VCPI_ReadDR		; 8
	Dd VCPI_WriteDR
	Dd VCPI_GetMappings	; 0ah
	Dd VCPI_SetMappings
;	Dd VCPI_V86toPM		; 0ch
VCPI_MAX equ ($ - VCPI_Call_Table) / 4
endif

		align 4

@emmpushreg macro
		SUB		ESP,4+4
		PUSHAD
        MOV		EBP,ESP
		endm		
@emmpopreg macro
		mov esp, ebp
		POPAD
        ADD		ESP,4+4
        endm
        
;--- breakpoint: if int 67h vector is hooked in real-mode, the hooker code
;--- is called and will finally met a breakpoint which will get us here.

Int67_V86Entry proc public
		call	Simulate_Iret
        add		esp,4		;skip return address
        mov		esi,[ebp].Client_Reg_Struc.Client_ESI
        mov		edx,[ebp].Client_Reg_Struc.Client_EDX
        mov		eax,[ebp].Client_Reg_Struc.Client_EAX
		JMP		EMM_ENTRY_2
Int67_V86Entry endp

Int67_Indirect:
		@emmpopreg
		push	67h
		jmp		V86_Monitor

		align 4
;
; Here starts the Expanded Memory Manager (EMM) Version 4.0
;

Int67_Entry PROC public

		@emmpushreg

		MOV 	ECX,SS		; address everything
		MOV 	DS,ECX
		MOV 	ES,ECX

if ?V86DBG
	@DbgOutS <"Int 67h in v86-mode, CS:EIP=">,1
	@DbgOutW <word ptr [ebp].V86FRAME.fCS>,1
	@DbgOutS <":">,1
	@DbgOutD [ebp].V86FRAME.fEIP,1
	@DbgOutS <" EBP=">,1
	@DbgOutD ebp,1
	@DbgOutS <" AX=">,1
	@DbgOutW ax,1
	@DbgOutS <10>,1
endif

		mov		ecx,[dwRSeg]
		cmp		cx,ds:[67h*4+2]		;IVT vector 67h modified?
		jnz		Int67_Indirect

		mov		esp,[dwStackCurr]

if ?MASM		
EMM_ENTRY_2::
else
EMM_ENTRY_2:		
endif
		CLD
		
if ?VCPI
		cmp	ah,0deh			; see if VCPI function
		jne	@@not_vcpi_api
		cmp al,0Ch
		jz VCPI_V86toPM
		movzx ecx,al

		cmp	[bNoVCPI],0		; check if VCPI turned off
		jne	@@vcpi_INV_CALL	; yes, return invalid code, flags VCPI not present for 0de00h
		cmp	al,VCPI_MAX
		jae	@@vcpi_INV_CALL	; invalid VCPI call
		call [VCPI_Call_Table+ECX*4]
  if ?VCPIDBG
		@DbgOutS <"VCPI rm, in: ax=">,1
		@DbgOutW <word ptr [ebp].Client_Reg_Struc.Client_EAX>,1
		@DbgOutS <" edx=">,1
		@DbgOutD [ebp].Client_Reg_Struc.Client_EDX,1
		@DbgOutS <", out: ax=">,1
		@DbgOutW ax,1
		@DbgOutS <" edx=">,1
		@DbgOutD edx,1
		@DbgOutS <10>,1
  endif
        mov	[ebp].Client_Reg_Struc.Client_EDX, edx
        mov	byte ptr [ebp].Client_Reg_Struc.Client_EAX+1,ah
		jmp	@@BYEEMSX
		align 4
@@not_vcpi_api:
endif

		MOVZX	ECX,AH				; check permitted range
		SUB 	CL,40H
		JB		@@emm_INV_CALL
		CMP 	CL,EMS_MAX
		JAE		@@emm_INV_CALL
		CALL	[EMS_Call_Table+ECX*4]
if ?EMSDBG
		@DbgOutS <"EMS in: ax=">,1
		@DbgOutW <word ptr [ebp].Client_Reg_Struc.Client_EAX>,1
		@DbgOutS <" bx=">,1
		@DbgOutW <word ptr [ebp].Client_Reg_Struc.Client_EBX>,1
		@DbgOutS <" dx=">,1
		@DbgOutW <word ptr [ebp].Client_Reg_Struc.Client_EDX>,1
		@DbgOutS <", out: ax=">,1
		@DbgOutW ax,1
		@DbgOutS <" bx=">,1
		@DbgOutW bx,1
		@DbgOutS <" dx=">,1
		@DbgOutW dx,1
		@DbgOutS <10>,1
endif
        mov		word ptr [ebp].Client_Reg_Struc.Client_EBX,bx
        mov		word ptr [ebp].Client_Reg_Struc.Client_EDX,dx
@@BYEEMS:
        mov		byte ptr [ebp].Client_Reg_Struc.Client_EAX+1,ah
@@BYEEMSX:
		@emmpopreg
		IRETD
@@vcpi_INV_CALL:
if ?VCPIDBG
		@DbgOutS <"VCPI invalid function, ax=">,1
		@DbgOutW ax,1
		@DbgOutS <10>,1
		MOV 	ah,EMSS_INVALID_FUNCTION
		JMP 	@@BYEEMS
endif
@@emm_INV_CALL:
if ?EMSDBG
		@DbgOutS <"EMS invalid function, ax=">,1
		@DbgOutW ax,1
		@DbgOutS <10>,1
endif
		MOV 	ah,EMSS_INVALID_FUNCTION
		JMP 	@@BYEEMS
		
Int67_Entry ENDP

;
; 6740: AH = 40h: return the actual state of the EMM-driver.
;
EMS_GET_STATUS PROC
	MOV 	AH,EMSS_OK
	RET
EMS_GET_STATUS ENDP
;
; 6741: AH = 41h: request the segment address of the EMS-window
;
EMS_GET_PAGE_FRAME_ADDRESS PROC
	mov		ah,80h
	cmp		[bNoFrame],0
	jnz		@@BYE
	MOV 	AH,EMSS_OK			; No error occurred
	MOV 	BH,[EMSPage2Segm+0]	; Segment address of EMS-Window/Frame
    MOV		BL,0
@@BYE:	  
	RET
EMS_GET_PAGE_FRAME_ADDRESS ENDP

;
; 6742: AH = 42h: Request number of free + total EMS-pages
; out: BX=free pages
; out: DX=total pages

EMS_GET_UNALLOCATED_PAGE_COUNT PROC

	call	GetFreeEMSPages
	MOV 	EBX,EAX
	MOV 	EDX,[EMSPagesMax] 		; total EMS pages

; follow MS-DOS EMM386 7.x lead and don't throttle pages on NOEMS
;	cmp	cs:[bNoEMS],0
;	je	@@unalloc_ret
;	or	bx,bx
;	je	@@unalloc_ret
;	mov	bx,1			; only show maximum of 1 EMS page if NOEMS set
;@@unalloc_ret:

	MOV 	AH,EMSS_OK
	RET
EMS_GET_UNALLOCATED_PAGE_COUNT ENDP

;
; 6743: AH = 43h: Reserve pages for new EMS handle
; in  BX = EMS pages to reserve
; out AH=00, DX = handle

EMS_ALLOCATE_PAGES PROC
	MOV 	AH,EMSS_ZERO_PAGES	; "Request to reserve null pages"
	AND 	BX,BX
	JZ		SHORT @@BYE

if ?MASM
allocate_pages_plus_zero::	;this entry allows to alloc zero pages!
else
allocate_pages_plus_zero:
endif
	MOV 	AH,EMSS_OUT_OF_PAGES	; "Not enough pages available"
    movzx	ebx,bx
	CMP 	EBX,[EMSPagesMax]
	JA		SHORT @@BYE

	call	GetFreeEMSPages
	CMP 	EBX, EAX
	MOV 	AH,EMSS_OUT_OF_FREE_PAGES	; "Not enough free pages available"
	JA		SHORT @@BYE

	MOV 	ESI,[EMSHandleTable]		; Now search for a free Handle in the table
	MOV 	CL,EMS_MAX_HANDLES
@@SEARCH:
	test 	[ESI].EMSHD.ehd_bFlags,EMSH_USED; Is there one free ... ?
	JZ		SHORT @@FOUND
	ADD 	ESI,size EMSHD
	dec		cl
	jnz 	@@SEARCH
	MOV 	AH,EMSS_NO_MORE_HANDLES		; "No more free Handles"
@@BYE:
	RET

@@FOUND:
	or	 	[ESI].EMSHD.ehd_bFlags,EMSH_USED

	MOV 	DX,EMS_MAX_HANDLES			; Set in DX now the actual Handle-
	SUB 	DL,CL					; number

; zero page allocations allowed, so test and bypass code if found

	or		ebx,ebx
	je		@@allocate_exit
    mov		ecx, ebx
    call	AllocateEMSPages
    jc		@@nofind
@@allocate_exit:
	MOV 	AH,EMSS_OK
	RET
@@nofind:
if ?POOLDBG
	@DbgOutS <"EMS_ALLOCATE_PAGES: @@nofind reached, BX=">,1
	@DbgOutW bx,1
	@DbgOutS <10>,1
endif
	call EMS_DEALLOCATE_PAGES		;free the handle in DX	
	MOV AH,EMSS_OUT_OF_FREE_PAGES	; "Not enough pages available anymore"
	ret
	align 4
	
EMS_ALLOCATE_PAGES ENDP

;--- get EMS absolute page
;--- inp DX:BX = handle:logical page
;--- out NC ok, EBX = absolute page (index into EMSPD array)
;--- C if failure, then error code in AH
;--- modifies ECX, EDI

EMS_get_abs_page proc
	AND 	BH,BH					; bx < 0 means unmap this phys. page
	JS		@@OK
	movzx	ecx, bx
    movzx	ebx, dl
    mov		edi,[EMSHandleTable]
    mov		bx,[edi+ebx*4].EMSHD.ehd_wIdx
	MOV 	EDI,[EMSPageAllocationStart]
    inc		ecx
    jmp		@@test
    align	4
@@nextitem:    
    mov		bx,[edi+ebx*4].EMSPD.wNext
@@test:    
    cmp		bx,-1
    loopnz	@@nextitem
    jz		@@fail
@@OK:    
    clc
    ret
@@fail:
	MOV 	AH,EMSS_LOG_PAGE_INVALID	; "logical page out of reserved area"
	stc
	ret
EMS_get_abs_page endp	 

; 6744
; AH = 44h: map logical page DX:BX into physical page AL (the EMS-window)
; AL = physical page (0-3)
; DX = handle
; BX = logical page #
;
EMS_MAP_HANDLE_PAGE PROC

	CALL	EMS_TEST_HANDLE

	CMP 	AL,[bEmsPhysPages]		; not" Only pages 0..3
	JAE 	SHORT @@PAGE_TOO_LARGE	; are allowed!

	PUSH	EBX 					; save BX  (since it is changed)
	call	EMS_MAP_REL_PAGE		; map in the page in DX:BX
	jc		@@done
    call	FlushTLB
	MOV 	AH,EMSS_OK
@@done:
	POP 	EBX
	RET
@@PAGE_TOO_LARGE:
@@ERR8B:
	MOV 	AH,EMSS_PHYS_PAGE_INVALID	; "physical page does not exist"
	RET

EMS_MAP_HANDLE_PAGE ENDP

;
; 6745: AH = 45h: Release reserved memoryspace again
;		DX = handle to release
; any pages of this handle mapped in page frame remain mapped!
; this is same behaviour as MS Emm386

EMS_DEALLOCATE_PAGES PROC
	CALL	EMS_TEST_HANDLE
    and		dx,dx
    jz		ems_release_null
	MOV 	AH,EMSS_CONTEXT_EXISTS	; "A saved state still
	CMP 	[ESI].EMSHD.ehd_bSS,-1		; exists" ?
	JNZ 	SHORT @@BYE

    and		[esi].EMSHD.ehd_bFlags,not EMSH_USED
	MOV 	EDI,[EMSPageAllocationStart]
    xor		eax, eax
    jmp		@@test
@@LOOP:
    lea		esi,[edi+eax*4]
	call	ReleaseEMSPage			; preserves registers
@@test:
    mov		ax,-1
    xchg	ax,[esi].EMSPD.wNext
	cmp		ax,-1
    jnz 	@@LOOP

; zero handle name on free
	mov	edi, [EMSNameTable]
	xor esi, esi
	movzx	ecx, dx
	mov	DWORD PTR [edi+ecx*8+0],esi
	mov	DWORD PTR [edi+ecx*8+4],esi

	MOV 	AH,EMSS_OK
@@BYE:
	RET
ems_release_null:
ife ?LIM32
	push ebx
    xor ebx,ebx
    call ems4_realloc
    pop ebx
else
	mov ah,EMSS_OK
endif    
	ret
EMS_DEALLOCATE_PAGES ENDP
;
; 6746: AH = 46h: determine Version-number of EMM
;
EMS_GET_VERSION PROC
if ?LIM32
	mov		byte ptr [ebp].Client_Reg_Struc.Client_EAX, 32h
else
	mov		byte ptr [ebp].Client_Reg_Struc.Client_EAX, 40h
endif    
	MOV 	AH,EMSS_OK
	RET
EMS_GET_VERSION ENDP

;--- save the frame window mapping state

EMS_SaveFrameToEdi proc
	mov		cl,4
EMS_SaveFrameToEdi endp	;fall through

;--- save CL (0 - bEmsPhysPages) pages to ESI
;--- EDI -> array of DWORDs, where PTEs will be stored
;--- modifies CL

EMS_SavePagesToEdi PROC
	PUSH	EAX
    PUSH	EDX
    PUSH	ESI
	INC		CL
    xor		edx,edx
    mov		esi,offset EMSPage2Segm
    jmp		@@test
@@NEXTPAGE:
	lodsb
    movzx   eax,al
    @GETPTEPTR eax, EAX*4+1000h
	MOV 	EAX, [EAX]
    mov		al,dl
    inc		edx
    STOSD
@@test:    
	DEC		CL
	jnz		@@NEXTPAGE
    POP		ESI
    POP		EDX
	POP 	EAX
	RET
EMS_SavePagesToEdi ENDP

;--- restore the frame window mapping state

EMS_RestoreFrameFromEsi PROC
	mov		cl, 4
EMS_RestoreFrameFromEsi ENDP		;fall through

;-- restore CL (0 - bEmsPhysPages) pages
;-- esi -> array of DWORDs, containing PTEs

EMS_RestorePagesFromEsi PROC

	push	edi
	INC		CL
    jmp		@@test
@@NEXTPAGE:
	lodsd
    movzx	edi,al
	movzx	edi,[EMSPage2Segm+EDI]
    @GETPTEPTR EDI,EDI*4+1000h
	MOV 	al,7
    stosd
    add		eax,1000h
    stosd
    add		eax,1000h
    stosd
    add		eax,1000h
    stosd
@@test:    
	DEC		CL
	jnz 	@@NEXTPAGE
    pop		edi
    call	FlushTLB
	MOV 	AH,EMSS_OK		; report OK (because of functions $4E01/$4E02)
	RET
	
EMS_RestorePagesFromEsi ENDP


;
; 6747: AH = 47h: Save status of EMS page frame to internally
;       maintained buffers (max 1 for each handle)
; in: DX = handle
; it might be that there are pages mapped into the EMS page frame
; which don't belong to any handles (anymore)!
;
EMS_SAVE_PAGES PROC
	mov		ah,EMSS_SOFTWARE_ERR
	cmp		[bNoFrame],0
	jnz		@@BYE
	CALL	EMS_TEST_HANDLE
	MOV 	AH,EMSS_STATE_ALREADY_SAVED   ; "State for Handle already saved"
	CMP 	[ESI].EMSHD.ehd_bSS,-1
	JNZ 	@@BYE
    mov		edi,[EMSStateTable]
    xor		eax,eax
@@nextitem:    
    cmp		[edi].EMSSTAT.dPg0,-1
    jz		@@found
    add		edi,size EMSSTAT
    inc		eax
    cmp		eax,EMS_MAXSTATE
    jnz		@@nextitem
    mov		ah,EMSS_CONTEXT_STACK_FULL
    ret
@@found:
    mov		[esi].EMSHD.ehd_bSS,al
	call	EMS_SaveFrameToEdi
	MOV 	AH,EMSS_OK
@@BYE:
	RET
EMS_SAVE_PAGES ENDP
;
; 6748: AH = 48h: Restore saved state of the EMS-window
; DX = handle
;
EMS_RESTORE_PAGES PROC
	mov		ah,EMSS_SOFTWARE_ERR
	cmp		[bNoFrame],0
	jnz		@@BYE
	CALL	EMS_TEST_HANDLE
	MOV 	AH,EMSS_NO_STATE_IS_SAVED ; "A saved state does not exist"
	CMP 	[ESI].EMSHD.ehd_bSS,-1
	JZ		SHORT @@BYE
    mov		al,-1
    xchg	al,[ESI].EMSHD.ehd_bSS
    movzx	eax,al
    shl		eax,4			;size of EMSSTAT
    mov		esi,[EMSStateTable]
    add		esi, eax
    push	esi
	CALL	EMS_RestoreFrameFromEsi
    pop		esi
    mov		[esi].EMSSTAT.dPg0,-1
	MOV 	AH,EMSS_OK
@@BYE:
	RET

EMS_RESTORE_PAGES ENDP

;
; report the failure so that we can maybe support it in the future
;
EMS_NOT_IMPL PROC

IF	?UNIMPL_EMS_DBG
	mov		edi,offset unimpl_ax
	call	w2a
	push	offset unimpl_func
	call	PrintString
ENDIF
	MOV 	AH,EMSS_INVALID_FUNCTION	  ; "Invalid function code"
	RET

if ?UNIMPL_EMS_DBG	  
unimpl_func db "Unimplemented EMS function called, ax="
unimpl_ax	db "____"
			db 13,10
			db 0
endif

EMS_NOT_IMPL ENDP
;
; 674B: AH = 4Bh: return Number of open Handles in BX
;
EMS_GET_OPEN_HANDLES_COUNT PROC
	MOV 	ESI,[EMSHandleTable] ; Search Handle-status-table for
	MOV 	ECX,EMS_MAX_HANDLES 	 ; assigned/given handles
	XOR 	EBX,EBX
    XOR		EAX,EAX
@@LOOP:
	test	[ESI].EMSHD.ehd_bFlags,EMSH_USED; Free ?
    setnz	al
	ADD 	ESI,size EMSHD				; Next entry
    add		ebx,eax
	loop	@@LOOP
	MOV 	AH,EMSS_OK
	RET
EMS_GET_OPEN_HANDLES_COUNT ENDP
;
; 674C: AH = 4Ch: return number of reserved pages for a handle
;  inp: handle in DX.
;  out: pages in BX.
;  modifies ESI, EDI, EBX, EAX

EMS_GET_PAGES_ONE_HANDLE PROC
	CALL	EMS_TEST_HANDLE
    movzx	EAX,[esi].EMSHD.ehd_wIdx
	MOV 	EDI,[EMSPageAllocationStart]
	XOR 	EBX,EBX
    jmp		@@test
@@LOOP:
    mov		ax,[edi+eax*4].EMSPD.wNext
	INC 	EBX
@@test:    
	cmp		ax,-1
    jnz		@@LOOP
	MOV 	AH,EMSS_OK
	RET
EMS_GET_PAGES_ONE_HANDLE ENDP
;
; 674D: AH = 4Dh: determine Number of reserved pages for all Handles
;	ES:DI -> array of 2 WORD entries (handle, pages)
; out: AH=00 success, BX=number of handles stored in array
;
EMS_GET_PAGES_ALL_HANDLES PROC
	MOVZX	ESI,WORD PTR [ebp].Client_Reg_Struc.Client_ES
	SHL 	ESI,4
	MOVZX	EDI,DI
	ADD 	ESI,EDI                      ; ESI -> array
	PUSH	EDX
	MOV 	EDI,[EMSHandleTable]
	XOR 	EAX,EAX 					 ; current Handle-Number
	XOR 	EBX,EBX						 ; count open handles
@@NEXT_HANDLE:
	test	[EDI].EMSHD.ehd_bFlags,EMSH_USED ; handle free?
	JZ		SHORT @@NEXT
	INC 	EBX 						 ; One more Handle is open...
	MOV 	[ESI+0],AX					 ; Place handle
	PUSH	EDI
    movzx   ecx,[edi].EMSHD.ehd_wIdx
	MOV 	EDI,[EMSPageAllocationStart] ; get pages for handle
	XOR 	EDX,EDX 					 ; EDX is counter
    jmp		@@test
@@LOOP:
    inc		edx
    mov		cx,[edi+ecx*4].EMSPD.wNext
@@test:    
	cmp		cx,-1
    jnz 	@@LOOP
	MOV 	[ESI+2],DX					 ; Set number of handle's pages
	add		ESI, 4
	POP 	EDI
@@NEXT:
	ADD 	EDI,size EMSHD
	INC 	EAX
	CMP 	AL,EMS_MAX_HANDLES				 ; All Handles processed ?
	JB		@@NEXT_HANDLE
	POP 	EDX
	MOV 	AH,EMSS_OK
	RET
EMS_GET_PAGES_ALL_HANDLES ENDP

;
; 674E: AH = 4Eh: Get & Set Page Map
; AL = 0,1,2,3
; AL = 0: ES:DI -> array to get info
; AL = 1: DS:SI -> array to set info
; AL = 2: DS:SI -> array to set info, ES:DI -> array to get info
; AL = 3: AL returns size of array (bytes)

@CHKSUM	MACRO	REG
	MOV 	EAX,[REG+04]		; Calculate checksum
	ADD 	EAX,[REG+08]
	ADD 	EAX,[REG+12]
	ADD 	EAX,[REG+16]
	ENDM

EMS_GET_SET_PAGE_MAP PROC
	CMP 	AL,3					; Subfunction 0 to 3 ?
	JA		bad_subfunc
	JZ		SHORT @@SUBF_3			; Size of field
	CMP 	AL,1
	JZ		SHORT @@SUBF_1			; Set Page Map

; AL = 2: Get & Set Page Map
; AL = 0: Get Page Map - save Hardwarestatus

@@SUBF_0:
	MOVZX	ECX, WORD PTR [ebp].Client_Reg_Struc.Client_ES; ES:DI ^ convert from statusfield in
	SHL 	ECX, 4					; usual REAL-Mode-Format
	MOVZX	EDI, DI
	ADD 	EDI, ECX
save_page_map_int::                 ; <--- internal, EDI=save area, AL=0
	PUSH	EAX						; save Subfunctioncode
    PUSH	edi
    add		edi,4
	mov		cl, [bEmsPhysPages]
	CALL	EMS_SavePagesToEdi
    pop		edi
	@CHKSUM	EDI 					; Calculate checksum and ...
    stosd
	POP 	EAX 					; restore and examen subfunctioncode
	CMP 	AL,2					; if subfuction 2 is wanted,
	JZ		SHORT @@SUBF_1			; then also set new map
	MOV 	AH,EMSS_OK
	RET

; Subf. 1: Set Page Map - restore Hardwarestatus

@@SUBF_1:
	MOVZX	ECX,WORD PTR [ebp].Client_Reg_Struc.Client_DS	; DS:SI ^ convert from statusfield in
	SHL 	ECX,4					; usual REAL-Mode-Format
	MOVZX	ESI,SI
	ADD 	ESI,ECX
restore_page_map_int::				; <--- internal: ESI=save area   
	@CHKSUM	ESI 					; Calculate checksum and check it
	CMP 	[ESI],EAX
	JNZ 	@@CHKERR
    lodsd							; skip checksum
	mov		cl, [bEmsPhysPages]
	JMP 	EMS_RestorePagesFromEsi

; Checksum is incorrect !
@@CHKERR:
	MOV 	AH,0A3H 				; data is destroyed !
	RET

; Subf. 3: return size of the field in AL

@@SUBF_3:
	MOV 	AL, byte ptr emm59_.e59_sizcont
	MOV		byte ptr [ebp].Client_Reg_Struc.Client_EAX, al
	MOV 	AH,EMSS_OK
	RET

EMS_GET_SET_PAGE_MAP ENDP

bad_subfunc:
	MOV 	AH,EMSS_INVALID_SUBFUNC	; Invalid subfunctioncode !
	RET
    align 4

;--- check if segment in AX is a valid (physical) page
;--- if yes, return NC and convert segment to physical page in AL

EMS_Segm2Phys proc
	and al,al			;must begin on a page boundary
    jnz @@notvalid
    mov al,ah
	push ecx
    push edi
    movzx ecx, [bEmsPhysPages]
    mov edi, offset EMSPage2Segm
    mov ah,cl
    repnz scasb
    pop edi
    jnz @@notvalid2
    mov al, ah
    dec al
    sub al, cl
    pop ecx
	ret
@@notvalid2:
    pop ecx
@@notvalid:
	mov ah,EMSS_PHYS_PAGE_INVALID
	stc
	ret
EMS_Segm2Phys endp

_ret:
	ret
    align 4

; Map EMS page in DX:BX to physical page in AL

EMS_MAP_REL_PAGE proc
	call EMS_get_abs_page
    jc _ret
EMS_MAP_REL_PAGE endp

; Map an EMS page to a physical page
; inp: AL = physical EMS page (0 - (bEmsPhysPages - 1))
;      BX = absolute EMS page (or -1 to unmap)
; modifies EDI, ECX, EAX
; the logical page in BX might belong to no handle!

EMS_MAP_ABS_PAGE PROC
	movzx	eax,al
    mov		al, [EMSPage2Segm+EAX]

	@GETPTEPTR EDI, EAX*4+1000h	; EDI -> PTE
    SHL		eax, 12				; C0 -> C0000, C4-> C4000
    
EMS_MAP_ABS_PAGE ENDP	;fall through!!!

; Map an (absolute) EMS page anywhere in address space
; BX = EMS abs. page
; EDI == ptr to PTE
; EAX == linear address
; modifies edi, ecx, eax

EMS_MAP_ABS_PAGE_EX proc	

	AND 	BH,BH				; unmap the page?
	JS		@@SET

	MOVZX ECX,BX				; get the EMSPD for the page in ECX
	shl	ecx,2
	add	ecx, [EMSPageAllocationStart]
	movzx ecx,[ecx].EMSPD.wPD	; get pool allocation block index

	cmp cx,-1	;bad pointer?
	jz @@SET	;then unmap this page

    movzx eax, bx
    add eax,[EMSPageAllocationEnd]
	movzx eax,[eax].EMSPD2.bNibOfs	; 16K offset from pool block base
	shl	ecx,6						; convert to 64-byte block offset
	shl	eax,14						; 16K to bytes
	add	ecx, [PoolAllocationTable]	; esi -> pool allocation block for page

	mov	ecx,[ecx].POOL_SYSTEM_INFO.psi_addressK
	shl	ecx,10				; K address to bytes
	add	eax,ecx				; edi == physical memory address of page

@@SET:
	OR 		EAX,7			; Statusbits: R/W=1,U/S=1,P=1
if 0    
    mov		cl,4
@@LOOP:
	MOV 	[EDI],EAX		; Register the new physical Address of
	ADD 	EDI,4			; window
	ADD 	EAX,4096		; Process next 4K-page
	DEC 	CL
	JNZ 	@@LOOP
else
	mov		ecx,1000h
    stosd
    add		eax,ecx
    stosd
    add		eax,ecx
    stosd
    add		eax,ecx
    stosd
endif
	RET
    align	4
	
EMS_MAP_ABS_PAGE_EX endp

FlushTLB proc
if 0
	cmp		[bNoInvlPg],0
	jz		@@noinvlpg
endif    
	MOV 	EAX,CR3 		; flush TLB
	MOV 	CR3,EAX
@@noinvlpg:
	ret
    align 4
FlushTLB endp

; Check a given Handle for validness.
; In case the Handle is invalid the returnaddress is thrown away
; and afterwards through RET returned to dispatcher.
; Else ESI will point to the handle in EMSHandleTable array

EMS_TEST_HANDLE PROC
	CMP 	DX,EMS_MAX_HANDLES				; out of area ?
	JAE 	@@INVALID
	MOVZX	ESI,DL						; get a pointer to the handle table
	SHL 	ESI,2						; size is 4
	ADD 	ESI, [EMSHandleTable]
	test	[ESI].EMSHD.ehd_bFlags, EMSH_USED
	JZ		@@INVALID
	RET
@@INVALID:
	ADD 	ESP,4						; throw away call(ing)-address
	MOV 	AH,EMSS_INVALID_HANDLE		; "Handle invalid"
	RET
EMS_TEST_HANDLE ENDP

;--- begin EMS 4.0 functions

ife ?LIM32

;
; 674F: AH = 4Fh: Get & Set partial Map
; AL = 0,1,2 
; AL = 0 (get map), DS:SI -> map to get, ES:DI -> status to receive
; AL = 1 (set map), DS:SI -> map to restore
; AL = 2 (get size), items in BX, returns size of map in AL
; the list for sub function 0 DS:SI points to has following structure:
; WORD	 : items in list
; WORD[] ; segment! addresses for which to get the map info 
; the output list ES:DI points to (function 0) has following structure:
; WORD	 : items in list
;  BYTE	 : page no
;  WORD  ; abs EMS page mapped (or -1)

ems4_get_set_partial_page_map PROC

	cmp al,2
	ja bad_subfunc
	jz @@getsize
	movzx ecx,WORD PTR [ebp].Client_Reg_Struc.Client_DS
	shl	ecx,4
	movzx esi, si
	add	esi,ecx
	
	cmp al,1
	jz @@setmap

;--- ax=4F00h (get map)

	movzx ecx,WORD PTR [ebp].Client_Reg_Struc.Client_ES
	shl	ecx,4
	movzx edi, di
	add	edi,ecx

	lodsw
	movzx eax,ax
	movzx ecx, [bEmsPhysPages]
	cmp eax,ecx
	ja @@failA3
	mov ecx, eax
	stosw
	jecxz @@done00
@@nextsegm:
	lodsw
	call EMS_Segm2Phys	;convert segment to phys page
	jc @@fail
    movzx eax,al
    push ecx
	movzx ecx, byte ptr [esi-1]
    @GETPTEPTR ecx,ECX*4+1000h
    mov ecx,[ecx]
    mov cl,0
    or eax,ecx
	stosd
    pop ecx
	loop @@nextsegm
@@done00:
	mov ah,EMSS_OK
	ret
@@failA3:
@@failA3_1:
	mov ah,0A3h	;segment count exceeds mappable pages
@@fail:
	ret

;--- ax=4F01h (set map)

@@setmap:
	lodsw
	movzx eax,ax
	movzx ecx, [bEmsPhysPages]
	cmp eax,ecx
	ja @@failA3
	mov ecx, eax
    jmp EMS_RestorePagesFromEsi

;--- ax=4F02h (get size of save area)

@@getsize:
	cmp bh,0
    jnz @@failA3_1
	cmp bl,[bEmsPhysPages]
	ja @@failA3_1
	mov al, bl
	shl al,2		;4 bytes (makes Kyrandia 3 work [better]!?)
    add al,2		;2 extra bytes for size
	mov byte ptr [ebp].Client_Reg_Struc.Client_EAX, al
	mov ah, EMSS_OK
	ret
    align 4

ems4_get_set_partial_page_map ENDP

; 6750:
; AH = 50h: EMS 4.0 map multiple pages
; DX = handle
;  DS:SI -> mapping array
;  CX = items in array (ecx is destroyed, reload it from stack)
;  structure of mapping array:
;  WORD logical page (or -1 to unmap page)
;  WORD physical page (AL=0) or segment address (AL=1)

ems4_map_multiple PROC

	cmp	al,1
	ja	bad_subfunc
	
	movzx ecx, word ptr [ebp].Client_Reg_Struc.Client_ECX	; load EMM entry CX value
	movzx edi, word ptr [ebp].Client_Reg_Struc.Client_DS
	shl	edi,4
	movzx esi,si
	add	edi,esi		; edi -> map address buffer

if ?MASM
ems4_map_multiple_edi::
else
ems4_map_multiple_edi:
endif

; perform handle check here so that stack return address isn't blown

	call EMS_TEST_HANDLE
	mov esi, edi	

	push ebx
	push eax
	jecxz @@success
@@multi_loop:
	mov	bx,[esi+0]
	mov	ax,[esi+2]
	add	esi,4
	cmp byte ptr [esp+0],1	;subfunction 1?
	jne	@@mappage
	call EMS_Segm2Phys		;convert segment in AX to a page no in AL
	jc	@@multi_out
@@mappage:
	push ecx
	call EMS_MAP_REL_PAGE	;map page in DX:BX to phys page in AL
    pop ecx
    jc @@multi_out
	loop @@multi_loop
    call FlushTLB
@@success:	  
	MOV	ah,EMSS_OK
@@multi_out:
	mov [esp+1],ah
	pop eax
	pop	ebx
	ret
	
ems4_map_multiple ENDP

; 6751:
; AH = 51h: EMS 4.0 reallocate pages for handle
; DX = handle
; BX = new page count for handle
; out: BX=pages assigned to handle
;
ems4_realloc PROC

    movzx ecx, bx			; save new pages
	call EMS_GET_PAGES_ONE_HANDLE	;get curr pages in EBX, ESI->EMSHD
	
    mov edi,[EMSPageAllocationStart]
    
	cmp	ecx, ebx			; check new page count against original
	jb @@shrinkalloc
	je @@realloc_success	; no change needed

	sub	ecx, ebx			; get no of additional pages

	call GetFreeEMSPages
	cmp	ecx,eax
	ja @@toomany

	movzx eax,[esi].EMSHD.ehd_wIdx
    jmp @@test
@@nextitem:
    lea esi,[edi+eax*4]
    mov ax,[esi].EMSPD.wNext
@@test:    
    cmp ax,-1
    jnz @@nextitem

	call AllocateEMSPages	; allocate ECX pages
	jnc	@@realloc_success
@@toomany:
	mov	ah,EMSS_OUT_OF_FREE_PAGES
	ret

; trim off the trailing pages
; ECX=new page count, EBX=old page count

@@shrinkalloc:
    xor ebx, ebx
    mov eax, ebx
    jmp @@test2
@@nextitem2:    
    lea esi,[edi+eax*4]
    inc ebx
@@test2:    
    mov ax,[esi].EMSPD.wNext
    cmp ax,-1
    jz @@realloc_success
    cmp ebx, ecx
    jnz @@nextitem2
    jmp @@test3
@@freenext:
    lea	esi,[edi+eax*4]
	call ReleaseEMSPage		;preserves registers
@@test3:    
    mov ax,-1
    xchg ax,[esi].EMSPD.wNext
    cmp ax,-1
	jnz	@@freenext
    
@@realloc_success:
	mov	ebx,[ebp].Client_Reg_Struc.Client_EBX
	mov	ah,EMSS_OK
	ret

ems4_realloc ENDP

; 6752
; AH = 52h: EMS 4.0 attribute related
; AL = 0/1/2, DX=handle, BL=0/1
; AL=2:
; out AL=attr

ems4_attribute PROC
	cmp	al,2
	jb	@@get_set_attribute
	ja	bad_subfunc	; this is an invalid subfunction

;-- AL==2 and AL==0

@@is_volatile:
	mov byte ptr [ebp].Client_Reg_Struc.Client_EAX, 0	; al == 0, volatile attribute only
	mov ah,EMSS_OK
	ret

;-- AL==1    
    
@@get_set_attribute:
	call EMS_TEST_HANDLE; only valid handles please
	or al,al			; 0 is get, 1 is set
	jz @@is_volatile	; only volatile here (none survive warm reboot)
	or bl,bl			; 0 is "make volatile" (true anyway)
	jnz @@cannot_make_nonvolatile
	mov ah,EMSS_OK
	ret
@@cannot_make_nonvolatile:
	mov ah,EMSS_FEATURE_UNSUPP	; feature not supported
	ret
ems4_attribute ENDP

; 6753:
; AH = 53h: EMS 4.0 get/set handle name
; AL = 0: get handle name in ES:DI
; AL = 1: set handle name in DS:SI
; DX = handle
;
ems4_get_set_handle_name PROC
	cmp	al,1
	ja	bad_subfunc	; this is an invalid subfunction
	jz	@@ems4_setname

	call EMS_TEST_HANDLE
	movzx esi,WORD PTR [ebp].Client_Reg_Struc.Client_ES
	shl	esi,4
	movzx edi,di
	add	edi,esi		; edi -> handle name buffer address (dest)
	mov	esi, [EMSNameTable]
	movzx ecx,dl	; handle (index)
	lea esi, [esi+ecx*8]
	jmp @@ems4_getsetname

@@ems4_setname:
	movzx edi, si	;ESI will be destroyed by next call
	call EMS_TEST_HANDLE
	movzx esi,WORD PTR [ebp].Client_Reg_Struc.Client_DS
	shl	esi,4
	add	esi,edi		; esi -> handle name (source)
    
;--- resetting the name is always valid

    mov eax,[esi+0]
    or eax,[esi+4]
    jz @@reset_name

;--- check for a handle which already has this name    
;--- return status A1h if one exists
;--- don't care if the handle found is the same as the current one
    
    mov edi,esi
    push esi
    call find_handle_by_name_int
    pop esi
    and ah,ah	;was a handle with this name found?
    mov ah,0A1h
    jz @@failed
@@reset_name:    
    
	mov	edi, [EMSNameTable]
	movzx ecx,dl	; handle (index)
	lea edi, [edi+ecx*8]
    
@@ems4_getsetname:
	movsd
    movsd
	mov	ah,EMSS_OK
@@failed:    
	ret

ems4_get_set_handle_name ENDP

; 6754:
; AH = 54h: EMS 4.0 get various handle info
;
; AL = 0: get handle directory into ES:DI
; AL = 1: search handle by name in DS:SI, return handle in DX
; AL = 2: get total handles in BX

ems4_get_handle_info PROC
	cmp	al,1
	jb	getallhand
	je	@@find_handle_by_name
	cmp	al,2
	ja	bad_subfunc	; this is an invalid subfunction

;-- AL=2

	mov	bx,EMS_MAX_HANDLES
	mov	ah,EMSS_OK
	ret

; AL=0, write handle directory to caller buffer
; return in AL number of open handles
; return in ES:DI array of:
;   WORD handle
;   QWORD name

getallhand:
	movzx	esi,WORD PTR [ebp].Client_Reg_Struc.Client_ES
	shl	esi,4
	movzx edi,di
	add	esi,edi
	mov	edi, [EMSHandleTable]
	xor eax, eax		; AL will be count of open handles
	xor ecx, ecx
    push edx
	mov	edx, [EMSNameTable]
@@scan_handles:
	test [edi].EMSHD.ehd_bFlags, EMSH_USED
	jz	@@free_handle
	inc	eax

	mov	[esi+0],cx
	push DWORD PTR [edx+ecx*8+0]	; copy handle name
	pop	DWORD PTR [esi+2]
	push DWORD PTR [edx+ecx*8+4]
	pop	DWORD PTR [esi+6]
	add	esi,10
	
@@free_handle:
	add	edi,size EMSHD
	inc ecx
	cmp cl, EMS_MAX_HANDLES
	jb	@@scan_handles
    pop edx
    mov byte ptr [ebp].Client_Reg_Struc.Client_EAX, al
	mov	ah,EMSS_OK
	ret

;--- AL=1 search handle by name
;--- in: DS:SI->handle name
;--- out: DX=handle

@@find_handle_by_name:

	movzx edi,WORD PTR [ebp].Client_Reg_Struc.Client_DS
	shl	edi,4
	movzx esi,si
	add	edi,esi
find_handle_by_name_int::	;find handle by name, edi=name
	push ebx
	mov	eax,[edi+0]		; fetch to-be-searched name
	mov	ebx,[edi+4]		; (8 byte binary string)
if 0 ;MS Emm386 allows to search a handle with no name!
	or	eax,eax
	jnz	@@valid_search_term
	or	ebx,ebx
	jz	@@invalid_search_term
@@valid_search_term:
endif
	xor	ecx,ecx
	mov	edi, [EMSNameTable]
	mov	esi, [EMSHandleTable]
@@scan_for_name:
	test [esi].EMSHD.ehd_bFlags, EMSH_USED
	jz	@@skipitem
	cmp	[edi+0],eax
	jnz	@@skipitem
	cmp	[edi+4],ebx			; Note that open handles do not have
	jz	@@found_handle		; to have a name.
@@skipitem:
	add	esi,size EMSHD
	add edi,8
	inc	ecx
	cmp	cl,EMS_MAX_HANDLES
	jb	@@scan_for_name
	pop ebx
	mov	ah,0a0h				; "no corresponding handle found"
	ret
@@found_handle:
	pop ebx
	mov edx,ecx
	mov	ah,EMSS_OK
	ret
if 0
@@invalid_search_term:
	pop ebx
	mov	ah,0a1h			; "handle found had no name"
	ret
endif

ems4_get_handle_info ENDP

;--- alter page map and jump/call structures

log_phys_map struc
wLogPage	   DW ?	; logical page (handle in DX)
wPhysPage	   DW ?	; physical pages if AL=0, segments if AL=1
log_phys_map ends

map_and_jump struc
target_address 		DD ? ; far16 jump address
new_page_map_len	DB ? ; items in new_page_map_ptr
new_page_map_ptr	DD ? ; far16 pointer to log_phys_map structure
map_and_jump ends


;--- client DS:SI -> map_and_jump 
;--- AL=0 -> physical page numbers
;--- AL=1 -> segment addresses

ems4_map_new_pagemap proc
	movzx edi, word ptr [ebp].Client_Reg_Struc.Client_DS
	shl	edi,4
	movzx esi,si
	add	edi,esi		; edi -> map address buffer
	movzx ecx, word ptr [edi].map_and_jump.new_page_map_ptr+0
	movzx esi, word ptr [edi].map_and_jump.new_page_map_ptr+2
	push edi
	shl esi, 4
	add esi, ecx
	movzx ecx, [edi].map_and_jump.new_page_map_len
	mov edi, esi
	call ems4_map_multiple_edi	;map ECX pages from EDI, DX=handle, AL=type
	pop edi
    and ah,ah
	ret
ems4_map_new_pagemap endp

; 6755:
; AH = 55h: EMS 4.0 alter page map and jump
; AL = 0/1
; DX = handle
; DS:SI -> map_and_jump structure

ems4_alter_map_jump proc
	call ems4_map_new_pagemap
	jnz @@failed
	mov ecx,[edi].map_and_jump.target_address
	mov word ptr [ebp].Client_Reg_Struc.Client_EIP, cx
	shr ecx, 16
	mov [ebp].Client_Reg_Struc.Client_CS, ecx
@@failed:
	ret
ems4_alter_map_jump endp

; 6756:
; AH = 56h: EMS 4.0 alter page map and call
; AL = 0/1/2
; DX = handle
; if AL=0/1: [in] DS:SI -> map_and_call structure ()
; if AL=2: [out] BX = additional stack space required

map_and_call struc
					map_and_jump <?>
old_page_map_len	db ? ; items in old_page_map_ptr
old_page_map_ptr	dd ? ; far16 pointer to log_phys_map structure
map_and_call ends

ems4_alter_map_call proc
	cmp al,2
	jz	@@getstackspace

	call ems4_map_new_pagemap
	jnz @@failed

if 0	; nested execution consumes ring 0 stack, which is to avoid

;--- prepare nested execution
;--- and run the client proc

	push	edx
    push	eax
	call	Begin_Nest_Exec
	movzx	edx,word ptr [edi].map_and_call.target_address+0
	movzx	ecx,word ptr [edi].map_and_call.target_address+2
    call	Simulate_Far_Call
    call 	Resume_Exec
	call	End_Nest_Exec
    pop		eax
    pop		edx
    
;--- set old state

	movzx	ecx, [edi].map_and_call.old_page_map_len
	movzx	esi, word ptr [edi].map_and_call.old_page_map_ptr+0
	movzx 	edi, word ptr [edi].map_and_call.old_page_map_ptr+2
	shl		edi, 4
	add 	edi, esi
	call 	ems4_map_multiple_edi
@@failed:
    ret
@@getstackspace:
	mov bx, 4
	ret

else

;--- this implementation copies 16-bit code onto the client's stack.
;--- this code calls int 67h, ah=50h (map multiple pages).

    mov esi, offset clproc
    mov al, byte ptr [ebp].Client_Reg_Struc.Client_EAX
    mov [esi+(_clal-clproc)],al
    movzx eax,[edi].map_and_call.old_page_map_len
    mov [esi+(_clcx-clproc)],ax
    mov [esi+(_cldx-clproc)],dx
    mov eax,[edi].map_and_call.old_page_map_ptr
    mov [esi+(_clsi-clproc)],ax
    shr eax,16
    mov [esi+(_clds-clproc)],ax
    
	push edi
	movzx ecx,word ptr [ebp].Client_Reg_Struc.Client_ESP
	movzx edi,word ptr [ebp].Client_Reg_Struc.Client_SS
    push edi
    shl edi, 4
    sub ecx, sizeclproc
    push ecx
    mov word ptr [ebp].Client_Reg_Struc.Client_ESP,cx
    add edi, ecx
    mov ecx, sizeclproc
    rep movsb
    pop eax
    pop ecx
    pop edi
    push edx
    mov edx,eax
    call Simulate_Far_Call
    mov cx,word ptr [edi].map_and_jump.target_address+2
    movzx edx,word ptr [edi].map_and_jump.target_address+0
    call Simulate_Far_Call
    pop edx
	mov ah,EMSS_OK    
@@failed:    
	ret
    
@@getstackspace:
	mov bx, sizeclproc+4
	ret

endif
	align 4
    
ems4_alter_map_call endp

;-------------------------------------------------------------
; 6757:
; AH = 57h: EMS 4.0 move/exchange memory region
; AL = 0: move memory region
; AL = 1: exchange memory region
; DS:SI -> EMM57

;-- this function must work even if no EMS page frame is defined!
;-- EMS regions may overlapp!

EMM57 struc
e57_dwSize	DD ?	; +0  size of region
e57_bSrcTyp DB ?	; +4  src memory type
e57_wSrcHdl DW ?	; +5  src handle
e57_wSrcOfs DW ?	; +7  src ofs
e57_wSrcSeg DW ?	; +9  src segm./log. page
e57_bDstTyp DB ?	; +11 dst memory type
e57_wDstHdl	DW ?	; +12 dst handle
e57_wDstOfs	DW ?	; +14 dst ofs
e57_wDstSeg	DW ?	; +16 dst segm./log. page
EMM57 ends

;--- memory type:
;--- 00: conv. memory
;--- 01: expanded memory
;--- handle:
;--- == NULL: conv. memory
;--- <> NULL: EMS handle

RegionDest	equ <ebp.Client_Reg_Struc.Client_Error>

ems4_move_memory PROC

	cmp	al,1
	ja	bad_subfunc	; this is an invalid subfunction
	movzx edi,WORD PTR [ebp].Client_Reg_Struc.Client_DS
	movzx esi,si
	shl	edi,4
	add	edi,esi		; edi -> EMS region buffer address

	mov [RegionDest],0

if ?EMSDBG
	@DbgOutS <"EMM 57h: siz=">,1
	@DbgOutD [edi].EMM57.e57_dwSize,1
	@DbgOutS <", src=">,1
	@DbgOutB [edi].EMM57.e57_bSrcTyp,1
	@DbgOutS <"/">,1
	@DbgOutW [edi].EMM57.e57_wSrcHdl,1
	@DbgOutS <"/">,1
	@DbgOutW [edi].EMM57.e57_wSrcSeg,1
	@DbgOutS <"/">,1
	@DbgOutW [edi].EMM57.e57_wSrcOfs,1
	@DbgOutS <", dst=">,1
	@DbgOutB [edi].EMM57.e57_bDstTyp,1
	@DbgOutS <"/">,1
	@DbgOutW [edi].EMM57.e57_wDstHdl,1
	@DbgOutS <"/">,1
	@DbgOutW [edi].EMM57.e57_wDstSeg,1
	@DbgOutS <"/">,1
	@DbgOutW [edi].EMM57.e57_wDstOfs,1
endif

	mov	ecx,[edi].EMM57.e57_dwSize
	test ecx,ecx
	je	@@ok						; always succeeds if no bytes are moved
	mov	ah,EMSS_REGLEN_EXCEEDS_1MB
	cmp	ecx,65536*16              	; does region length exceed 1M?
	ja	@@exit

; process region destination information

	movzx	ecx,[edi].EMM57.e57_wDstOfs
	movzx	ebx,[edi].EMM57.e57_wDstSeg
	cmp		[edi].EMM57.e57_bDstTyp,0	;0 = conv, 1 = expanded
	je	@@calc_dest_conv

; destination is EMS

	mov dx, [edi].EMM57.e57_wDstHdl
	call EMS_TEST_HANDLE
	
	mov	ah,EMSS_OFFS_EXCEEDS_PGSIZ		; preload error code, specified offset is outside logical page
	test ch,0C0h	; ecx must be < 4000h (it is a EMS page offset!)
	jnz	@@exit

	mov		eax, ?SCRATCHLINEAR+104000h
	lea		esi, [ecx+eax]
	mov		[RegionDest],esi
	add		ecx,[edi].EMM57.e57_dwSize
	
; try to map in all needed pages (max space is 1 MB + 16 kB)

	@GETPTEPTR esi, 2000h+?SCRATCHPTE+104h*4, 1
	call	mappages
    jc		@@exit
	jmp 	@@calc_dest_done

@@calc_dest_conv:
	shl	ebx,4		; convert seg to memory offset
	add	ebx,ecx
	mov	[RegionDest],ebx
	mov ah,0A2h		; conv memory region must not exceed 1 MB boundary
	add	ebx, [edi].EMM57.e57_dwSize
	cmp ebx, 100000h
	ja	@@exit
@@calc_dest_done:	 

; process region source information

	movzx	ecx,[edi].EMM57.e57_wSrcOfs
	movzx	ebx,[edi].EMM57.e57_wSrcSeg
	cmp		[edi].EMM57.e57_bSrcTyp,0	; 0 = conv, 1 = expanded
	je	@@calc_src_conv

; source is EMS

	mov dx, [edi].EMM57.e57_wSrcHdl
	call EMS_TEST_HANDLE
	
	mov	ah,EMSS_OFFS_EXCEEDS_PGSIZ		; preload error code to specified offset is outside logical page
	test ch,0C0h	; ecx must be < 4000h
	jnz	@@exit
	
	mov		eax,?SCRATCHLINEAR
	add		ecx,[edi].EMM57.e57_dwSize
	
; try to map in all needed pages (max size is 1 MB)

	@GETPTEPTR esi, 2000h+?SCRATCHPTE, 1
	call	mappages
    jc		@@exit
	mov		ecx, [edi].EMM57.e57_dwSize
	movzx	esi, [edi].EMM57.e57_wSrcOfs
	add		esi, ?SCRATCHLINEAR

; if src and dest are EMS test if they overlapp
	
	cmp		[edi].EMM57.e57_bDstTyp,0	; is dst also expanded memory?
	jz		@@calc_src_done
	cmp		dx, [edi].EMM57.e57_wDstHdl	; are handles equal?
	jnz 	@@calc_src_done

	movzx eax, [edi].EMM57.e57_wDstSeg
	movzx edx, [edi].EMM57.e57_wSrcSeg
	shl eax, 14
	shl edx, 14
	or	ax, [edi].EMM57.e57_wDstOfs
	or	dx, [edi].EMM57.e57_wSrcOfs

;--- the problem case is:
;--- source < destination AND source + size > destination

	cmp edx, eax		; source < destination?
	jnc @@calc_src_done	; no, use std copy
	add edx, ecx		; edx == source + size
	cmp eax, edx		; destination >= source + size?
	jnc @@calc_src_done	; yes, use std copy
	jmp @@overlapped

@@calc_src_conv:
	shl	ebx,4			; convert seg to memory offset
	add	ebx,ecx
	mov	ecx, [edi].EMM57.e57_dwSize
	mov	esi,ebx
	mov ah,0A2h			; conv memory region must not exceed 1 MB boundary
	add ebx, ecx
	cmp ebx, 100000h
	ja	@@exit
	
@@calc_src_done:
	mov	edi, [RegionDest]
	cmp	byte ptr [ebp].Client_Reg_Struc.Client_EAX,0
	jne	@@xchg
if ?IRQWINDOW
	mov		edx, ecx
@@movenext:
	mov		ecx, edx
    cmp		ecx, BLOCKSIZE
    jb		@@blocksizeok
    mov		ecx, BLOCKSIZE
@@blocksizeok:
	sub		edx, ecx
endif
	MOV 	EAX,ECX
	SHR 	ECX,2
	REP 	MOVS DWORD PTR [ESI], DWORD PTR [EDI]
	@BIG_NOP
	MOV 	ECX,EAX
	AND 	ECX,3
	REP 	MOVS BYTE PTR [ESI],BYTE PTR [EDI]
	@BIG_NOP
if ?IRQWINDOW
	call	Yield    ;expects ebp -> Client_Reg_Struc
	and		edx, edx
	jnz		@@movenext
endif
@@ok:
	mov	ah,EMSS_OK	; zero ah, no error return

; exit with code in AH

@@exit:
if ?EMSDBG
	@DbgOutS <"=">,1
	@DbgOutB ah,1
	@DbgOutS <10>,1
endif
	mov	edx,[ebp].Client_Reg_Struc.Client_EDX
	mov	ebx,[ebp].Client_Reg_Struc.Client_EBX
	ret

@@overlapped:
	mov	edi, [RegionDest]
	cmp	byte ptr [ebp].Client_Reg_Struc.Client_EAX,0
	jne	@@xchg
	std
	lea		esi,[esi+ecx-1]
	lea		edi,[edi+ecx-1]
	mov		eax,ecx
	and		ecx,3
	REP 	MOVS BYTE PTR [ESI],BYTE PTR [EDI]
	MOV 	ECX,EAX
	sub		esi,3
	sub		edi,3
	SHR 	ECX,2
	REP 	MOVS DWORD PTR [ESI], DWORD PTR [EDI]
	cld
	mov		ah,EMSS_OVERLAP_OCCURED	;status "overlapp occured"
	jmp		@@exit
@@xchg:
	mov	ah,cl
	and	cl,3
	je	@@fullx
@@xb:
	mov	al,[edi]
	movsb
	mov	[esi-1],al
	dec cl
	jnz	@@xb
@@fullx:
	mov	cl,ah
	shr	ecx,2
	jz @@ok
@@xdw:
	mov	eax,[edi]
	movsd
	mov	[esi-4],eax
	dec ecx
	jnz @@xdw
	jmp	@@ok

;--- map in EMS pages in scratch region
;--- ecx = max "offset"
;--- eax = start linear address to map pages in
;--- DX:BX = EMS page start
;--- esi -> PTE
	
mappages:
	add		ecx, eax		;let ecx point to end of region
@@nextpagetomap:
	pushad
	call	EMS_get_abs_page;get abs page of DX:BX in BX
	jc		@@map_exit
    mov		edi, esi
	call	EMS_MAP_ABS_PAGE_EX		;requires EAX,BX,EDI to be set
	popad
	inc		ebx				;next EMS page
	add		eax, 4000h		;proceed with linear address
	add		esi, 4*4		;proceed with PTE pointer
	cmp		eax,ecx
	jb		@@nextpagetomap
    call	FlushTLB
	retn
@@map_exit:
	mov     byte ptr [esp].PUSHADS.rEAX+1,ah
    popad
    retn
	
ems4_move_memory ENDP

; 6758:
; AH = 58h: EMS 4.0 get addresses of mappable pages, number of mappable pages
; AL = 0: ES:DI -> buffer, returns no of pages in CX
; buffer item:
;  WORD segment
;  WORD physical page
; AL = 1: returns no of pages in CX
; the items in the buffer must be sorted in ascending segment order!

ems4_get_mappable_info PROC
	cmp	al,1
	ja	bad_subfunc	; only 0 and 1 allowed

	movzx ecx, [bEmsPhysPages]
	mov	WORD PTR [ebp].Client_Reg_Struc.Client_ECX,cx	; mappable pages in CX

	cmp al,1
	je	@@nummap
	jecxz @@nummap
	
	movzx esi,WORD PTR [ebp].Client_Reg_Struc.Client_ES
	shl	esi,4
	movzx edi,di
	add	edi,esi		; edi -> buffer address
    mov ah,0
@@mapinfo_loop:
	call @@getpage	; get phys page in AL
    movzx edx,al
    mov ah,0
    shl eax,16
    mov ah,byte ptr [edx+offset EMSPage2Segm]
    mov al,0
    stosd
	loop @@mapinfo_loop
@@nummap:
	mov	ah,EMSS_OK
	ret
    
;--- get the next segment address to AH    
    
@@getpage:
    push ecx
	mov esi, offset EMSPage2Segm
    mov dl,-1
    mov cl,[bEmsPhysPages]
@@nextitem:
	lodsb
    sub al,ah
    jbe @@skipitem
    cmp al,dl
    ja @@skipitem
    mov dl,al
    mov dh,cl
@@skipitem:
    loop @@nextitem
    mov al,[bEmsPhysPages]
    sub al,dh	
    pop ecx
    ret
ems4_get_mappable_info ENDP

; 6759:
; AH = 59h: EMS 4.0 get hardware config/get number of raw pages
; AL = 1: return raw pages in DX and BX
; AL = 0: get hardware config in ES:DI

ems4_get_config PROC
	cmp	al,1	; only subfunctions 0+1 supported
	ja	bad_subfunc
	je	EMS_GET_UNALLOCATED_PAGE_COUNT
	
	movzx	esi, WORD PTR [ebp].Client_Reg_Struc.Client_ES
	shl		esi, 4
	movzx	edi, di
	add		edi, esi
    mov		esi,offset emm59_
    mov		ecx,size emm59_ shr 1
    rep		movsw
	mov		ah,EMSS_OK
	ret
    
ems4_get_config ENDP

; 675A:
; AH = 5ah: EMS 4.0 allocate handle and standard/raw pages
; in  AL = 0/1
; in  BX = pages to allocate (may be 0)
; out DX = handle
;
ems4_allocate_pages PROC

	cmp	al,1	; subfunction must be 0 or 1, we don't care if either
	ja	bad_subfunc
	jmp	allocate_pages_plus_zero

ems4_allocate_pages ENDP

; 675B: alternate map register sets
; AL=0/1/2/3/4/5/6/7/8

ems4_alt_map_reg_set PROC

if ?SUPP5B
	mov ah,9Ch	;alternate map register sets not supported
    cmp al,1
    jb @@is00
    jz @@is01
    cmp al,3
    jb @@is02
    jz @@is03
    cmp al,5
    jb @@is04
    jz @@is05
    cmp al,7
    jb @@is06
    jz @@is07
	cmp al,8
    jz @@is08
    jmp bad_subfunc
@@is00:
	mov bl,0
    mov eax,[mapptr]
    and eax, eax
    jz  @@noptr
    push eax
    movzx edi,ax
    shr eax,16
    shl eax,4
    add edi, eax
    mov al,0
    call save_page_map_int
    pop eax
@@noptr:    
    mov word ptr [ebp].Client_Reg_Struc.Client_EDI,ax
    shr eax,16
    mov word ptr [ebp].Client_Reg_Struc.Client_ES,ax
    jmp @@done
@@is01:
	cmp bl,0
    jnz	@@exit
	mov ax,word ptr [ebp].Client_Reg_Struc.Client_ES
    shl eax,16
    mov ax,word ptr [ebp].Client_Reg_Struc.Client_EDI
    mov [mapptr],eax
    and eax, eax
    jz  @@done
    movzx esi,ax
    shr eax,16
    shl eax,4
    add esi, eax
    call restore_page_map_int
	jmp @@done
@@is02:
	mov dx,emm59_.e59_sizcont
	jmp @@done
@@is03:
@@is05:
	mov bl,0
    jmp @@done
@@is04:
@@is06:
@@is07:
@@is08:
	cmp bl,0
    jnz	@@exit
@@done:
	mov ah,EMSS_OK
@@exit:    
else
	mov ah,0A4h	;access denied by OS
endif    
    ret

ems4_alt_map_reg_set ENDP

endif	;?LIM32

if ?VCPI
;
; AX=DE00: VCPI presence detection
;  return BH = 1 (major version), BL = 0 (minor version)
;
VCPI_Presence	PROC
	mov	word ptr [ebp].Client_Reg_Struc.Client_EBX,100h
	mov	ah,EMSS_OK
	ret
VCPI_Presence	ENDP

;
; AX=DE01: VCPI get protected mode interface
;  inp: es:di -> client zero page table (to fill)
;		ds:si -> three descriptor table entries in client's GDT (to fill)
;  out: [es:di] page table filled
;		di: first uninitialized page table entry (advanced by 4K)
;	   ebx: offset to server's protect mode code segment

VCPI_GetInterface	PROC
	movzx edi,WORD PTR [ebp].Client_Reg_Struc.Client_DS
	shl	edi,4
	movzx esi,si
	add	edi,esi			; esi -> client GDT entries
	mov	esi, offset V86GDT + FLAT_CODE_SEL
	movsd
    movsd
    movsd
    movsd

	movzx esi,WORD PTR [ebp].Client_Reg_Struc.Client_ES
    movzx edi,WORD PTR [ebp].Client_Reg_Struc.Client_EDI
	shl	esi,4
	add	edi,esi				; edi -> client zero page table
	@GETPTEPTR	esi,1000h,1	; esi -> page table for first 1M

;--- Jemm must ensure that 
;--- the VCPI_PM_ENTRY label will be in shared memory. Since this label is
;--- now at the very beginning of V86 segment, 1 page should suffice

if ?CODEIN2PAGE
	mov 	ecx, 440h+8 ;this is offset in page table for 112000h
else
	mov 	ecx, 440h+4 ;this is offset in page table for 111000h
endif	 
	add		word ptr [ebp].Client_Reg_Struc.Client_EDI,cx
	shr		ecx, 2
@@vgiloop:
	lods dword ptr [esi]
	and	ah,0F1h		; clear bits 9-11
	stos dword ptr [edi]
	loop @@vgiloop

if 1
	and byte ptr es:[edi-4], not 4 	;set shared page to system
endif

	mov	[ebp].Client_Reg_Struc.Client_EBX,OFFSET VCPI_PM_Entry
	mov	ah,EMSS_OK
	ret

VCPI_GetInterface	ENDP

; AX=DE02: VCPI get maximum physical memory address
;  return edx == physical address of highest 4K page available
;
VCPI_GetMax	PROC
	mov	edx,[dwTotalMemory]
if ?EMX
	test bV86Flags, V86F_EMX
	jz @@noemx
	mov	edx,[dwMaxMem4K]	;mem in 4K pages
	shl edx, 12				;convert to bytes
	add edx, [DMABuffStartPhys]
@@noemx:	
endif	 
	dec	edx
	and	dx,NOT 0fffh

	mov	ah,EMSS_OK
	ret
VCPI_GetMax	ENDP

;
; AX=DE03: VCPI get number of free pages
;  out: edx == number of free pages
;
; this function may also be called from protected-mode.
; then SS+DS+ES are flat, but they are NOT necessarily FLAT_DATA_SEL!!!

VCPI_GetFreePages PROC

	call Pool_GetFreeXMSPages	; get free 4k XMS pages in EDX
	mov	ecx,edx
	call Pool_GetFree4KPages	; free pool pages in eax
	add	eax,ecx					; eax == all free pages
    
	mov	edx,[dwMaxMem4K]
    sub edx,[dwUsedMem4K]
    jc @@nofree

	cmp	edx, eax
	jb	@@done
	mov	edx, eax
@@done:
	mov	ah,EMSS_OK
	ret

@@nofree:
	xor	edx,edx
	jmp	@@done
    align 4

VCPI_GetFreePages ENDP

;
; AX=DE04: VCPI allocate a 4K page
;  out: edx == physical address of 4K page allocated
;
; this function may also be called from protected-mode.
; then SS+DS+ES are flat, but they are NOT FLAT_DATA_SEL!!!

VCPI_Allocate4K	PROC public

	mov	eax,[dwMaxMem4K]
    sub eax,[dwUsedMem4K]
    jbe @@fail

@@tryagain:
	call Pool_Allocate4KPage	; see if any pool block has 4K free
	jnc	@@success
	call Pool_ExpandAnyBlock	; try to expand a pool block
	jnc	@@tryagain
	call Pool_AllocateEMBForPool
	jnc	@@tryagain
@@fail:
	mov	ah,EMSS_OUT_OF_FREE_PAGES
	ret
@@success:
	mov edx, eax
	inc [dwUsedMem4K]
	mov	ah,EMSS_OK
	ret
	align 4

VCPI_Allocate4K	ENDP

;
; AX=DE05: VCPI free a 4K page
;  in: edx == physical address of 4K page to free
;
; this function may also be called from protected-mode.
; then SS+DS+ES are flat, but they are NOT FLAT_DATA_SEL!!!

VCPI_Free4K	PROC
	call Pool_Free4KPage
	jc	@@bad
    dec [dwUsedMem4K]
	mov	ah,EMSS_OK
	ret
@@bad:
	mov	ah,EMSS_LOG_PAGE_INVALID
	ret

VCPI_Free4K	ENDP

;
; AX=DE06: VCPI get physical address of 4K page in first megabyte
;  entry cx = page number (cx destroyed, use stack copy)
;  return edx == physical address of 4K page
;
VCPI_GetAddress	PROC
	movzx ecx, word ptr [ebp].Client_Reg_Struc.Client_ECX
	cmp	cx,256
	jae	@@vga_bad		; page outside of first megabyte

	@GETPTE	edx, ecx*4+1000h
	and	dx,0f000h		; mask to page frame address
	mov	ah,EMSS_OK
	ret

@@vga_bad:
	mov	ah,EMSS_PHYS_PAGE_INVALID
	ret

VCPI_GetAddress	ENDP

;
; AX=DE07: VCPI read CR0
;  return EBX == CR0
;
VCPI_GetCR0	PROC
	mov	ebx,cr0
    mov [ebp].Client_Reg_Struc.Client_EBX, ebx
	mov	ah,EMSS_OK
	ret
VCPI_GetCR0	ENDP
 
;
; AX=DE08: VCPI read debug registers
;  call with ES:DI buffer pointer. Returns with buffer filled.
;  (8 dwords, dr0 first, dr4/5 undefined)
;
VCPI_ReadDR	PROC
	movzx esi,WORD PTR [ebp].Client_Reg_Struc.Client_ES
	shl	esi,4
	movzx edi,di
	add	edi,esi
	mov	eax,dr0
    stosd
	mov	eax,dr1
    stosd
	mov	eax,dr2
    stosd
	mov	eax,dr3
    stosd
	mov	eax,dr6
    mov [edi+8], eax
    stosd
    mov eax,dr7
    mov [edi+8], eax
    stosd
	mov	ah,EMSS_OK
	ret
VCPI_ReadDR	ENDP

;
; AX=DE09: VCPI write debug registers
;  call with ES:DI buffer pointer. Updates debug registers.
;  (8 dwords, dr0 first, dr4/5 ignored)
;
VCPI_WriteDR	PROC
	movzx esi,WORD PTR [ebp].Client_Reg_Struc.Client_ES
	shl	esi,4
	movzx edi,di
	add	esi,edi
    lodsd
	mov	dr0,eax
    lodsd
	mov	dr1,eax
    lodsd
	mov	dr2,eax
    lodsd
	mov	dr3,eax
    add esi,8
    lodsd
	mov	dr6,eax
    lodsd
	mov	dr7,eax
	mov	ah,EMSS_OK
	ret
VCPI_WriteDR	ENDP

;
; AX=DE0A: VCPI get 8259A interrupt vector mappings
;  return bx == 1st vector mapping for master 8259A (IRQ0-IRQ7)
;	 cx == 1st vector mapping for slave 8259A (IRQ8-IRQ15)
;
VCPI_GetMappings	PROC
	mov	bx, [wMasterPICBase]
	mov	cx, [wSlavePICBase]
	mov	word ptr [ebp].Client_Reg_Struc.Client_EBX,bx
	mov	word ptr [ebp].Client_Reg_Struc.Client_ECX,cx
	mov	ah,EMSS_OK
	ret
VCPI_GetMappings	ENDP

; AX=DE0B: VCPI set 8259A interrupt vector mappings
;  entry bx == 1st vector mapping for master 8259A (IRQ0-IRQ7)
;	 cx == 1st vector mapping for slave 8259A (IRQ8-IRQ15)
;-- this is meant just as info, the client has to program the PIC itself

VCPI_SetMappings	PROC

	mov ecx, [ebp].Client_Reg_Struc.Client_ECX
	mov [wMasterPICBase],bx
	mov [wSlavePICBase],cx
	mov	ah,EMSS_OK
	ret
VCPI_SetMappings	ENDP

.text$03 ends

.text$02 segment

;--- the following 3 procs must be located in the first page.
;--- If this is no longer possible,
;--- the VCPI shared address space has to be increased.

; VCPI switch V86 mode to protected mode
; inp: AX=DE0C
;     ESI -> linear address of "v86 to protected-mode switch" data
;   set by EMM entry code:
;     ESP -> ecx, edi, esi
;     DS,ES=FLAT; FS,GS=NULL (done by cpu)
; out: GDTR, IDTR, LDTR, TR loaded for client
;     SS:ESP=?STKSIZE (must provide at least 16 byte space for client)
;                    HIWORD(ESP) is cleared
; modifies EAX, ESI
;

?CLEARTB	equ 1

VCPI_V86toPM	PROC

	mov ecx,[ebp].Client_Reg_Struc.Client_ECX
    mov ebp,[ebp].Client_Reg_Struc.Client_EBP
	mov ax, V86_STACK_SEL 			; some poorly written VCPI clients expect
    mov ss, eax     				; hiword(esp) to be cleared.
	mov	eax,[esi].V862PM.swCR3		; set client's context *first*
	mov	cr3,eax

	mov	eax,[esi].V862PM.swIDTOFFS	; set up client's IDT
	lidt fword ptr [eax]
	mov	eax,[esi].V862PM.swGDTOFFS	; set up client's GDT
	movzx esp,[esi].V862PM.swTR
	lgdt fword ptr [eax]
if ?CLEARTB    
	mov	eax,[eax+2] 				; EAX == linear address of client's GDT
	and	BYTE PTR ds:[esp+eax+5],NOT 2	; clear task busy bit in TSS descriptor
endif    
	ltr	sp							; set up client's TSS
	lldt [esi].V862PM.swLDTR		; set up client's LDT
	mov esp,?HLPSTKSIZE
	jmp	[esi].V862PM.swCSEIP		; jump to client's entry point

VCPI_V86toPM	ENDP

	align 4
	
; VCPI switch protected mode to v86 mode
;  inp: SS:ESP set for IRETD to V86, PM far call return address to discard;
;       stack must be in shared address space.
;       AX=DE0C
;		DS -> selector containing full shared address space 0-11xxxx
;  out: CR3, GDTR, IDTR, LDTR, TR loaded for server,
;	 IRETD will load SS:ESP and all segment registers, then enable v86 mode.
;  modifies: EAX
;
;-- for speed reasons the following lines are a bit mixed.
;-- but what is done is simple:
;-- 1. switch to host context (SS:ESO will stay valid, stack is in 1. MB)
;-- 2. load IDTR, GDTR, LDTR, TR for VCPI host
;-- 3. clear task busy bit in host's TSS descriptor
;-- 4. clear task switch flag in CR0
;-- 5. IRETD will switch to v86 mode, interrupts disabled

VCPI_PMtoV86	PROC

	cli					; client should have disabled interrupts, but not all do
	add	esp,5*4			; position ESP to EFL+4 on stack
	mov	eax,[V86CR3]
    push 23002h			; set flags VM=1, NT=0, IOPL=3, IF=0, TF=0
	mov	cr3,eax
    sub esp,2*4
	lgdt fword ptr [GDT_PTR]
	xor	eax,eax
	lidt fword ptr [IDT_PTR]
	lldt ax
	and	byte ptr [V86GDT+V86_TSS_SEL+5],NOT 2
	mov	al,V86_TSS_SEL
	clts
	ltr	ax
	iretd

VCPI_PMtoV86	ENDP


;-- put the VCPI PM entry at the very beginning. This entry
;-- must be in the shared address space, and just the first page
;-- is shared!
;-- entry for EMM routines called from protected mode

	align 4

VCPI_PM_Entry	PROC

	cmp	ax,0de0ch		; see if switch from protected mode to V86 mode
	je	VCPI_PMtoV86	; yes, give it special handling
	pushfd
	push ds				; have to save segments for p-mode entry
	push es

	pushad

	mov	ecx,cs
	add	ecx,8
	mov	ds,ecx			; load DS,ES with a copy of FLAT_DATA_SEL
	mov	es,ecx

;--- segment registers should *all* be set *before* switching contexts!
;--- why? because GDT of client might be located in unreachable space.
;--- get client SS:ESP + CR3, switch to host stack and context

	cli					; don't allow interruptions
    mov ebp, ss
    mov esi, esp
    mov edi, cr3
    mov ss, ecx
	mov	esp, [dwStackCurr]
	mov	ecx, [V86CR3]
	mov	cr3, ecx
    push ebp            ;save client's SS
    push esi            ;save client's ESP
    push edi            ;save client's CR3

if ?SAFEMODE
	sub	esp,8+8
	sgdt [esp+0]
	sidt [esp+8]
	lgdt fword ptr [GDT_PTR]
	lidt fword ptr [IDT_PTR]
	mov cx, FLAT_DATA_SEL
    mov	ss, ecx
	mov	ds, ecx
	mov	es, ecx
endif

	cld

	cmp	ah,0deh
	jne	@@INV_CALL	; only allow VCPI calls from protected mode interface

; other than de0ch, don't allow anything other than de03h,de04h,de05h from PM
	cmp	al,3
	jb	@@INV_CALL
	cmp	al,5
	ja	@@INV_CALL

if ?VCPIDBG
	push eax
    push edx
endif

	movzx ecx,al
	call [VCPI_Call_Table+ECX*4]
if ?VCPIDBG
	mov ebp,esp
	@DbgOutS <"VCPI pm, inp: ax=">,1
	@DbgOutW <word ptr [ebp+4]>,1
	@DbgOutS <" edx=">,1
	@DbgOutD <dword ptr [ebp+0]>,1
	@DbgOutS <", out: ax=">,1
    @DbgOutW ax,1
	@DbgOutS <" edx=">,1
    @DbgOutD edx,1
	@DbgOutS <10>,1
    add esp,8
endif

@@PM_ret:
if ?SAFEMODE
	lgdt fword ptr [esp+0]
	lidt fword ptr [esp+8]
	add esp,8+8
endif
	pop	ecx
	pop esi
	pop edi
	mov	cr3, ecx	; restore client context *first* and
	mov ss, edi		; then restore client SS:ESP, thus client's GDT
	mov esp, esi	; need not be located in shared address space
	mov [esp].PUSHADS.rEDX,edx
	mov byte ptr [esp].PUSHADS.rEAX+1,ah
	popad
	pop	es
	pop	ds
	popfd
	retf
@@INV_CALL:
if ?VCPIDBG
	@DbgOutS <"VCPI pm, invalid call ax=">,1
	@DbgOutW ax,1
	@DbgOutS <10>,1
endif
	mov	ah,EMSS_INVALID_SUBFUNC
	jmp @@PM_ret
    
VCPI_PM_Entry	ENDP

.text$02 ends

endif	;?VCPI

.text$03 segment

; dynamically compute free EMS pages
;  if fixed allocation, check only current EMS store
; return free pages in EAX
; other registers preserved

GetFreeEMSPages	PROC public

	push edx
	call Pool_GetFreeXMSPages	; get free XMS pages in EDX
	shr	edx,2					; convert 4K to 16K pages
	call Pool_GetFree16KPages	; get free EMS pages in EAX
	add	eax,edx
    
	mov edx, [EMSPagesMax]
    sub edx, [EMSPagesUsed]		; ecx == free EMS pages numbers
    jbe @@nofree
    cmp edx, eax				
    jnc @@eaxok
    mov eax, edx			   	; use the lower value
@@eaxok:    

@@ret:
if ?POOLDBG
	@DbgOutS <"GetEMSPageCount: eax=">,1
	@DbgOutD eax,1
	@DbgOutS <10>,1
endif
	pop edx
	ret

@@nofree:
	xor	eax,eax
	jmp	@@ret
    align 4

GetFreeEMSPages	ENDP

; allocate an EMS page
; upon entry edi -> EMSPD for new page to allocate
; return carry if fail, due to internal failure
; destroys EAX

AllocateEMSPage	PROC

	push edi
	push edx

@@tryagain:
	call Pool_Allocate16KPage	; see if any pool block has 16K free
	jnc	@@success
	call Pool_ExpandAnyBlock	; expand a block
	jnc	@@tryagain
	call Pool_AllocateEMBForPool
	jnc	@@tryagain
	@DbgOutS <"AllocateEMSPage, out of memory",10>,?POOLDBG
    jmp @@exit
@@success:

;  set EMSPD.wPD == index of allocation block
;  set EMSPD.bNibOfs == nibble offset in allocation block (2 * 48)

	shr	eax,6		; convert to 64-byte offset (block count)
	mov	[edi].EMSPD.wPD,ax
    sub edi, [EMSPageAllocationStart]
    shr edi, 2
    
	@DbgOutS <"AllocateEMSPage ok, page=">,?POOLDBG
	@DbgOutW di,?POOLDBG
	@DbgOutS <10>,?POOLDBG
    
    add edi, [EMSPageAllocationEnd]
	mov	[edi].EMSPD2.bNibOfs,dl
	inc	[EMSPagesUsed]
	add	[dwUsedMem4K],4
    clc
@@exit:    
	pop	edx
	pop	edi
	ret

AllocateEMSPage	ENDP

;--- allocate ECX new pages for a handle
;--- inp: ESI=EMSPD
;--- modifies ECX, EDI, EAX, ESI

AllocateEMSPages proc public

	push	ebx
    mov		ebx,ecx
	MOV 	EDI,[EMSPageAllocationStart]	; mark the pages as used
	MOV 	ECX,[EMSPagesMax]
@@SEARCH_PAGES:
	or  	eax,-1
	REPNZ	SCASD
	jnz		@@nofind			; out of free pages?
    sub		edi,4
	call	AllocateEMSPage		; allocate the page
	jc		@@nofind
    mov		eax,edi
    sub		eax,[EMSPageAllocationStart]
    shr		eax,2
    mov		[esi].EMSPD.wNext, ax
    mov		esi, edi
    add		edi,4
if ?YIELDOPEN
	call	Yield
endif
    dec		ebx
	JNZ 	@@SEARCH_PAGES
    pop		ebx
	ret
@@nofind:
	pop		ebx
	stc
    ret
AllocateEMSPages endp


; release EMS page in AX
; destroy no registers

ReleaseEMSPage	PROC public
	push edx
	movzx edx,ax
    shl edx, 2
    add edx, [EMSPageAllocationStart]
	cmp	edx, [EMSPageAllocationEnd]
	jae	@@ret							; out of range
	call Pool_Free16KPage
    jc @@ret
    
	@DbgOutS <"ReleaseEMSPage ok, page=">,?POOLDBG
	@DbgOutW ax,?POOLDBG
	@DbgOutS <10>,?POOLDBG
    
	dec [EMSPagesUsed]
	sub	[dwUsedMem4K],4
@@ret:
	pop	edx
	ret
ReleaseEMSPage	ENDP

.text$03 ends

.text$04 segment

;--- init EMS handle status table (255 handles * 8)
;--- inp: EDI -> free memory

SetEMSHandleTable proc public
	cmp		[EMSHandleTable],0
	jnz 	@@done
	MOV 	[EMSHandleTable],EDI; set start of EMS handle table.
	MOV 	EAX,0FF01FFFFh  	; Handle 0 is reserved.
	STOSD
    mov		eax,0FF00FFFFh
	MOV 	ECX, EMS_MAX_HANDLES-1	; fill the rest
	REP 	STOSD
@@done:    
	ret
SetEMSHandleTable endp

SetEMSStateTable proc public
	cmp	[EMSStateTable],0
	jnz	@@done
	mov	[EMSStateTable],EDI
    mov eax, -1
    mov ecx, EMS_MAXSTATE*4
    rep stosd
@@done:
    ret
SetEMSStateTable endp

SetEMSNameTable proc
	cmp [EMSNameTable],0
    jnz @@done
	mov	[EMSNameTable],EDI
	mov	eax,'TSYS'		; store "SYSTEM" as first handle name
    stosd
	mov	eax,'ME'
    stosd
	mov	ecx,8*EMS_MAX_HANDLES/4
	xor	eax,eax
	rep	stosd
@@done:    
    ret
SetEMSNameTable endp

;--- init EMS variables
;--- ESI -> JEMMINIT

EMS_Init1 proc public    
	movzx	eax, [esi].JEMMINIT.jiMaxEMSPages
	mov		[EMSPagesMax],eax
	mov		al, [esi].JEMMINIT.jiNoFrame
	mov		[bNoFrame],al
	mov		al, [esi].JEMMINIT.jiNoEMS
	mov		[bNoEMS],al
	cmp		al,0
	jz		@@emsactive
	mov		[bNoFrame], 1
	mov		eax,[dwRes]
	mov		byte ptr [eax + DEVICE_NAME + 3],'Q' ;EMMXXXX0 -> EMMQXXX0
@@emsactive:	

    cmp		[bNoFrame],0
    jnz		@@noframe
    mov 	[bEmsPhysPages], 4
	movzx	eax, byte ptr [esi].JEMMINIT.jiFrame+1
    mov		edx, eax
    mov		dh,dl
    add		dh,4
    mov		word ptr [EMSPage2Segm+0], dx
    add		dx,0808h
    mov		word ptr [EMSPage2Segm+2], dx

if 0	;not needed. Once the pages are remapped, the bits are cleared
;--- reset the "global page" attribute for the EMS frame PTEs
    
    @GETPTEPTR eax, eax*4+1000h
    mov		ecx,16
@@nextitem:    
    and		byte ptr [eax+1],not 1
    add		eax,4
    loop	@@nextitem
endif

@@noframe:

;--- calc mappable EMS pages

ife ?LIM32
    movzx	ebx,word ptr [esi].JEMMINIT.jiPageMap+0
    movzx	edx,word ptr [esi].JEMMINIT.jiPageMap+2
    shl		edx,4
    add		ebx,edx

if ?INITDBG    
	xor		ecx,ecx
    @DbgOutS <"SysMem table:",10>,1
@@nextitemx:
	@DbgOutC [ebx+ecx],1
    inc		ecx
    test	cl,3Fh
    jnz		@@nextitemx
    @DbgOutS <10>,1
    and		cl,cl
    jnz		@@nextitemx
endif

    mov		dl,0C0h
    mov		ecx,0A0h		;on first turn, add the pages > A000h
@@nextround:
    mov		dh,0			;DH=num mappable pages below A000
@@nextitem2:
	mov		eax,[ebx+ecx]
    cmp		eax,'PPPP'
    jz		@@skipitem
    cmp		cl,0a0h
    jc		@@useitem
    cmp		eax,'IIII'
    jnz 	@@skipitem
    cmp		[esi].JEMMINIT.jiNoRAM,0
    jz		@@skipitem
@@useitem:    
    movzx	eax,[bEmsPhysPages]
    cmp		al,?MAXPHYSPG
    jnc		@@skipitem
	mov		[EMSPage2Segm+eax],cl
    inc		eax
    inc		dh
    mov		[bEmsPhysPages],al
if 0		;is not needed, since once the page is remapped, the bit is reset    
    @GETPTEPTR eax,1000h+ecx*4
    and		byte ptr [eax+00+1],not 1	;reset "global" attribute
    and		byte ptr [eax+04+1],not 1	;reset "global" attribute
    and		byte ptr [eax+08+1],not 1	;reset "global" attribute
    and		byte ptr [eax+12+1],not 1	;reset "global" attribute
endif    
@@skipitem:    
    add		ecx,4
    cmp		cl,dl
    jc		@@nextitem2
    cmp		dl,0A0h
	mov		cl,byte ptr [esi].JEMMINIT.jiBorder+1	;begin at 0x1000
    mov		dl,0A0h
    jnz		@@nextround
    mov		[bPagesConv],dh
    movzx	edx,dh
    add		word ptr [EMSPagesMax],dx
    jns		@@nopagelim
    mov		word ptr [EMSPagesMax],MAX_EMS_PAGES_POSSIBLE
@@nopagelim:
    shl		edx,2
    add 	[dwMaxMem4K],edx
endif	;?LIM32

	movzx	eax,[bEmsPhysPages]
    inc		eax		;+ 1 dword for checksum
    shl		eax,2
	mov		emm59_.e59_sizcont, ax

if ?VCPI
	mov		al, [esi].JEMMINIT.jiNoVCPI
	mov		[bNoVCPI],al
endif
	ret
EMS_Init1 endp

;--- alloc the EMS management tables
;--- ESI -> JEMMINIT
;--- EDI -> free space

EMS_Init2 proc public

;--- now set the EMS tables    

; alloc EMS handle/status/name table (4/8/8 bytes)

	call SetEMSHandleTable
	call SetEMSStateTable
	call SetEMSNameTable
    
if ?INITDBG
	@DbgOutS <"EMS handle table=">,1
	@DbgOutD EMSHandleTable,1
	@DbgOutS <", state table=">,1
	@DbgOutD EMSStateTable,1
	@DbgOutS <", name table=">,1
	@DbgOutD EMSNameTable,1
	@DbgOutS <10>,1
	@WaitKey 1,0
endif	 

; allocate and -1 store space for EMS page allocation pointer/descriptors
;  dword per page, points into EMS/VCPI block which controls page allocation
; allocate 4 bytes per 16K XMS total, 128K-4 max (no more than 32K-1 pages controlled)
;  page descriptor high word == 64-byte EMS/VCPI allocation block count from start
;  page descriptor low word ==	half-byte offset of allocation page (2 * 48)
;	within allocation block, not including system bytes

	mov ecx,[EMSPagesMax]
	mov	[EMSPageAllocationStart],edi
    push ecx
	or	eax,-1
	rep	stos DWORD PTR [edi]
	@BIG_NOP
    pop ecx
	mov	[EMSPageAllocationEnd],edi
    inc eax
    rep stosb
	@BIG_NOP

if ?INITDBG
	@DbgOutS <"EMS page alloc start/end=">,1
	@DbgOutD [EMSPageAllocationStart],1
	@DbgOutS <"/">,1
	@DbgOutD [EMSPageAllocationEnd],1
	@DbgOutS <", byte ofs array end=">,1
	@DbgOutD edi,1
	@DbgOutS <10>,1
endif

ife ?LIM32
	movzx	ecx,[bPagesConv]
    jecxz	@@nomap2
    call Pool_GetUnusedBlock
    mov [edx].POOL_SYSTEM_INFO.psi_16kmax,cl
    mov [edx].POOL_SYSTEM_INFO.psi_16kfree,cl
    mov ebx,ecx
    shl ecx,2
    mov [edx].POOL_SYSTEM_INFO.psi_4kfree,cx
    movzx eax,[esi].JEMMINIT.jiBorder
    shr eax,6		;paragraphs -> 1K
    mov [edx].POOL_SYSTEM_INFO.psi_addressK, eax
    mov [edx].POOL_SYSTEM_INFO.psi_flags, PBF_DONTFREE or PBF_DONTEXPAND
    pushad
	MOV	EDI,[EMSPageAllocationStart]
    mov esi,[EMSHandleTable]
    xor ecx,ecx
@@nextpage:
	call AllocateEMSPage
    mov	[esi].EMSPD.wNext, cx
    mov esi,edi
    add edi,4
    inc ecx
	cmp ecx,ebx
    jnz @@nextpage
	popad
@@nomap2:
endif

    @DbgOutS <"EMSInit2 done",10>,?INITDBG
    ret
EMS_Init2 endp

.text$04 ends

		END
