/* type.c */

/* Displays a help page, similar to UNIX `man' */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>			/* Borland: exit(), system() */
#include <string.h>			/* for strcmp */
#include <process.h>			/* Borland: system() */


/* Symbolic constants */

#define DEF_PAGER	"MORE"
#define DEF_HELPPATH	"C:\\HELP"


/* Functions */

void usage (void);


/* The program starts here */

int
main (int argc, char **argv)
{
  int i;
  char exec_string[128];		/* MS-DOS allowed 128-char commands */
  char *str;

  /* Scan command line for "/?". */

  for (i = 1; i < argc; i++)
    {
      if (strncmp (argv[i], "/?", 2) == 0)
	{
	  usage ();
	  exit (0);
	}
    } /* for */

  /* Build the exec string */

  strcpy (exec_string, "");

  str = getenv ("PAGER");
  if (str)
    {
      strcat (exec_string, str);
    }

  else
    {
      strcat (exec_string, DEF_PAGER);
    }

  strcat (exec_string, " ");

  str = getenv ("HELPPATH");
  if (str)
    {
      strcat (exec_string, str);
    }

  else
    {
      strcat (exec_string, DEF_HELPPATH);
    }

  strcat (exec_string, "\\");

  /* Add the topic to view */

  if (i == 1)
    {
      strcat (exec_string, "INDEX");	/* general help topic */
    }

  else
    {
      strcat (exec_string, argv[1]);
    }

  /* Execute the string */

  i = system (exec_string);

#if 0
  printf ("system: %s\n", exec_string);
#endif /* Debugging code */

  exit (i);
}

void
usage (void)
{
  fprintf (stderr, "HELP - display a Help topic\n");
  fprintf (stderr, "Usage:\n");
  fprintf (stderr, "\tHELP [topic]\n");
}
