/*
// Program:  Format
// Module:  FORMAT.H
// Module Description:  Free FDISK Header File
// Written By:  Brian E. Reifsnyder
// Version:  0.7
// Copyright:  2001 under the terms of the GNU GPL, Version 2.
*/

/*
/////////////////////////////////////////////////////////////////////////////
//  DEFINES
/////////////////////////////////////////////////////////////////////////////
*/

#ifdef MAIN
#define EXTERN /**/
#else
#define EXTERN extern
#endif

#define MEG 1048576

#define PRIMARY 1
#define EXTENDED 2
#define LOGICAL 3
#define SPECIAL 4

#define LAST 99

#define TRUE  1
#define FALSE 0

#define HARD   0
#define FLOPPY 1

#define FAT12 1
#define FAT16 2
#define FAT32 3


/*
/////////////////////////////////////////////////////////////////////////////
//  GLOBAL VARIABLES
/////////////////////////////////////////////////////////////////////////////
*/

EXTERN char ascii_cd_number[15];
EXTERN char partition_label[16];

/* Buffers */
EXTERN unsigned long bad_sector_map[1024];

EXTERN unsigned char mirror_map[8192];

/* Ending Mapping Variables */
EXTERN long computed_ending_cylinder;
EXTERN unsigned long computed_partition_size;

/* Integers converted from long numbers */
EXTERN int integer3;
EXTERN int integer4;

extern unsigned long translated_cylinder;
extern unsigned long translated_head;
extern unsigned long translated_sector;

/*
/////////////////////////////////////////////////////////////////////////////
//  GLOBAL STRUCTURES
/////////////////////////////////////////////////////////////////////////////
*/

typedef struct Drive_Statistics
  {
  unsigned long bytes_total_disk_space;
  unsigned long bytes_available_on_disk;

  unsigned long bytes_in_each_allocation_unit;
  unsigned long allocation_units_available_on_disk;

  unsigned int serial_number_low;
  unsigned int serial_number_high;
  } DS;

typedef struct Formatting_Parameters
  {
  char drive_letter[2];
  char volume_label[12];

  int drive_type;                 /* FLOPPY or HARD */
  int drive_number;
  int physical_drive_number;
  int partition_number;
  int fat_type;
  int media_type;                 /* FD#### or HD */

  int force_yes;

  int v;
  int q;
  int u;
  int f;
  int b;
  int s;
  int t;
  int n;
  int one;
  int four;
  int eight;

  unsigned long size;
  unsigned long cylinders;
  unsigned long sectors;

  } FP;

typedef struct DDPT_Structure
{
  unsigned step_rate : 4 ;
  unsigned head_unload_time : 4;
  unsigned head_load_time : 7;
  unsigned dma_flag : 1;
  unsigned post_rt_of_disk_motor : 8;
  unsigned sector_size : 8;
  unsigned sectors_per_cylinder : 8;
  unsigned gap3_length_rw : 8;
  unsigned dtl : 8;
  unsigned gap3_length_xmat : 8;
  unsigned fill_char_xmat : 8;
  unsigned head_settle_time : 8;
  unsigned run_up_time : 8;
} DDPT;

typedef struct Track_Address_Field_Structure
{
  unsigned cylinder : 8;
  unsigned head : 8;
  unsigned sector : 8;
  unsigned size_code : 8;
} TAF;

typedef struct Low_Level_Format_Values_Structure
{
  int interleave_factor;
  int interleave_index;
  int interleave_map[64];
} LLFVS;

EXTERN DS drive_statistics;
EXTERN FP param;
EXTERN DDPT far *ddpt;
EXTERN LLFVS low_level;



