/*
File Name:  bpb.h
Description:  BIOS Parameter Block and Drive Specs Header File
Author:  Brian E. Reifsnyder
Copyright: 2000 under the GNU GPL
*/


#define  FD160    0
#define  FD180    1
#define  FD320    2
#define  FD360    3
#define  FD720    4
#define  FD1200   5
#define  FD1440   6
#define  FD2880   7
#define  HD       8
#define  UNKNOWN 99

typedef struct BIOS_Parameter_Block
{
  unsigned cylinders                 :  8;
  unsigned bytes_per_sector          : 16;
  unsigned sectors_per_cluster       :  8;
  unsigned reserved_sectors          : 16;
  unsigned number_of_fats            :  8;
  unsigned root_directory_entries    : 16;
  unsigned total_sectors             : 16;
  unsigned media_descriptor          :  8;
  unsigned sectors_per_fat           : 16;
  unsigned sectors_per_cylinder      : 16;
  unsigned number_of_heads           : 16;
  unsigned hidden_sectors_low        : 16;
  unsigned hidden_sectors_high       : 16;
  unsigned large_sector_count_low    : 16;
  unsigned large_sector_count_high   : 16;
} BPB;

BPB drive_specs[9]=
{
  {40,512,1,1,2, 64, 320,0xfe,1, 8,1,0,0,0,0},  /* FD160  */
  {40,512,1,1,2, 64, 360,0xfc,2, 9,1,0,0,0,0},  /* FD180  */
  {40,512,2,1,2,112, 640,0xff,1, 8,2,0,0,0,0},  /* FD320  */
  {40,512,2,1,2,112, 720,0xfd,2, 9,2,0,0,0,0},  /* FD360  */
  {80,512,2,1,2,112,1440,0xf9,3, 9,2,0,0,0,0},  /* FD720  */
  {80,512,1,1,2,224,2400,0xf9,7,15,2,0,0,0,0},  /* FD1200 */
  {80,512,1,1,2,224,2880,0xf0,9,18,2,0,0,0,0},  /* FD1440 */
  {80,512,2,1,2,240,5760,0xf0,9,36,2,0,0,0,0},  /* FD2880 */
  { 0,512,0,1,2,512,   0,0xf8,0, 0,0,0,0,0,0}   /* HD     */
};

