     NAME:

          FORMAT - format floppy disks and hard drive partitions

     SYNOPSIS:

          FORMAT drive [/8] [/1] [/4] [/T:tracks] [/N:sectors]
                 [/F:size] [/V:label]

     DESCRIPTION:

          FORMAT formats the disk in drive for use with DOS.

          The options are as follows:

               /8
                    Specifies an eight sector per track format.
                    Applicable only to 5.25-inch floppy drives.

               /1
                    Specifies a single-sided format.  Applicable only
                    to 5.25-inch floppy drives.

               /4
                    Specifies a forty track format.  Applicable only
                    to 5.25-inch floppy drives.

               /T:tracks
                    Specifies the number of tracks to format.

               /N:sectors
                    Specifies the number of sectors per track to
                    format.

               /F:size
                    The recommended way to specify the desired floppy
                    disk format.  Size may be specified in kilobytes,
                    or in megabytes for capacities of 1.2M and above.
                    (Note that, following general usage in this
                    context, a 'megabyte' is interpreted as 1000, not
                    1024, kilobytes.)

               /V:label
                    Specifies an eleven character volume label.  This
                    option may not be used with DOS 1.xx compatible
                    formats (see below).


     NOTES:

          All format specification options (ie. all options except
          /V:label) are applicable only to floppy drives.

          Three methods exist for specifying a floppy disk format:

               /F:size
               /T:tracks /N:sectors
               One or more of the options /8 /1 /4

          The three methods are incompatible with each other.  Note,
          for instance, that you cannot use /T:40 /1 /N:9 to specify a
          360K format.

          The following table shows equivalent format specifications
          (assuming a 1.2M 5.25-inch drive, where applicable):

               /F:160K                                    /4 /1 /8
               /F:180K                                    /4 /1
               /F:320K                    /T:40 /N:8      /4 /8
               /F:360K                    /T:40 /N:9      /4
               /F:720K                    /T:80 /N:9
               /F:1200K (or /F:1.2M)      /T:80 /N:15
               /F:1440K (or /F:1.44M)     /T:80 /N:18
               /F:2880K (or /F:2.88M)     /T:80 /N:36

          The 8 sector per track formats (160K and 320K) are
          specifically intended for DOS 1.xx compatibility.  This
          affects what appears in the boot sector and root directory
          entries.  A volume label may not be specified with either of
          these formats.

          Network drives, and ASSIGNed and SUBSTed drives cannot be
          formatted.


     DIAGNOSTICS:

          An exit status of 0 is returned upon successful operation.
          Exit status 3 indicates that operation was interrupted by
          means of CTRL+C or CTRL+BREAK.  Exit status 5 indicates
          that, when prompted, the user elected not to proceed with
          formatting of a hard drive partition, or did not correctly
          supply the existing volume label.  Other errors cause an
          exit status of 4 to be returned, along with an appropriate
          error message.


     BUGS:

          To be functional under Free-DOS, this utility requires the
          implementation of the following kernel services:

               Int 21h   4409h   (Is drive remote)
               Int 21h   440Dh   (Generic IOCTL)
               int 21h   60h     ("Truename")


     AUTHOR:

          Robert Nordier
          rnordier@iafrica.com
