/*
// Program:  Format
// Version:  no longer used in 0.91g
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  parts formerly in hdisk.c
// Module Description:  Hard Drive Specific Functions
*/

void Get_DPB()
{
  if(param.fat_type!=FAT32)
    {
    regs.h.ah = 0x32;

    regs.h.dl = param.drive_number + 1;
    intdosx(&regs, &regs, &sregs);

    if (regs.h.al != 0)
	{
	    printf("INT 0x21/0x32/drive=%c failed\n", param.drive_number+'A');
	    printf("*** Drive not formatted??? Aborting! ***\n");
	    exit(1);
	    /* should not abort here, but rather create our own DPB */
	    /* *** TODO!!! *** */
	}

    dpb = MK_FP(sregs.ds,regs.x.bx);

    segread(&sregs);                    /* restore defaults */
    }
  else /* FAT32 case */
    {
    unsigned int drive_number = param.drive_number +1;

    unsigned int ext_param_block_seg = FP_SEG(&ext_parameter_block);
    unsigned int ext_param_block_off = FP_OFF(&ext_parameter_block);
    ext_parameter_block.buffer_length = 63; /* *** size for Win95 *** */
    ext_parameter_block.ext_dpb.bytes_per_sector = 1; /* impossible value */

    { /* limit variable scope of sregs */
      struct SREGS sregs;
      /* reactivated old Turbo C 2.01 style code -ea */
      /* also fixed that code. Turbo C 2.01 has no asm { ... } -ea */
      regs.x.ax = 0x7302; /* get FAT32 extended DPB */
      regs.x.cx = 0x003f; /* size of the buffer */

      sregs.es = ext_param_block_seg;
      regs.x.di = ext_param_block_off;

      regs.x.si = 0xf1a6; /* magic value to make dev-pointer valid */
                          /* and to make next-dpb pointer valid... */

      regs.h.dl = drive_number;
      intdosx(&regs, &regs, &sregs);
    }
   
    if (regs.x.cflag || /* non-FAT32 DOSes will not set carry here */
        (ext_parameter_block.ext_dpb.bytes_per_sector != 512))
	{
	    printf("INT 0x21/0x7302/drive=%c failed\n", param.drive_number+'A');
	    printf("Could not get FAT32 extended DPB. Aborting!\n");
	    exit(1);
	    /* *** TODO: calculate your own DPB instead! *** */
	}

    dpb = MK_FP(sregs.ds,regs.x.bx+2);	/* *** +2 ! *** */

    segread(&sregs);			/* restore defaults */
    }
}

