/*
File Name:  floppy.h
Description:  Floppy disk BPB table header file.
Author:  Brian E. Reifsnyder
Copyright: 2001 under the terms of the GNU GPL, Version 2
(Changed by Eric Auer 2003 - version 0.91c)
*/

#ifdef FLOP
  #define FEXTERN /* */
#else
  #define FEXTERN extern
#endif

void Set_Floppy_Media_Type(void);
int Format_Floppy_Cylinder(int,int);
void Compute_Sector_Skew(void);

typedef struct BIOS_Parameter_Block
{                                            /* diskoffset */
  unsigned cylinders                 :  8;
  unsigned bytes_per_sector          : 16;   /* 0b         */
  unsigned sectors_per_cluster       :  8;   /* 0d         */
  unsigned reserved_sectors          : 16;   /* 0e         */
  unsigned number_of_fats            :  8;   /* 10         */
  unsigned root_directory_entries    : 16;   /* 11         */
  unsigned total_sectors             : 16;   /* 13         */
  unsigned media_descriptor          :  8;   /* 15         */
  unsigned sectors_per_fat           : 16;   /* 16         */
  unsigned sectors_per_cylinder      : 16;   /* 18         */
  unsigned number_of_heads           : 16;   /* 1a         */
  unsigned hidden_sectors_low        : 16;   /* 1c         */
  unsigned hidden_sectors_high       : 16;   /* 1e         */
  unsigned large_sector_count_low    : 16;   /* 20         */
  unsigned large_sector_count_high   : 16;   /* 22         */
  int interleave_factor;
  int sector_skew;
  unsigned long total_logical_sectors;
} BPB;

/* make sure, struct size is OK; i.e. alignement is 0 */
struct verify_BIOS_Parameter_Block {
    char x[1 - 2*(sizeof(BPB) != 1 + 25 + 2*sizeof(int) + sizeof(long))];
    };

#define HD 8 /* we need this in hdisk.c, drive_specs[HD] must be HD */

#ifdef FLOP
BPB drive_specs[18]=
{
  /*
  CYL BPS SEC/CLUST     SIDES (HEADS)
   v   v  v RES_SEC         SEC/CYL v HIDDEN
   v   v  v v FATS   SEC_PER_FAT  v v v v LARGE_CNT
   v   v  v v v  ROOT_DIR_ENT  v  v v v v v v  INTERLEAVE
   v   v  v v v  v  SIZE DESC  v  v v v v v v  v  SKEW, TOTAL_LOGICAL
/* 5.25 inch 40 track: 0..3 (H/S: 1/8, 1/9, 2/8, 2/9) */
  {40,512,1,1,2, 64, 320,0xfe, 1, 8,1,0,0,0,0, 1, 0, 0}, /* FD160  5.25 SS   */
  {40,512,1,1,2, 64, 360,0xfc, 2, 9,1,0,0,0,0, 1, 0, 0}, /* FD180  5.25 SS   */
  {40,512,2,1,2,112, 640,0xff, 1, 8,2,0,0,0,0, 1, 0, 0}, /* FD320  5.25 DS   */
  {40,512,2,1,2,112, 720,0xfd, 2, 9,2,0,0,0,0, 1, 0, 0}, /* FD360  5.25 DS   */
/* 3.5 inch small:     4 */
  {80,512,2,1,2,112,1440,0xf9, 3, 9,2,0,0,0,0, 1, 0, 0}, /* FD720  3.5  LD   */
/* 5.25 inch 80 track: 5 */
  {80,512,1,1,2,224,2400,0xf9, 7,15,2,0,0,0,0, 1, 0, 0}, /* FD1200 5.25 HD   */
/* 3.5 inch big:       6 */
  {80,512,1,1,2,224,2880,0xf0, 9,18,2,0,0,0,0, 1, 0, 0}, /* FD1440 3.5  HD   */
/* extra big:          7 */
  {80,512,2,1,2,240,5760,0xf0, 9,36,2,0,0,0,0, 1, 0, 0}, /* FD2880 3.5  ED   */
/* HARDDISK:           8 */
  { 0,512,0,1,2,512,   0,0xf8, 0, 0,0,0,0,0,0, 0, 0, 0}, /* HD     HARD DISK */

 /* Non-Standard Format BPB Values (FAT sizes fixed in 0.91c) */

  /* DMF Format: variant of FD1680, used even by MS (and by IBM OS/2?) */
  {80,512,1,1,2, 16,3360,0xf0,10,21,2,0,0,0,0, 2, 3, 0}, /* FD1680 3.5  HD   */

  /* More Sectors Only */
  {40,512,2,1,2,112, 800,0xfd, 2,10,2,0,0,0,0, 3, 3, 0}, /* FD400  5.25 DS   */
  {80,512,2,1,2,112,1600,0xf9, 3,10,2,0,0,0,0, 3, 3, 0}, /* FD800  3.5  LD   */
  {80,512,1,1,2,224,3360,0xf0,10,21,2,0,0,0,0, 3, 3, 0}, /* FD1680x 3.5 HD   */
  {80,512,2,1,2,240,6720,0xf0,10,42,2,0,0,0,0, 3, 3, 0}, /* FD3360 3.5  ED   */

  /* More Cylinders and Sectors */
  {83,512,1,1,2,224,2988,0xf9, 9,18,2,0,0,0,0, 3, 3, 0}, /* FD1494 5.25 HD   */
  {83,512,1,1,2,224,3486,0xf0,11,21,2,0,0,0,0, 3, 3, 0}, /* FD1743 3.5  HD   */

  {83,512,2,1,2,240,6972,0xf0,11,42,2,0,0,0,0, 3, 3, 0}, /* FD3486 3.5  ED   */

  /* Suggestion: 81 and 82 cylinder formats!? 19 and 20 sector formats!? */

  /* END MARKER */
  { 0,  0,0,0,0,  0,   0,0x00,0, 0,0,0,0,0,0, 0, 0, 0}
};
#else
extern BPB drive_specs[];
#endif


