/*
// Program:  Format
// Version:  0.90d
// (0.90b/c/d fixing compiler warnings - Eric Auer 2003)
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  uformat.c
// Module Description:  Unconditional Format Functions
*/

#define UFORMAT

#include "format.h"
#include "uformat.h"
#include "floppy.h"
#include "driveio.h"
#include "userint.h"

void Unconditional_Floppy_Format(void);
void Unconditional_Hard_Disk_Format(void);
void Compute_Sector_Skew(void);

/* Unconditionally Format the Drive */
void Unconditional_Format()
{
  bad_sector_map_pointer=0;

  if(param.drive_type==FLOPPY) Unconditional_Floppy_Format();
  else Unconditional_Hard_Disk_Format();
}

void Unconditional_Floppy_Format()
{
  int index = 0;
  int buggy = 0;

  unsigned long percentage;



  /* Reset the floppy disk controller */
  int drive_number = param.drive_number;
  regs.h.ah = 0x00;
  regs.h.dl = drive_number;
  int86( 0x13, &regs, &regs);


  /* Set huge_sector_buffer to all 0xf6's. */
  memset(huge_sector_buffer_0, 0xf6, sizeof(huge_sector_buffer_0));

  do
    {
    buggy += Format_Floppy_Cylinder(index,0);
    if (drive_specs[param.media_type].number_of_heads==2)
      buggy += Format_Floppy_Cylinder(index,1);
    /* old version only used 2nd head if heads != 2        */
    /* now using only 1st head if heads != 2, correct? -ea */

    if ((index==0) && (buggy>0)) /* -ea */
      {
      printf("Format error in track 0, giving up.\n");
      exit(23);
      }

    percentage =
      ((100*index)/(drive_specs[param.media_type].cylinders));

    Display_Percentage_Formatted(percentage);

    Compute_Sector_Skew();

    index++;
    } while (index < drive_specs[param.media_type].cylinders);
    /* must be < not <= (formatted one track too much in 0.91 ! */

    if (buggy>0)
      printf("Found %d bad sectors during formatting.\n");
}

void Unconditional_Hard_Disk_Format()
{
  /* int error_code; */
  int number_of_sectors=sizeof(huge_sector_buffer_0)>>9; /* -ea */

  int percentage_refresh_rate=10;
  int percentage_refresh_counter=10;

  unsigned index=0;

  unsigned long last_bad_sector=0;
  unsigned long sector_number=1;
  unsigned long max_logical_sector
   = drive_specs[param.media_type].total_logical_sectors;
  unsigned long percentage;

  long int badsec1 = 0; /* -ea */
  long int badsec2 = 0; /* -ea */

  if (number_of_sectors < 1) {
    printf("huge_sector_buffer not available???\n");
    number_of_sectors = 1; /* use small sector_buffer */
    /* Set sector_buffer to all 0xf6's. */
    memset(sector_buffer_0, 0xf6, sizeof(sector_buffer_0));
  }

  /* Clear and check for bad sectors. (maximum of 32 at a time) */
  printf(" Zapping / checking %ld sectors\n", max_logical_sector); /* -ea */
  do
    {

    /* Set huge_sector_buffer to all 0xf6's. */
    memset(huge_sector_buffer_0, 0xf6, sizeof(huge_sector_buffer_0));

    if ((sector_number + number_of_sectors) > max_logical_sector) {
      /* clip last chunk -ea */
      if ( (max_logical_sector - sector_number) > 32767L ) {
        printf("Hu??? Last chunk size > 32767 sectors???\n");
      }
      Drive_IO(WRITE,sector_number, (int)(max_logical_sector - sector_number));
      Drive_IO(READ,sector_number, (int)(max_logical_sector - sector_number));
    } else {
      Drive_IO(WRITE,sector_number, number_of_sectors);
      Drive_IO(READ,sector_number, number_of_sectors);
    }

    /* Check for bad sectors by comparing the results of the sector read. */
    index=0;
    do
      {
      if (huge_sector_buffer[index] != 0xf6)
	{
	if( (last_bad_sector==0)
	  || (last_bad_sector != (sector_number + ( (index+1) / 512) ) ) )
	  {
	  bad_sector_map[bad_sector_map_pointer]
	    = sector_number + ( (index+1) / 512 );
	  badsec1++; /* -ea */
	  }
	}

      index++;
      } while (index < (32*512) ); /* one buffer full */

    if (percentage_refresh_counter==0)
      {
      percentage=(100*sector_number)/max_logical_sector;
      Display_Percentage_Formatted(percentage);
      if (badsec1 != 0) { /* added better output -ea */
        printf("\n [errors found]\n");
        badsec2 += badsec1;
        badsec1 = 0;
      }
      }
    if (percentage_refresh_counter==percentage_refresh_rate)
      percentage_refresh_counter=-1;
    percentage_refresh_counter++;

    sector_number += 32;
    
    } while (sector_number<max_logical_sector);
    
    badsec2 += badsec1;
    if (badsec2>0) {
      printf("\n %lu errors found.\n", badsec2);
    } else {
      printf("\n No errors found.\n");
    }

}
