; include file for the Free-DOS XMS driver
; Copyright (c) 1995, Till Gerken

INFO_STR                          EQU '80386 64MB version, no XXMS support'
DRIVER_VERSION                    EQU '0.1'
INTERFACE_VERSION                 EQU '3.0'
INTERFACE_VER                     EQU 0x300

XMS_START                         EQU 1088       ; XMS starts at 1088k
                                                 ;    after HMA

CMD_INIT                          EQU 0          ; init command (used when
                                                 ;    installed)

STATUS_OK                         EQU 0x100      ; driver is initialized
                                                 ;    and ok
STATUS_BAD                        EQU 0x8000     ; driver couldn't be
                                                 ;    installed

VDISK_IDSTR                       EQU "VDISK"
VDISK_IDLEN                       EQU 5
VDISK_IDOFS                       EQU 0x12

XMS_NOT_IMPLEMENTED               EQU 0x80
XMS_VDISK_DETECTED                EQU 0x81
XMS_A20_FAILURE                   EQU 0x82
XMS_DRIVER_FAILURE                EQU 0x8E
XMS_DRIVER_FATAL                  EQU 0x8F
XMS_HMA_NOT_THERE                 EQU 0x90
XMS_HMA_IN_USE                    EQU 0x91
XMS_HMAREQ_TOO_SMALL              EQU 0x92
XMS_HMA_NOT_USED                  EQU 0x93
XMS_A20_STILL_ENABLED             EQU 0x94
XMS_ALREADY_ALLOCATED             EQU 0xA0
XMS_NO_HANDLE_LEFT                EQU 0xA1
XMS_INVALID_HANDLE                EQU 0xA2
XMS_INVALID_SOURCE_HANDLE         EQU 0xA3
XMS_INVALID_SOURCE_OFFSET         EQU 0xA4
XMS_INVALID_DESTINATION_HANDLE    EQU 0xA5
XMS_INVALID_DESTINATION_OFFSET    EQU 0xA6
XMS_INVALID_LENGTH                EQU 0xA7
XMS_OVERLAP                       EQU 0xA8
XMS_PARITY_ERROR                  EQU 0xA9
XMS_BLOCK_NOT_LOCKED              EQU 0xAA
XMS_BLOCK_LOCKED                  EQU 0xAB
XMS_LOCK_COUNT_OVERFLOW           EQU 0xAC
XMS_LOCK_FAILED                   EQU 0xAD
XMS_ONLY_SMALLER_UMB              EQU 0xB0
XMS_NO_UMB_AVAILABLE              EQU 0xB1
XMS_UMB_SEGMENT_NR_INVALID        EQU 0xB2

struc request_hdr
  .req_size:       RESB 1         ; number of bytes stored
  .unit_id:        RESB 1         ; unit ID code
  .cmd:            RESB 1         ; command code
  .status:         RESW 1         ; status word
  .rsvd:           RESB 8         ; reserved
endstruc

sizeOf_request_hdr EQU 13

struc init_strc
  .init_hdr:       RESB sizeOf_request_hdr
  .units:          RESB 1         ; number of supported units
  .end_addr:       RESD 1         ; end address of resident part
  .cmd_line:       RESD 1         ; address of command line
endstruc

struc desc
  .limit:          RESW 1         ;*** 0xFFFF    ; segment limit
  .base0_15:       RESW 1         ; low word of base address
  .base16_23:      RESB 1         ; high byte of base address
  .flags:          RESB 1         ;*** 0x93      ; std read/write segment
  .reserved:       RESB 1
endstruc

struc xms_handle
  .xbase:          RESW 1         ; base address in kbytes
  .xsize:          RESW 1         ; size in kbytes
  .used:           RESB 1         ; 1 if used
  .locks:          RESB 1         ; lock count
endstruc

sizeOf_xms_handle  EQU 6

struc xms_move_strc
  .len:            RESD 1         ; block length in bytes
  .src_handle:     RESW 1         ; source handle
  .src_offset:     RESD 1         ; offset into source
  .dest_handle:    RESW 1         ; destination handle
  .dest_offset:    RESD 1         ; offset into destination
endstruc