unit FdiskUnit;

interface
uses CRT,
     HashCode,
     PCstuff,MsaTools,
     DOS;

const part : integer = 1;
  MajorVersion  = '2';
  MinorVersion  = '29';
  Version   : string[9] = MajorVersion+'.'+MinorVersion {$IFOPT D+} + '' {$ENDIF};
    ABlink : byte = Blink;
    DiskDescription : string22 = '';
    HelpFileOpenned : boolean = false;
    NeedToRead : boolean = true;
    RowPart : string[25]='                        ';
    MaxCylForPhysical : array[0..31] of word = (4095,4095,4095,4095,4095,4095,4095,4095,
                      4095,4095,4095,4095,4095,4095,4095,4095,4095,4095,4095,4095,4095,4095,
                      4095,4095,4095,4095,4095,4095,4095,4095,4095,4095);
    ListAllMode   : set of (ListEmpty,ListExtended,ListLogical) = [ListEmpty];
    MaxCyl        = 2200 ; {this program won't work with disks with more than this cylinders}
    TabMode       : boolean = false;
    ThisPartition : integer = 0;

var UsedCyl : array[0..MaxCyl] of byte;

type
  OptionsType = array[1..8] of string[80];
  ChangedSectorListPointer = ^ChangedSectorList;
  ChangedSectorList = record Next : ChangedSectorListPointer;
                             Cyl,Head,Sector,Sectors : integer;
                             Comment : string[64];
                             PreviousContents : array[1..512] of byte;
                             end;

const
  UsePrimary    : boolean = true;
  Changed       : ChangedSectorListPointer = nil;
  LastCommand   : string = '';
  FaultyPartitions : string = '';
  LinuxName        : string[5]='hda4';
  FirstScsiDrive   : integer=1; {=number of non-SCSI hard drives; determined later}
  Drive            : byte = 0;
  PrimaryDosExists : boolean = false;
  ExtendedTypes = [5,$C5,$E5,$A5,$F2];  {those partition types that are extended partitions}
  DosPartitionTypes = [1,4,6,$24,$50,$51,$C1,$C4,$C6,$E1,$E3,$E4,$E6,$A6];

type
    BiosParameterBlock = record      {found in boot Sector of DOS disks (Ver 2 onwards), & in driver RAM}
                     BytesPerSector   : integer; {normally 512; sometimes 128, 256, 1024}
                     SectorsPerCluster: byte; {or "sectors per allocation unit" - 1 for small diskettes}
                     ReservedSectors  : word; {normally 1, for the Boot sector; more if small sector size}
                     NumberOfFATs     : byte; {normally 2, DOS assumes 2 no matter what it says, except in VDISK}
                     RootEntries      : word; {size of root directory (32 bytes/entry)}
                     TotalSectors     : word; {DOS subtracts ReservedSectors & FAT space}
                     FormatID         : byte; {see Dos_360K etc}
                     SectorsPerFAT    : word; {2 for 360Kb, 7 for 1.2Mb}
                     SectorsPerTrack  : word; {e.g. 8, 9, 15, 26}
                     NumberOfSides    : word; {1 or 2 for diskettes}
                     SpecialReserved  : longint;
                     end {of record};
    BPBpointer      = ^BiosParameterBlock;
    Dos_BootSector = record Hop,Skip,Jump   : byte;
                     SystemID        : array[1..8] of char;
                     BPB             : BiosParameterBlock;
                     BigTotalSectors : longint;
                     Reserved1       : array[36..38] of byte;
                     VolumeSerial    : record Low,High : word; end;
                     VolumeLabel     : array[1..11] of char;
                     FatWhatever     : array[1..6] of char;
                     BootstrapProgram: array[60..509] of char;
                     Signature       : array[1..2] of char; {should be #$55#$AA}
                     end {of record};
    PartitionRecord = record Bootable : byte; {0=NO, $80=Yes}
                                                      StartSide,StartSector,StartCyl : byte;
                                                      System : byte;
                                                      EndSide,EndSector,EndCyl : byte; {top 2 bits of Cyl. in Sector}
                                                      RelSect,NumberOfSectors : longint;
                                                      end;
    MBRtype = record BootCode : array[0..$1AC] of char;
                     Reserved : array[$1AD..$1BD] of byte;
                     Partition: array[1..4] of PartitionRecord;
                     AA55 : word;
                     end;
    MbrPointer = ^MBRtype;
    Dos_DirectoryEntry = record  {32-byte entries in MS-DOS directories}
                         Filename    : array[1..8] of char;  {Filename[1]='.' means deleted, =#0 means end}
                         Extension   : array[1..3] of char;
                         Attribute   : byte; {see Dos_ReadOnly, etc}
                         Dunno       : word;
                         Password,GID,UID,Permissions : word;
                         Time,
                         Date        : word;
                         StartCluster: word;
                         FileSize    : longint;
                         end;
    LinkedList = ^LinkedListRecord;
    LinkedListRecord = record Next : LinkedList; msg : string; end;
    String29 = string[29];
    String29Array = array[byte] of string29;
    String128=string[128];
  KnownPartitionType = array[1..42] of record Parent,
                                              FirstSector,LastSector: longint;
                                              StartOfSlack          : longint;
                                              cyl,head,sect,error   : word;
                                              RawEntry              : PartitionRecord;
                                              Description           : string[40];
                                              Faults                : string128;
                                              BootSector            : ^DOS_BootSector;
                                              CurrentDosName,
                                              NewDosName            : string[2];
                                              ThisLinuxName         : string[5];
                                              end;

var NumberOfDrives : byte absolute $40:$75;
    t0,counter : longint;
    ticks      : longint absolute $40:$6C;
    dd         : array[byte] of word;
    info       : record k0, Cylinders, k2, Heads, k4,k5, Sectors : word;
                        dontcare : array[7..9] of word;
                        SerialNumber : array[1..20] of char;
                        ControllerType : word;
                        BufferSize : word;
                        ECCbytes   : word;
                        ControllerRevision : array[1..8] of char;
                        Model : array[1..40] of char;
                        end absolute dd;
var
  i, ThisDir, p, f           : Integer;
  ValidLinuxPartitions       : 4..80;
  PartitionType : String29Array;
  MaxPartition  : integer;
  OriginalPartitions,
  PartitionsOn     : array[0..7] of ^KnownPartitionType;
  DescribeDocument, {open up the file & display some of the text}
  FullNameRequired, {want full pathname after size}
  TotalRequired,    {at end of list give the grand total}
  UnpackFlag,       {look inside packed (PKARC-type) dump files}
  GotTemplate,
  InFlag                 : boolean;
  PhysicalDrive          : byte;
  OldInterrupt13         : pointer;
  ThisParameter          : integer;
  DriveDetails  : array['A'..'Z'] of record CX : word; DH, DL : byte;
                                            end;
  x,
  PhysicalStart,
  PartitionSize,
  PhysicalSize,
  UsedClusters,
  BadClusters            : longint;
  OffsetToData           : longint;
  PhysicalCyl,
  PhysicalHeads,
  MaxPhysicalSector,
  Contiguous             : word;
  start,finish           : string[20];
  n                      : real;
  CanonicalForm          : string80;
  Style     : 1..3;
  Buffer    : array[0..512*4-1] of byte;
  PartitionTable         : MBRtype absolute Buffer;
  ExtendedMBR : MBRtype;
  Buffer2   : array[0..1023] of char;
  BootSector: Dos_BootSector absolute Buffer2;
  ThisBootSector : DOS_BootSector;
  Dir       : DirStr absolute Buffer2; {never need both at same time}
  Ext       : ExtStr;
const MainOptions : OptionsType = (
                   'New partition',
                   'Boot from... (select active partition)',
                   'Delete a partition (and all its data!)',
                   'List all primary & logical partitions',
                   'Pick physical disk',
                   'Find, and fix, faults in partitions',
                   'eXtra for experts (resize, type-change, etc) ',
                   '');
const x0=3; x9:byte=79; y0=2; y9:byte=21;
      DriveDescription : array[0..7] of string[40] = ('','','','','','','','');
var {PartitionNumberList : string;}
    ScrollOffset        : integer;


function AbsoluteSector(cyl : longint; head,sect : word) : longint;
function BootableStatus(B : byte) : string22;
function chs(Cyl,Head,Sector:integer) : string;
function chs2Integer(st : string) : longint;
function Dos_ReadSector(Drive : word; StartSector : longint; HowMany : word; var Where) : boolean ;
function DriveType(n : byte) : string;
function KnownName(I : byte) : string29;
function LBA2chs(sector : longint) : string22;
function Menu(Prompt : string; MainOptions : OptionsType) : string;
function nth(n : byte) : string;
function OSname(p : pointer) : string;
function Part2Integer(st : string) : longint;
function PartitionTypeName(n : byte; StartCyl,StartSide,StartSector : word) : string80;
function PresentDosName(Drive, CX, DH : word) : string;
function ProcessMouseButton : string;
function Split(var Command : string; TheOptions : OptionsType) : char;
function Swappa(st : string) : string;
function fmt(n : real; size : integer) : string;
function Trim(st : string) : string;
function TryToString(st : string) :string;

procedure AddFault(var Faults : string128; msg : string);
procedure Beep;
procedure EditCMOS(Command : string);
procedure EditSectors(Command : string);
procedure ExploreExtended(ParentPartition: integer);
procedure GetDriveParameters(drive : byte);
procedure Help(topic : string);
procedure Highlight(part : byte);
procedure IDEinfo(st : string);
procedure LongBlockRead(Sector : longint; Buffer : pointer);
procedure Message(st : string);
procedure PickPhysicalDisk(Command : string);
procedure PopupPartitionInfo(n : integer);
procedure PopupWindow(Title : string; Big : boolean);
procedure PrepareScreen(Prompt : string80);
procedure ReadLong(sectornumber : longint; var buffer);
procedure ReadPartitionTable;
procedure StatusLine(st : string);
procedure Unimplemented;
procedure UpdatePart(PartitionNumber : integer);
procedure WriteSector(This_CX,This_DX : word; Block :MbrType);

implementation

procedure AddFault(var Faults : string128; msg : string);
begin
if pos(msg,Faults)=0 then Faults:=Faults+' ('+msg+')';
end;

procedure ReadLong(sectornumber : longint; var buffer);
{global pcstuff.reg used by deletePartition!}
const sixtyfour : word = 64;
var sect,head : word;
    cyl : longint;
    BootSector : Dos_BootSector absolute buffer;
begin
with pcstuff.reg do
          begin
          AH:=2;                                               {read command}
          AL:=1;                                         {one sector to read}
          if MaxPhysicalSector<2
                then begin flags:=255; exit; end;
          if SectorNumber<0
             then begin flags:=1; exit; end;
          sect:=1+(SectorNumber mod MaxPhysicalSector);
          head:=(SectorNumber div MaxPhysicalSector) mod PhysicalHeads;
          DL:=$80 or (drive and 31);
          cyl:=(SectorNumber div MaxPhysicalSector) div PhysicalHeads;
          if (cyl<0) or (cyl>=1024*4)
             then begin flags:=1; exit; end;
          CL:=sect+SixtyFour*word(hi(cyl) and 3);
          CH:=lo(cyl);
          if cyl>MaxCylForPhysical[drive and 31]
                then begin flags:=255; exit; end;
          DH:=head+SixtyFour*word(hi(cyl) shr 2);
          ES:=seg(buffer); BX:=ofs(Buffer);
          fillchar(buffer,512,0);
          intr($13,pcstuff.reg);
          if odd(Flags)
           then if (ah=10)
             then begin
                  {writeln('  error=',AH,' flags=',flags,'    cyl:',cyl:4,' head:',head:2,' sect:',sect:2,'  AX:=',hex(ax));}
                  if cyl>100 then MaxCylForPhysical[drive and 31]:=cyl-1;
                  end
     end;
   end;

function KnownName(I : byte) : string29;
 begin
 case I of
        0 : KnownName:='Empty';
      $01 : KnownName:='DOS 12bit small';
      $02,$03 : KnownName:='XENIX';
      $04 : KnownName:='DOS 16bit';
      $05 : KnownName:='Extended Partition';
      $06 : KnownName:='DOS >32Mb';
      $07 : KnownName:='HPFS/NTFS (OS/2 or NT)';
      $08 : KnownName:='AIX bootable';
      $09 : KnownName:='AIX data';
      $0A : KnownName:='Boot Manager (OS/2 or Partition Magic)';
      $10 : KnownName:='OPUS';
      $12 : KnownName:='Compaq Diagnostics';
      $18 : KnownName:='AST special Windows swap file';
      $24 : KnownName:='NEC MSDOS 3.x';
      $3C : KnownName:='PowerQuest PartitionMagic recovery partition';
      $40 : KnownName:='VENIX 80286';
      $42 : KnownName:='SFS (Secure File System) by Peter Gutmann';
      $50 : KnownName:='Disk Manager READONLY partition';
      $51 : KnownName:='Disk Manager (need DMDRVR.BIN)';
      $52 : KnownName:='CP/M or Microport';
      $56 : KnownName:='GoldenBow VFeature';
      $61 : KnownName:='SpeedStor';
      $63 : KnownName:='GNU HURD,Mach or 386/ix';
      $64 : KnownName:='NetWare';
      $65 : KnownName:='NetWare (3.11)';
      $70 : KnownName:='DiskSecure Multi-Boot';
      $71 : KnownName:='PC/IX';
      $75 : KnownName:='PC/IX';
      $80 : KnownName:='Minix v1.1 - 1.4a';
      $81 : KnownName:='Minix or Linux';
      $82 : KnownName:='Linux Swap';
      $83 : KnownName:='Linux e2fs (Extended 2 Filesystem)';
      $84 : KnownName:='OS/2 hidden DOS C:';
      $93 : KnownName:='Amoeba file system';
      $94 : KnownName:='Amoeba bad block table';
      $A5 : KnownName:='FreeBSD, BSD/386';
      $B7 : KnownName:='BSDI secondary swap';
      $B8 : KnownName:='BSDI swap';
      $C7 : KnownName:='Syrinx Boot';
      $DB : KnownName:='CP/M, Concurrent CP/M, Concurrent DOS';
      $DB : KnownName:='CTOS (Convergent Technologies OS)';
      $E1 : KnownName:='SpeedStor 12-bit FAT extended partition';
      $E3 : KnownName:='DOS read-only';
      $E4 : KnownName:='SpeedStor 16-bit FAT extended partition';
      $F2 : KnownName:='DOS 3.3+ secondary';
      $F4 : KnownName:='SpeedStor';
      $FE : KnownName:='LANstep';
      $FF : KnownName:='Xenix bad block table';
 $11,$14,$16,$17,
  $84..$86: KnownName:=copy(KnownName(I and $F),1,9)+' hidden by bootman';
  $C1..$C6: KnownName:='DR-'+KnownName(I and $F)+' Secured';
  $E1..$E6: KnownName:='SpeedStor '+KnownName(I and $F);
      else KnownName:='unknown type 0x'+hex2(I);
      end;
 end;

procedure Message(st : string);
var SaveTextAttr,SaveXY : word;
begin
SaveXY:=GetCursorXY; SaveTextAttr:=TextAttr;
gotoXY(1,2);
TextAttr:=white;
if st='' then ClrEOL;
TextAttr:=$70;
write(copy(st,1,79));
TextAttr:=SaveTextAttr;
end;

function TryToString(st : string) :string;
var i : byte;
begin
for i:=length(st) downto(1) do if st[i] in [#0..#31,#127..#255]
    then delete(st,1,1);
TryToString:=st;
end;

function Special(colour : byte): byte;
begin
if colour=7 then colour:=3;
if LastMode=MONO then Special:=$70
                 else begin
                      Special:=$70+colour;
                      if colour<>LIghtGreen then SetBorderColour(black);
                      end;
end;

procedure PrepareScreen(Prompt : string80);
const colour= white;
begin
 TextAttr:=Colour;
 if Prompt='' then begin
                   window(1,2,80,15);
                   CRT.ClrScr;
                   window(1,1,80,25);
                   end
              else begin
                   window(1,1,80,25);
                   CRT.ClrScr;
                   gotoXY(1,1);
                   TextAttr:=11; write('FDISK '); TextAttr:=3; write(' ('); TextAttr:=11; write('F');
                   TextAttr:=3; write('ixed '); TextAttr:=11; write('Disk');
                   TextAttr:=3; write(' Utility) Rev ',Version+'. '); TextAttr:=8+3; write(Capitals(Prompt));
                   end;
end;

function PartitionTypeName(n : byte; StartCyl,StartSide,StartSector : word) : string80;
var st : string;
begin
st:=PartitionType[n];
with pcstuff.reg,ThisBootSector do
            begin
            AX:=$0201; CX:=1;
            CH:=StartCyl;  CL:=StartSector;
            DH:=StartSide; DL:=$80+Drive;
            ES:=seg(ThisBootSector); BX:=ofs(ThisBootSector);
            fillchar(ThisBootSector,sizeof(BootSector),0);
            intr($13,pcstuff.reg);
            case n of
                 1,4,6,8: if Signature=#$55#$AA
                              then st:=st+' {'+TryToString(SystemID)+'}'
                              else if Signature=#$F6#$F6 then st:=st+' (unformatted)';
                 5 : if Signature<>#$55#$AA
                        then st:=st+'{?!}'
                        else if Hop<>0 then st:=st+'{exec}';
                 $82 : if Hop=254 then st:=st+'{mkswap''ed}';
                 $83 : if pos('ILO',systemID)=1 then st:=st+' {LILO}'
                                                else if (Hop=0) and (SystemID=#0#0#0#0#0#0#0#0)
                                                        then st:=st+' {No LILO}';
                 7   : if Signature<>#$55#$AA then st:=st+' {no format}'
                                              else st:=st+' {'+TryToString(SystemID)+'}';
                 end;
            end;

PartitionTypeName:=st;
end;

procedure PopupWindow(Title : string; Big : boolean);
var st : string;
begin
TurnOffMouseCursor;
SaveScreen;
if Big then begin x9:=79; y9:=y0+23; end
       else begin x9:=x0+9+length(Title); y9:=y0+6; end;
TextAttr:=$30; st[0]:=char(x9-x0+1);
fillchar(st[1],1+x9-x0,'');
move(Title[1],st[1+(x9-x0-length(Title)) div 2],length(Title));
TextAttr:=$31;
CRT.gotoXY(x0,y0);
write(st);
Window(x0,y0+1,x9,y9);
CRT.ClrScr;
CRT.gotoXY(2,y9-y0);
TextAttr:=$B1;
end;

procedure LongBlockRead(Sector : longint; Buffer : pointer);
var sect,head,cyl : integer;
begin
with pcstuff.reg do begin
            AX:=$0201; CX:=1;
            Sect:=(Sector mod MaxPhysicalSector)+1;
            Head:=(Sector div MaxPhysicalSector) mod PhysicalHeads;
            Cyl:=(Sector div (MaxPhysicalSector * PhysicalHeads));
            CH:=byte(Cyl);  CL:=(Sect)+64*(hi(Cyl) and 3);
            DH:=head+64*(hi(Cyl) div 4); DL:=$80+Drive;
            ES:=seg(buffer^); BX:=ofs(Buffer^);
            fillchar(Buffer^,sizeof(BootSector),0);
            intr($13,pcstuff.reg);
            end;
end;

procedure Unimplemented;
begin
PopupWindow('Sorry, Unimplemented',false);
TextAttr:=yellow; DirectVideo:=true;
CRT.GotoXY(1,2);
TextAttr:=$30+Yellow;
writeln(' Not implemented yet! ');
if Readkey=#0 then if Readkey=#3 then;
window(1,1,80,25);
RestoreScreen;
TurnonMouseCursor;
end;


function BootableStatus(B : byte) : string22;
begin
case B of
     $80 : BootableStatus:='Y ';
     $00 : BootableStatus:='- ';
     else BootableStatus:=hex2(B);
     end;
end;

function nth(n : byte) : string;
begin
case n of
     1 : nth:='1st';
     2 : nth:='2nd';
     3 : nth:='3rd';
     else nth:=chr(48+n)+'th';
     end;
end;

function DriveType(n : byte) : string;
begin
if n=0
   then DriveType:=' type 0 (SCSI?)'
   else DriveType:=' type '+decimal(n);
end;


function Swappa(st : string) : string;
 var t : char;
 begin
 for i:=1 to length(st) do
     if odd(i) then begin t:=st[i]; st[i]:=st[i+1]; st[i+1]:=t; end;
 Swappa:=st;
 end;

function fmt(n : real; size : integer) : string;
var st : string;
begin
if frac(n)>0.08 then str(n:size:1,st) else str(n:size:0,st);
fmt:=st;
end;

function OSname(p : pointer) : string;
var bs : ^DOS_BootSector absolute p;
    i : integer;
    st,best : string[80];

    procedure EndOfString;
    begin
    if (best='') or (pos('IO.',st)>0) then best:=st;
    st:='';
    end;
begin
st:=''; best:='';
with bs^ do for i:=60 to 509 do
     begin
     case BootstrapProgram[i] of
          ' ' : if st<>'' then begin
                               if st[length(st)]<>'.' then st:=st+'.';
                               end;
          'A'..'Z' : if (length(st)<6) or (st[length(st)-3]<>'.')
                        then st:=st+BootstrapProgram[i]
                        else begin EndOfString; st:=BootstrapProgram[i]; end;
          else if st<>'' then EndOfString;
                              
          end;
     end;
OSname:=best;
end;

function chs(Cyl,Head,Sector:integer) : string;
 begin
 chs:='('+fmt((Sector and $C0)*4+Cyl,4)+'/'+fmt(Head,2)+'/'+fmt(Sector and $3F,2)+')';
 end;

function LBA2chs(sector : longint) : string22;
 var t : longint;
 begin
 t:=sector div MaxPhysicalSector;
 LBA2chs:=chs(t div (PhysicalHeads), t mod (PhysicalHeads),succ(sector mod MaxPhysicalSector));
 end;

function chs2Integer(st : string) : longint;
 var i,j,k,cyl,head,sect,p,p1,p2 : integer;
 begin
 while (st<>'') and (st[1] in [#9..' ','(']) do delete(st,1,1);
 st:=capitals(st);
 chs2integer:=0;
 if copy(st,1,4)='/DEV' then delete(st,1,4);
 p2:=pos(copy(st,1,2),'/'+capitals(LinuxName));
 if p2 in [1,2]
    then begin
         if st[1]='/' then delete(st,1,1);
         for p:=1 to MaxPartition do with PartitionsOn[Drive]^[p] do
             if capitals(ThisLinuxName)=Capitals(st)
                then begin chs2integer:=FirstSector; ThisPartition:=p; exit; end;
         exit;
         end;
 p1:=pos('/',st);
 if (st[1] in ['A'..'Z']) and ((st[2]=':') or (st[1] <'H'))
    then begin
         for p:=1 to MaxPartition do with PartitionsOn[Drive]^[p] do
             if CurrentDosName[1]=st[1]
                then begin chs2integer:=FirstSector; ThisPartition:=p; exit; end;
         {???!!!}
         end;
 if p1>0
    then begin
         cyl:=stringtointeger(copy(st,1,p1-1));
         delete(st,1,p1);
         p2:=pos('/',st);
         if p2=0 then p2:=length(st)+1;
         head:=stringtointeger(copy(st,1,p2-1)); sect:=stringtointeger(copy(st,p2+1,2));
         chs2integer:=(cyl*(PhysicalHeads)+head)*MaxphysicalSector+max(0,Sect-1);
         end
    else chs2integer:=StringToInteger(st);
 end;

function Part2Integer(st : string) : longint;
 var i,j,k,cyl,head,sect,p,p1,p2 : integer; x : longint;
 begin
 while (st<>'') and (st[1] in [#9..' ','(']) do delete(st,1,1);
 st:=capitals(st);
 Part2integer:=0;
 if copy(st,1,4)='/DEV' then delete(st,1,4);
 p2:=pos(copy(st,1,2),'/'+capitals(LinuxName));
 if p2 in [1,2]
    then begin
         if st[1]='/' then delete(st,1,1);
         for p:=1 to MaxPartition do with PartitionsOn[Drive]^[p] do
             if capitals(ThisLinuxName)=Capitals(st)
                then begin Part2integer:=p; ThisPartition:=p; exit; end;
         exit;
         end;
 p1:=pos('/',st);
 if (st[1] in ['A'..'Z']) and ((st[2]=':') or (st[1] <'H'))
    then begin
         for p:=1 to MaxPartition do with PartitionsOn[Drive]^[p] do
             if CurrentDosName[1]=st[1]
                then begin Part2integer:=p; ThisPartition:=p; exit; end;
         {???!!!}
         end;
 if p1>0
    then begin
         cyl:=stringtointeger(copy(st,1,p1-1));
         delete(st,1,p1);
         p2:=pos('/',st);
         if p2=0 then p2:=length(st)+1;
         head:=stringtointeger(copy(st,1,p2-1)); sect:=stringtointeger(copy(st,p2+1,2));
         x:=(cyl*(PhysicalHeads)+head)*MaxphysicalSector+max(0,Sect-1);
         for p:=1 to MaxPartition do with PartitionsOn[Drive]^[p] do
             if x=firstsector
                then begin Part2integer:=p; ThisPartition:=p; exit; end;
         end
    else Part2integer:=StringToInteger(st);
 end;

procedure IDEinfo(st : string);
var disk : byte;
    InfoBuffer : array[0..511] of byte;
    FDScsiBuffer : record PhysicalInfo : set of (Dunno,Parity,BPS256,CapacityUnknown,Removable,LUNnotPresent);
                          TranslatedCylinders :word;
                          TranslatedHeads,TranslatedSPT : byte;
                          DriveAddress : byte; {bits 0-2: LUN, bits 3-5: SCSI device number}
                          One, SenseCode,Zero,SenseKey,AnotherZero : byte;
                          CommandDescriptorBlock : array[1..10] of byte;
                          TranslatedTotalSectors : longint;
                          end absolute InfoBuffer;

begin
TextAttr:=TextAttr and $79;
CRT.ClrScr;
disk:=pos(st[1],'2345');
writeln('Drive ',disk+1,' of ',NumberOfDrives,' hard drives');
writeln('     BIOS reports: ',PhysicalCyl,' cyl x ',PhysicalHeads,' x ',MaxPhysicalSector,' sectors');
if lo(MachineID) in [$FA..$FC]
   then i:=CmosRam($12)
   else i:=0;
case drive and 15 of
     0 : if (i>=$F0) then st:=DriveType(CmosRam($19))
                       else st:=DriveType(i shr 4);
     1 : if (i and $F)=$F then st:=DriveType(CmosRam($1A))
                       else st:=DriveType(i and $F);
     else st:='unsure';
     end;
writeln('   CMOS disk type: ',st);
{read IDE stuff!}
t0:=ticks;
fillchar(dd,sizeof(dd),0);
    begin
    while port[$1F7]<>$50 do
          if ticks>t0+3 then with pcstuff.reg do
                             begin
                             st:=getenv('windir')+' ';
                             for i:=EnvCount downto 1 do
                                 begin
                                 st:=st[1]+EnvStr(i);
                                 if st[2]='w' then delete(st,1,1);
                                 end;
                             if (st[1]<>' ')
                                then writeln('Running under WINDOWS (or controller timed-out)')
                                else writeln('Not IDE (or controller timed-out)');
                             pcstuff.reg.AX:=$1B01; pcstuff.reg.DX:=$80+(Drive and 31);
                             pcstuff.reg.ES:=seg(InfoBuffer); pcstuff.reg.BX:=ofs(InfoBuffer);
                             intr($13,pcstuff.reg);
                             if not odd(pcstuff.reg.Flags) then
                                begin
                                if ES=seg(InfoBuffer)
                                   then begin
                                        writeln('ESDI Info: ',InfoBuffer[0]);
                                        (* unimplemented; !!! *)
                                        end
                                   else with FDScsiBuffer do
                                        begin
                                        writeln('Future Domain SCSI ',InfoBuffer[0]);
                                        end;
                                exit;
                                end;
                             fillchar(InfoBuffer,sizeof(InfoBuffer),0);
                             ax:=$1325; dx:=$80+(Drive and 31);
                             ES:=seg(InfoBuffer); BX:=ofs(InfoBuffer);
                             intr($13,pcstuff.reg);
                             if not odd(Flags)
                                then writeln('PS/1 or PS/2 Disk');
                             exit;
                             end;
    port[$1F6]:=$A0 + (disk*$10); {which drive}
    port[$1F7]:=$EC;  {get drive info}
    while port[$1F7]<>$58 do
          if ticks>t0+5 then ErrorMessage('IDE Disk Controller won''t talk to me!');
    for i:=0 to 255 do dd[i]:=portw[$1F0];
    end;
with Info do
     begin
     writeln('IDE disk model is: ',swappa(Model),
         ^M^J'           serial: ',swappa(SerialNumber),
         ^M^J'         Revision: ',Swappa(ControllerRevision),
         ^M^J'      Buffer Size: ',BufferSize div 2,' Kb',
         ^M^J'Double-word xfers: ',boolean(dd[48]));
     if (Cylinders<>PhysicalCyl) and (Cylinders>0) and (PhysicalCyl>0)
        then st:='(note mapping from '+decimal(Cylinders)+' to '+decimal(PhysicalCyl)+')'
        else if dd[54]<>Cylinders then st:='(Default is: '+decimal(dd[54])+' x '+decimal(dd[55])+')'
                                  else st:='';
     writeln('   Physical Cyls.: ',Cylinders:4,' ',st,
         ^M^J'            Heads: ',Heads,
         ^M^J'          Sectors: ',Sectors,
         ^M^J'         Capacity: ',Cylinders*0.5*Heads*Sectors/1024:4:0,' Mb');
     end;
end;


procedure StatusLine(st : string);
var p,SaveAttr,SaveX,SaveY : integer;
begin
SaveAttr:=TextAttr; SaveX:=whereX; SaveY:=whereY;
CRT.gotoXY(1,24);
CRT.gotoXY(1,25);
if st='' then TextAttr:=7 else TextAttr:=$70;
if HelpFileOpenned and (pos('F1',st)=0)
   then st:='F1=Help '+st;
if length(st)<77
   then begin
        p:=pos('ESC',st);
        if p>0
           then st:=copy(st,1,p-1)+copy('                                                        ',1,78-length(st))
                   +''+copy(st,p,99);
        end;
write(st);
ClrEOL;
CRT.GotoXY(saveX,saveY);
TextAttr:=SaveAttr;
end;

function Split(var Command : string; TheOptions : OptionsType) : char;
var i,j,k : integer; ThisWord : string[33]; 
begin
while (Command<>'') and (Command[1]<=' ') do delete(command,1,1);
while (Command<>'') and (Command[length(Command)]<=' ') do dec(Command[0]);
if Command='' then Split:=#27
              else begin
                   i:=1;
                   repeat inc(i) until (i>length(Command)) or (Command[i] in [#0..' ',',']);
                   j:=i;
                   repeat inc(j) until (j>Length(Command)) or not (Command[j] in [#0..' ',',']);
                   LastCommand:=copy(Command,1,i-1);
                   Thisword:=Capitals(LastCommand);
                   if Command[1] in ['1'..'9'] then LastCommand:=TheOptions[ord(Command[1])-ord('0')];
                   Command:=copy(command,j,99);
                   for i:=1 to 8 do if ThisWord=Capitals(copy(TheOptions[i],1,length(ThisWord)))
                       then ThisWord:=decimal(i);
                   Split:=upcase(ThisWord[1]);
                   end;
end;

function Dos_ReadSector(Drive : word; StartSector : longint; HowMany : word; var Where) : boolean ;
const NumberOfFloppyDiskDrives : byte = 2;
var Result : byte;
    Packet : record SectorNumber : longint;
                    NumberToRead : word;
                    TransferAddr : pointer;
                    end;
    PackPointer : pointer;
begin
Dos_ReadSector:=true;
intr($11,pcstuff.reg);
with pcstuff.reg do if odd(AX) then NumberOfFloppyDiskDrives:=succ((AX shr 6) and 3)
                       else NumberOfFloppyDiskDrives:=0;
{A:=0, B:=1, etc}
if drive<max(2,NumberOfFloppyDiskDrives)
   then with pcstuff.reg do begin
                    AH:=2; AL:=HowMany;
                    CH:=0;
                    CL:=1+StartSector;
                    DX:=Drive; {DH=head=0}
                    ES:=seg(where); BX:=ofs(where);
                    if true then intr($40,pcstuff.reg)
                            else intr($13,pcstuff.reg);
                    if odd(flags) and (ah=6)
                       then begin AH:=2; AL:=HowMany; intr($13,pcstuff.reg); end;
                    result:=flags and 1;
                    end
   else begin
        inline(
  $55/$16/$1E/         { PUSH BP,SS,DS  }
  $8B/$8E/HowMany/     { MOV CX,HowMany[BP]}
  $8B/$86/Drive/       { MOV AX,Drive[BP] }
  $8B/$96/StartSector/ { MOV DX,StartSector[BP]}
  $C5/$9E/Where/       { LDS BX,Where[BP] }
  $CD/$25/             { INT 25h ; read DOS absolute sectors}
  $1F/                 { POP DS  ; because flags pushed}
  $1F/$17/$5D/         { POP DS,SS,BP}
  $73/$02/             { JNC .+2}
  $0C/$01/             { OR AL,1}
  $88/$86/Result);     { MOV Result[BP],AL}
        if (Result>1) or (BootSector.BPB.BytesPerSector<128) or (StartSector>=$FFFF) then
           begin
           with Packet do
             begin
             SectorNumber:=StartSector;
             NumberToRead:=HowMany;
             TransferAddr:=@where;
             end;
           HowMany:=$FFFF;
           PackPointer:=@Packet;
           inline(
             $55/$16/$1E/         { PUSH BP,SS,DS  }
             $8B/$8E/HowMany/     { MOV CX,HowMany[BP]}
             $8B/$86/Drive/       { MOV AX,Drive[BP] }
             $8B/$96/StartSector/ { MOV DX,StartSector[BP]}
             $C5/$9E/PackPointer/ { LDS BX,Where[BP] }
             $CD/$25/             { INT 25h ; read DOS absolute sectors}
             $1F/                 { POP DS  ; because flags pushed}
             $1F/$17/$5D/         { POP DS,SS,BP}
             $88/$86/Result);     { MOV Dos_WriteSector[BP],AL}
           DosError:=Result;
           Dos_ReadSector:=(DosError=0);
           end;
        end;
end;

procedure GetDriveParameters(drive : byte);
begin
with pcstuff.reg do
    begin
    AX:=$0800; DX:=Drive; intr($13,pcstuff.reg);
    PhysicalCyl:=(CH+(CL div 64)*256)+1;
    MaxPhysicalSector:=(CL mod 64);
    PhysicalHeads:=(dh+1);
    PhysicalSize:=PhysicalCyl*longint(MaxPhysicalSector)*PhysicalHeads;
    if DriveDescription[Drive and 7]=''
       then DriveDescription[Drive and 7]:=Decimal(PhysicalCyl)+' cylinders/'+decimal(Physicalheads)+' heads/'
               +decimal(MaxPhysicalSector)+' sectors';
    AX:=$0201;
    CH:=0;
    CL:=1;
    DX:=Drive;
    ES:=seg(PartitionTable); BX:=ofs(PartitionTable);
    if Drive=255 then Flags:=1
                 else intr($13,pcstuff.reg);
    end;
end;

function AbsoluteSector(cyl : longint; head,sect : word) : longint;
begin
cyl:=(cyl+256*(sect shr 6)+1024*(head shr 6));
AbsoluteSector:=(cyl*PhysicalHeads+(Head and 63))*MaxPhysicalSector+(Sect and 63)-1;
end;

procedure Help(topic : string);
begin
end;

procedure Beep;
begin
write(^G);
end;

procedure EditSectors(Command : string);
var key : char;
type ArrayOfPchar = array[0..512] of ^char;
const mode : char = 'P';
const cyl: integer = 0; head : integer=0; sect : integer = 1;
      offset : integer = 0;
var ThisSector : array[0..511] of byte;
    ThisTable  : MbrType absolute ThisSector;
    Best,Lba   : longint;

 function AttrName(b : word) : string;
 var st : string[8]; i : byte;
 begin
 st:='';
 for i:=7 downto 0 do
     if odd(b shr i) then st:=st+BitInitial[i][1]
                     else if st<>'' then st:=st+'.';
 AttrName:=st;
 end;

 procedure SplitCHS(LBA : longint; var cyl,head,sect : integer);
 begin
 Cyl:=LBA div (PhysicalHeads*MaxPhysicalSector);
 Head:=(LBA div MaxPhysicalSector) mod PhysicalHeads;
 Sect:=(LBA mod MaxPhysicalSector)+1;
 end;

  function FindPartition : integer;
  var best : integer; bestLba : longint;
  begin
  best:=MaxPartition;
  bestLba:=(Physicalcyl*PhysicalHeads*MaxphysicalSector-1);
  LBA:=(cyl*(PhysicalHeads)+head)*MaxphysicalSector+max(0,Sect-1);
  for p:=1 to MaxPartition do
      with PartitionsOn[Drive]^[p] do if RawEntry.System>0 then
           if (FirstSector<LBA) and (FirstSector<BestLBA)
              then best:=p;
  FindPartition:=best;
  end;

 procedure Redisplay(mode : char);
 var DirPointer : ^Dos_DirectoryEntry;
     MbrPointer : ^MbrType;
     BootPointer: ^DOS_BootSector;
 var IP,i,j,k : integer;

  procedure ShowCode(var IP : integer; length : integer);
  var i : integer;
  begin
  TextAttr:=5;
  write(hex(IP),' ');
  TextAttr:=11;
  for i:=IP to IP+length-1 do write(Hex(ThisSector[i]));
  inc(IP,length);
  writeln('      ');
  end;

  procedure ShowChar(var IP : integer; length : integer; name : string);
  var i : integer; st : string[64];
  begin
      TextAttr:=5;
      write(hex(IP),' ');
      TextAttr:=11; st:='';
      for i:=IP to IP+length-1
          do begin
             if (i-IP)<9 then write(Hex(ThisSector[i]));
             st:=st+char(ThisSector[i]);
             end;
      writeln('':18-length*2,' db "',st,'"  ; ',name);
      inc(IP,length);
  end;

  procedure ShowLong(var IP : integer; name : string);
  var i : integer; n : longint;
  begin
  TextAttr:=5;
  write(hex(IP),' ');
  TextAttr:=11; n:=0;
  for i:=IP to IP+3 do
      begin
      write(Hex(ThisSector[i]));
      end;
  n:=ThisSector[IP]+256*ThisSector[IP+1]+65536*(ThisSector[IP+2]+256*ThisSector[IP+3]);
  writeln('          dd ',n:7,' ; ',name );
  inc(IP,4);
  end;

  procedure ShowWord(var IP : integer; name : string);
  var i : integer; n : longint;
  begin
  TextAttr:=5;
  write(hex(IP),' ');
  TextAttr:=11; n:=0;
  for i:=IP to IP+1 do
      begin
      write(Hex(ThisSector[i]));
      n:=(n shl 8)+ThisSector[i];
      end;
  writeln('              dw ',n:4,' ; ',name );
  inc(IP,2);
  end;

  procedure ShowByte(var IP : integer; name : string);
  var i : integer; n : longint;
  begin
  TextAttr:=5;
  write(hex(IP),' ');
  TextAttr:=11; n:=0;
  for i:=IP to IP do
      begin
      write(Hex(ThisSector[i]));
      n:=(n shl 8)+ThisSector[i];
      end;
  writeln('                db ',n:3,' ; ',name );
  inc(IP,1);
  end;

  procedure Hex_mode;
  var i,j : integer;
  begin
  k:=0;
  for i:=0 to $0F do
      begin
      TextAttr:=5;
      write(hex(i*2),' ');
      TextAttr:=11;
      for j:=0 to $1F do
          begin
          if j=$10 then write(' ');
          if (k=offset) then TextAttr:=$70
                        else if odd(j) then TextAttr:=LightCyan
                                       else TextAttr:=7;
          write(hex(ThisSector[k]));
          inc(k);
          end;
      ClrEOL; writeln('');
      end;
  TextAttr:=Green; st:='';
  for i:=0 to 511 do
      begin
      if ThisSector[i]>=32 then st:=st+chr(ThisSector[i]) else st:=st+'';
      if length(st)=74
         then begin ClrEOL; writeln(st); st:=''; end;
      end;
  write(st);
  CRT.gotoXY((offset mod 74)+1,(offset div 74)+17);
  TextAttr:=$72; write(chr(ThisSector[offset]));
  end;

  function Sensible(n : longint) : string;
  {convert number of sectors to Mb or Gb or something sensible based on its size}
  var st : string[22];
  begin
  if n<0 then Sensible:='??'
     else if n<2048 then Sensible:=decimal(n div 2)+'Kb'
     else if n<2000000 then sensible:=decimal(n div 2048)+'Mb'
     else begin str(n/2048000:3:1,st); Sensible:=st+'Gb'; end;
  end;

  procedure Partition_mode;
  var i,j : integer;
  begin
  CRT.ClrScr;
  k:=0;
  for i:=0 to $0B do
      begin
      TextAttr:=5;
      write(hex(i*2),' ');
      TextAttr:=11;
      for j:=0 to $1F do
          begin
          if j=$10 then write(' ');
          if (k=offset) then TextAttr:=$70
                        else if odd(j) then TextAttr:=LightCyan
                                       else TextAttr:=7;
          write(hex(ThisSector[k]));
          inc(k);
          end;
      ClrEOL; writeln('');
      end;
  MbrPointer:=@ThisSector;
  for i:=1 to 4 do with MbrPointer^.Partition[i] do
      begin
      ClrEOL;
      st:=hex(System);
      if Bootable<>0
         then st:=st+' BOOT'
         else st:=st+'     ';
      writeln('#',i,' type=',st,' ('+fmt((StartSector and $C0)*4+StartCyl,4)+'/'+fmt(StartSide,2)+'/'+
                    fmt(StartSector and $3F,2)+')->('+fmt((EndSector and $C0)*4+EndCyl,4)+'/'+fmt(EndSide,2)+'/'+
                    fmt(EndSector and $3F,2)+')',
                    ' rel.sect=',RelSect:8,' size=',Sensible(NumberOfSectors));
      end;
  TextAttr:=Green; st:='';
  for i:=0 to 511 do
      begin
      if ThisSector[i]>=32 then st:=st+chr(ThisSector[i]) else st:=st+'';
      if length(st)=74
         then begin ClrEOL; writeln(st); st:=''; end;
      end;
  write(st);
  CRT.gotoXY((offset mod 74)+1,(offset div 74)+17);
  TextAttr:=$72; write(chr(ThisSector[offset]));
  end;

  procedure Asm_mode;
  var i,j : integer;
  begin
  CRT.ClrScr;
  k:=0;
  BootPointer:=@ThisSector;
  IP:=0;
  with BootPointer^,BPB do
      begin
      ShowCode(IP,3);
      ShowChar(IP,8,'SystemID');
      ShowWord(IP,'BytesPerSector');
      Showbyte(IP,'SectorsPerCluster');
      ShowWord(IP,'ReservedSectors');
      ShowByte(IP,'NumberOfFATs');
      ShowWord(IP,'RootEntries');
      ShowWord(IP,'TotalSectors');
      ShowByte(IP,'FormatID');
      ShowWord(IP,'SectorsPerFAT');
      ShowWord(IP,'SectorsPerTrack');
      ShowWord(IP,'NumberOfHeads');
      ShowLong(IP,'Special Reserved');
      ShowLong(IP,'Big total Sectors');
      ShowChar(IP,3,'reserved');
      ShowLong(IP,'volume serial');
      ShowChar(IP,11,'volume label');
      ShowChar(IP,6,'FAT type');
 (*
          FatWhatever     : array[1..6] of char;
          BootstrapProgram: array[60..509] of char;
          Signature       : array[1..2] of char; {should be #$55#$AA}
 *)
      end;
  TextAttr:=Green; st:='';
  for i:=0 to 511 do
      begin
      if ThisSector[i]>=32 then st:=st+chr(ThisSector[i]) else st:=st+'';
      if length(st)=74
         then begin ClrEOL; writeln(st); st:=''; end;
      end;
  write(st);
  CRT.gotoXY((offset mod 74)+1,(offset div 74)+17);
  TextAttr:=$72; write(chr(ThisSector[offset]));
  end;

  procedure Dir_mode;
  var i,j,k : integer;
  begin
  k:=0;
  ClrEOL;
  for i:=0 to $0F do
      begin
      DirPointer:=@ThisSector[i*32];
      TextAttr:=5;
      with DirPointer^ do
           begin
           ClrEOL;
           write(TryToString(Filename):8,'.',
             Extension,FileSize:9,' ',AttrName(Attribute):7,
             ' ',TimeString(Time+65536*Date):12,
             ' @',StartCluster:5);
           if (Password<>0) or (UID<>0) or (GID<>0) or (Permissions<>0)
              then{ write(' ',hex2(Password),UID:6,'/',GID)};
           end;
      writeln('');
      end;
  TextAttr:=Green; st:='';
  for i:=0 to 511 do
      begin
      if ThisSector[i]>=32 then st:=st+chr(ThisSector[i]) else st:=st+'';
      if length(st)=74
         then begin ClrEOL; writeln(st); st:=''; end;
      end;
  write(st);
  CRT.gotoXY((offset mod 74)+1,(offset div 74)+17);
  TextAttr:=$72; write(chr(ThisSector[offset]));
  end;

  procedure Text_mode;
  var i,j,k : integer;
      StartOfLine : ArrayOfPchar;
  begin
  end;

  procedure Fat_mode;
  var i,j,k : integer;
      StartOfLine : ArrayOfPchar;
      N_lines : integer absolute StartOfLine;
  begin
  N_Lines:=1; StartOfLine[N_Lines]:=@ThisSector[0];
  end;

  begin
  CRT.gotoXY(1,1);
  case mode of
       'H' : Hex_mode;
       'P' : Partition_mode;
       'A' : Asm_mode;
       'D' : Dir_mode;
       'T' : Text_mode;
       'F' : Fat_mode;
       end;
  end {of Redisplay within EditSectors};
 procedure DisplaySector;
 var desc : string[20];
 begin
 with pcstuff.reg do
      begin
      window(1,1,80,25);
      CRT.gotoXY(1,1); TextAttr:=Yellow;
      if (Cyl=0) and (Head=0) and (Sect=1)
         then Desc:='[Master Boot Record]'
         else begin
              Desc:='[Linear='+decimal((cyl*(PhysicalHeads)+head)*MaxphysicalSector+max(0,Sect-1))+']';
              if not keypressed
                 then with PartitionsOn[Drive]^[FindPartition] do
                      if CurrentDosName<>'' then insert('('+CurrentDosName+')',Desc,length(Desc)-1);
              end;
      st:='[Disk: 0][Cyl=0000][Head=00][Sect=01][@000:???="?"]ͻ';
      move(Desc[1],st[59],length(Desc));
      writeln(st);
      for i:=2 to 24 do
          begin gotoXY(1,i); write(''); gotoXY(80,i); write(''); end;
      TextAttr:=7;
      gotoXY(10,1); write(Drive);
      gotoXY(18,1); write(Cyl:4);
      gotoXY(29,1); write(Head and 63:2);
      gotoXY(38,1); write(Sect and 63:2);
      gotoXY(43,1); write(Offset:3);
      AX:=$0201;
      CH:=byte(Cyl);  CL:=(Sect and 63)+64*(hi(Cyl) and 3);
      DH:=Head and 63; DL:=$80+Drive;
      ES:=seg(ThisSector); BX:=ofs(ThisSector);
      fillchar(ThisSector,sizeof(ThisSector),0);
      intr($13,pcstuff.reg);
      if odd(Flags)
         then begin
              Unimplemented;
              end;
      gotoXY(47,1); write(ThisSector[offset]:3);
      if ThisSector[offset] in [32..255]
         then begin gotoXY(52,1); write(char(ThisSector[Offset])); end;
      window(2,2,79,24);
      with ThisTable do
           if ( (Cyl=0) and (Head=0) and (Sect=1))
              then Mode:='P'
              else if (Mode in ['A','P']) and (Sect<>1) and (AA55<>$AA55) then mode:='H'
              (*
              else if (Mode='H') and (AA55=$AA55) and (ThisSector[$12]=2) then mode:='A' *);
      Redisplay(mode);
      end;
 end;

 procedure NextSector;
 begin
 inc(Sect);
 if Sect>63
    then begin
         Sect:=1; inc(Head);
         if Head>63 then begin Head:=0; inc(Cyl); end;
         end;
 end;

 procedure PreviousSector;
 begin
 dec(Sect);
 if Sect<0
    then begin
         Sect:=63; dec(Head);
         if Head<0 then begin Head:=63; dec(Cyl); end;
         end;
 end;

 procedure AskInteger(Title : string;var N : integer;x0 : byte);
 var y0 : byte;
 begin
 TurnOffMouseCursor;
 SaveScreen;
 x9:=x0+3+length(Title);
 y9:=3; y0:=1;
 TextAttr:=$30; st[0]:=char(x9-x0+1);
 fillchar(st[1],1+x9-x0,'');
 move(Title[1],st[1+(x9-x0-length(Title)) div 2],length(Title));
 TextAttr:=$31;
 CRT.gotoXY(x0,y0);
 Window(x0,y0+1,x9,y9);
 CRT.ClrScr;
 write(st);
 CRT.gotoXY(2,y9-y0);
 TextAttr:=$B0;
 Readln(N);
 window(1,1,80,25);
 RestoreScreen;
 TurnonMouseCursor;
 end;

 procedure NewMode;
 var oldmode : char;
 begin
 oldmode:=Mode;
 if Mode='P' then Mode:='H';
 end;

 procedure PickCyl;
 begin
 AskInteger('Cylinder number (0-'+decimal(PhysicalCyl)+')?',Cyl,12);
 NewMode;
 end;

 procedure PickHead;
 begin
 AskInteger('Head (0-'+decimal(PhysicalHeads)+')?',Head,23);
 NewMode;
 end;

 procedure PickSect;
 begin
 AskInteger('Sector (1-'+decimal(MaxPhysicalSector)+')?',Sect,32);
 NewMode;
 end;

 procedure PickOffset;
 begin
 AskInteger('Octet (offset) in sector (0-511)?',Offset,46);
 end;

var t0 : longint;
begin {EditSectors}
StatusLine(' F1=InfoF2=Bin F3=TextF4=Dir F5=FAT F6=MBR F7=Asm +-'#25''#24''#26''#27'F10=Exit');
TextAttr:=3;
window(1,1,80,24);
CRT.ClrScr;
repeat if not keypressed then DisplaySector;
       TurnOnMouseCursor;
       key:=#255;
       repeat if keypressed
                 then key:=ReadKey
                 else if MouseButton<>0
                         then begin
                              t0:=TimerTicks;
                              repeat case MouseY div 8 of
                                   0 : case MouseX div 8 of
                                            3..9: key:=^P; {physical drive}
                                          13..21: key:=^C; {Cyl}
                                          23..30: Key:=^H; {Head}
                                          32..38: Key:=^S; {sector}
                                          41..44: key:='@';{offset}
                                          46..48: key:='=';{set decimal}
                                          50..52: key:='"';{set ASCII}
                                          else beep;
                                          end;
                                   1..16: begin
                                          Offset:=max(0,MouseX div 8);
                                          if Offset>=36 then Offset:=(max(36,offset-1) div 2)-2
                                                        else Offset:=(offset div 2) -2;
                                          inc(Offset,(MouseY div 8)*32-32);
                                          key:=' ';
                                          end;
                                   24 : case MouseX div 8 of
                                             0..7: key:='?'; {Info}
                                            9..15: key:=^B; {Binary}
                                           17..23: key:=^T; {text}
                                           25..31: key:=^D; {dir}
                                           33..39: key:=^G; {Fat}
                                           41..47: key:=^P; {Partition}
                                           49..55: key:=^A; {Asm}
                                           71..79: key:=#27; {exit}
                                              57 : key:='+';
                                              59 : key:='-';
                                           else beep;
                                           end;
                                   17..23: begin
                                           offset:=(MouseX div 8 -1)+74*(MouseY div 8 -17);
                                           key:=' ';
                                           end;
                                   else begin
                                        gotoXY(72,1); write(MouseX div 8:2);
                                        end;
                                   end;
                                 until (MouseButton=0) or keypressed or (TimerTicks>t0+5);
                              end;
              until key<>#255;
       case key of
            ^A : mode:='A';
            ^B : mode:='H';
            ^C : PickCyl;
            ^D : mode:='D';
            ^E : key:=#27; {exit}
            ^F : mode:='F';
            ^H : PickHead;
            ^I : help('DISK EDITOR');
            ^P : mode:='P';
            ^T : mode:='T';
            '+': NextSector;
            '-': PreviousSector;
            ' ': Redisplay(Mode);
            #0: case ord(ReadKey) of
                     F1,23: Help('DISK EDITOR');
                     F2,48: mode:='H'; {hex=Binary}
                     F3,20: mode:='T';
                     F4: mode:='D';
                     F5,33: mode:='F';
                     F6,50,25: mode:='P';
                     F7,30: mode:='A';
                     32: PickPhysicalDisk('');
                     46: PickCyl;
                     35: PickHead;
                     31: PickSect;
                     24,3: PickOffset;
                     71: Offset:=0; {home}
                     73: if offset=0 then PreviousSector else Offset:=0;
                     79: Offset:=511; {end}
                     75: if offset=0 then begin offset:=511; PreviousSector; end
                                     else dec(offset);
                     77: begin
                         offset:=(offset+1) and 511;
                         if offset=0 then NextSector;
                         end;
                     72: begin {up}
                         offset:=offset - 32;
                         if offset<0 then begin offset:=offset and 511; PreviousSector; end;
                         end;
                     80: begin
                         offset:=offset + 32;
                         if offset>511 then begin offset:=offset and 511; NextSector; end;
                         end;
                    132: begin {Ctrl PgUp}
                         cyl:=0; head:=0; Sect:=1; offset:=0;
                         end;
                    117: begin {Ctrl End}
                         SplitCHS(PartitionsOn[Drive]^[FindPartition].LastSector,cyl,head,sect);
                         end;
                    119: begin {Ctrl End}
                         SplitCHS(PartitionsOn[Drive]^[FindPartition].FirstSector,cyl,head,sect);
                         end;
                     end;
            end;
       TurnOffMouseCursor;
       until key=#27;
window(1,2,80,25); CRT.ClrScr;
end;

procedure EditCMOS(Command : string);
begin
unimplemented;
end;

procedure PickPhysicalDisk(Command : string);
begin
st:=capitals(Command); (* !!! nextword??? *)
NeedToRead:=true;
if (st='')
   then begin
        if drive>=NumberOfDrives
			then drive:=0
			else inc(drive);
        end
   else case st[1] of
             '1'..'9' : drive:=ord(st[1])-ord('1');
             'H' : drive:=ord(st[3])-ord('A');
             'S' : drive:=ord(st[3])-ord(FirstScsiDrive);
             else ErrorMessage('I don''t understand drive: '+st);
             end;
end;
procedure WriteSector(This_CX,This_DX : word; Block :MbrType);
{var reg : registers;}
begin
NeedToRead:=true;
with pcstuff.reg do begin
            AX:=$0301; CX:=This_CX; DX:=This_DX;
            ES:=seg(Block); BX:=ofs(Block);
            intr($13,pcstuff.reg);
            if odd(flags) and (Drive<>0)
               then begin Drive:=0; exit; end;
            end;
end;

procedure UpdatePart(PartitionNumber : integer);
var PartitionTable : MbrType;
begin
with PartitionsOn[Drive and 31]^[PartitionNumber],RawEntry do
     begin
     if PartitionNumber<=4
        then ReadLong(0,PartitionTable)
        else ReadLong(PartitionsOn[Drive and 31]^[Parent].FirstSector,PartitionTable);
     move(RawEntry,PartitionTable.Partition[succ(pred(PartitionNumber) and 3)],sizeof(RawEntry));
     if true
        then WriteSector(pcstuff.reg.cx,pcstuff.reg.dx,PartitionTable);
     end;
end;

procedure ExploreExtended(ParentPartition: integer);
var ExtendedMBR : MBRtype;
    base,i : integer;
    c      : char;
    k,p    : longint;
begin
if MaxPartition>=80-4
   then begin WarningMessage('Too many partitions?'); exit; end;
with PartitionsOn[Drive and 15]^[ParentPartition],RawEntry do
     if (word(BootSector^.Signature)<>$AA55)
        then begin Faults:=Faults+'Signature not AA,55;'; exit; end
        else move(BootSector^,ExtendedMBR,sizeof(ExtendedMBR));
base:=MaxPartition;
inc(MaxPartition,4);
for i:=1 to 4 do with PartitionsOn[Drive and 15]^[base+i],RawEntry do
    begin
    move(ExtendedMBR.Partition[i],RawEntry,sizeof(RawEntry));
    Parent:=ParentPartition;
    if System<>0 then
       begin
       Cyl:=StartCyl+256*(StartSector shr 6)+1024*(StartSide shr 6);
       Head:=StartSide and 63; (* !!!? *)
       Sect:=StartSector and 63;
       FirstSector:=RelSect+PartitionsOn[Drive and 15]^[ParentPartition].FirstSector;
       k:=AbsoluteSector(cyl,head,sect);
       if FirstSector<>k
          then begin
               Faults:='Cyl/head/sect ('+decimal(k)+') doesn''t match rel. sector ('
                                        +decimal(RelSect)+'+'+decimal(FirstSector-RelSect)+')';
               if (Cyl>=1023) and (FirstSector>k)
                  then if Cyl=1023 then Faults:='cyl/head/sect limited by "Compatibility mode" for cyl>1023);'
                                   else Faults:='cyl/head/sect doesn''t make sense to me (due to >1023 cyl mapping);';
               if (RelSect<=0)
                  then begin FirstSector:=k; Faults:=Faults+' Relative Sector is crazy!'; end;
               end
          else Faults:='';
       if BootSector=nil
          then begin new(BootSector); fillchar(BootSector^,sizeof(BootSector^),0); end;
       ReadLong(FirstSector,BootSector^);
       if odd(pcstuff.reg.flags)
          then if FirstSector=k
                  then Faults:=Faults+'Error '+hex(pcstuff.reg.AX)+' reading sector;'
                  else begin
                       ReadLong(k,BootSector^);
                       if odd(pcstuff.reg.flags) then Faults:=Faults+'Both fields are wrong;'
                                         else Faults:='Relative sector is wrong;'+faults;
                       FirstSector:=k;
                       end
          else {FirstSector:=RelSect+parent's first sector};
       LastSector:=FirstSector+NumberOfSectors;
       if (System>0) and not (system in ExtendedTypes)
                        then begin
                             inc(ValidLinuxPartitions);
                             ThisLinuxName:=copy(linuxName,1,3)+Decimal(ValidLinuxPartitions);
                             end
                        else ThisLinuxName:='';
       NewDosName:='';
       Description:=PartitionTypeName(System,StartCyl,StartSide,StartSector);
       CurrentDosName[1]:=#0;
       CurrentDosName:=PresentDosName($80+Drive,StartCyl*256+StartSector,StartSide);
{
       writeln(^M,parent:3,'->',base+i:2,' type ',hex(system),' @',FirstSector,' ',chs(cyl,head,sect),
                                           RawEntry.System in ExtendedTypes:9,' ',Faults);
}
       if RawEntry.System in ExtendedTypes then
          ExploreExtended(Base+i);
       end;
    end;
end;

procedure ReadPartitionTable;
var i,j,n : integer;
    c,ThisDriveLetter : char;
begin
PrimaryDosExists:=false;
if lo(MachineID) in [$FA..$FC]
   then i:=CmosRam($12)
   else i:=0;
case drive of
     0 : if (i>=$F0) then st:=DriveType(CmosRam($19))
                       else st:=DriveType(i shr 4);
     1 : if (i and $F)=$F then st:=DriveType(CmosRam($1A))
                       else st:=DriveType(i and $F);
     else st:='SCSI?';
     end;
if pos('SCSI',st)>0
   then LinuxName:='sd'+chr(97+drive-FirstScsiDrive)
   else LinuxName:='hd'+chr(97+drive);
PrimaryDosExists:=false;
ThisDriveLetter:=LinuxName[3];
inc(ThisDriveLetter,2);
with pcstuff.reg do begin
            AX:=$0201; CX:=1; DX:=$80+Drive;
            ES:=seg(PartitionTable); BX:=ofs(PartitionTable);
            fillchar(PartitionTable,sizeof(PartitionTable),0);
            intr($13,pcstuff.reg);
            if odd(flags) and (Drive<>0)
	       then begin st:='no disk'; end;
            end;
DiskDescription:=st;
if PartitionsOn[Drive and 15]=nil
   then begin
        new(PartitionsOn[Drive and 15]);
        fillchar(PartitionsOn[Drive and 15]^,sizeof(PartitionsOn[Drive and 15]^),0);
        end;
for i:=1 to 4 do with PartitionsOn[Drive and 15]^[i],RawEntry do
    begin
    move(PartitionTable.Partition[i],RawEntry,sizeof(RawEntry));
    Cyl:=StartCyl+256*(StartSector shr 6)+1024*(StartSide shr 6);
    Head:=StartSide and 63; (* !!!? *)
    Sect:=StartSector and 63;
    FirstSector:=AbsoluteSector(cyl,head,sect);
    if FirstSector<>RelSect
       then begin
            if (Cyl>=1023) and (RelSect>FirstSector)
               then Faults:='Warning: partition beyond cyl 1023; Compatibility mode;'
               else Faults:='Cyl/head/sect doesn''t match rel. sector;'
            end
       else Faults:='';
    if BootSector=nil
       then begin new(BootSector); fillchar(BootSector^,sizeof(BootSector^),0); end;
    ReadLong(RelSect,BootSector^);
    if odd(pcstuff.reg.flags)
       then if FirstSector=RelSect
               then Faults:=Faults+'Error '+hex(pcstuff.reg.AX)+' reading sector;'
               else begin
                    ReadLong(FirstSector,BootSector^);
                    if odd(pcstuff.reg.flags) then Faults:=Faults+'Both fields are wrong;'
                                      else Faults:=Faults+'Relative sector is wrong;'
                    end
       else FirstSector:=RelSect;
    LastSector:=FirstSector+NumberOfSectors;
    ThisLinuxName:=LinuxName+decimal(i);
    Description:=PartitionTypeName(System,StartCyl,StartSide,StartSector);
    Faults:='';
    Parent:=0;
    NewDosName:='';
    CurrentDosName[1]:=#0;
    CurrentDosName:='';{PresentDosName($80+Drive,StartCyl*256+StartSector,StartSide);}
    for c:='A' to 'Z' do
    with pcstuff.reg do
       if ($80+Drive=DriveDetails[c].DL) and (pcstuff.reg.CX=DriveDetails[c].CX) and (pcstuff.reg.DH=DriveDetails[c].DH)
         then begin CurrentDosName:=c+':'; end;
    if RawEntry.System in [1,4,5,6,$50,$51,$C1,$C4,$C6,$E1]
       then begin inc(ThisDriveLetter); NewDosName:=ThisDriveLetter+':'; end
       else begin {???} end;
    end;
MaxPartition:=4;
ValidLinuxPartitions:=4;
for i:=1 to 4 do with PartitionTable,Partition[i] do
    begin
    if (System in ExtendedTypes)
       then ExploreExtended(i);
    end;
NeedToRead:=false;
end;

function PresentDosName(Drive, CX, DH : word) : string;
var i : char;
begin
for i:='A' to 'Z' do
    if (Drive=DriveDetails[i].DL) and (CX=DriveDetails[i].CX) and (DH=DriveDetails[i].DH)
         then begin PresentDosName:=i+':'; exit; end;
PresentDosName:='';
end;

function Trim(st : string) : string;
begin
while (st<>'') and (st[length(st)]=' ') do dec(st[0]);
Trim:=st;
end;

procedure PopupPartitionInfo(n : integer);
var SaveScreen : array[1..25,1..80] of word;
    SaveAttr   : word; SaveXY : word;
    i,j,k      : integer;
    blocks,
    StartOffset : longint;
    ThisDirBlock : array[1..16] of DirEntry;
    BestDir    : DirEntry;
    VFAT       : boolean;
    Directories: string[80];
    UnusedEntries: integer;
    st         : string;
    Other, Boots,
    SystemList : string;

  function Recognise(name : namestr; ext : extstr; size,time : longint) : string;
  var st,st2,date : string[80]; i : byte;
  begin
  date:=TimeString(time);
  st:=Trim(name)+'.'+ext;
  i:=21-length(st);
  if Size>999999 then begin str(size/1048576:i-2:0,st2); st2:=st2+'Mb'; end
                 else str(size:i,st2);
  Recognise:=st+' '+st2+' ('+date+')';
  end;

  type long = longint;
  type super_block = record
	      	  s_inodes_count : long;		{ Inodes count }
	      	  s_blocks_count : long;		{ Blocks count }
	      	  s_r_blocks_count : long;	{ Reserved blocks count }
	      	  s_free_blocks_count : long;	{ Free blocks count }
	      	  s_free_inodes_count : long;	{ Free inodes count }
	      	  s_first_data_block : long;	{ First Data Block }
	      	  s_log_block_size : long;	{ Block size }
      		  s_log_frag_size : long;		{ Fragment size }
	      	  s_blocks_per_group : long;	{ # Blocks per group }
	      	  s_frags_per_group : long;	{ # Fragments per group }
	      	  s_inodes_per_group : long;	{ # Inodes per group }
	      	  s_mtime : long;			{ Mount time }
	      	  s_wtime : long;			{ Write time }
	      	  s_mnt_count : word;		{ Mount count }
	      	  s_max_mnt_count : integer;	{ Maximal mount count }
	      	  s_magic : word;			{ Magic signature }
	      	  s_state : word;			{ File system state }
	      	  s_errors : word;		{ Behaviour when detecting errors }
	      	  s_pad : word;
	      	  s_lastcheck : long;		{ time of last check }
	      	  s_checkinterval : long;	{ max. time between checks }
	      	  s_creator_os : long;		{ OS }
	      	  s_rev_level : long;		{ Revision level }
	      	  s_def_resuid : word;		{ Default uid for reserved blocks }
	      	  s_def_resgid : word;		{ Default gid for reserved blocks }
	      	  s_reserved : array[0..235] of long;	{ Padding to the end of the block }
                  end;
    group_desc = record
	      	  bg_block_bitmap : long;		{ Blocks bitmap block }
	      	  bg_inode_bitmap : long;	        { Inodes bitmap block }
	      	  bg_inode_table : long;		{ Inodes table block }
	      	  bg_free_blocks_count : word;	{ Free blocks count }
	      	  bg_free_inodes_count : word;	{ Free inodes count }
	      	  bg_used_dirs_count : word;	{ Directories count }
	      	  bg_pad : word;
	      	  bg_reserved : array[0..3] of long;
                  end;
  { * Inode Structure }
    inode = record
	      	   i_mode : word;			{ File mode }
	       	   i_uid : word;			{ Owner Uid }
	       	   i_size : long;			{ Size in bytes }
	       	   i_atime : long;			{ Access time }
	       	   i_ctime : long;			{ Creation time }
	       	   i_mtime : long;			{ Modification time }
	       	   i_dtime : long;			{ Deletion Time }
	       	   i_gid : word;			{ Group Id }
	       	   i_links_count : word;		{ Links count }
	       	   i_blocks : long;		        { Blocks count }
	       	   i_flags : long;			{ File flags }
	       	   i_reserved1 : long;		{ Reserved 1 }
	      	   i_block : array[0..15] of long;{ Pointers to blocks }
	      	   i_version : long;		{ File version (for NFS) }
	      	   i_file_acl : long;		{ File ACL }
	      	   i_dir_acl : long;		{ Directory ACL }
	      	   i_faddr : long;			{ Fragment address }
	           i_frag : byte;			{ Fragment number }
	           i_fsize : byte;			{ Fragment size }
	           i_reserved2 : array[0..2] of long; { Reserved 2 }
                   end;

  const MaxPhysicalSector : integer = 63;
        PhysicalHeads   : integer = 64; {0-63}
        PhysicalCyls    : integer = 525;
        EXT2_SUPER_MAGIC = $EF53;

  procedure ShowExt2Contents(StartSector : longint);
  var reg : registers;
      PartitionTable : MbrType;
      i,j,k,p : integer;
      st      : string;
      sb      : super_block;

  function ctime(n : longint) : string;
  const DaysIn : array[1..12] of byte = (31,28,31,30,31,30,31,31,30,31,30,31);
  var DT : DateTime; days : longint;
  begin
  with DT do
       begin
       days:=n div (24*3600);
       n:=n mod (24*3600);
       sec:=n mod 60;
       min:=(n mod 3600) div 60;
       hour:=(n div 3600);
       year:=1968;
       repeat if days>366 then begin inc(year); dec(days,365); end;
              if days>365 then begin inc(year); dec(days,365); end;
              if days>365 then begin inc(year); dec(days,365); end;
              if days>365 then begin inc(year); dec(days,365); end;
              until days<366;
       month:=1;
       while days>daysin[month] do begin dec(days,DaysIn[month]); inc(month); end;
       day:=days;
       ctime:=DateTimeString(Year,month,day,hour,min,sec);
       end;
  end;

  var b : DOS_BootSector;
      o : integer;
  begin
  ReadLong(StartSector,b);
  for o:=0 to 1024 do
      begin
      ReadLong(StartSector+o,sb);
      if sb.s_magic=EXT2_SUPER_MAGIC
         then begin
              writeln('    Superblock offset: ',o:2);
              TextAttr:=LightGreen+$30;
              with sb do write  ('Inodes:           ',s_inodes_count,
	      	             ^M^J'Blocks count:     ',s_blocks_count,
	      	             ^M^J'Reserved blocks:  ',s_r_blocks_count,
	      	             ^M^J'Free blocks:      ',s_free_blocks_count,
	      	             ^M^J'Free inodes:      ',s_free_inodes_count,
	      	             ^M^J'Mount count:      ',s_mnt_count,
	      	             ^m^j'Max. mount count: ',s_max_mnt_count,
	      	             ^M^J'Magic signature:  ',hex(s_magic),
	      	             ^M^J'Filesystem state: ',s_state,
	      	             ^M^J'Error Behaviour:  ',s_errors,
	      	             ^M^J'Pad:              ',s_pad,
	      	             ^M^J'Mount time:       ',s_mtime,' = ',ctime(s_mtime),
	      	             ^M^J'Write time:       ',s_wtime,' = ',ctime(s_wtime),
	      	             ^M^J'Last check time:  ',s_lastcheck,' = ',ctime(s_lastcheck));
              window(40,11,79,22);
              with sb do writeln('Check interval:   ',s_checkinterval,
	      	             ^M^J'Creator OS:       ',s_creator_os,
	      	             ^M^J'Revision level:   ',s_rev_level,
	      	             ^M^J'Default UID:      ',s_def_resuid,
	      	             ^M^J'Default GID:      ',s_def_resgid,
                             ^M^J'First datablock:  ',s_first_data_block,
	      	             ^M^J'Block size:       ',s_log_block_size,
      		             ^M^M'Fragment size:    ',s_log_frag_size,
	      	             ^M^J'Blocks/group:     ',s_blocks_per_group,
	      	             ^M^J'Fragments/group:  ',s_frags_per_group,
	      	             ^M^J'Inodes/group:     ',s_inodes_per_group);

               exit;
              end;
      end;
  writeln('NO SUPERBLOCK :-( ');
end;

  procedure ShowFatContents;
  var i : integer;
  begin
  with PartitionsOn[Drive and 15]^[n],RawEntry,ThisBootSector,BPB do
          if Signature=#$55#$AA
             then begin
                  writeln('       55AA Signature:  ok (',st,') '+TryToString(FatWhatever));
                  TextAttr:=$35;
                  blocks:=TotalSectors;
                  if blocks=0 then blocks:=BigTotalSectors;
                  if (blocks=0) or (SectorsPerCluster=0) then exit;
                  writeln('  Size: ',blocks:7,' blocks= ',ReservedSectors,'+',NumberOfFats,'x',SectorsPerFat,
                       '+(',RootEntries,'/16)+ ',
                     (blocks-ReservedSectors-NumberOfFats*SectorsPerFAT-((15+RootEntries) div 16)) div SectorsPerCluster,
                     ' clusters of ',SectorsPerCluster,' sectors');
                  write(BytesPerSector:26,' bytes/sector; ',SectorsPerTrack:3,' sectors/track; ',
                                             NumberOfSides:3,' tracks/cyl'^M^J,
                          'Volume: ',hex2(VolumeSerial.high),'-',hex2(VolumeSerial.low));
                  write(', FormatID: ',hex(FormatID));
                  if (BootSector^.BPB.FormatID<$F0)
                     then begin writeln('  (should be F8)'); exit; end;
                  fillchar(BestDir,sizeof(BestDir),0);
                  StartOffset:=ReservedSectors+NumberOfFats*SectorsPerFat;
                  if Parent>0
                     then inc(StartOffset,FirstSector)
                     else inc(StartOffset,SpecialReserved);
                  st:=''; Boots:=''; Other:=''; SystemList:='';
                  VFAT:=false;      {$R-}
                  for i:= 59 to 510 do if (BootstrapProgram[i] in [' '..'Z'])
                           and ((BootstrapProgram[i-1] in [' '..'Z']) or (BootstrapProgram[i+1] in [' '..'Z']))
                           then Boots:=Boots+BootstrapProgram[i];
                  UnusedEntries:=0; Directories:='';
                  for i:=1 to RootEntries do
                      begin
                      if (i and 15)=1
                         then LongBlockRead(StartOffset+(i div 16),@ThisDirBlock);
                      with ThisDirBlock[succ(i and 15)] do
                       if (Name[1]=#0) or (Name[1]='') then inc(UnusedEntries) else
                           begin
                           if (byte(Attribute)=15)
                              then VFAT:=true
                              else if boolean(attribute and VolumeID) and (size=0)
                                      then st:=st+'->'+Name+ext
                                      else if size>BestDir.size
                                              then move(Name,BestDir,sizeof(BestDir));
                           if boolean(Attribute and Directory)
                              then Directories:=Directories+Name+' ';
                           if pos(Name+ext,Boots)>0
                              then SystemList:=SystemList+Recognise(Name,ext,size,time+65536*date)+^M^J'        '
                              else if(pos(Name,'COMMAND ,IBMBIO  ,IBMDOS  ,IO      ,MSDOS   ,WINBOOT ,DRVSPACE,DBLSPACE')>0)
                                      or ((size>4999999) and (Name[1]='S') and boolean(attribute and Hidden))
                                      or boolean(attribute and System)  and (attribute<>15)
                                         then begin
                                           Other:=Other+Trim(Name)+'.'+trim(ext)+', ';
                                           if size>9999999
                                              then begin
                                                   dec(Other[0],2);
                                                   Other:=Other+'('+decimal(round(size/1048576))+'Mb), ';
                                                   end;
                                           end;
                           end;
                      end;
                  if VolumeLabel[1]>' '
                     then if st='' then st:=TryToString(VolumeLabel)
                                   else if st<>VolumeLabel then st:=st+'/'+VolumeLabel
                                                           else st:='"'+st+'"';
                  with BestDir do
                   writeln(', Label: ',st:11{,^M^J' Contains: ',Trim(Name)+'.'+Ext:12,' (',(Size+1023)/1048576:5:2,'Mb) etc'});

                  write('Root Dir=',decimal(RootEntries):5,',',UnusedEntries*100.0/max(RootEntries,1):5:0,'% unused.');
                  if VFAT and (System<>$A) then writeln(' VFAT') else writeln;
                  while SystemList[length(SystemList)] in [^J..' '] do dec(SystemList[0]);
                  i:=500;
                  while (i>60) and (BootstrapProgram[i] in [#0,' ']) do dec(i);
                  writeln('System: ',SystemList);
                  if pos(#0,Other)>0 then Other:='';
                  if Other<>''
                     then begin
                          i:=68;
                          repeat dec(i) until Other[i]=',';
                          writeln(' Other: ',copy(Other,1,byte(i-1)));
                          while length(Other)>i+2 do
                                begin
                                delete(Other,1,i);
                                while (Other[1]=' ') and (Other<>'') do delete(Other,1,1);
                                i:=68;
                                repeat dec(i) until Other[i]=',';
                                writeln('        ',copy(Other,1,i));
                                end;
                          end;
                  TextAttr:=red+$30;

                  end
             else writeln('       55AA Signature:  ',hex(ord(Signature[1]))+','+hex(ord(Signature[2])),' ('+st+')');
  end;

begin
x9:=79; y9:=23;
if n=0
   then begin
        PopupWindow('Hard Disk Drive 0x'+hex($80+Drive)+' Info',true);
        IdeInfo(char(49+(Drive and 15)));
        end
   else PopupWindow('Partition '+decimal(n)+' Info',true);
write('Press any key');
Window(x0+1,y0+1,x9,y9-1);
CRT.gotoxy(1,1);
TextAttr:=$30;
if n>0 then with PartitionsOn[Drive and 15]^[n],RawEntry do
     begin
     writeln('Partition system type:  ',hex(system),' ('+PartitionType[system]+')');
     if parent=0 then if n<=4
                         then st:='none (this is a Primary Partition)'
                         else st:='(deleted partition)'
                 else begin
                      st:=decimal(parent);
                      k:=parent;
                      while (k>4) do
                            begin k:=PartitionsOn[Drive and 15]^[k].parent; st:=st+'->'+decimal(k); end;
                      if ThisLinuxName<>'' then st:=st+' ('+ThisLinuxName+')';
                      end;
     writeln('     Parent partition:  ',st);
     if BootSector=nil then new(BootSector);
     if FirstSector<0
        then ReadLong(0,BootSector^)
        else ReadLong(FirstSector,BootSector^);
     if FirstSector<0
        then writeln('This isn''t a valid partition/disk!')
        else if odd(reg.flags)
                then if FirstSector<0
                        then writeln('Error 0x',hex(reg.ax),' reading disk ',drive)
                        else writeln('Error 0x',hex(reg.ax),' reading sector: ',FirstSector);
     st:=PresentDosName($80+Drive,StartCyl*256+StartSector,StartSide);
     writeln(' Present drive letter:  ',st);
     k:=PhysicalHeads*MaxPhysicalSector;
     i:=FirstSector div k;
     j:=(FirstSector div MaxPhysicalSector) mod PhysicalHeads;
     write  ('Start (cyl,head,sect):  ',chs(StartCyl,StartSide,StartSector));
     if Parent>0 then st:='+'+decimal(PartitionsOn[Drive and 15]^[parent].Firstsector)
                 else st:='';
     if (Cyl=i)
        then writeln('= rel. sector: ',RelSect,st)
        else writeln('but rel. sect: ',RelSect,st,' -> (',i,',',j,',',succ(RelSect mod MaxPhysicalSector),')');
     writeln('  End (cyl,head,sect):  ',chs(EndCyl,EndSide,EndSector));
     writeln('    Number of Sectors:  ',NumberOfSectors,' = ',
                  round((MaxPhysicalSector+NumberOfSectors)/(PhysicalHeads*MaxPhysicalSector)),' cyl.');
     st:=PartitionTypeName(System,StartCyl,StartSide,StartSector);
     Boots:='';
     {$R-}
     hc:=BootHashcode(BootSectorPointer(BootSector));
     write('      BootID Hashcode:  ',hc);
     case MiscFlags and 6 of
          2 : write(' Stoned virus?!');
          4 : if hc[11]<>'#' then write(' Virus!')
                             else write(' non-bootable');
          6 : write(' Virus-innoculated??');
          0 : if (System in DosPartitionTypes) and not (BadFlags in [0,3])
                 then write(' You should run a virus scanner');
          end;
     writeln('');
     if (BootSector^.BPB.FormatID in [$F8])
        then ShowFatContents
        else if System=$83
                then ShowExt2Contents(FirstSector)
                else with BootSector^,BPB do
                          begin
                          writeln('             Contents: ',NonCodeBytes,' non-code bytes, ',TextBytes,' text.');
                          writeln('       Longest string:  "',LongestString,'"');
                          st:='strange?!';
                          case Hop of
                               0 : st:='zero-byte!';
                              $EB,$E9,$EA: st:='jump';
                              $FF : if skip=$26 then st:='2-byte jump?!';
                              $CD : st:='int '+hex(skip)+'h';
                              end;
                          writeln('         Initial code:  ',hex(Hop),'h (',st,')');
                          if (system and $1F)=5
                             then with MBRtype(BootSector^) do
                                  begin
                                  writeln(' Partition Table:');
                                  for i:=1 to 4 do with Partition[i] do
                                      begin
                                      case bootable of
                                           0 : st:='   ';
                                          $80: st:='Yes';
                                          else st:=hex(Bootable)+' ';
                                          end;
                                      writeln(i:2,': type=',hex(system),' boot=',st,' ',NumberOfSectors/2048:5:1,'Mb',
                                                  ' start=',RelSect:7,' cyl/h/s=',chs(StartCyl,StartSide,StartSector));
                                      end;
                                  end;
                          end;
     end;
if Readkey=#0 then if Readkey=#3 then;
window(1,1,80,25);
RestoreScreen;
TurnonMouseCursor;
end;

 procedure Highlight(part : byte);
 var i,j,row : integer;
 const previousrow : integer = 5;
 begin
 row:=pos(chr(part),RowPart);
 if row=previousrow then exit;
 i:=PreviousRow;
 for j:=23 to 25 do ScreenPointer^[3,j]:=byte(ScreenPointer^[3,j]) + $0F00;
 previousrow:=row;
 if i in [5..14]
    then for j:=1 to 2 do ScreenPointer^[i,j]:=byte(ScreenPointer^[i,j]) + $0300;
 case row of
      1..5 : for j:=23 to 25 do ScreenPointer^[3,j]:=byte(ScreenPointer^[3,j]) + $7000;
      6..13: for j:=1 to 2 do ScreenPointer^[row,j]:=byte(ScreenPointer^[row,j]) + $7000;
      else exit;
      end;
 end;

 function ProcessMouseButton : string;
 var row : integer; st : string[80];
 begin
 ProcessMouseButton:='';
 row:=succ((MouseY+7) div 8);
 if (MouseButton<>0)
   then begin
        case row of
            3 : begin
                Part:=0; Highlight(0);
                PopupPartitionInfo(0)
                end;
            4 : if (ListLogical in ListAllMode) and (ScrollOffset>0)
                           then begin dec(Part); ProcessMouseButton:=' '; Highlight(ord(RowPart[row])); end
                           else write(^G);
            14: if (ListLogical in ListAllMode) and (ScrollOffset<MaxPartition-4)
                   then begin inc(Part); ProcessMouseButton:=' '; Highlight(ord(RowPart[row])); end
                   else write(^G);
            6..13 : begin
                    Part:=ord(RowPart[row]);
                    st:=decimal(Part);
                    if Part>0 then PopupPartitionInfo(Part);
                    ProcessMouseButton:=' '+decimal(Part);
                    end;
            16..23: ProcessMouseButton:=chr(48+row-15);
             else if row=24 then ProcessMouseButton:='0';
             end;
        while (MouseButton<>0) and not keypressed
          do idle;
        end
   else if part=0 then case row of
           5,6..14: begin
                    st:=decimal(ord(RowPart[row]));
                    if st<>'0' then Highlight(ord(RowPart[row]));
                    ProcessMouseButton:='';
                    end;
             end;
 end;

function Menu(Prompt : string; MainOptions : OptionsType) : string;
var Initials : string[12]; line: string[79];
    k,colour,row,default,x1 : byte;

begin
gotoXY(1,14);
colour:=(TextAttr and 7);
if colour=0 then colour:=(TextAttr shr 4);
if colour=0 then colour:=7;
TextAttr:=colour;
ClrEOL;
gotoXY(1,15);
TurnOnMouseCursor;
TextAttr:=Yellow;
ClrEOL;writeln(Prompt); 
TextAttr:=White;
Initials:='';
default:=0;
for i:=1 to 8 do
    begin
    gotoXY(1,15+i); ClrEOL;
    st:=MainOptions[i];
    if st>'!' then
       begin
       Initials:=Initials+upcase(st[1]);
       TextAttr:=White; write(' '+chr(i+48)); TextAttr:=7; write(') ');
       if st[1] in ['a'..'z']
          then begin
               Initials[length(Initials)]:=st[2];
               write(st[1]); TextAttr:=White; write(st[2]); delete(st,1,1);
               end
          else begin TextAttr:=15; write(st[1]); end;
       if st[length(st)]='!' then begin TextAttr:=Blink+11; default:=i; end
                             else TextAttr:=7;
       writeln(copy(st,2,77));
       end;
    end;
st:=' '; st:='';
CRT.gotoXY(1,24);
ClrEOL;
repeat idle;
       cursoroff;
       gotoXY(1,24);
       if TabMode
          then begin
               if Part=0 then st:='hard disk '+decimal(Drive)+' '
                         else st:='partition '+decimal(Part)+' ';
               st[0]:=#12;
               StatusLine(' '#25#24' select partition  '#26#27' select disk  ENTER=view '+st+' TAB=menu mode');
               end
          else begin
               StatusLine('');
               Cursoroff;
               TextAttr:=Yellow;
               if MainOptions[3][1]='D'
                  then st:='Exit'
                  else st:='Return to Main Menu';
               write('  ...enter desired option (0='+st+') [',default,']'#8#8);
               x1:=whereX;
               end;
       TextAttr:=White;
       cursoron;
       st:='';
       if keypressed then begin
                          st:=upcase(ReadKey);
                          if TabMode
                             then begin
                                  case st[1] of
                                       '1'..'9' : begin
                                                  PopupPartitionInfo(ord(st[1])-ord('0'));
                                                  st:='';
                                                  end;
                                       ^M : begin
                                            PopupPartitionInfo(Part);
                                            st:='';
                                            end;
                                       #0: begin
                                           k:=ord(Readkey);
                                           case k of
                                               75 : begin
                                                    if Drive>0 then dec(Drive);
                                                    NeedToRead:=true;
                                                    end;
                                               77 : begin
                                                    inc(Drive);
                                                    NeedToRead:=true;
                                                    end;
                                               80 : inc(Part);
                                               72 : if Part>0 then dec(Part) else Part:=1;
                                               {else write(k:3);}
                                               end;
                                           st:='';
                                           end;
                                       end;
                                  Highlight(Part);
                                  end;
                          end
                     else st:=ProcessMouseButton;
       until st<>'';
TurnOffMouseCursor;
Menu:=st;
case st[1] of
     #0 : begin
          k:=ord(ReadKey);
          st:=Initials[pos(char(k),#59#60#61#62#63#64#65#66#67)];
          case k of
               75 : begin
                    if Drive>0 then dec(Drive);
                    NeedToRead:=true;
                    end;
               77 : begin
                    inc(Drive);
                    NeedtoRead:=true;
                    end;
               80 : inc(Part);
               72 : if Part>1 then dec(Part) else Part:=1;
               {else write(k:3);}
               end;
          if st<' ' then Menu:=' ' else Menu:=st[1];
          end;
     ^M : Menu:=chr(48+default);
     #9 : TabMode:=not TabMode;
     '1'..'9' : begin
                Menu:=st[1];
                st:=MainOptions[ord(st[1])-ord('0')];
                st:=copy(st,1,pos(' ',st));
                end;
    ^C,#27,'0': Menu:='0';
     else Menu:=st[1];
     end;
gotoXY(x1,24);
if st>' ' then write(st[1]);
Message('');
gotoXY(64,24);
end;


begin
end.
