/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <io.h>
#include "bootmgr.h"
#include "selemenu.h"
#include "common.h"
#include "fdisk.h"
#include "global.h"
#include "keymap.h"
#include "getobj.h"

static void  ShowOffsetAddr (sword startAddr);
static void  ShowTextByte (byte *buff, sword offset, sword color);
static void  ShowHexByte (byte *buff, sword offset, sword color);
static void  ShowHaltSector (sword sw, void *buffer);
static void  ShowHaltSectorDiff (sword sw, void *compBuffer, void *showBuffer);
static void  ShowSectorMode (dword linearSect, byte *buff, sword *sw, sword mode);

static sword EditHexByte (byte *buff, sword offset);
static sword EditTextByte (byte *buff, sword offset);
static sword EditSector (dword linearSect, byte *buff, sword sw);
static sword Save_Restore (sword offset, dword nowSect, sword nSect, sbyte *fname, sbyte flag);

/*=======================   B x s  ^ s   =====================*/
void Display_Sector (void)
{
#if ( DISPLAY == CHINESE )
    #define DUMP_PRIMARY_PARTN_AREA     "1.    D   "
    #define DUMP_PHYSICAL_SECTOR        "2.       "
#else 
    #define DUMP_PRIMARY_PARTN_AREA     "1. Display MBR Sector"
    #define DUMP_PHYSICAL_SECTOR        "2. Physical Sector"
#endif

    extern SeleMenu g_Menu;                                /** ο檫 **/
    static dword    sector = 1;
    static dword    head   = 0;
    static dword    cyl    = 0;
    static sword    sele   = 1;
    dword           linearSect;
 
    MenuBox(23, 4, 47, 7, NULL);                         /** øsΤ **/
 
    g_Menu.prompt(25, 5, DUMP_PRIMARY_PARTN_AREA, TRUE);   /** ]w椺e **/
    g_Menu.prompt(25, 6, DUMP_PHYSICAL_SECTOR,    TRUE);
 
    g_Menu.enableCtrl(M_WRAP | M_LOCK);
    g_Menu.menuColor(PAR_MENU_COLOR, LIGHT_BAR_COLOR);
    sele = g_Menu.select(sele);
 
    if ( g_Menu.lastKey() == ESC_KEY )
       return;
 
    if ( sele == 1 )
        ShowSector(0, 0, 1, HEX_DUMP);             /** ܡBxsB^sϰ **/
    else
    {
        do
        {
            if ( Input_CHS_LBA(&cyl, &head, &sector, &linearSect) == ESC_KEY )
                return;
        } while ( linearSect >= (dword)CUR_DK->lgeo.tnSector );
 
        ShowSector(cyl, head, sector, HEX_DUMP);   /** ܡBxsB^sϰ **/
    } /* end if */
} /* end Display_Sector */


/*===============================     ===============================*/
void ShowSector (dword cyl, dword head, dword sector, sword mode)
{
#if ( DISPLAY == CHINESE )
    #define EXCEED_EDIT_RANGE    " W L   d   N |   s  C"
    #define INPUT_HEX_PROMPT     "  J 16 i  XG "
    #define OVERWRITE_NUM_SECT   " g X     H "
    #define RESTORE_NUM_SECT     "  J ^ s     (0:, 1-%lu)G "
    #define RESTORE_ST_OFFSET    "  J   ^ s  } l   (0-%lu)G "
    #define SAVE_NUM_SECT        "  J  x s     (1-32767)G "
    #define PLEASE_WAIT_MSG      "    y ԡDDD"
    
    static sbyte overWritePrompt[] = "T w q o     g (y/n) H";
#else
    #define EXCEED_EDIT_RANGE    "If the edit action out of the sector range, it will terminated."
    #define INPUT_HEX_PROMPT     "Please input HEX Code: "
    #define OVERWRITE_NUM_SECT   "Please input number of sectors: "
    #define RESTORE_NUM_SECT     "Please input number of sectors (0:ALL, 1-%lu): "
    #define RESTORE_ST_OFFSET    "Please input offset of the file (0-%lu): "
    #define SAVE_NUM_SECT        "Please input number of sectors (1-32767): "
    #define PLEASE_WAIT_MSG      "Please wait a moment....."
 
    static sbyte overWritePrompt[] = "Are you sure to overwrite from this sector (y/n)? ";
#endif
    dword  sectorPerCyl, prevSect, bakSect, nowSect, endSect, nSect, fLen;
    sword  bPrevValid, offset, number, key, sw, i;
    sbyte  fname[43];
    byte   buff[512];
    FILE   *fptr;
 
    Redraw_Fdisk_Picture(TRUE);
 
    key        = 'S';
    sw         = FALSE;
    bPrevValid = FALSE;
 
    prevSect   = 0;
    nowSect    = CHS_to_Sect(cyl, head, sector, CUR_DK);       /** ҩlϰ **/
    endSect    = CHS_to_Sect(CUR_DK->lgeo.maxCyl,
                             CUR_DK->lgeo.maxHead,
                             CUR_DK->lgeo.maxSect, CUR_DK);
 
    sectorPerCyl = (CUR_DK->lgeo.maxHead + 1) * CUR_DK->lgeo.maxSect;
    
    while ( 1 )
    {
        if ( nowSect > endSect )
            nowSect = endSect;
  
        bakSect = nowSect;
        Sect_to_CHS(nowSect, &cyl, &head, &sector, CUR_DK);
  
        if ( linear_ReadWDK(nowSect, 1, buff) )
            ShowError(7);
  
        ShowSectorMode(nowSect, buff, &sw, mode);
        
        /*--------------------------------------+
        |              B z                |
        +--------------------------------------*/
        key = WaitKey();
  
        if ( IsFuncKey(key) )                 /** modify by SPF, 2001.05.20 **/
        {
            switch( key )
            {
                case HOME_KEY:
                    nowSect = 0;
                    sw = FALSE;
                    break;
               
                case END_KEY:
                    nowSect = endSect;
                    sw = ( mode == HEX_DUMP ) ? TRUE : FALSE;
                    break;
    
                case DOWN_KEY:
                    if ( sw || mode != HEX_DUMP )
                    {
                        if ( nowSect == endSect )
                            break;
                        else
                            nowSect++;
                    } /* end if */
                    
                    if ( mode == HEX_DUMP )
                       sw = !sw;
                    break;
                   
                case UP_KEY:
                    if ( sw == FALSE || mode != HEX_DUMP )
                    {
                        if ( nowSect == 0 )
                            break;
                        else
                            nowSect--;
                    } /* end if */
                    
                    if ( mode == HEX_DUMP )
                        sw = !sw;
                    break;
                     
                case LEFT_KEY:                                     /** ܺY **/
                    if ( nowSect <= CUR_DK->lgeo.maxSect )
                        nowSect = 0;
                    else
                        nowSect -= CUR_DK->lgeo.maxSect;
                    break;
               
                case RIGHT_KEY:   
                    nowSect += CUR_DK->lgeo.maxSect;
                    break;
    
                case PAGE_UP_KEY:
                    if ( nowSect <= sectorPerCyl )
                        nowSect = 0;
                    else
                        nowSect -= sectorPerCyl;
                    break;
                
                case PAGE_DOWN_KEY:
                    nowSect += sectorPerCyl;
                    break;
                   
                case F3_KEY:
                {
                    dword  linearSect;
                    
                    do
                    {
                        if ( Input_CHS_LBA(&cyl, &head, &sector, &linearSect) == ESC_KEY )
                            linearSect = nowSect;
                    } while ( cyl > CUR_DK->lgeo.maxCyl ||
                              head > CUR_DK->lgeo.maxHead ||
                              sector > CUR_DK->lgeo.maxSect ||
                              linearSect >= (dword)CUR_DK->lgeo.tnSector );
     
                    nowSect = linearSect;
                } /* end case */

                break;
            } /* end switch */
        }
        else
        {
            key = toupper(key);                /** added by SPF, 2001.05.20 **/
            
            switch( key )
            {           
                case ESC_KEY:
                    return;
             
                case BACKSPACE_KEY:
                    if ( bPrevValid )
                    {
                        nowSect    = prevSect;
                        bPrevValid = FALSE;
                    } /* end if */
                    break;
    
                case 'H':
                    if ( mode != HEX_DUMP )
                    {
                        Redraw_Fdisk_Picture(TRUE);
                        mode = HEX_DUMP;
                        sw   = FALSE;
                    } /* end if */
                    break;
             
                case 'D':
                    if ( mode != ROOT )
                    {
                        Redraw_Fdisk_Picture(TRUE);
                        sw = FALSE;
                        mode = ROOT;
                    } /* end if */
                    break;
             
                case 'B':
                    if ( mode != BOOT )
                    {
                        Redraw_Fdisk_Picture(TRUE);
                        sw = FALSE;
                        mode = BOOT;
                    } /* end if */
                    break;
    
                case 'E':
                    if ( mode != HEX_DUMP )
                    {
                        Redraw_Fdisk_Picture(TRUE);
                        sw = FALSE;
                        mode = HEX_DUMP;
                        ShowSectorMode(nowSect, buff, &sw, mode);
                    } /* end if */
                    ShowMSG(EXCEED_EDIT_RANGE);
                    sw = EditSector(nowSect, buff, sw);
                    break;
    
                case 'F':
                    ShowMSG(INPUT_HEX_PROMPT);
                    if ( GetStr((sbyte *)buff, 2, HEX_STR | ALLOW_ESC) != ESC_KEY &&
                         buff[0] != 0 )
                    {
                        ShowMSG(OVERWRITE_NUM_SECT);
                        if ( InputWORD(&number, 1, 32767, 5, ALLOW_ESC) != ESC_KEY &&
                             YN_box(IMMEDIATE_BOX, overWritePrompt) )
                        {
                            i = (sword)strtoul((sbyte *)buff, NULL, 16);
                            if ( Fill_Sector(CUR_DK, nowSect, number, i) )
                                ShowError(17);
                        }
                        else
                            Cancel_Box();
                    } /* end if */
                    ShowMSG(NULL);
                    break;
             
                case 'S':                                    /** xsP^s **/
                case 'R':
                    if ( Input_Filename(fname, 42) )
                    {
                        number = 0;
                        offset = 0;
                        if ( key == 'R' )   /** Restore to sector from file **/
                        {
                            if ( (fptr = new_fopen(fname, "rb")) == NULL )
                            {
                                ShowError(8);
                                break;
                            } /* end if */
               
                            fLen  = new_flength(fptr);  /*filelength( fileno(fptr) ) */
                            nSect = fLen / 512L;                     /* fLen / 512L; */
                            new_fclose(fptr);
               
                            if ( nSect < 1 )
                            {
                                ShowError(20);            /** פ@ϰ **/
                                break;
                            } /* end if */
                           
                            ShowMSG(RESTORE_NUM_SECT, nSect);
      
                            if ( InputWORD(&number, 0, nSect, 5, ALLOW_ESC) == ESC_KEY )
                            {
                                Cancel_Box();
                                break;
                            } /* end if*/
  
                            if ( fLen > 32767L )
                                fLen = 32767L;

                            ShowMSG(RESTORE_ST_OFFSET, fLen);
      
                            if ( InputWORD(&offset, 0, 32767, 5, ALLOW_ESC) == ESC_KEY ||
                                 !YN_box(IMMEDIATE_BOX, overWritePrompt) )
                            {
                                Cancel_Box();
                                break;
                            } /* end if*/
  
                        }
                        else
                        {
                            if ( Is_Overwrite(fname) )
                            {
                                ShowMSG(SAVE_NUM_SECT);
                                if ( InputWORD(&number, 1, 32767, 5, ALLOW_ESC) == ESC_KEY )
                                    break;
                            }
                            else
                                break;
                        } /* end if */
     
                        ShowMSG(PLEASE_WAIT_MSG);
                        i = Save_Restore(offset, nowSect, number, fname, key);
                        if ( i )
                            ShowError( (i == -1) ? 7 : 8 );
                    } /* end if */
                    break;
    
#if 0   /* new function ------------------------------------- */

                    case 'A':
                    {
                        dword sect, n;
                        dword val;
                        sword i;
                        
                        c_printf("\nstart val: ");
                        if ( InputDWORD(&val, 0, 0xFFFFFFFFL, 8, HEX_STR | ALLOW_ESC | DIRECT_ENTER) == ESC_KEY )
                            break;
                        c_printf("\nnumber sector: ");
                        if ( InputDWORD(&sect, 0, 0xFFFFFFFFL, 10, ALLOW_ESC | DIRECT_ENTER) == ESC_KEY )
                            break;
                        if ( YN_box(IMMEDIATE_BOX, overWritePrompt) )
                            for ( n = 0 ; n < sect ; n++ )
                            {
                                for ( i = 0 ; i < 512 ; i += 4, val++ )
                                    *(dword *)&buff[i] = val;
                                linear_WriteWDK(nowSect + n, 1, buff);
                            } /* end for */
                    }
                    break;
         
                case 'P':
                {
                    extern sword SeleSearchUpDown (sword *sw);
                    sword sw = 1;
                    sword i;
                    dword val;
                    dword sect, cond1, cond2;
                /*    dword stsect  = 10120950L;
                    dword endsect = 10265553L;  */
                    dword stsect  = 10241233L;
                    dword endsect = 10253393L;
                    dword maxsect = CHS_to_Sect(CUR_DK->lgeo.maxCyl,
                                                CUR_DK->lgeo.maxHead,
                                                CUR_DK->lgeo.maxSect, CUR_DK);
                
                    c_printf("start sector: ");
                    if ( InputDWORD(&sect, stsect, maxsect, 10, ALLOW_ESC | DIRECT_ENTER) == ESC_KEY )
                        break;
                    if ( sect == stsect )
                        sect = nowSect;
                /*  c_printf("end sector: ");
                    InputDWORD(&endsect, 0, maxsect, 10, 0);
                */
                    c_printf("Cond1: ");
                    if ( InputDWORD(&cond1, 0, 0xFFFFFFFFL, 8, HEX_STR | ALLOW_ESC | DIRECT_ENTER) == ESC_KEY )
                        break;
                    if ( cond1 == 0 )
                        cond1 = *(dword *)buff;
                    else if ( cond1 == 0xF6 )
                        cond1 = 0xF6F6F6F6L;
                    c_printf("Cond2: ");
                    if ( InputDWORD(&cond2, 0, 0xFFFFFFFFL, 8, HEX_STR | ALLOW_ESC | DIRECT_ENTER) == ESC_KEY )
                        break;
                    if ( cond2 == 0 )
                        cond2 = *(dword *)&buff[4];
                    else if ( cond2 == 0xF6 )
                        cond2 = 0xF6F6F6F6L;
                
                    for ( ; sect >= stsect && sect <= endsect ; sect += sw )
                    {
                        if ( ((word)sect & 0xff) == 0 )
                            c_printXY(13, 23, "%lu ", ((sw > 0) ? endsect - sect : sect - stsect) );
                
                        linear_ReadWDK(sect, 1, buff);
                
                /*        
                        for ( i = 0 ; i < 512 ; i += 4 )
                            if ( *(dword *)&buff[i] == 0x00012755L )
                                break;
                        if ( i < 512 )
                */        
                /*
                        if ( *(dword *)buff == cond1 && *(dword *)&buff[4] == cond2 )
                */        
                        if ( *(dword *)buff == 0xF6F6F6F6L && *(dword *)&buff[4] == 0xF6F6F6F6L &&
                             *(dword *)&buff[8] == 0xF6F6F6F6L && *(dword *)&buff[12] == 0xF6F6F6F6L )
                        {
                             Sect_to_CHS(sect, &cyl, &head, &sector, CUR_DK);
                             ShowSector(cyl, head, sector, HEX_DUMP);          /** ܺϰ **/
                             ShowMSG(NULL);
                             if ( SeleSearchUpDown(&sw) )
                                break;
                
                             linear_ReadWDK(sect-1, 1, buff);
                             val = *(dword *)&buff[508];
                             val++;
                             for ( i = 0 ; i < 512 ; i += 4, val++ )
                                 *(dword *)&buff[i] = val;
                             linear_WriteWDK(sect, 1, buff);
                        }
                
                        if ( c_kbhit() && (WaitKey() == ESC_KEY) )
                        {
                            if ( SeleSearchUpDown(&sw) )
                                break;
                            ShowMSG(NULL);
                            c_printXY(13, 23, "%lu ", ((sw > 0) ? endsect - sect : sect - stsect) );
                        } /* end if */
                    } /* end for */
                } /* end case */
#endif  /* 0-------------------------------------  */
  
            } /* end switch */
        } /* end if */
  
        if ( bakSect != nowSect )
        {
            bPrevValid = TRUE;
            prevSect   = bakSect;
        } /* end if */
  
        ClrKeyBuffer();                                 /** M Buffers **/
    } /* end while */
} /* end ShowSector */


/*==========================         =========================*/
static void ShowSectorMode (dword linearSect, byte *buff, sword *sw, sword mode)
{
    #if ( DISPLAY == CHINESE )
        #define PROMPT_KEY_1   "[E]:sA [F]:񺡡A [S]:sɡA [R]:ɮצ^sثeϰϡA [H/B/D]:"
        #define PROMPT_KEY_2   "[][]:ϰ  [][]:Y  [PgUp][PgDn]:ϬW  [F3]:wϰ"
        #define DISK_PARA_FMT  "ϭy:%04lu  Y:%03lu  ϰ:%02lu,  uʺϰ:(%08lXh) %-10lu"
    #else
        #define PROMPT_KEY_1   "[E]:Edit, [F]:Fill, [S]:Save to file, [R]:Restore from file, [H/B/D]:Switch"
        #define PROMPT_KEY_2   "[][]:Sector  [<-][->]:Head  [PgUp][PgDn]:Cyl  [F3]:Jump Sector"
        #define DISK_PARA_FMT  "Cyl:%04lu  Head:%03lu  Sector:%02lu,  LBA Sector:(%08lXh) %-10lu"
    #endif

    static sbyte diskParaFmt[] = DISK_PARA_FMT;
    dword  cyl, side, sector;

    Sect_to_CHS(linearSect, &cyl, &side, &sector, CUR_DK);

    if ( mode == ROOT || mode == BOOT )
    {
        if ( mode == ROOT )
            ShowDIR(buff);
        else
            ShowBootRecord(buff);
        *sw = FALSE;
        ShowMSG(diskParaFmt, cyl, side, sector, linearSect, linearSect);
    }
    else
    {
        ShowHaltSector(*sw, buff);             /** ܺϰϪebqΫbq **/
        c_textattr(MESSAGE_COLOR);
        c_printXY(3, 20, diskParaFmt, cyl, side, sector, linearSect, linearSect);

        c_textattr(BOX_LINE_COLOR);
        Clr_Block(3, 20, 77, 20);
        c_printXY(3, 21, PROMPT_KEY_1);   /**  E,F,S,R,H,B,D i **/
        c_textattr(DEFAULT_COLOR);
        ShowMSG(PROMPT_KEY_2);                         /** ܤV䪺Nq **/
    } /* end if */

    c_gotoxy(78, 23);
} /* end ShowSectorMode */


/*=============================== s    ===============================*/
static sword EditSector (dword linearSect, byte *buff, sword sw)
{
    #if ( DISPLAY == CHINESE )
        #define OUT_OF_RANGE_MSG     "WLϰϽdAs I"
        #define DO_YOU_WANT_TO_SAVE  "O _ n x s   H"
        #define PROMPT_FUNC_KEY      "[][][][]:ܡA"       \
                                     "[s-Tab]/[Tab]:A"    \
                                     "[F3]:sϡA"           \
                                     "[ESC]:s"
    #else
        #define OUT_OF_RANGE_MSG     "Out of sector range. The edit action\nterminated!"
        #define DO_YOU_WANT_TO_SAVE  "Do you want to save change ?"
        #define PROMPT_FUNC_KEY      "[][][<-][->]:sele, "        \
                                     "[s-Tab]/[Tab]:switch_field, " \
                                     "[F3]:switch_area, "           \
                                     "[ESC]:quit"
    #endif
    
    enum   { HEX_AREA, TEXT_AREA }  editArea;
    sword  color, key, ndx;
    byte   tmp[512];
 
    editArea = HEX_AREA;                            /** w]sϬ Hex  **/
 
    key = 0;
    ndx = ( sw ) ? 256 : 0;
    CopyMem(tmp, buff, 512);

    c_textattr(BOX_LINE_COLOR);
    Clr_Block(3, 20, 77, 20);
    c_printXY(3, 21, PROMPT_FUNC_KEY);
    c_textattr(DEFAULT_COLOR);

    while ( key != ESC_KEY && ndx >= 0 && ndx < 512 )
    {
        if ( ndx < 256 && sw )
        {
            sw = FALSE;
            ShowHaltSectorDiff(sw, buff, tmp);
        }
        else if ( ndx >= 256 && !sw )
        {
            sw = TRUE;
            ShowHaltSectorDiff(sw, buff, tmp);
        } /* end if */

        /*----- edit a byte -----*/
        if ( editArea == HEX_AREA )
            key = EditHexByte(tmp, ndx);
        else
            key = EditTextByte(tmp, ndx);

        /*----- show modified -----*/
        color = ( tmp[ndx] != buff[ndx] ) ? UPDATE_COLOR : 0;

        ShowHexByte(tmp, ndx, color);
        ShowTextByte(tmp, ndx, color);

        switch ( key )
        {
            case ESC_KEY:
                break;
            case F3_KEY:                                    /* s */
                editArea = ( editArea == HEX_AREA ) ? TEXT_AREA : HEX_AREA;
                break;
            case UP_KEY:
                ndx -= 16;
                break;
            case DOWN_KEY:
                ndx += 16;
                break;
            case S_TAB_KEY:
            case LEFT_KEY:
                ndx--;
                break;
            case TAB_KEY:
            case RIGHT_KEY:
            case ENTER_KEY:
                ndx++;
                break;
            default:
                break;
        } /* end switch */
    } /* end while */


    /*-----------------------------
     * if tmp[] data be modified
     *----------------------------*/
    if ( CompMEM(tmp, buff, 512) )
    {
        if ( YN_box(IMMEDIATE_BOX, DO_YOU_WANT_TO_SAVE) )
        {
            if ( linear_WriteWDK(linearSect, 1, tmp) )     /** xsu@ **/
                ShowError(17);
            else
                CopyMem(buff, tmp, 512);
        } /* end if */
    }
    else if ( (key != ESC_KEY) && (key != F2_KEY) )
    {
         Talk_Msg_Box(OUT_OF_RANGE_MSG, NULL);
    } /* end if */

    return( sw );                
} /* end editSector */


/*==============================    }  =============================*/
static void ShowOffsetAddr (sword startAddr)
{
    sword  y;
 
    for ( y = 4 ; y < 20 ; y++, startAddr += 16 )
        c_printXY(3, y, "%03X(%03d):", startAddr, startAddr);
} /* end ShowOffsetAddr */


/*======================= s  @  Text   byte =======================*/
static sword EditTextByte (byte *buff, sword offset)
{
    extern GETOBJ g_GetObj;
    sbyte  str[2];
    sword  x, y;

    x = (offset & 15) + 62;                         /** (ndx % 16) + 62     **/
    y = ((offset >> 4) & 15) + 4;                   /** (ndx / 16) % 16 + 4 **/
    str[0] = buff[offset];
    str[1] = 0;

    /*
     * s誫ݩʳ]w, NqаѦ getobj.h
     */
    g_GetObj.enableCtrl( G_ALLOW | G_AUTOENTER | G_ALLOWLEAVE | G_CUR_RESET );
    g_GetObj.disableCtrl( G_WRAP | G_USETAB | G_LOCK | G_CURMEM );


    /*
     * @ӥNrJ
     */
    g_GetObj.s_get(x, y, NULL, 1, str, NULL);
    g_GetObj.edit(1);

    buff[offset] = *str;
    return( g_GetObj.lastkey() );
} /* end EditTextByte */


/*======================== s  @  Hex   byte =======================*/
static sword EditHexByte (byte *buff, sword offset)
{
    extern GETOBJ g_GetObj;
    sbyte  str[3];
    sword  x, y;

    x = ((offset & 15) * 3) + 13;                       /** (ndx % 16)      **/
    y = ((offset >> 4) & 15) + 4;                       /** (ndx / 16) % 16 **/
    sprintf(str, "%02X", buff[offset]);

    /*
     * s誫ݩʳ]w, NqаѦ getobj.h
     */
    g_GetObj.enableCtrl( G_ALLOW | G_AUTOENTER | G_ALLOWLEAVE | G_CUR_RESET );
    g_GetObj.disableCtrl( G_WRAP | G_USETAB | G_LOCK | G_CURMEM );

    /*
     *  16 iƥBtpIJ
     */
    g_GetObj.s_get(x, y, NULL, 2, str, "HH");
    g_GetObj.edit(1);

    /*
     * N 16 iƦrରƭ
     */
    x = 0;
    for ( y = 0 ; y < 2 ; y++ )
    {
        if ( !isxdigit(str[y]) )
            break;
        str[y] = toupper(str[y]);
        x = (x << 4) + ((str[y] >= 'A') ? str[y] - 'A' + 10 : str[y] - '0'); 
    } /* end for */

    buff[offset] = x;
    return( g_GetObj.lastkey() );
} /* end EditHexByte */


/*=============================   @  byte ============================*/
static void ShowHexByte (byte *buff, sword offset, sword color)
{
    sword  x, y;

    x = ((offset & 15) * 3) + 13;                       /** (ndx % 16)      **/
    y = ((offset >> 4) & 15) + 4;                       /** (ndx / 16) % 16 **/
    if ( color )
        c_textattr(color);
    c_printXY(x, y, "%02X", buff[offset]);
    if ( color )
        c_textattr(DEFAULT_COLOR);
} /* end ShowHexByte */


/*=============================   @  byte ============================*/
static void ShowTextByte (byte *buff, sword offset, sword color)
{
    sword  x, y;

    x = (offset & 15) + 62;                         /** (ndx % 16) + 62     **/
    y = ((offset >> 4) & 15) + 4;                   /** (ndx / 16) % 16 + 4 **/
    c_gotoxy(x, y);
    if ( color )
        c_textattr(color);
    ShowRangeStr(32, 254, &buff[offset], 1, NULL);       /** uܥir **/
    if ( color )
        c_textattr(DEFAULT_COLOR);
} /* end ShowTextByte */


/*============================   b    ============================*/
/*           sw  0 hܫebqϰϡA buffer ܪϰϸ            */
/*===========================================================================*/
static void ShowHaltSectorDiff (sword sw, void *compBuffer, void *showBuffer)
{
    byte   *cmpBuff = (byte *)compBuffer;
    byte   *shwBuff = (byte *)showBuffer;
    sword  base = ( sw ) ? 0x100 : 0;
    sword  offset, count, color;
 
    ShowOffsetAddr(base);
    for ( count = 0 ; count < 256 ; count += 16,  base += 16 )
    {
        for ( offset = 0 ; offset < 16 ; offset++ )
        {
            color = (cmpBuff[base+offset] != shwBuff[base+offset]) ? UPDATE_COLOR : DEFAULT_COLOR;
            ShowHexByte(showBuffer, base + offset, color);
        } /* end for */
 
        c_printf(" |");
        for ( offset = 0 ; offset < 16 ; offset++ )
        {
            color = (cmpBuff[base+offset] != shwBuff[base+offset]) ? UPDATE_COLOR : DEFAULT_COLOR;
            ShowTextByte(showBuffer, base+offset, 0);
        } /* end for */
        
        c_putch(' ');
    } /* end for */
} /* end ShowHaltSectorDiff */


/*============================   b    ============================*/
/*           sw  0 hܫebqϰϡA buffer ܪϰϸ            */
/*===========================================================================*/
static void ShowHaltSector (sword sw, void *buffer)
{
    byte   *buff = (byte *)buffer;
    sword  base  = ( sw ) ? 0x100 : 0;
    sword  offset, count;
 
    ShowOffsetAddr(base);
    for ( count = 0 ; count < 256 ; count += 16,  base += 16 )
    {
        for ( offset = 0 ; offset < 8 ; offset++ )
            ShowHexByte(buff, base + offset, 0);
        c_putch('-');
        for ( ; offset < 16 ; offset++ )
            ShowHexByte(buff, base + offset, 0);
        c_printf(" |");
        for ( offset = 0 ; offset < 16 ; offset++ )
            ShowTextByte(buff, base+offset, 0);
        c_putch(' ');
    } /* end for */
} /* end ShowHaltSector */


/*========================== x s  ^ s   ===========================*/
static sword Save_Restore (sword offset, dword nowSect, sword nSect, sbyte *fname, sbyte flag)
{
    sword  count, error;
    dword  endSect;
    sbyte  buff[512], *attr;
    FILE   *fptr;
 
    attr  = ( flag == 'S' ) ? "wb" : "rb";
    fptr  = new_fopen(fname, attr);
    error = ( fptr == NULL ) ? -2 : 0;                        /** }ɥѡI**/
 
    if ( (flag == 'R') && (offset > 0) )
        new_fseek(fptr, offset, SEEK_SET);
 
    if ( error == 0 )
    {
        count   = 0;
        endSect = CHS_to_Sect(CUR_DK->lgeo.maxCyl,
                              CUR_DK->lgeo.maxHead,
                              CUR_DK->lgeo.maxSect, CUR_DK);
  
        for ( ; nowSect <= endSect ; nowSect++ )
        {
            if ( flag == 'R' )                               /** ^sw **/
            {
                if ( nSect && (++count > nSect) )
                    break;
                
                if ( new_fread(buff, 1, 512, fptr) < 512 )
                    break;
                
                if ( linear_WriteWDK(nowSect, 1, buff) )
                {
                    error = -1;
                    break;
                } /* end if */
            }
            else                                                   /** xs **/
            {        
                if ( linear_ReadWDK(nowSect, 1, buff) )
                    error = -1;
    
                if ( ++count > nSect )
                    break;
             
                if ( new_fwrite(buff, 1, 512, fptr) < 512 )  /** xsɮ **/
                {
                    error = -3;
                    break;
                } /* end if */
            } /* end if */
        } /* end for */
    } /* end if */
 
    new_fclose(fptr);
    if ( error == -3 )
        new_unlink( fname );
 
    return( error );
} /* end Save_Restore */
