/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <conio.h>
#include "fdisk.h"
#include "selemenu.h"
#include "output.h"
#include "global.h"
#include "keymap.h"

static void Find_Partn_Object (PARTN *partnArr);
         
/*-------------------------- B z }    ------------------------------*/
/*      Partn == NULL h   j MA _ h M   l }            */
/*---------------------------------------------------------------------------*/
void Process_Partn_Object (PARTN *partnArr)
{
    #if ( DISPLAY == CHINESE )
        #define SURE_TO_REMOVE_REMAINDER_PARTN   "T w n    l }   H"
        #define SURE_TO_RELOAD_LOGIC_PARTN       "T w n  s  J    ΡH"
        static sbyte *menu[] =
        {
            "1.   j  M  }      ",
            "2.   M      l    ",
            "3.             "
        };
    #else
        #define SURE_TO_REMOVE_REMAINDER_PARTN   "Are you sure to clear remainder OBJ?"
        #define SURE_TO_RELOAD_LOGIC_PARTN       "Are you sure to reload logic parti-\ntion?"
        static sbyte *menu[] =
        {
            "1.  Search Boot Object",
            "2.  Clear Remainder Object",
            "3.  Reload logic partition"
        };
    #endif

    extern SeleMenu g_Menu;
    sword  sele, i;
 
    MenuBox(23, 10, 54, 14, NULL);                       /** øsΤ **/
    for ( i = 0 ; i < sizeof(menu) / sizeof(sbyte *) ; i++ )   /** ]w **/
        g_Menu.prompt(25, i + 11, menu[i], TRUE);
 
    g_Menu.enableCtrl(M_WRAP | M_LOCK);
    g_Menu.menuColor(PAR_MENU_COLOR, LIGHT_BAR_COLOR);
    sele = g_Menu.select(1);
    
    if ( sele == 1 )
    {
        Find_Partn_Object(NULL);
    }
    else if ( sele == 2 )
    {
        if ( IsUpdatePartn() ||             /** Y partition ʥB|xs **/
             !YN_box(IMMEDIATE_BOX, SURE_TO_REMOVE_REMAINDER_PARTN) )
            Cancel_Box();
        else
            Find_Partn_Object(partnArr);                       /** iM **/
    }
    else if ( sele == 3 )
    {
        if ( g_Info.fd.ext_head == -1 )
            ShowError(11);
        else if ( YN_box(TALK_BOX, SURE_TO_RELOAD_LOGIC_PARTN) )
            ReloadLogicPartn(partnArr);                /** sJ޿ **/
        else
            Cancel_Box();
    } /* end if */
} /* Process_Partn_Object */


/*-------------------------- j M }    ------------------------------*/
/*      partnArr == NULL h   j MA _ h M   l }         */
/*---------------------------------------------------------------------------*/
static void Find_Partn_Object (PARTN *partnArr)
{
    #define PROMPT_KEY_NDX      0
    #define PAUSE_MSG_NDX       1
    #define EVERY_SIDE_NDX      2
    #define SAVE_FILE_NDX       3
    #define TITLE_MSG_NDX       4
    #define OTHER_MSG_NDX       5
    #define PARTN_NOTE_NDX      6
    #define BOOT_NOTE_NDX       7
    #define PRI_PARTN_NDX       8
    #define LOG_PARTN_NDX       9
    #define SEARCH_DONE_NDX    10
    
    #if ( DISPLAY == CHINESE )
        #define DELETED_MSG     "swRs"
        #define DELETE_FAILED   "sRѡs"
        #define USER_INTERRUPT  "* ϥΪ̤_ *"
        #define LINE_LENGHT     50

        static sbyte *msg[] =
        {
            "bjMæΪϰϡA [Esc]:A[Enter]:ȰDDD", 
            " I   N  ~ DDD",
            "O _ j M  W  C @   H",
            "O _ N  G s  H",
            "ϬWm   Y    %16s",
            "䥦T",
            "Ϊ   => [ ",
            "Ұʺϰ => [ ",
            "Dn",
            "޿",
            "j M   I"
        };
    #else
        #define DELETED_MSG     "* Deleted *"
        #define DELETE_FAILED   "* Delete failure *"
        #define USER_INTERRUPT  "* User Interrupt *"
        #define LINE_LENGHT     60
     
        static sbyte *msg[] =
        {
            "It's searching Partition Object, [Esc]:Stop, [Enter]:Pause", 
            "PAUSE !  Press any key to continue....",
            "Do you want to search every side ?",
            "Do you want to save result to file ?",
            "Cylinder   Head    Type%29s",
            "Other Information",
            "Partition Table => [ ",
            "Boot Sector     => [ ",
            "Primary",
            "Logic",
            "Search Done !"
        };
    #endif /* !CHINESE */

    dword  endSide, side, cyl;
    sword  line, key, i;
    sbyte  buff[512];
    FILE   *fptr = NULL;
 
    if ( !partnArr && YN_box(TALK_BOX, msg[SAVE_FILE_NDX]) )
    {
        if ( !Input_Filename(buff, 42) || !Is_Overwrite(buff) )
        {
            Cancel_Box();
            return;
        } /* end if */

        if ( (fptr = new_fopen(buff, "w")) == NULL )
        {
            ShowError(8);
            return;
        } /* end if */
    } /* end if */

    endSide = ( YN_box(TALK_BOX, msg[EVERY_SIDE_NDX]) ) ? CUR_DK->lgeo.maxHead : 2;

    Redraw_Fdisk_Picture(TRUE);
    c_printXY(7, 4, msg[TITLE_MSG_NDX], msg[OTHER_MSG_NDX]);
    c_gotoxy(3, 5);

    Repeat_Char('-', LINE_LENGHT);
    i = LINE_LENGHT;

    /** write to file **/
    if ( fptr )
    {
        new_fprintf(fptr, "\nnHD(%d),  CHS(%lu, %lu, %lu),  Work_H.D(%d)\n\n",
                          g_Info.nHD,
                          CUR_DK->lgeo.maxCyl + 1,
                          CUR_DK->lgeo.maxHead + 1,
                          CUR_DK->lgeo.maxSect, CUR_DK->diskNO - 0x7f);

        new_fprintf(fptr, msg[TITLE_MSG_NDX], msg[OTHER_MSG_NDX]);
        new_fputc('\n', fptr);
        for ( ; i > 0 ; i-- )
            new_fputc('-', fptr);
        new_fputc('\n', fptr);
    } /* end if */

    ShowMSG(msg[PROMPT_KEY_NDX]);
 
    key  = 0;
    line = 6;
    for ( cyl = 0 ; cyl <= CUR_DK->lgeo.maxCyl ; cyl++ )
    {
        for ( side = 0 ; side <= endSide ; side++ )
        {
            c_printXY(9, line, "%4ld --- %3ld --- ", cyl, side);
   
            if ( c_kbhit() )
            {
                key = WaitKey();
                if ( key == ESC_KEY )
                {
                    cyl = CUR_DK->lgeo.maxCyl + 1;
                    User_Interrupt_Box();                 /** ܨϥΪ̤_ **/
                    break;
                }
                else if ( key == ENTER_KEY )
                {
                    if ( fptr )
                        new_fflush(fptr);
                    ShowMSG(msg[PAUSE_MSG_NDX]);                   /** Ȱ **/
                    WaitKey();
                    ShowMSG(msg[PROMPT_KEY_NDX]);
                } /* end if */
            } /* end if */
   
            chs_ReadWDK(side, cyl, 1, 1, buff);
   
            /*-------------------------------+
            |        pGΪSx        |
            +-------------------------------*/
            if ( *(word *)&buff[0x1fe] == 0xaa55 )
            {
                /*
                 * ˬdO_ثeO餤ҫإߪ
                 */
                if ( partnArr )
                {
                    for ( i = 0 ; i < g_Info.fd.used ; i++ )
                        if ( partnArr[i].stCyl == cyl )
                            break;
                    if ( (cyl == 0) || (i < g_Info.fd.used) )     /** pGO **/
                        continue;
                } /* end if */

                if ( fptr )
                    new_fprintf(fptr, "%4ld --- %3ld --- ", cyl, side);

                if ( (!cyl && !side) || IsLikeExtPartn(buff) )
                {
                    c_printf(msg[PARTN_NOTE_NDX]);
                    c_textattr(BOOT_DEF_COLOR);
                    c_printf( (cyl == 0) ? msg[PRI_PARTN_NDX] : msg[LOG_PARTN_NDX] );
                    c_textattr(DEFAULT_COLOR);
                    if ( fptr )
                        new_fprintf(fptr, "%s%s", 
                                msg[PARTN_NOTE_NDX], 
                                ((cyl == 0) ? msg[PRI_PARTN_NDX] : msg[LOG_PARTN_NDX]));
                }
                else
                {
                    c_printf(msg[BOOT_NOTE_NDX]);
                    ShowRangeStr(32, 128, buff+3, 8, NULL); /** u 32-128 r **/
                    if ( fptr )
                    {
                        new_fprintf(fptr, msg[BOOT_NOTE_NDX]);
                        ShowRangeStr(32, 128, buff+3, 8, fptr);
                    } /* end if */
                } /* end if */
          
                c_printf(" ]");
                if ( fptr )
                    new_fprintf(fptr, " ]\n");
    
                if ( partnArr )
                {
                    *(word *)&buff[0x1fe] = 0;
                    c_gotoxy(53, line);
     
                    if ( chs_WriteWDK(side, cyl, 1, 1, buff) == 0 )
                        c_printf(DELETED_MSG);
                    else
                        c_printf(DELETE_FAILED);
                } /* end if */
          
                if ( ++line >= 22 )
                {
                    line = 21;
                    scroll_up(2, 5, 75, 20, 1);
                    /* c_movetext(3, 7, 76, 21, 3, 6); */ /** d򤺵eW@C **/
                } /* end if */
            } /* end if */
        } /* end for side */
    } /* end cyl */

    if ( fptr )
    {
        new_fprintf(fptr, "\n%s\n",
                      ((key != ESC_KEY) ? msg[SEARCH_DONE_NDX] : USER_INTERRUPT));
        new_fclose(fptr);
    } /* end if */
 
    c_printXY(9, line, "%16c", ' ');
 
    if ( key != ESC_KEY )
    {
        ShowMSG(msg[SEARCH_DONE_NDX]);
        WaitKey();
    } /* end if */
} /* end Find_Partn_Object */


/*========================== Reload logic partiiton =========================*/
void ReloadLogicPartn (PARTN *partnArr)
{
    sword  ext, err;
 
    if ( g_Info.fd.ext_head != -1 )
    {
        g_Info.fd.maxParNO    = 4;
        g_Info.fd.used        = g_Info.fd.pri_use;
        g_Info.fd.logic_exist = FALSE;
     
        Remove_unused_partn(partnArr);
        ext = Find_EXT(partnArr);                /** oXRΪ}C **/
        err = Get_Logic_Partn(partnArr, partnArr + ext);
  
        if ( g_Info.fd.used == g_Info.fd.pri_use )
            ShowError(29);
     /* else if ( partnArr[g_Info.fd.used-1].end > partnArr[ext].end ||
                  partnArr[g_Info.fd.used-1].start > partnArr[ext].end )
            g_Info.fd.ext_end = partnArr[ext].end = partnArr[g_Info.fd.used-1].end;
     */

        if ( Find_Problem(partnArr) )          /** ˬdΪL|ο~ **/
            err |= PARTN_OVERLAP;
  
        if ( err & PARTN_OVERLAP_OR_TOO_MUCH )
            g_Info.fd.canSaveFlag = FALSE;
  
        if ( err )                                     /** sŪ޿ **/
            Disk_Err_Msg(err);
  
        Find_space(partnArr);                          /** Mtm϶ **/
        g_Info.fd.modified = 1;
    } /* end if */         
} /* end ReloadLogicPartn */

