/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include "fdisk.h"
#include "common.h"
#include "selemenu.h"
#include "global.h"
#include "keymap.h"

void Exchange_partn (PARTN *partnArr, sword ndx)
{
    #if ( DISPLAY == CHINESE )
        #define WARNING_MSG    "mΩxsɷ|MIAzTwniH"
        #define TARGET_PARTN   "s  %d    M       H"
    #else 
        #define WARNING_MSG    "This partition is danger if exchagne\nit, are you sure to continue ?"
        #define TARGET_PARTN   "Which one do you want to swap with No. %d partition ?"
    #endif
 
    extern SeleMenu  g_Menu;
    sword  ndx1, i;
    PARTN  *ptr;
 
    i    = 0;
    ndx1 = ndx;
    do
    {
        ptr = &partnArr[ndx1];
        if ( (ptr->no == 5) &&
             (ptr->stCyl == g_Info.fd.ext_head) && (ptr->side < 2) )
        {
            if ( IsLegalBootSect(ptr) )            /** O_ĪҰʺϰ **/
                if ( !YN_box(TALK_BOX, WARNING_MSG) )
                    return;
        } /* end if */
  
        if ( ++i == 1 )
        {
            Redraw_Fdisk_Picture(TRUE);
            ShowMSG(TARGET_PARTN, ptr->no);
   
            /*===============================================*/
            /*  ܤΡA Just_primary  Just_logic 禡 */
            /*              PartnMnu.C                 */
            /*===============================================*/
            ndx1 = Sele_Partn(partnArr, 0, 0,
                              ((ptr->no < 5) ? Just_primary : Just_logic));

            ndx1--;
            if ( g_Menu.lastKey() == ESC_KEY )
            {
                 Cancel_Box();
                 return;
            } /* end if */
        } /* end if */
    } while ( i < 2 );
 
    if ( ndx1 != ndx )
    {
        i = ptr->no;
        ptr->no = partnArr[ndx].no;
        partnArr[ndx].no = i;
    } /* end if */
 
    if ( g_Info.fd.modified <= 0 )                               /** ʰO **/
        g_Info.fd.modified = -1;
} /* end Exchange_partn */

