/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include "common.h"
#include "output.h"
#include "global.h"

#define GS_BUFFER_LEN   160

static sbyte gs_buff[GS_BUFFER_LEN + 1];

/*---------------------------------------------------------------------------*/
void Init_Screen (void)
{
    #if ( DISPLAY == TEXTMODE )
        IntoTextMode();
    #else
        #if ( DISPLAY == CHINESE )
            SortFont(g_Font, g_nFont);
            SortFont(bm_Font, bm_nFont);
        #endif

        IntoGraphicMode();                                 /** iJøϼҦ **/ 

        /*------------------------------------------------+
        | ѦYis c_printf.... c_ tCܨ禡 |
        +------------------------------------------------*/
    #endif

    Ctrl_Cursor(FALSE);                                        /** ô **/
} /* end Init_Screen */


/*---------------------------------------------------------------------------*/
void End_Screen (void)
{
    #if ( DISPLAY == TEXTMODE )
        Ctrl_Cursor(TRUE);                                     /** ô **/
    #else
        if ( g_CurPos.graphicMode )
            IntoTextMode();                         /** return to text mode **/
    #endif
} /* end End_Screen */


/*---------------------------------------------------------------------------*/
/*                Sort Font Data use selection sort algorithm                */
/*---------------------------------------------------------------------------*/
#if ( DISPLAY == CHINESE )

/*---------- compare Font key function ------------*/
sword FontComp (const void *elem1, const void *elem2)
{
    const FONT *f1 = (const FONT *)elem1;
    const FONT *f2 = (const FONT *)elem2;

    return( (*(word *)f1->key < *(word *)f2->key) ? -1 :
            (*(word *)f1->key > *(word *)f2->key) ?  1 : 0 );
} /* end FontComp */


/*---------- sort Font array function -------------*/
void SortFont (FONT *pFont, sword n)
{
    Select_Sort(pFont, n, sizeof(FONT), FontComp);
} /* end SortFont */

#endif  /* end CHINESE */

     
/*---------------------------------------------------------------------------*/
sword GetColor (void)
{
    return( (sword)g_CurPos.color & 0x00FF );
} /* end GetColor */


/*--------------------------     r  ------------------------------*/
void Repeat_Str (const sbyte *str, sword len)
{
    sword  i;
 
    for ( i = 0 ; i < len ; i++ )
        #if ( DISPLAY == TEXTMODE )
            cprintf( str );
        #else
            ColorStr( str );
        #endif
} /* end Repeat_Str */


/*---------------------------- Set cursor location ---------------------------+
|    x = 1 - 80,   y = 1 - 25                                                 |
+----------------------------------------------------------------------------*/
void c_gotoxy (sword x, sword y)
{
    #if ( DISPLAY == TEXTMODE )
        gotoxy(x, y);
    #else
        SetXY(x - 1, y - 1);
    #endif
} /* end c_gotoxy */


/*---------------------------------------------------------------------------*/
void c_clrscr (void)
{
    #if ( DISPLAY == TEXTMODE )
        clrscr();
    #else
        Clr_Block(0, 0, 79, 24);
    #endif
} /* end c_clrscr */


/*---------------------------------------------------------------------------*/
void c_clreol (void)
{
    #if ( DISPLAY == TEXTMODE )
        clreol();                                              /** C function **/
    #else 
        sword  x, y;
  
        GetXY(&x, &y);
        Clr_Block(x, y, 79, y);
    #endif
} /* end c_clreol */


/*---------------------------------------------------------------------------*/
void c_textattr (sword color)
{
   #if ( DISPLAY == TEXTMODE )
       textattr( color );                                    /** C function **/
       g_CurPos.color = (byte)color;
   #else
       SetColor( color );
   #endif
} /* end c_textattr */


/*-----------------  o  e    b  m  C    ------------*/
word c_getattr (void)
{
    #if ( DISPLAY == TEXTMODE )
        return( GetCurTextAttr() );
    #else
        return( g_TextArea[g_CurPos.y][g_CurPos.x] );
    #endif
} /* end c_getattr */


/*---------------------------------------------------------------------------*/
void c_putch (sbyte chr)
{
    #if ( DISPLAY == TEXTMODE )
        putch(chr);                                          /** C function **/
    #else
        ColorChar(chr);
    #endif

} /* end c_putch */


/*---------------------------------------------------------------------------*/
void c_vprintf (const sbyte *form, va_list list)
{
    sword  len;

    #if SPF_DEBUG
        sbyte  bugMsg[] = "c_printf() found a bug\n"
                          "Please press ctrl-c to terminate";
         
        if ( strlen(form) > GS_BUFFER_LEN )
             Bug_Msg_Box(bugMsg, NULL);
        gs_buff[GS_BUFFER_LEN] = 0;
    #endif
 
    len = vsprintf(gs_buff, form, list);
 
    #if SPF_DEBUG
        if ( (len > GS_BUFFER_LEN) || (gs_buff[GS_BUFFER_LEN] != 0) )
            Bug_Msg_Box(bugMsg, NULL);
    #endif
 
    #if MSDOS
        #if ( DISPLAY == TEXTMODE )
        {
            if ( len == 1 )
            {
                if ( *gs_buff == '\n' )
                    putch('\r');
                putch(*gs_buff);
            }
            else
            {
                sbyte  *ptr;
                sbyte  *line;

                /* cprintf(...) can't transfer <LF> to <CR><LF>, so I must do it */
                for ( ptr = gs_buff ; *ptr ; ptr = line )
                {
                    for ( line = ptr ; *line && *line != '\n' ; line++ );
                    cprintf(((*line) ? "%.*s\r\n" : "%.*s"), line - ptr, ptr);
                    if ( *line )
                        line++;
                } /* end for */
            } /* end if */
        }
        #else
            ColorStr(gs_buff);
        #endif
    #else
        printf(gs_buff);
    #endif       

} /* end c_vprintf */


/*---------------------------------------------------------------------------*/
void c_printXY (sword x, sword y, const sbyte *form, ...)
{
    va_list  va_ptr;
 
    c_gotoxy(x, y);
    va_start(va_ptr, form);
    c_vprintf(form, va_ptr);
    va_end(va_ptr);

} /* end c_printXY */


/*---------------------------------------------------------------------------*/
void c_printf (const sbyte *form, ...)
{
    va_list  va_ptr;
 
    va_start(va_ptr, form);
    c_vprintf(form, va_ptr);
    va_end(va_ptr);

} /* end c_printf */


/*---------------------------------------------------------------------------*/
/*  x = 1 - 80,  y = 1 - 25                                                  */
/*---------------------------------------------------------------------------*/
void c_gettext (sword x1, sword y1, sword x2, sword y2, void *buff)
{
    #if ( DISPLAY == TEXTMODE )
        gettext(x1, y1, x2, y2, buff);                       /** C function **/
 
    #else
        sword  x, y;
        word   *area;
      
        x1--;
        area = (word *)buff;
        for ( y = y1 - 1 ; y < y2 ; y++ )
            for ( x = x1 ; x < x2 ; x++,  area++ )
                *area = g_TextArea[y][x];
    #endif

} /* end c_gettext */


/*---------------------------------------------------------------------------*/
/*  x = 1 - 80,  y = 1 - 25                                                  */
/*---------------------------------------------------------------------------*/
void c_puttext (sword x1, sword y1, sword x2, sword y2, void *buff)
{
    #if ( DISPLAY == TEXTMODE )
        puttext(x1, y1, x2, y2, buff);                       /** C function **/
 
    #else
        byte   bakColor;
        word   *area;
        sword  x, y;
             
        x1--;
        area = (word *)buff;
        bakColor = g_CurPos.color;
        for ( y = y1 - 1 ; y < y2 ; y++ )
        {
            SetXY(x1, y);
            for ( x = x1 ; x < x2 ; x++,  area++ )
            {                  
                c_textattr( *area >> 8 );
                c_putch( (byte)*area );
            } /* end for */
        } /* end for */
      
        #if ( DISPLAY == CHINESE )
            Flush();
        #endif
      
        c_textattr(bakColor);
                              
    #endif  /* end TEXTMODE */

} /* end c_puttext */


/*---------------------------------------------------------------------------*/
/*  x = 1 - 80,  y = 1 - 25                                                  */
/*---------------------------------------------------------------------------*/
#if 0

void c_movetext (sword x1, sword y1, sword x2, sword y2, sword tX, sword tY)
{
    sword  sourX, sourY, xHead, tarX, tarY, offX, offY, endX, endY, x;
 
    if ( x1 == tX && y1 == tY )
        return;
 
    if ( x1 < tX )
    {
        offX  = -1;
        sourX = x2 - 1;
        endX  = x1 - 1;
        xHead = tX + (x2 - x1);
    }
    else
    {
        offX  = 1;
        sourX = x1 - 1;
        endX  = x2 - 1;
        xHead = tX - 1;
    } /* end if */
    
    if ( y1 < tX )
    {
        offY  = -1;
        sourY = y2 - 1;
        endY  = y1 - 1;
        tarY  = tY + (y2 - y1);
    }
    else
    {
        offY  = 1;
        sourY = y1 - 1;
        endY  = y2 - 1;
        tarY  = tY - 1;
    } /* end if */
    
    for ( ; sourY != endY ; sourY += offY, tarY += offY )
    {
        tarX = xHead;
        for ( x = sourX ; x != endX ; x += offX, tarX += offX )
        {
            g_TextArea[tarY][tarX] = g_TextArea[sourY][x];
      
            /**  ;;;;; NO_DISPLAY; fix me **/
        }
    } /* end for */
} /* end c_movetext */

#endif   /* end 0 */


/*----------------------------------------------------------------------------+
|   x1, x2 = 0 - 79    y1, y2 = 0 - 24                                        |
+----------------------------------------------------------------------------*/
void scroll_up (sword x1, sword y1, sword x2, sword y2, sword line)
{
    #if ( DISPLAY == TEXTMODE )
        /* 
         * movetext: x1,x2 = 1-80  y1,y2 = 1-25
         */
        movetext(x1+1, y1+line+1, x2+1, y2+1, x1+1, y1+1);   /** C function **/
        Clr_Block(x1, y2-line+1, x2, y2);
 
    #else
        sword  tarY, x, y;
        byte   bakColor;
        word   *area;
        
        if ( line > (y2 - y1 + 1) )
            line = y2 - y1 + 1;
        
        tarY = y1;
        if ( line > 0 )
        {
            bakColor = g_CurPos.color;
            for ( y = y1 + line ; y <= y2 ; y++,  tarY++ )
            {
                area = &g_TextArea[y][x1];
                SetXY(x1, tarY);
                for ( x = x1 ; x <= x2 ; x++, area++ )
                {
                    c_textattr( (byte)(*area >> 8) );
                    c_putch( (byte)*area );
                } /* end for */
            } /* end for */

            g_CurPos.color = bakColor;
        } /* end if */
        
        #if ( DISPLAY == CHINESE )
            Flush();
        #endif
        
        Clr_Block(x1, tarY, x2, y2);
 
    #endif  /* end TEXTMODE */

} /* end scroll_up */


/*----------------------------------------------------------------------------+
|   x = 0 - 79    y = 0 - 24                                                  |
+----------------------------------------------------------------------------*/
#if 0

void scroll_down (sword x1, sword y1, sword x2, sword y2, sword line)
{
    #if ( DISPLAY == TEXTMODE )
        /* 
         * movetext: x1,x2 = 1-80  y1,y2 = 1-25
         */
        movetext(x1+1, y1+1, x2+1, y2+1, x1+1, y1+line+1);    /** C function **/
        Clr_Block(x1, y1, x2, y1+line-1);
 
    #else
        sword  tarY, x, y;
        byte   bakColor;
        word   *area;
      
        if ( line > (y2 - y1 + 1) )
            line = y2 - y1 + 1;
      
        tarY = y2;
        if ( line > 0 )
        {
            bakColor = g_CurPos.color;
            for ( y = y2 - line ; y >= y1 ; y--,  tarY-- )
            {
                area = &g_TextArea[y][x1];
                SetXY(x1, tarY);
                for ( x = x1 ; x <= x2 ; x++ )
                {
                    c_textattr( (byte)(*area >> 8) );
                    c_putch( (byte)*area );
                } /* end for */
            } /* end for */
            
            g_CurPos.color = bakColor;
        } /* end if */
      
        #if ( DISPLAY == CHINESE )
            Flush();
        #endif
      
        Clr_Block(x1, y1, x2, tarY);
    #endif  /* end TEXTMODE */

} /* end scroll_down */

#endif  /* 0 */

