/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/

#ifndef __LOWLEVEL_H_
#define __LOWLEVEL_H_

#include <dos.h>
#include <conio.h>

#define _CLI()              asm cli
#define _STI()              asm sti
#define ENABLE_CTRL_BREAK   ctrlbrk(CTRL_BREAK)
#define DISABLE_CTRL_BREAK  ctrlbrk(NO_CTRL_BREAK)

#define TIMER_INTR          0x1c

#define FAR                  far

#define RETRY_TIMES            3

#define DISK_XCHG              1
#define PAUSE_DISK_XCHG        0
#define DETECT_XCHG_STATUS  0xFE
#define RELEASE_MY_INT13    0xFF

#define VALID_DISKDT        0x01
#define SUPPORT_13EXT       0x02
#define FLOPPY_DISK         0x04
#define HARD_DISK           0x08
#define SCSI_DISK           0x10

#define MAKE_FP(seg,ofs)    ((void FAR *)(((dword)(seg) << 16) | (word)(ofs)))
#define FP_SEGM(fp)         ((word)((dword)((void FAR *)(fp)) >> 16))
#define FP_OFFS(fp)         ((word)(fp))

#define SELE_GR(n)          (outportb(0x3ce, (n)))
#define SET_GR(n)           (outportb(0x3cf, (n)))
#define GET_GR()            (inportb(0x3cf))
#define SELE_SR(n)          (outportb(0x3c4, (n)))
#define SET_SR(n)           (outportb(0x3c5, (n)))
#define GET_SR()            (inportb(0x3c5))
 
#define SET_WRITE_MODE(n)   { SELE_GR(5); \
                              SET_GR((GET_GR() & 0xfc) | (n)); }

typedef struct Disk_Descriptor  DiskDT;

typedef struct Disk_Geometry
{
   word    bytePerSect;
   dword   sectPerCyl;
   dword   maxCyl;
   dword   maxHead;
   dword   maxSect;
/* dword   tnSects_L;   */                /**   low 4 bytes of Total Sector **/
/* dword   tnSects_H;   */                /**  high 4 bytes of Total Sector **/
   double  tnSector;                      /** (tnSects_H << 32) + tnSects_L **/
} DiskGEO;


/*----------------------------------------+
|    Disk Driver Structure Declaration    |
+----------------------------------------*/
typedef struct Disk_Driver
{
   sword   (*open)(DiskDT *dk);
   sword   (*close)(DiskDT *dk);
   sword   (*reset)(DiskDT *dk);
   sword   (*getAttr)(DiskDT *dk);
   /*------------------------------------------------------------*/
   sword   (*linearRead)(DiskDT *dk,
                      dword linearSect, dword nSects, void *buff); 
   sword   (*linearWrite)(DiskDT *dk,
                       dword linearSect, dword nSects, void *buff); 
   sword   (*linearCheck)(DiskDT *dk,                         
                       dword linearSect, dword nSects, void *buff);
   /*------------------------------------------------------------*/
   sword   (*chsRead)(DiskDT *dk,
                      dword head, dword cyl, dword sector,
                      dword nSects, void *buff);
   sword   (*chsWrite)(DiskDT *dk,
                       dword head, dword cyl, dword sector,
                       dword nSects, void *buff);
   sword   (*chsCheck)(DiskDT *dk,
                       dword head, dword cyl, dword sector, 
                       dword nSects, void *buff);
} DiskDRV;


/*------------------------------------------+
|    ϺаѼƪ̪CӤҬUc   |
+------------------------------------------*/
struct Disk_Descriptor
{        
   word     flag;               /** OeO_ġBO_䴩 INT13 ext ...**/
   DiskGEO  lgeo;
   DiskGEO  pgeo;
   DiskDRV  *drv;                                           /** Disk Driver **/

   word     diskNO;                /** ѼƤlϺХN 0x80, 0x81... **/
/* FILE     *fptr;  */             /** linux use file system to access disk **/
/* sbyte    *name;  */             /** linux use file system to access disk **/
};


/*---------------------------------------------------+
|     INT 13h extension s  w  M   c  |
+---------------------------------------------------*/
typedef struct DRV_ADR_Packet
{ 
   byte   size,
          reserved1,
          transfer,
          reserved2;
   word   buff_OFF,
          buff_SEG;
   dword  startLow,
          startHigh;
} DRV_PKT;


/*------------------------------------------------------+
|     INT 13h extension s  w      c  |
+------------------------------------------------------*/
typedef struct FLD
{
    word  dma_boundary_err:1,
          valid4_15:1,
          isRemovable:1,
          SupportsW_V:1,
          notification:1,
          lockable:1,
          dvl_Maximum:1,
          reserved:9;
} WORD_FLD;


/*------------------------------------------------------+
|     INT 13h extension  ^ w      c  |
+------------------------------------------------------*/
typedef struct Result_Buffer
{
   word       size;
   WORD_FLD   flag;
   dword      maxCyl,
              maxHead,
              maxSector,
              total_Low,              /** (High << 32) + Low = Total Sector **/
              total_High;
   word       bytePerSect;
   dword      dpt_ptr;
} DRV_PARA;


struct ByteRegs
{
    byte  al, ah, bl, bh;
    byte  cl, ch, dl, dh;
};

struct WordRegs
{
    word  ax, bx, cx, dx;
    word  si, di, cflag, flags;
};

union Regs
{
    struct ByteRegs  h;
    struct WordRegs  x;
};

struct SRegs
{
    word  es;
    word  cs;
    word  ss;
    word  ds;
};


word   GetRealKey (void);
word   GetCurTextAttr (void);
sword  ChkKeyPressed (void);
sword  GetCharacter (void);

/* byte   Ctrl_DrvExchg (byte sw); */
sword  Disk_Extra_Ctrl (byte ctrl);
sword  Get_Disk_Extra_Status (void);
sword  Set_Disk_Extra_Status (byte ctrl);

sword  GetPartnToBuffer (DiskDT *dk, byte partn, dword *partnAddr, byte *buff);
sword  CreateDiskParaTable (void);
sword  GetNumDisk (sword kind);
sword  ResetWorkDisk (void);

sword  TempToShell (void);
sword  SystemInitial (void);
void   SystemRecovery (void);
void   Enable_Ctrl_Break (void);
void   Disable_Ctrl_Break (void);

void   ReadSegRegs (struct SRegs *sregs);
void   BiosCall (sword intr_no, union Regs *regs, struct SRegs *sregs);

sword  c_kbhit (void);
sword  c_getch (void);
word   c_get_real_key (void);
void   PushKey (word key);
      
#endif

