/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <conio.h>
#include "bootmgr.h"
#include "common.h"
#include "output.h"

#if ( DISPLAY == CHINESE )
static sbyte gs_FontCopyRight[] = "nϥΤrwo -qѥq- v";
#endif

/*=============================== DU ==================================*/
void Show_Help (void)
{
    static sbyte *msg[] =
    {
        #if ( DISPLAY == CHINESE )
            "\nSPecial FDisk O@MݨҰʺ޲zεwФγBzKOn I",
            "\nykG  SPFDisk  [/Ѽ]\n\n",
            "    /mbr                s MBRA۷ DOS  FDISK /mbr\n",
            "    /undo [filename]    ^s SPFDisk ƥɩ UNDO \n",
            "    /?                  DUe",
            "\n\nо\\Ū USERGUID.TXT ɡA sG%s   {]pG\n"
        #else 
            "\nSPecial FDisk is a boot manager and partition tool !",
            "\nSyntax:  SPFDisk  [/Parameter]\n\n",
            "    /mbr                Rebuilt MBR, it is equal to DOS's FDISK /mbr\n",
            "    /undo [filename]    Restore the Backup/UNDO file of SPFDisk\n",
            "    /?                  This help",
            "\n\nPlease read the USERGUID.TXT file.  Ver.%s   Program by Hsu-Ping Feng .\n"
        #endif
    }; /* end msg[] declaration */

    sword  i;

    #if ( DISPLAY == CHINESE )
        c_textattr( YELLOW + (BLUE << 4) );
        c_printf(" %s I", gs_FontCopyRight);
        c_textattr(LIGHTGRAY);
    #endif
 
    for ( i = 0 ; i < sizeof(msg) / sizeof(sbyte *) - 1 ; i++ )
        c_printf(msg[i]);
    c_printf(msg[i], VERSION);
} /* end Show_Help */


/*============================= ܦrv ================================*/
void Show_Copyright (void)
{
    #if ( DISPLAY == CHINESE )
        sword  h_line[] = { 11, 14, 0 };
    
        Square(11, 9, 69, 17, h_line);                           /** e **/
        ShowCenter(10, "Copyright (C) 2003, Hsu-Ping Feng");
        c_printXY(13, 12, "oO@MKOnAbLӷ~欰UziNƻsδG,");
        c_textattr( YELLOW + (BLUE << 4) );
        c_printXY(13, 13, gs_FontCopyRight);
        c_textattr(DEFAULT_COLOR);
        c_printXY(13, 15, "n魺G http://spfdisk.sourceforge.net");
        c_printXY(13, 16, "@̫HcG spferng@ksts.seed.net.tw ");
    
    #else
        sword  h_line[] = { 11, 14, 0 };
    
        Square(13, 9, 68, 17, h_line);                           /** e **/
        ShowCenter(10, "Copyright (C) 2003, Hsu-Ping Feng");
        c_printXY(15, 12, "This is a freeware, you can redistribute it under");
        c_printXY(15, 13, "observe the condition that without mercantile action.");
        c_printXY(15, 15, "Homepage: http://spfdisk.sourceforge.net");
        c_printXY(15, 16, "E-Mail  : spferng@ksts.seed.net.tw ");
    #endif

    WaitKey();
} /* end Show_Copyright */
