/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
|                                                                             |
+----------------------------------------------------------------------------*/
#include <dos.h>
#include "undo.h"
#include "global.h"
#include "common.h"

/*------ driver call common function -------*/
static sword LBA_Access (word cmd, DiskDT *dk,
                         dword linearSect, dword nSects, void *buff);
static sword CHS_Access (word cmd, DiskDT *dk, dword head,
                         dword cyl, dword sector, dword nSects, void *buff);
static sword int13 (word cmd, DiskDT *dk, dword head,
                    dword cyl,  dword sector, dword nSects, void FAR *buffer);
static sword int13ext (word cmd, DiskDT *dk,  dword head, 
                       dword cyl, dword sector, dword nSects, void FAR *buffer);

/*------ driver -------*/
static sword drv_DkOpen (DiskDT *dk);
static sword drv_DkClose (DiskDT *dk);
static sword drv_DkReset (DiskDT *dk);
static sword drv_DkGetAttr (DiskDT *dk);

static sword drv_LBA_DkRead (DiskDT *dk,
                             dword linearSect, dword nSects, void *buff); 
static sword drv_LBA_DkWrite (DiskDT *dk,
                              dword linearSect, dword nSects, void *buff); 
static sword drv_LBA_DkCheck (DiskDT *dk,
                              dword linearSect, dword nSects, void *buff);
static sword drv_CHS_DkRead (DiskDT *dk, dword head,
                             dword cyl, dword sector, dword nSects, void *buff);
static sword drv_CHS_DkWrite (DiskDT *dk, dword head,
                              dword cyl, dword sector, dword nSects, void *buff);
static sword drv_CHS_DkCheck (DiskDT *dk, dword head,
                              dword cyl, dword sector, dword nSects, void *buff);


/*-----------------------------------+
|    Disk Driver Structure initial   |
+-----------------------------------*/
DiskDRV  g_diskDrv =
{
    drv_DkOpen,
    drv_DkClose,
    drv_DkReset,
    drv_DkGetAttr,
    drv_LBA_DkRead,
    drv_LBA_DkWrite,
    drv_LBA_DkCheck,
    drv_CHS_DkRead,
    drv_CHS_DkWrite,
    drv_CHS_DkCheck
};


/*------------------------------ oϺаѼ -------------------------------*/
sword drv_DkGetAttr (DiskDT *dk)
{
    dword    maxSect, maxHead, maxCyl;
    union    Regs regs;
    DRV_PARA drvPara;

    dk->flag &= ~(SUPPORT_13EXT | VALID_DISKDT);             /** clear flag **/
    dk->drv->reset(dk);                                      /** reset disk **/

    regs.h.ah = 8;
    regs.h.dl = dk->diskNO;
    BiosCall(0x13, &regs, NULL);
    if ( regs.x.cflag )                                        /**  **/
    {
        dk->drv->reset(dk);
        return(-1);
    } /* end if */

    /*-------------------------+
    |       oϺаѼ       |
    +-------------------------*/
    maxHead = regs.h.dh;                           /** get head_per_cyl - 1 **/
    maxSect = regs.x.cx & 0x3f;                    /** get sector_per_track **/
    maxCyl  = ((regs.x.cx & 0xc0) << 2) | regs.h.ch;  /** get total_cyl - 1 **/

#if 1
    if ( (dk->flag & FLOPPY_DISK) == 0 )                   /** if hard_disk **/
    {
        /*---------------------------+
        |  ˬdO_䴩 INT 13h ext  |
        +---------------------------*/
        regs.h.ah = 0x41;
        regs.h.dl = dk->diskNO;
        regs.x.bx = 0x55aa;
        BiosCall(0x13, &regs, NULL);

        if ( (regs.x.cflag == 0) &&                    /** 䴩 INT 13h ext **/
             (regs.x.bx == 0xaa55) && (regs.x.cx & 1) )
        {
            if ( int13ext(8, dk, 0, 0, 0, 0, &drvPara) == 0 )
                dk->flag |= SUPPORT_13EXT;                     /** ]w䴩 **/
            else
            {
                dk->drv->reset(dk);
                return(-1);
            }
        } /* end if */
    } /* end if */
#endif

    /*-------------------------+
    |    NϺаѼƶJc    |
    +-------------------------*/
    dk->lgeo.maxCyl     = maxCyl;
    dk->lgeo.maxHead    = maxHead;
    dk->lgeo.maxSect    = maxSect;
    dk->lgeo.sectPerCyl = (maxHead + 1) * maxSect;

    if ( dk->lgeo.sectPerCyl <= 0 )
        return(-1);

    /*------------------------------------------+
    |    oϺЮeq(ϰϼ)ήե̤jϬW   |
    +------------------------------------------*/
    if ( (dk->flag & SUPPORT_13EXT) == 0 )
    {
        dk->pgeo.maxCyl     = dk->lgeo.maxCyl;
        dk->pgeo.maxHead    = dk->lgeo.maxHead;
        dk->pgeo.maxSect    = dk->lgeo.maxSect;
        dk->pgeo.sectPerCyl = dk->lgeo.sectPerCyl;

        /*
         *  p`ϰϼ 
         */
        dk->lgeo.tnSector = (double)(maxCyl + 1) * dk->lgeo.sectPerCyl;
    }
    else
    {
        if ( drvPara.flag.valid4_15 )
        {
            dk->pgeo.maxCyl     = drvPara.maxCyl;
            dk->pgeo.maxHead    = drvPara.maxHead;
            dk->pgeo.maxSect    = drvPara.maxSector;
            dk->pgeo.sectPerCyl = (drvPara.maxHead + 1) * drvPara.maxSector;
        } /* end if */

        /*
         *  Total_Sector = Total_Low_dword + Total_High_dword * (2^32);
         *  (2^32) = 2 to the power of 32 = (double)(dword)0xffffffffL + 1;
         */
        dk->lgeo.tnSector = (double)drvPara.total_Low +
                            (double)drvPara.total_High *
                            ((double)(0xffffffffUL) + 1);
  
        /*
         *  ե total_cyl - 1
         */
        dk->lgeo.maxCyl = (dword)( dk->lgeo.tnSector / dk->lgeo.sectPerCyl ) - 1;

    } /* end if */

    if ( (dk->lgeo.maxCyl <= 0) || (dk->lgeo.tnSector < 1) )
        return(-1);

    dk->pgeo.tnSector = dk->lgeo.tnSector;
    dk->flag |= VALID_DISKDT;
    return(0);
} /* end drv_DkGetAttr */


/*---------------------------------------------------------------------------*/
sword drv_DkOpen (DiskDT *dk)
{
    return( ( dk == NULL ) ? -1 : 0 );
} /* end drv_DkOpen */


/*---------------------------------------------------------------------------*/
sword drv_DkClose (DiskDT *dk)
{
    return( ( dk == NULL ) ? -1 : 0 );
} /* end drv_DkClose */


/*---------------------------------------------------------------------------*/
sword drv_DkReset (DiskDT *dk)
{
    return( Reset_Disk(dk->diskNO) );
} /* end drv_DkReset */
   

/*---------------------------------------------------------------------------*/
sword drv_LBA_DkRead (DiskDT *dk, dword linearSect, dword nSects, void *buff)
{
    return( LBA_Access(2, dk, linearSect, nSects, buff) );
} /* end drv_LBA_DkRead */


/*---------------------------------------------------------------------------*/
sword drv_LBA_DkWrite (DiskDT *dk, dword linearSect, dword nSects, void *buff)
{
    dword  sector, head, cyl;
 
    Sect_to_CHS(linearSect, &cyl, &head, &sector, dk);          /** get CHS **/
 
    if ( IsOpenUndo() )                              /** pG} undo  **/
        return( SaveUNDO(dk, cyl, head, sector, nSects) );
    else if ( GET_WRITE_SW() )                                 /** \gJ **/
        return( CHS_Access(3, dk, head, cyl, sector, nSects, buff) );
    else
        return(0);
} /* end drv_LBA_DkWrite */


/*---------------------------------------------------------------------------*/
sword drv_LBA_DkCheck (DiskDT *dk, dword linearSect, dword nSects, void *buff)
{
    return( LBA_Access(4, dk, linearSect, nSects, buff) );
} /* end drv_LBA_DkCheck */


/*---------------------------------------------------------------------------*/
sword drv_CHS_DkRead (DiskDT *dk, dword head, dword cyl,
                                  dword sector, dword nSects, void *buff)
{
    return( CHS_Access(2, dk, head, cyl, sector, nSects, buff) );
} /* end drv_CHS_DkRead */


/*---------------------------------------------------------------------------*/
sword drv_CHS_DkWrite (DiskDT *dk, dword head, dword cyl,
                                   dword sector, dword nSects, void *buff)
{                 
    if ( IsOpenUndo() )                              /** pG} undo  **/
        return( SaveUNDO(dk, cyl, head, sector, nSects) );
    else if ( GET_WRITE_SW() )                                 /** \gJ **/
        return( CHS_Access(3, dk, head, cyl, sector, nSects, buff) );
    else
        return(0);
} /* end drv_CHS_DkWrite */


/*---------------------------------------------------------------------------*/
sword drv_CHS_DkCheck (DiskDT *dk, dword head, dword cyl,
                                   dword sector, dword nSects, void *buff)
{
    return( CHS_Access(4, dk, head, cyl, sector, nSects, buff) );
} /* end drv_CHS_DkCheck */


/*=========================== H LBA w}sϰ ===========================*/
sword LBA_Access (word cmd, DiskDT *dk,
                            dword linearSect, dword nSects, void *buff)
{
    dword  sector, head, cyl;
 
    Sect_to_CHS(linearSect, &cyl, &head, &sector, dk);
    return( CHS_Access(cmd, dk, head, cyl, sector, nSects, buff) );
} /* end LBA_Access */


/*=========================== H CHS w}sϰ ===========================*/
sword CHS_Access (word cmd, DiskDT *dk, dword head,
                            dword cyl, dword sector, dword nSects, void *buff)
{
    sword  err, i;
 
    /*---------------------------------------------+
    |    pG} UNDO ɥBnigJʧ@      |
    +---------------------------------------------*/
    for ( i = 0 ; i < RETRY_TIMES ; i++ )
    {
        if ( dk->flag & SUPPORT_13EXT )
            err = int13ext(cmd, dk, head, cyl, sector, nSects, buff);
        else
            err = int13(cmd, dk, head, cyl, sector, nSects, buff);
  
        if ( err )
            Reset_Disk(dk->diskNO);                                /** m **/
        else
            break;
    } /* end for */
 
    return( err );
} /* end CHS_Access */

 
/*-------------------------- Conventional INT 13h ---------------------------*/
sword int13 (word cmd, DiskDT *dk, dword head,
             dword cyl, dword sector, dword nSects, void FAR *buffer)
{
    cmd &= ~0x40;
    return( INT_13H(cmd, dk->diskNO, (word)head, (word)cyl, (word)sector,
                                                 (byte)nSects, buffer) );
} /* end int13 */


/*---------------------------- INT 13h extension -----------------------------+
|                                                                             |
|   The function just support Fn 42h, 43h, 44h, 48h, can't use other fn !!!   |
+----------------------------------------------------------------------------*/
sword int13ext (word cmd, DiskDT *dk, dword head, 
                dword cyl, dword sector, dword nSects, void FAR *buffer)
{
    struct  SRegs sregs;
    union   Regs  regs;
    DRV_PKT para;
 
    ReadSegRegs(&sregs);
 
    cmd |= 0x40;
    regs.h.al = 0;             /* modified AL to 0 for AMI BIOS 0x43 by SPF03 */
    regs.h.ah = (byte)cmd;
    regs.h.dl = (byte)dk->diskNO;
 
    if ( cmd == 0x48 )
    {
        sword  i;
  
        *(byte FAR *)buffer = 30;            /** c׬ 30 Ӧ줸 **/
        for ( i = 1 ; i < 30 ; i++ )         /** added for some BIOS, SPF04 **/
            *((byte FAR *)buffer + i) = 0;
        regs.x.si = FP_OFFS(buffer);
        sregs.ds  = FP_SEGM(buffer);
        BiosCall(0x13, &regs, &sregs);
    }
    else                                                   /** oϺаѼ **/
    {
        para.size      = 16;
        para.reserved1 =  0;
        para.reserved2 =  0;
  
        /*
         * (StartHigh) high word no use, FIX ME
         */
        para.startLow  = CHS_to_Sect(cyl, head, sector, dk);
        para.startHigh = 0;
  
        #if 0
            /*
             * Check access sector out of range
             * if partition is invalid, it possible trigger this check
             */
            if ( para.startLow >= (dword)dk->lgeo.tnSector )
            {
                sbyte  msg[60];
       
                #if ( DISPLAY == CHINESE )
                    sprintf(msg, "BUG !\nsXkϰ(%ld)I", para.startLow);
                #else
                    sprintf(msg, "BUG !\nAttempt to access illegal sector(%ld)!", para.startLow);
                #endif
       
                Error_Msg_Box(msg, NULL);
                SPFDisk_End_Process();
                exit();
            } /* end if */
        #endif /* 0 */
  
        para.transfer = (byte)nSects;
        para.buff_OFF = (word)FP_OFFS(buffer);
        para.buff_SEG = (word)FP_SEGM(buffer);

        /** DS:SI -> &para **/
        sregs.ds  = (word)FP_SEGM(&para);
        regs.x.si = (word)FP_OFFS(&para);
  
        #if 0 /* mark for AMI BIOS, SPF03 */
            if ( regs.h.ah == 0x43 )
                regs.h.al = 2;
        #endif

        BiosCall(0x13, &regs, &sregs);
    } /* end if */

/*
    regs.x.ax = (regs.x.ax >> 8) & 0x00ff;
    return( regs.x.ax );
*/
    return( (sword)(byte)regs.h.ah );    
} /* end int13ext */
