/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/

#ifndef __COMMON_H_
#define __COMMON_H_

/*------------------------------ Type Define --------------------------------*/
typedef unsigned char   byte;
typedef char            sbyte;
typedef unsigned int    word;                              /** must 2 bytes **/
typedef int             sword;                             /** must 2 bytes **/
/** typedef unsigned short    word;  **/
/** typedef short             sword; **/
typedef unsigned long   dword;
typedef long            sdword;

#include <stdio.h>

#ifndef __CONFIG_H_
   #include "config.h"
#endif

#ifndef __LOWLEVEL_H_
   #include "lowlevel.h"
#endif

#ifndef __MESSAGE_H_
   #include "message.h"
#endif

#ifndef __OUTPUT_H_
   #include "output.h"
#endif

/*------------------------------+
|     X  T x s  c    |
+------------------------------*/
typedef struct common_information
{               
    word      nFP,                                           /** nо` **/
              nHD;                                           /** wо` **/
    DiskDT    *wdk;                                  /** Vu@ЪѼƪ **/
    sword     reboot_flag;             /** ɬO_X{ܭs}T **/
    sword     swap_status;                           /** O_Ϻиm欰 **/
    sword     expertMode;                           /** ϥμҦ(Ma,@) **/
    sword     usingMenu;
    sword     prevMenu;
    FILE      *undoFP;

    struct boot_manager_info                           /** BootMGR {M **/
    {
        sword  updated,
               clr_screen;
    } bm;

    struct fdisk_info                                    /** FDisk {M **/
    {          
        dword  ext_head,
               ext_end;
        sword  logic_exist,
               maxParNO,
               used,
               pri_use,
               primary,
               modified,
               use_fat32,
               canSaveFlag,
               clr_screen;
    } fd;

} INFO;

#define CUR_DK        (g_Info.wdk)                         /** ثeu@ **/

#define KB_UNIT        0
#define MB_UNIT        1
#define GB_UNIT        2
#define TB_UNIT        3
#define PB_UNIT        4
#define EB_UNIT        5

/*--------------------------- Function Proto type ---------------------------*/
void   SwitchMenu (sword menu);
void   Show_Copyright (void);
void   ShowError (sword code);
/* void Clr_Block (sword x1, sword y1, sword x2, sword y2); */
void   Ctrl_Cursor (sword sw);
void   Square (sword x1, sword y1, sword x2, sword y2, sword *line);
void   MenuBox (sword x1, sword y1, sword x2, sword y2, sword *line);
void   ShowCenter (sword row, const sbyte *str);
void   ShowMSG (const sbyte *str, ...);
void   ShowRangeStr (sword Front, sword Rear, void *buff, sword len, FILE *fptr);
void   Show_Help (void); 
void   Sect_to_CHS (dword linearSect, dword *c, dword *h, dword *s, DiskDT *dk);
void   Repeat_Str (const sbyte *str, sword len);
void   Repeat_Char (sbyte chr, sword len);
void   ClrKeyBuffer (void);
void   SetHotKeySW (sword key, sword flags);

sword  SPFDisk_Initial (void);
sword  CreateDiskParaTable (void);
sword  ProcCommandLinePara (sword argc, sbyte **argv);
sword  CopySector (DiskDT *dk, dword Source, dword Target, dword nSects);
sword  Fill_Sector (DiskDT *dk, dword NowSect, dword nSect, byte ch);
sword  WaitKey (void);
sword  IsFuncKey (sword Key);
sword  Input_Filename (sbyte *str, sword len);
sword  GetStr (sbyte *str, sword max_len, sword key_flag);
sword  Input_CHS_LBA (dword *cyl, dword *head, dword *sector, dword *linearSect);
sword  InputWORD (void *var, dword min, dword max, sword len, sword key_flag);
sword  InputDWORD (void *var, dword min, dword max, sword len, sword key_flag);
sword  Is_Yes (sbyte *chinese);
sword  Is_Overwrite (sbyte *str);
sword  IsValid (DiskDT *dk);
sword  IsHiddenWinID (sword id);
sword  IsHiddenID (sword id);
sword  IsFAT (byte *Bootrec);
sword  Is_Extended (byte id);  
sword  ChkSysID (byte id, sword cond);
sword  SetHotKey (sword key, sword (*func)(void), sword eat);
                                                                              
sword  linear_WriteWDK (dword linearSect, dword nSects, void *buff);
sword  linear_ReadWDK (dword linearSect, dword nSects, void *buff);
sword  chs_WriteWDK (dword head, dword cyl, dword sect, dword nSects, void *buff);
sword  chs_ReadWDK (dword head, dword cyl, dword sector, dword nSects, void *buff);
sword  chs_CheckWDK (dword head, dword cyl, dword sect, dword nSects, void *buff);
sword  ResetWorkDisk (void);

void   Beep (void);
void   SPFDisk_End_Process (void);
void   SaveScreen (void);
void   RestoreScreen (void);
void   PushScreenBlock (sword x1, sword y1, sword x2, sword y2);
void   PopScreenBlock (sword x1, sword y1, sword x2, sword y2);
void   GiveupScreenBlock (void);

void   Asm_Sect_Cyl (byte *str, dword sector, dword track);
void   Show_Capacity (sbyte *chi_title, double nSects, sword sw);
void   CopyMem (void *target, const void *source, word size);
void   Select_Sort (void *base, sword elem_num, sword elem_size,
                    sword (*fcmp)(const void *elem1, const void *elem2));

byte   *GetScreenBuff (void);

dword  CHS_to_Sect (dword c, dword h, dword s, DiskDT *dk);
          
double TranSizeUnit (double val, sbyte **retUnitStr, sword valUnit);

void   SetWorkingDisk (DiskDT *dk);
DiskDT *GetFloppyDT (word ndx);
DiskDT *GetHardDiskDT (word ndx);


/*-----------------------------  `  w q --------------------------------*/
#define ENABLE_WRITE()        g_WriteSW = TRUE
#define DISABLE_WRITE()       g_WriteSW = FALSE
#define SET_WRITE_SW(n)       g_WriteSW = (n)
#define GET_WRITE_SW()        g_WriteSW

#define FALSE                 0
#define TRUE                  1

/* check system ID condition */
#define EXTENDED_ID           0x01
#define FAT12_16              0x02
#define LBA_FAT               0x04
#define NT_ID                 0x08
#define HIDD_ID               0x80
#define FAT12_16_32           (FAT12_16 | LBA_FAT)
#define NT_FAT12_16_32        (FAT12_16_32 | NT_ID)

#define F_HELP                0x01
#define F_REBUILD_MBR         0x02
#define F_UNDO_FILE           0x04
#define F_INVALID             0x08

#define CUT_ERR_PARTN         0x01                         /** ~ **/
#define INV_PARTN_TAB         0x02                           /** LĤΪ **/
#define PARTN_NUM_TOO_MUCH    0x04                     /** μƶWX̤j **/
#define INV_DISK_PARA         0x08                             /** w~ **/
#define PARTN_ACCESS_ERR      0x10                       /** Ϊs **/
#define PARTN_OVERLAP         0x20                         /** εoͭ| **/
#define GIVE_UP_CHG_WD        0x40                     /** wu@ **/
#define DISK_ERROR            0x80               /** Ϻп~Bu@w **/
#define PARTN_OVERLAP_OR_TOO_MUCH \
            (PARTN_OVERLAP | PARTN_NUM_TOO_MUCH)

#define ALLOW_ESC             0x0001
#define AUTO_ENTER            0x0002
#define DIRECT_ENTER          0x0004
#define PASSWORD              0x0008
#define HEX_STR               0x0010
#define ALLOW_SPACE           0x0020
#define HAS_INITIAL           0x0040
#define LIMIT_ALPHA           0x0080
#define LIMIT_NUMERIC         0x0100
#define LIMIT_NUM_SYMB        0x0200
#define DISABLE_VDIRKEY       0x0400
#define DISABLE_HDIRKEY       0x0800
#define DISABLE_DIRKEY        DISABLE_HDIRKEY | DISABLE_VDIRKEY

#define QUIT_TO_DOS           -1

#define MAIN_MENU             1
#define BOOTMGR_EDIT_MENU     2
#define BOOTMGR_OPTION_MENU   3
#define FDISK_TOOL_MENU       4


/*---------------------------------------------------------------------------*/
#define COLOR_SELECT(fg, bg, blink)       (fg + (bg << 4) + blink)

#define INIT_COLOR            COLOR_SELECT(LIGHTGRAY,    BLACK,   0)
#define DEFAULT_COLOR         COLOR_SELECT(WHITE,        BLUE,    0)
#define LIGHT_BAR_COLOR       COLOR_SELECT(YELLOW,       GREEN,   0)
#define KEY_IN_COLOR          COLOR_SELECT(WHITE,        CYAN,    0)
#define EDIT_SECTOR_COLOR     COLOR_SELECT(WHITE,        BLACK,   0)
#define PAR_MENU_COLOR        COLOR_SELECT(WHITE,        RED,     0)
#define EXPERT_COLOR          COLOR_SELECT(WHITE,        RED,     BLINK)
#define UPDATE_COLOR          COLOR_SELECT(WHITE,        MAGENTA, 0)
#define NO_UPDATE_COLOR       COLOR_SELECT(WHITE,        GREEN,   0)
#define WARNING_COLOR         COLOR_SELECT(WHITE,        BLUE,    BLINK)
#define MESSAGE_COLOR         COLOR_SELECT(YELLOW,       BLUE,    0)
#define BOOT_PW_COLOR         COLOR_SELECT(LIGHTRED,     BLUE,    0)
#define BOOT_DEF_COLOR        COLOR_SELECT(LIGHTCYAN,    BLUE,    0)
#define BOOTMGR_PARTN_COLOR   COLOR_SELECT(LIGHTMAGENTA, BLUE,    0)
#define PROBLEM_PARTN_COLOR   COLOR_SELECT(LIGHTRED,     BLUE,    0)
#define UNUSED_PARTN_COLOR    COLOR_SELECT(LIGHTCYAN,    BLUE,    0)
#define ADJUST_COLOR          COLOR_SELECT(WHITE,        BLUE,    BLINK)
#define PMT_LINE_COLOR        COLOR_SELECT(WHITE,        RED,     0)
#define NO_CHECK_COLOR        COLOR_SELECT(MAGENTA,      BLUE,    0)
#define CHECKING_COLOR        COLOR_SELECT(LIGHTMAGENTA, BLUE,    0)
#define CHK_ERR_COLOR         COLOR_SELECT(LIGHTRED,     BLUE,    0)
#define READ_ERR_COLOR        COLOR_SELECT(RED,          BLUE,    0)
#define LG_NO_USE_COLOR       COLOR_SELECT(BLACK,        GREEN,   0)
#define NO_USE_COLOR          COLOR_SELECT(LIGHTGRAY,    BLUE,    0)
#define MOVE_DATA_COLOR       COLOR_SELECT(LIGHTRED,     BLUE,    0)
#define HIDD_PARTN_COLOR      COLOR_SELECT(LIGHTCYAN,    BLUE,    0)      
#define READ_ONLY_COLOR       COLOR_SELECT(LIGHTGRAY,    CYAN,    0)
#define NON_SELE_COLOR        COLOR_SELECT(LIGHTGRAY,    RED,     0)
#define BOX_TITLE_COLOR       COLOR_SELECT(LIGHTRED,     CYAN,    BLINK)
#define BOX_LINE_COLOR        COLOR_SELECT(YELLOW,       CYAN,    0)
#define BOX_MSG_COLOR         COLOR_SELECT(WHITE,        CYAN,    0)
#define BOX_KEY_COLOR         COLOR_SELECT(YELLOW,       MAGENTA, 0)
#define DELE_FILE_COLOR       COLOR_SELECT(LIGHTGRAY,    BLUE,    0)
#define DIRECTORY_COLOR       COLOR_SELECT(YELLOW,       BLUE,    0)
#define VOLUMN_COLOR          COLOR_SELECT(LIGHTCYAN,    BLUE,    0)
#define FILE_COLOR            COLOR_SELECT(WHITE,        BLUE,    0)
#define LONGNAME_COLOR        COLOR_SELECT(LIGHTCYAN,    BLUE,    0)

#define FDISK_TOOLS_COLOR     COLOR_SELECT(YELLOW,       BLUE,    0)
#define ADD_BOOT_ITEM_COLOR   COLOR_SELECT(LIGHTCYAN,    BLUE,    0)

#define CURSOR_COLOR          YELLOW

#endif /* __COMMON_H_ */
