/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <mem.h>
#include "fdisk.h"
#include "global.h"

static sword Partn_Info (PARTN *partnArr, byte *buff);
static void  Get_One_Partn (dword begin, PARTN *ptr, byte *buff, sword field, DiskDT *dk);

/*=========================       ================================+
|   Ǧ^ȡG                                                                  |
|                                                                             |
|          CUT_ERR_PARTN       Ϊeo{~Al               |
|          INV_PARTN_TAB       LĪΪ                                   |
|          PARTN_NUM_TOO_MUCH  WXiμƶq                           |
|          INV_DISK_PARA       _ 13h u@ѡAiOw~              |
|          PARTN_ACCESS_ERR    wЦs~                                   |
|          PARTN_OVERLAP       o{έ|                                   |
|          GIVE_UP_CHG_WD      󴫤u@Ϻ                               |
|          DISK_ERROR          wЦs                                   |
+============================================================================*/
sword Chg_Work_Disk (PARTN *partnArr)
{
    sword  disk, err;
 
    if ( g_Info.fd.modified &&
         (Prompt_Save_Partn(partnArr) < 0) )      /** prompt & process save **/
    {
        return(-1);                                            /**  **/
    } /* end if */

    disk = 1;
    err  = INV_DISK_PARA;

    while ( (disk > 0) && (err & INV_DISK_PARA) )
    {
        err &= ~INV_DISK_PARA;                /** M INV_DISK_PARA X **/
        if ( g_Info.nHD > 1 )                            /** ⳡHWw **/
        {
            #if ( DISPLAY == CHINESE )
                ShowMSG("    @  w  H");
            #else
                ShowMSG("Which hard disk do you want ?");
            #endif
            disk = Sele_HD(FALSE, 0);                          /** ܵw **/
        } /* end if */
  
        if ( disk < 1 )
            return( GIVE_UP_CHG_WD );                          /**  **/

        /*--------------------------------------------------+
        |     ŪJwЩҦθT Partn c}C     |
        +--------------------------------------------------*/
        err = Get_Disk_Info(GetHardDiskDT(disk), partnArr, TRUE);

        if ( err )
        {
            Disk_Err_Msg( err );                           /** ܿ~T **/
            if ( (err & INV_DISK_PARA) && (g_Info.nHD <= 1) )
                return( DISK_ERROR );            /** w~Bu@w **/
        } /* end if */
    } /* end while */
 
    return(0);
} /* end Chg_Work_Disk */


/*=============== ŪJϺФΤθT Partn }C info }C ================+
|   Ǧ^ȡG                                                                  |
|                                                                             |
|       CUT_ERR_PARTN       Ϊeo{~Al                  |
|       INV_PARTN_TAB       LĪΪ                                      |
|       PARTN_NUM_TOO_MUCH  WXiμƶq                              |
|       INV_DISK_PARA       _ 13h u@ѡAiOw~                 |
|       PARTN_ACCESS_ERR    wЦs~                                      |
|       PARTN_OVERLAP       o{έ|                                      |
+============================================================================*/
sword Get_Disk_Info (DiskDT *dk, PARTN *partnArr, sword find_flag)
{
    byte   buff[512];
    sword  err;
 
    Init_Fdisk();                                       /** m fdisk info **/
 
    if ( !IsValid(dk) )
        return( INV_DISK_PARA );                             /** LİѼƪ **/
 
    SetWorkingDisk(dk);                                  /** ]wu@Ϻ **/
    memset(partnArr, 0, sizeof(PARTN) * MAX_PARTN_ELEM); /** Ϊ}Cl **/
 
    if ( linear_ReadWDK(0, 1, buff) )
        *(word *)&buff[510] = 0;                      /** DΪŪѡI**/
 
    #if ( DISPLAY == CHINESE )
        ShowMSG(" b Ū    A  y DDD");
    #else 
        ShowMSG("It's reading the partition table, please wait......");
    #endif
 
    err = Partn_Info(partnArr, buff);                    /** RXΪT **/
 
    if ( Find_Problem(partnArr) )              /** ˬdΪL|ο~ **/
        err |= PARTN_OVERLAP;
 
    if ( find_flag && (err & ~PARTN_OVERLAP_OR_TOO_MUCH) == 0 )
        if ( err & PARTN_OVERLAP_OR_TOO_MUCH )
            g_Info.fd.canSaveFlag = FALSE;
 
    Find_space(partnArr);                              /** Mtm϶ **/
    return( err ); 
} /* end Get_Disk_Info */


/*========================  o U    q ==============================+
|    Ǧ^ȡG                                                                 |
|                                                                             |
|        CUT_ERR_PARTN        Ϊeo{~Al                |
|        PARTN_NUM_TOO_MUCH   WXiμƶq                            |
|        PARTN_ACCESS_ERR     wЦs~                                    |
+============================================================================*/
sword Get_Logic_Partn (PARTN *partnArr, PARTN *extPartn)
{                         
    dword  extStart, sector;
    sword  err, ndx, no;
    byte   buff[512];
    PARTN  *ptr;
 
    extStart = GetStart(extPartn);                          /** oҩlϰ **/
    sector   = extStart;
 
    /*============ ŪJĤ@޿Ϊ ============*/
    if ( linear_ReadWDK(sector, 1, buff) )
        return( PARTN_ACCESS_ERR );
 
    /*============ Ĥ@h޿Τsb ============*/
    if ( (*(dword *)&buff[0x1be] == (dword)0xf6f6f6f6L) || (buff[0x1c2] == 0) )
        return(0);
 
    no  = 5;
    err = 0;
    ndx = g_Info.fd.pri_use;
    ptr = partnArr + ndx;
    while ( 1 )
    {
        if ( ndx > (MAX_PARTN_ELEM - 1) )
        {
            err |= PARTN_NUM_TOO_MUCH;             /** WXiμƶq **/
            break;
        } /* end if */
  
        if ( *(word *)&buff[510] != 0xaa55 )           /** LĪ޿Ϊ **/
        {
            err |= CUT_ERR_PARTN;
            break;
        } /* end if */
  
        sector += *(dword *)&buff[0x1c6];                /** [Wúϰϼ **/
        Get_One_Partn(sector, ptr, buff, 1, CUR_DK);
        ptr->no = no;                                          /** νs **/
        no++;
        ndx++;
        ptr++;
  
        /*---------------------------------------------------+
        |        ޿ΪĤG@wOXRΩΪŪ        |
        +---------------------------------------------------*/
        if ( (*(dword *)&buff[0x1d2] == 0) || !Is_Extended(buff[0x1d2]) )
            break;
  
        /*---------------------------------------------------+
        |             J U @                 |
        +---------------------------------------------------*/
        sector = extStart + *(dword *)&buff[0x1d6];
        if ( linear_ReadWDK(sector, 1, buff) )
        {
            err |= PARTN_ACCESS_ERR;
            break;
        } /* end if */
    } /* end while */
 
    if ( ndx > g_Info.fd.used )
    {
        g_Info.fd.logic_exist = TRUE;
        g_Info.fd.maxParNO    = no - 1;
        g_Info.fd.used        = ndx;
    } /* end if */
     
    return( err );
} /* end Get_Logic_Partn */


/*======================== R X     T ==============================+
|   Ǧ^ȡG                                                                  |
|                                                                             |
|         CUT_ERR_PARTN       Ϊeo{~Al                |
|         INV_PARTN_TAB       LĪΪ                                    |
|         PARTN_NUM_TOO_MUCH  WXiμƶq                            |
|         PARTN_ACCESS_ERR    wЦs~                                    |
|         PARTN_OVERLAP       o{MIΦsb                                |
+============================================================================*/
static sword Partn_Info (PARTN *partnArr, byte *buff)
{        
    sword  adr, err, ndx, ext, i;
    dword  sector;
    PARTN  *ptr;
 
    adr = 0x1be;
    err = 0;
    ndx = 0;
    ptr = partnArr;
    ext = -1;
 
    if ( *((word *)(&buff[510])) != 0xaa55 )
        err |= INV_PARTN_TAB;                                /** LĤΪ **/
    else
    {
        for ( i = 0 ; i < 4 ; i++,  adr += 0x10 )            /** ŪD **/
            if ( buff[adr+4] != 0 )
            {
                if ( (ext == -1) && ( Is_Extended(buff[adr+4]) || \
                     (buff[adr+4] == HIDDEN_ID) && (Is_Extended(buff[HIDD_BAK+i])) ) )
                {
                    ext = ndx;
                } /* end if */
    
                sector = *(dword *)&buff[adr+8];
    
                Get_One_Partn(sector, ptr, buff, i + 1, CUR_DK);
    
                g_Info.fd.maxParNO = 4;
                g_Info.fd.primary++;
                ptr->no = i + 1;                               /** νs **/
    
                ndx++;
                ptr++;
            } /* end if */
  
        g_Info.fd.pri_use = g_Info.fd.primary;
        g_Info.fd.used    = g_Info.fd.primary;
  
        /* added for debug by SPF
        partnArr[0].id = 5;
        partnArr[0].old_id = 5;
        */
  
        if ( ext > -1 )
        {
            g_Info.fd.ext_head = partnArr[ext].stCyl;   /** O ext ΰϰ **/
            g_Info.fd.ext_end  = partnArr[ext].endCyl;
            err = Get_Logic_Partn(partnArr, partnArr + ext); /** Ū޿ **/
        } /* end if */
    } /* end if */
 
    /*----------------------------------------+
    |   N    e H  l  W     |
    +----------------------------------------*/
    Sort_Partn(partnArr, FOR_STCYL);               /** ΰ}CHϬWƧ **/
    g_Info.fd.modified = 0;
 
    return( err );
} /* end Partn_Info */


/*========================== R X U   T ==============================*/
static void Get_One_Partn (dword begin, PARTN *ptr, byte *buff, sword field, DiskDT *dk)
{
    byte   *bak_id = buff + field + 0x19f;
    byte   *elem   = buff + field * 0x10 + 0x1ae;
    dword  end;

    ptr->adjust =
    ptr->remake = 0;
    ptr->stCyl  =
    ptr->endCyl = 0;
    ptr->active = elem[0];
    ptr->id     = elem[4];

    if ( ptr->id != 0 )
    {
        if ( !IsHiddenPartn(ptr) )
            ptr->old_id = ptr->id;
        else if ( IsHiddenWinID(ptr->id) )
            ptr->old_id = ptr->id & 0x0f;
        else if ( *bak_id != 0 )
            ptr->old_id = *bak_id;
        else
            ptr->old_id = HIDDEN_ID;

        end = begin + *(dword *)&elem[12] - 1;               /** D CHS **/
        Sect_to_CHS(end, &ptr->endCyl, &ptr->side, &ptr->sector, dk);
                                                             /** Dҩl CHS **/
        Sect_to_CHS(begin, &ptr->stCyl, &ptr->side, &ptr->sector, dk);
    }
    else
        ptr->old_id = 0;
} /* end Get_One_Partn */
