/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "bootmgr.h"
#include "selemenu.h"
#include "common.h"
#include "global.h"
#include "keymap.h"

static void  Display_BootMenu_Rec (BMGR *boot, sword item, sword forceShow);
static void  Del_not_exist (void *hiddArr, PARTN *partnArr);
static sword Sele_BootMenu_Rec (BMGR *boot, sword begin);
static sword Ins_Del_Hidden (void *hiddArr, DiskDT *dk, sword partnNo);

/*========================== Reset Boot Manager =============================*/
void Reset_Bootmgr (void)
{
    Init_BMGR(g_Boot, &g_BootPara);                        /** l BootMGR **/
    g_Info.bm.updated      = FALSE;
    g_Info.bm.clr_screen  = TRUE;
} /* end Reset_Bootmgr */


/*============================== ܼƪl ===================================*/
void Init_BMGR (BMGR *boot, BOOTPARA *bootPara)
{
    memset(boot, 0, sizeof(BMGR) * REC_NUMBER);
    memset(bootPara, 0, sizeof(BOOTPARA));
    bootPara->waitTime = NO_TIMER;
} /* end Init_BMGR */


/*====================== ]wBzOο椺e =========================*/
static sword Sele_BootMenu_Rec (BMGR *boot, sword begin)
{
    extern SeleMenu g_Menu;                                /** ο檫 **/
    sword  sele, i;
 
    sele = begin;
    g_Menu.disableCtrl(M_AUTOENTER | M_LOCK);
 
    do
    {
        for ( i = 0 ; i < g_BootPara.nBootREC ; i++ )
        {
            if ( g_BootPara.sysPW[PW_LEN] || boot[i].p_wd[PW_LEN] )
                g_Menu.itemColor( BOOT_PW_COLOR );
            if ( g_BootPara.def_save == FALSE && g_BootPara.def_boot == (i + 1) )
                g_Menu.itemColor( BOOT_DEF_COLOR );    /** WΤC **/
            g_Menu.prompt(10, i + 7, boot[i].label, TRUE);
            g_Menu.itemColor(DEFAULT_COLOR);
        } /* end for */
  
        sele = g_Menu.select(sele);
        if ( g_Menu.lastKey() == ESC_KEY )                   /** YU ESC **/
            return(0);
    } while ( sele < 1 );
 
    return( sele );
} /* end Sele_BootMenu_Rec */


/*============================== קO ===================================*/
sword Modify_BootMenu_Rec (BMGR *boot, PARTN *partnArr)
{
    sword  sele;
 
    if ( (sele = Sele_BootMenu_Rec(boot, 1)) == 0 )            /** F ESC **/
        return(-1);
    return( Input_BootMenu_Rec(boot, partnArr, sele) );
} /* end Modify_BootMenu_Rec */


/*============================== hO ===================================*/
sword Move_BootMenu_Rec (BMGR *boot)
{
    #if ( DISPLAY == CHINESE )
        #define MOVE_SOURCE_ITEM_MSG    "h   @    H"
        #define MOVE_TARGET_ITEM_MSG    "h    @     m H"
    #else
        #define MOVE_SOURCE_ITEM_MSG    "Which item do you want to move ?"
        #define MOVE_TARGET_ITEM_MSG    "Where are you move to ?"
    #endif

    BMGR   *sourPtr, *tarPtr, tmp;
    sword  target, sele;
 
    ShowMSG(MOVE_SOURCE_ITEM_MSG);
    if ( (sele = Sele_BootMenu_Rec(boot, 1)) == 0 )            /** F ESC **/
        return(-1);
 
    ShowMSG(MOVE_TARGET_ITEM_MSG);
    target = Sele_BootMenu_Rec(boot, sele);
    if ( (target == 0) || (target == sele) )
        return(-1);
    else
    {
        if ( g_BootPara.def_save )
            g_BootPara.def_boot = 1;
        else
        {
            /*----- hw]} -----*/
            if ( g_BootPara.def_boot == sele )
                g_BootPara.def_boot = target;
            else if ( g_BootPara.def_boot >= target &&
                      g_BootPara.def_boot < sele )
                g_BootPara.def_boot++;
            else if ( g_BootPara.def_boot > sele &&
                      g_BootPara.def_boot <= target )
                g_BootPara.def_boot--;
        } /* end if */
  
        sele--;
        target--;
        tmp = boot[sele];                                        /** Backup **/
        if ( target > sele )                                   /** h **/
        {
            tarPtr  = boot + sele;
            sourPtr = tarPtr + 1;
            sele    = target - sele;
        }
        else                                                   /** eh **/
        {
            sourPtr = boot + target;
            tarPtr  = sourPtr + 1;
            sele   -= target;
        } /* end if */
        
        CopyMem(tarPtr, sourPtr, sizeof(BMGR) * sele);
        boot[target] = tmp;                                     /** Restore **/
    } /* end if */
 
    return(0);
} /* Move_BootMenu_Rec */


/*============================== RO ===================================*/
sword Delete_BootMenu_Rec (BMGR *boot)
{
    #if ( DISPLAY == CHINESE )
        #define SURE_TO_DELE_THE_ITEM    "T w n R   }    H"
    #else
        #define SURE_TO_DELE_THE_ITEM    "Are you sure to delete this item ?"
    #endif
 
    sword  sele;
 
    sele = Sele_BootMenu_Rec(boot, 1);                         /** X{ **/
 
    if ( (sele != 0) && YN_box(TALK_BOX, SURE_TO_DELE_THE_ITEM) )
    {
        CopyMem(&boot[sele - 1], &boot[sele],
                sizeof(BMGR) * (g_BootPara.nBootREC - sele));
                      
        g_BootPara.nBootREC--;                               /** OO **/
        memset(boot + g_BootPara.nBootREC, 0, sizeof(BMGR));
        
        if ( g_BootPara.def_save )
            g_BootPara.def_boot = 1;
        else
        {
            if ( sele < g_BootPara.def_boot )
                g_BootPara.def_boot--;
            else if ( sele == g_BootPara.def_boot )
            {
                g_BootPara.def_boot = 0;
                g_BootPara.waitTime = 0;
            } /* end if */
        } /* end if */
        
        return(0);
    } /* end if */

    return(-1);
} /* end Delete_BootMenu_Rec */


/*============================== JO ===================================*/
sword Insert_BootMenu_Rec (BMGR *boot, PARTN *partnArr)
{
    sword  moveBytes, sele;
 
    sele = ( g_BootPara.nBootREC > 1 ) ? Sele_BootMenu_Rec(boot, 1) : 1;
    if ( sele == 0 )
        return(-1);                                        /** pGF ESC **/
 
    moveBytes = sizeof(BMGR) * (g_BootPara.nBootREC - sele + 1);
    CopyMem(&boot[sele], &boot[sele - 1], moveBytes);    /** OVᮿ@ **/
    g_BootPara.nBootREC++;
 
    memset(&boot[sele - 1], 0, sizeof(BMGR));                     /** RESET **/
    boot[sele - 1].hidden = 1;

    if ( g_BootPara.def_save )
        g_BootPara.def_boot = 1;
    else if ( g_BootPara.def_boot >= sele )
        g_BootPara.def_boot++;                           /** w]۲ **/
 
    List_BootMenu_Rec(boot, g_BootPara.nBootREC);
    if ( Input_BootMenu_Rec(boot, partnArr, sele) )          /** Js **/
    {
        CopyMem(&boot[sele - 1], &boot[sele], moveBytes);  /** Ʀ^m **/
        g_BootPara.nBootREC--;
        memset(&boot[g_BootPara.nBootREC], 0, sizeof(BMGR));      /** RESET **/
        if ( g_BootPara.def_boot >= sele )
            g_BootPara.def_boot--;
        return(-1);                                            /** J **/
    } /* end if */
 
    return(0);
} /* end Insert_BootMenu_Rec */


/*============================== ܰO ===================================*/
void List_BootMenu_Rec (BMGR *boot, sword ndx)
{
    #if ( DISPLAY == CHINESE )
        #define DEFAULT_BOOT_MSG     "w]}ﶵG  "
        #define PRE_SELE_MSG         "e"
        #define NON_SETUP_MSG        "|]w"
        #define BOOT_WAIT_TIME_MSG   "}ݮɶG  "
        #define NO_TIMER_MSG         "p"
        #define NO_WAITING_MSG       ""
        #define SEC_FORMAT           "%2d  "
        #define FLOPPY_NUM_FMT       "nϺоơG%4d  "
        #define HD_NUM_FMT           "wϺоơG%4d  "

    #else
        #define DEFAULT_BOOT_MSG     "Define boot item: "
        #define PRE_SELE_MSG         "Hold Sele"
        #define NON_SETUP_MSG        "None     "
        #define BOOT_WAIT_TIME_MSG   "boot wait time:   "
        #define NO_TIMER_MSG         "No Timer "
        #define NO_WAITING_MSG       "No Wait"
        #define SEC_FORMAT           "%2d Second"
        #define FLOPPY_NUM_FMT       "Floppy Drive(s): %3d"
        #define HD_NUM_FMT           "Hard Drive(s): %5d"
    #endif
    
    sword  i;

    c_printXY(53, 4, DEFAULT_BOOT_MSG);
    if ( g_BootPara.def_save )
        c_printf(PRE_SELE_MSG);
    else if ( g_BootPara.def_boot == 0 )
        c_printf(NON_SETUP_MSG);
    else
        c_printf("%2d%7c", g_BootPara.def_boot, ' ');
       
    c_printXY(53, 5, BOOT_WAIT_TIME_MSG);
    if ( g_BootPara.waitTime == NO_TIMER )
        c_printf(NO_TIMER_MSG);
    else if ( g_BootPara.waitTime == NO_WAIT )
        c_printf(NO_WAITING_MSG);
    else
        c_printf(SEC_FORMAT, g_BootPara.waitTime);
                  
    c_printXY(53, 6, FLOPPY_NUM_FMT, g_Info.nFP);
    c_printXY(53, 7, HD_NUM_FMT, g_Info.nHD);

 
    for ( i = 1 ; i <= ndx ; i++ )
    {
        c_gotoxy(8, i + 6);
        Display_BootMenu_Rec(boot, i, FALSE);
    } /* end for */
 
    Clr_Block(7, i + 5, 49, 20);
} /* end List_BootMenu_Rec */


/*============================== ܰO ===================================*/
/* item = 1 - maxItem */
static void Display_BootMenu_Rec (BMGR *boot, sword item, sword forceShow)
{
    sword  def_flag;
    BMGR   *ptr;
 
    ptr = (item > 0) ? &boot[item - 1] : boot;
 
    if ( (ptr->label[0] == '\0') && !forceShow )
        c_printf("%*c", LAB_LEN + 28, ' ');
    else
    {
        def_flag = ((item != 0) &&
                    (g_BootPara.def_save == FALSE) && (item == g_BootPara.def_boot));
  
        c_textattr( ( g_BootPara.sysPW[PW_LEN] ||
                      ptr->p_wd[PW_LEN] ) ? BOOT_PW_COLOR  :
                       ( def_flag != 0  ) ? BOOT_DEF_COLOR : DEFAULT_COLOR );
  
        c_printf("%c %-*.*s ", ((ptr->hidden == 0) ? '*' : ' '),
                               LAB_LEN, LAB_LEN, ptr->label);
  
        if ( def_flag )
            c_textattr(BOOT_DEF_COLOR);
  
        c_printf("%5d %7d", ((ptr->disk < 0x80) ? ptr->disk : ptr->disk - 0x7f),
                            ptr->partn);
  
        if ( ptr->v_key[0] )
            c_printf("%9d", ptr->v_key[0]);
        else
            c_printf("%9c", ' ');
    } /* end if */
 
    c_textattr(DEFAULT_COLOR);
} /* end Display_BootMenu_Rec */


/*=============================  J   =================================*/
/*  ndx = 1 - max                                                            */
/*===========================================================================*/
sword Input_BootMenu_Rec (BMGR *boot, PARTN *partnArr, sword ndx)
{
    #if ( DISPLAY == CHINESE )
        static sbyte floppyMsg[] = "[Ĥ@nо]";
        static sbyte *msg[] =
        {
            "  J    (^)A  [Esc]  ",
            " n    O  X   СH ",
            " n    O  @   ΡH "
        };
    #else
        static sbyte floppyMsg[] = "First floppy";
        static sbyte *msg[] =
        {
            "What is this item explain? Press [Esc] cancel",
            "Which one would you choose disk to boot? ",
            "Which one would you choose partition to boot? "
        };
    #endif

    sword   bAppend, keyFlag, tmp, err, y;
    BMGR    dTemp, *pSele;
    sbyte   *str;
    DiskDT  *dk;
 
    memset(&dTemp, 0, sizeof(BMGR));
    dTemp.hidden = 1;

    pSele   = &boot[ndx - 1];
    bAppend = !pSele->label[0];
 
    y = ndx + 6;                                 /** p⦹ﶵbem **/
 
    if ( !g_Info.expertMode )
    {
        g_Info.bm.clr_screen = TRUE;
        PushScreenBlock(54, 9, 77, 21);                    /** xsϰe **/
  
        /*--------------------------+
        |         w      |
        +--------------------------*/
        if ( bAppend )
            tmp = 2;
        else
            tmp = ( pSele->disk >= 0x80 ) ? pSele->disk - 0x7e : 1;
        
        ShowMSG(msg[1]);
        if ( (dTemp.disk = Sele_HD(TRUE, tmp)) == (byte)-1 )
        {
            GiveupScreenBlock();
            return(-1);                                        /** J **/
        } /* end if */

        dTemp.disk--;
        g_Info.fd.modified = 0;
        if ( dTemp.disk == 0 )
            dTemp.partn = _FLOPPY_;
        else
        {                                                  /** oθT **/
            dk = GetHardDiskDT(dTemp.disk);
            dTemp.disk += 0x7f;
   
            err = Get_Disk_Info(dk, partnArr, FALSE);
            if ( err )
            {
                Disk_Err_Msg( err );
                if ( err & 0x1e )                        /** Ωεw~ **/
                {
                    GiveupScreenBlock();
                    return(-1);
                } /* end if */
            } /* end if */
   
            /*-----------------------------------------------*/
            /*  ܤΡA All_used 禡 Partnmnu.C    */
            /*-----------------------------------------------*/
            if ( bAppend )
                tmp = 1;
            else
                tmp = Find_Partn_No(partnArr, pSele->partn);
            
            ShowMSG(msg[2]);
            tmp = Sele_Partn(partnArr, tmp, 0, All_used);
            if ( tmp < 1 )
            {
                GiveupScreenBlock();
                return(-1);                                    /** J **/
            } /* end if */

            dTemp.partn = partnArr[tmp - 1].no;
        } /* end if*/
         
        Boot_Menu_Picture( TRUE );                         /** ܥDe   **/
        PopScreenBlock(54, 9, 77, 21);                     /** ^sϰe **/
  
        g_Info.bm.clr_screen = FALSE;
        List_BootMenu_Rec(boot, g_BootPara.nBootREC);          /** ܸ **/
        c_gotoxy(8, y);                                  /** ܤ~]w **/
        Display_BootMenu_Rec(&dTemp, 0, TRUE);
    } /* end if */
 
    /*-------------------------*/
    /*     J        */
    /*-------------------------*/
    if ( !g_Info.expertMode && !dTemp.disk && bAppend )          /* n */
        strcpy(dTemp.label, floppyMsg);
    else
    {
        ShowMSG(msg[0]);
        sprintf(dTemp.label, "%.*s", LAB_LEN, pSele->label);
        c_gotoxy(10, y);
        do
        {
            if ( GetStr(dTemp.label, LAB_LEN, HAS_INITIAL | ALLOW_SPACE | ALLOW_ESC) == ESC_KEY )
                return(-1);                                    /** J **/
            for ( str = dTemp.label ; *str == ' ' ; str++ );
        } while ( *str == '\0' );
    } /* end if */

    if ( g_Info.expertMode )
    {
        keyFlag = ( !bAppend ) ? ALLOW_ESC | HAS_INITIAL : ALLOW_ESC;
        
        /*--------------------------*/
        /*      J          */
        /*--------------------------*/
        ShowMSG(msg[1]);
        c_printf("(0: %s)", floppyMsg); 
        c_gotoxy(LAB_LEN + 14, y);
        tmp = pSele->disk;
        if ( tmp >= 0x80 )
            tmp -= 0x7f;
        if ( InputWORD(&tmp, 0, 99/*g_Info.nHD*/, 2, keyFlag) == ESC_KEY )
            return(-1);                                        /** J **/
  
        /*-------------------------*/
        /*     J        */
        /*-------------------------*/
        if ( tmp == 0 )                                          /** Floppy **/
            dTemp.disk = tmp;
        else
        {   
            dTemp.disk = tmp + 0x7f;                                 /** HD **/
            ShowMSG(msg[2]);
            c_gotoxy(LAB_LEN + 22, y);
            tmp = pSele->partn;
            if ( InputWORD(&tmp, 1, MAX_PARTN_ELEM, 2, keyFlag) == ESC_KEY )
                return(-1);                                    /** J **/
            dTemp.partn = tmp;
        } /* end if */
    } /* end if */
  
    *pSele = dTemp;
    return(0);
} /* end Input_BootMenu_Rec */


/*============================== ]w ===================================*/
void Set_Hidden_OnSameKindPartn (BMGR *boot)
{
    #if ( DISPLAY == CHINESE )
        #define HIDDEN_SAME_PARTN    "}     P  D   H"
    #else
        #define HIDDEN_SAME_PARTN    "Hidden same partition at boot ?"
    #endif
    
    sword  sele;
 
    if ( (sele = Sele_BootMenu_Rec(boot, 1)) != 0 )            /** F ESC **/
        boot[sele - 1].hidden = YN_box(TALK_BOX, HIDDEN_SAME_PARTN);
} /* end Set_Hidden_OnSameKindPartn */


/*=========================== j]wҰʺX ==============================*/
void Set_Active_OnBoot (BMGR *boot)
{
    #if ( DISPLAY == CHINESE )
        #define BOOT_TIME_SET_ACTIVE    "}   ]      H"
    #else
        #define BOOT_TIME_SET_ACTIVE    "Set to active partition at boot ?"
    #endif

    sword  sele;
 
    if ( (sele = Sele_BootMenu_Rec(boot, 1)) != 0 )            /** F ESC **/
        boot[sele-1].active = YN_box(TALK_BOX, BOOT_TIME_SET_ACTIVE);
} /* end Set_Active_OnBoot */


/*========================= ]w}wЬĤ@ ============================*/
void Set_Disk_Swap (BMGR *boot)
{
    #if ( DISPLAY == CHINESE )
        #define BOOT_TIME_SET_TO_FIRST    "}ɳ]Ĥ@w (INT 13h)H\nDOSBWindows MΡC"
    #else
        #define BOOT_TIME_SET_TO_FIRST    "Change to first HD at boot time ?\nIt use INT 13h for DOS, Windows!"
    #endif

    sword  sele;
 
    if ( (sele = Sele_BootMenu_Rec(boot, 1)) != 0 )            /** F ESC **/
        boot[sele-1].noSwap = !YN_box(TALK_BOX, BOOT_TIME_SET_TO_FIRST);
} /* end Set_Disk_Swap */


/*============================ ]w =================================*/
void Set_Virtual_Key (BMGR *boot)
{
    #if ( DISPLAY == CHINESE )
        #define START_INPUT_KEY    "{ b  } l  J     X  (Alt-Z:)G %d "
    #else
        #define START_INPUT_KEY    "Please begin input macro key(Alt-Z:OK): %d"
    #endif

    sword  sele, i;
    word   key;
 
    if ( (sele = Sele_BootMenu_Rec(boot, 1)) == 0 )            /** ܰO **/
        return;                                                /** F ESC **/
 
    sele--;
    i = 0;
    while ( 1 )
    {
        ShowMSG(START_INPUT_KEY, i);
        key = c_get_real_key();        /** get key ascii code and scan code **/
        if ( key == A_Z_KEY )
            break;
        if ( i < KEY_NUM )                        /** u KEY_NUM ӫ **/
            boot[sele].v_key[++i] = key;
        else
            Beep();
    } /* end while */
 
    boot[sele].v_key[0] = i;
    for ( ++i ; i <= KEY_NUM ; i++ )                                /**  0 **/
        boot[sele].v_key[i] = 0;
 
    g_Info.bm.updated = TRUE;
} /* end Set_Virtual_Key */


/*============================== ]wKX ===================================*/
sword Set_Password (BMGR *boot)
{
    #if ( DISPLAY == CHINESE )
        #define CANCEL_PASSWD_MSG       "    q  X I"
        #define NO_SETUP_PASSWD_MSG     "|  ] w q  X I"
        #define INPUT_PASSWORD          "  J K X G"
        #define INPUT_PASSWORD_AGAIN    "A  J @  G"
        static sbyte *menu[] =
        {
            "1)]wtαKX", "2)MtαKX",
            "3)]w涵KX", "4)M涵KX"
        };
    #else
        #define CANCEL_PASSWD_MSG       "Clear password success !"
        #define NO_SETUP_PASSWD_MSG     "No set any password !"
        #define INPUT_PASSWORD          "Please input password: "
        #define INPUT_PASSWORD_AGAIN    "Please input again: "
        static sbyte *menu[] =
        {
            "1. Set Sys_PW",  "2. Clr Sys_PW",
            "3. Set Item_PW", "4. Clr Item_PW"
        };
    #endif

    extern SeleMenu g_Menu;                                /** ο檫 **/
    sbyte  ming[PW_LEN + 1], passwd[PW_LEN + 1], *ptr;
    sword  sele, seed, i;
    byte   *pwPTR;
 
    memset(passwd, 0, PW_LEN + 1/*sizeof(passwd)*/);
    memset(ming,   0, PW_LEN + 1/*sizeof(ming)*/);
 
    ShowMSG(NULL);
    for ( i = 0 ; i < sizeof(menu) / sizeof(sbyte *) ; i++ )
        g_Menu.prompt(13 + (menu[i] - menu[0]) + i * 2, 23, menu[i], TRUE);
 
    if ( (sele = g_Menu.select(1)) < 1 )
        return(0);
    else if ( sele <= 2 )
        pwPTR = g_BootPara.sysPW;
    else
    {
        if ( (i = Sele_BootMenu_Rec(boot, 1)) == 0 )       /** pGF ESC **/
            return(0);
        pwPTR = boot[i - 1].p_wd;
    } /* end if */
 
    if ( sele == 2 || sele == 4 )
    {
        if ( pwPTR[PW_LEN] )
        {
            pwPTR[PW_LEN] = 0;                           /** KX׳] 0 **/
            ptr = CANCEL_PASSWD_MSG;
        }
        else
            ptr = NO_SETUP_PASSWD_MSG;
  
        Prompt_Msg_Box(ptr, NULL);
        return(0);
    } /* end if */

    ShowMSG(INPUT_PASSWORD);
    if ( GetStr(ming, PW_LEN, PASSWORD | ALLOW_SPACE | ALLOW_ESC) != ESC_KEY )
    {
        if ( *ming == '\0' )
            return( FALSE );
  
        ShowMSG(INPUT_PASSWORD_AGAIN);
        if ( GetStr(passwd, PW_LEN, PASSWORD | ALLOW_SPACE | ALLOW_ESC) != ESC_KEY )
        {
            if ( strcmp(ming, passwd) != 0 )
                ShowError( 15 );                           /** KX]w **/
            else
            {
                randomize();
                seed = random(256);
                Encoder((byte *)ming, (byte)seed, (byte *)passwd);

                passwd[PW_LEN] = (byte)seed;             /** bڦsJ_ **/
                CopyMem(pwPTR, passwd, PW_LEN + 1);      /** ƻsͪK **/
                return( TRUE );
            } /* end if */
        } /* end if */
    } /* end if */
 
    return( FALSE );
} /* end Set_Password */


/*=============================== w]}ﶵ ==============================*/
void Set_Default_Boot (BMGR *boot)
{
    #if ( DISPLAY == CHINESE )
        #define SELE_DEFAULT_BOOT_ITEM  "   w ] }    (ESC:)"
        #define INPUT_WAIT_TIME         "  J }      (0:ݡA1-99)H "
        static sbyte *menu[] =
        {
            "1) Tww] ", "2) xsW} ", "3) Mw] "
        };
    #else
        #define SELE_DEFAULT_BOOT_ITEM  "Please choice define boot item (ESC:Cancel)"
        #define INPUT_WAIT_TIME         "Please input boot waiting time (0:no wait, 1-99)? "
        static sbyte *menu[] =
        {
            "1. Fixed default", "2. Hold select", "3. Clear default"
        };
    #endif
    
    extern SeleMenu g_Menu;                                /** ο檫 **/
    sword  def_sele, second, sele, i;
 
    ShowMSG(NULL);
    for ( i = 0 ; i < sizeof(menu) / sizeof(sbyte *) ; i++ )
        g_Menu.prompt(13 + (menu[i] - menu[0]) + i * 3, 23, menu[i], TRUE);
 
    if ( (sele = g_Menu.select(1)) < 1 )
        return;
 
    if ( sele == 3 )
    {
        def_sele = 0;
        second   = NO_TIMER;
    }
    else
    {
        if ( sele == 1 )
        {
            
            ShowMSG(SELE_DEFAULT_BOOT_ITEM);
            if ( (def_sele = Sele_BootMenu_Rec(boot, 1)) == 0 )/** ܰO **/
                return;                                        /** F ESC **/
        } /* end if */
  
        ShowMSG (INPUT_WAIT_TIME);
        if ( InputWORD(&second, 0, 99, 2, ALLOW_ESC) == ESC_KEY )
           return;
    } /* end if */
 
    if ( sele == 2 )                                           /** e **/
    {
        def_sele = 1;
        g_BootPara.def_save = TRUE;
    }
    else
        g_BootPara.def_save = FALSE;
 
    g_BootPara.def_boot = def_sele;
    g_BootPara.waitTime = second;
} /* end Set_Default_Boot */


/*========================== ϥΪ̦۩wä =============================*/
void User_Define_Hidden (BMGR *boot, PARTN *partnArr)
{    
    #if ( DISPLAY == CHINESE )
        #define SELE_SET_ITEM     "    ] w    (ESC:)"
        #define PROMPT_KEY_MSG    "[Esc]:^DA [TAB]:wСA [][] :]w/"
        #define HIDD_PROMPT       "  : %-2d"
        #define HIDD_FULL_MSG     "  ƶqw"
    #else
        #define SELE_SET_ITEM     "Please choice the item (ESC:Cancel)"
        #define PROMPT_KEY_MSG    "[Esc]:Back Menu, [TAB]:Work HD, [][] :Setup/Cancel"
        #define HIDD_PROMPT       "Hidden: %-2d"
        #define HIDD_FULL_MSG     " Hidd Full"
    #endif

    extern SeleMenu g_Menu;                                /** ο檫 **/
    sword  sele, ndx, num, key, err;
    byte   *ptr;
 
    ShowMSG(SELE_SET_ITEM);
    if ( (sele = Sele_BootMenu_Rec(boot, 1)) == 0 )            /** ܰO **/
        return;                                                    /**  **/
 
    g_Info.bm.clr_screen = TRUE;
 
    sele--;
    ptr = (byte *)boot[sele].h_partn;
    Del_not_exist(ptr, partnArr);                  /** RsbϺФ **/
 
    /*------------------------------------------------------------+
    |          p    w ] w       q          |
    +------------------------------------------------------------*/
    for ( num = 0 ; (*ptr != 0) && (num < 20) ; num++,  ptr += 2 );
 
    key = TAB_KEY;
    while ( key != ESC_KEY )
    {
        if ( key == TAB_KEY )                                /** u@ **/
        {
            g_Info.fd.modified = 0;
            err = Chg_Work_Disk(partnArr);                 /** oθT **/
            if ( err & 0x40 )
                break;
            else if ( err & 0x80 )                             /** w~ **/
                continue;

            Redraw_Fdisk_Picture(TRUE);
            ShowMSG(PROMPT_KEY_MSG);
        } /* end if */
  
        set_boot_variable(sele, num);      /** ]w partnmnu.c @ܼ **/
        
        if ( num < HIDD_ITEM )
            c_printXY(69, 23, HIDD_PROMPT, num);
        else
            c_printXY(69, 23, HIDD_FULL_MSG);
  
        /*--------------------------------------------------------+
        |    ܤΡA User_hidden_set 禡 Partnmnu.C     |
        +--------------------------------------------------------*/
        ndx = Sele_Partn(partnArr, 0, MOVE_LIGHT_BAR | NO_REDRAW_MENU, User_hidden_set);
        key = g_Menu.lastKey();
        if ( ndx > 0 )
        {
            num += Ins_Del_Hidden(boot[sele].h_partn, CUR_DK, partnArr[ndx - 1].no);
            g_Info.bm.updated = TRUE;
        } /* end if */
    } /* end while */
} /* end User_Define_Hidden */


/*----------------------------------------------------------------------------+
|                     J  R  @   w                       |
+-----------------------------------------------------------------------------+
|  hiddArr Ұʺ޲z浲csϥΪ̩ҳ]wy۩wäΡz}CA} |
|          CcC byte @աALow byte swХN 0x80, 0x81....   |
|          High byte hOêνsA}CH 0 r                  |
+----------------------------------------------------------------------------*/
static sword Ins_Del_Hidden (void *hiddArr, DiskDT *dk, sword partnNo)
{
    word   data, tmp;
    byte   *ptr;
    sword  ret;
 
    /*----- MO_nL -----*/
    ptr = (byte *)hiddArr;
 
    while ( (*ptr) &&                                                             
            ((*ptr < dk->diskNO) || (*ptr == dk->diskNO) && (*(ptr+1) < partnNo)) ) 
        ptr += 2;

    /*-----------------------------+
    |  pGsbh[JAϤR  |
    +-----------------------------*/
    if ( (*ptr == 0) || (*ptr != dk->diskNO) || (*(ptr+1) != partnNo) )
    {
        ret  = 1;
        data = (partnNo << 8) + dk->diskNO;          /** assemble 2 bytes   **/
        for ( ; data ; ptr += 2 )                    /** JƨlVᮿ **/
        {
            tmp  = *(word *)ptr;
            *(word *)ptr = data;
            data = tmp;
        } /* end for */
    }
    else
    {
        ret = -1;
        for ( ; *ptr ; ptr += 2 )                    /** ƨlVe **/
            *(word *)ptr = *(word *)(ptr + 2);
    } /* end if */
 
    return( ret );
} /* end Ins_Del_Hidden */


/*======================= Rsbäγ]w ==========================*/
static void Del_not_exist (void *hiddArr, PARTN *partnArr)
{
    byte    curDisk, *okData, *ptr, *end;
    sword   status, err;
    DiskDT  *dk;
 
    okData  = ptr = (byte *)hiddArr;
    end     = ptr + (HIDD_ITEM * 2);
    curDisk = 0x7f;
    status  = 1;

    *(word *)end = 0;

    while ( status )
    {
        if ( ptr >= end )
           status = 5;

        switch ( status )
        {
            case 1:
                status = ( (++curDisk - 0x80) < g_Info.nHD ) ? 2 : 5;
                break;
            case 2:
                if ( *ptr == 0 )
                    status = 5;
                else if ( *ptr >= curDisk )
                    status = 3;
                else if ( (ptr += 2) >= end )             /** to next field **/
                    status = 5;
                break;
            case 3:
                curDisk = *ptr;
                dk      = GetHardDiskDT(curDisk - 0x7f);
                err     = Get_Disk_Info(dk, partnArr, FALSE);
                status  = ( (err & 0x1a) == 0 ) ? 4 : 1;
                break;
            case 4:
                if ( (*ptr != curDisk) || (*(ptr+1) > g_Info.fd.maxParNO) )
                {
                    status = 1;
                    break;
                }
                else if ( *(ptr+1) > 4 ||
                          Find_Partn_No(partnArr, *(ptr+1)) )
                {
                    *(word *)okData = *(word *)ptr;
                    okData += 2;
                } /* end if*/

                if ( (ptr += 2) >= end )                  /** to next field **/
                    status = 5;
                break;
            case 5:
                memset(okData, 0, end - okData + 2);
                status = 0;
                break;
        } /* end switch */
    } /* end while */
} /* end Del_not_exist */

