/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#ifndef __BOOTMGR_H__
#define __BOOTMGR_H__

#ifndef __FDISK_H_
   #include "fdisk.h"
#endif

#define  REC_NUMBER         15                       /** Ұʺ޲z Menu  **/
#define  LAB_LEN            15                               /** r **/
#define  KEY_NUM            10                               /** Ӽ **/
#define  PW_LEN             11                               /** KX   **/
#define  HIDD_ITEM          20                               /** iö **/

#define  VER_LINE            0
#define  BMG_EXPERT_MODE     1


/*----------------------+
|        c   |
+----------------------*/
typedef struct STRU_BMGR
{
   sbyte label[LAB_LEN + 1];
   byte  disk;
   byte  partn;
   word  v_key[KEY_NUM + 1];
   byte  p_wd[PW_LEN + 1];
   byte  h_partn[HIDD_ITEM + 1][2];              /** sêϺСB **/
   byte  active;                                 /**       j]wʺX **/
   byte  hidden;                                 /**   jæPD **/
   word  sysID;                                  /**      }ɦst ID **/
   byte  noSwap;                                 /**   N}ܦĤ@ **/
   byte  hold[7];
} BMGR;


/*----------------------+
|        c   |
+----------------------*/
typedef struct STRU_BOOTPARA
{
   byte   instDisk,                                    /**       w˪Ϻ **/
          instPartn,                                   /**       w˪ **/
          nDataSect,                                   /**   Ʀκϰϼ **/
          nCodeSect,                                   /**   {κϰϼ **/
          def_save;                                    /**     w]ﶵҦ **/
   sbyte  def_boot;                                    /**     w]Ұʿﶵ **/
   byte   nBootREC;                                    /** ϥΪ涵 **/
   word   waitTime;                                    /**         ݮɶ **/
   dword  codeBegin,                                   /**   {qҩlϰ **/
          dataBegin;                                   /**   Ƭqҩlϰ **/
   byte   sysPW[PW_LEN + 1],                           /**         tαKX **/
          hold[8];
} BOOTPARA;


typedef struct PackageStru
{
   dword  start;
   word   cyl;
   word   head;
   word   sector;
   byte   disk;
   byte   nSects;
} PACKAGE;


/*-----------------------------------+
|   Boot Manager Loader Infomation   |
+-----------------------------------*/
typedef struct kernel_loader
{
   byte  jumpCode[3];
   sbyte mark[8];                                                  /**  **/
   word  magicNum,
         version;
   byte  nCodeSect,                                /** ֤ߵ{qκϰϼ **/
         nDataSect,                                /** ֤߸Ƭqκϰϼ **/
         disk;                                                 /** ҦbϺ **/
   word  cyl;                                                      /** ϬW **/
   byte  head,                                                     /** Y **/
         sector;                                                   /** ϰ **/
   dword begin;                                                /** ҩlϰ **/
} KERL_LDR;


/*=============================    i =================================*/
void  Reset_Bootmgr (void);
void  Init_BMGR (BMGR *boot, BOOTPARA *BootPara);
void  Boot_Menu_Picture (sword flag);
void  ShowExtra (sword showKind);
void  Install_Boot_Menu (BMGR *boot, PARTN *partnArr);
void  List_BootMenu_Rec (BMGR *boot, sword Number);
void  Set_Hidden_OnSameKindPartn (BMGR *boot);
void  Set_Active_OnBoot (BMGR *boot);
void  Set_Disk_Swap (BMGR *boot);
void  Set_Virtual_Key (BMGR *boot);
void  Set_Default_Boot (BMGR *boot);
void  User_Define_Hidden (BMGR *boot, PARTN *partnArr);
void  set_boot_variable (sword now_item, sword num);
void  Locate_show (sword x, sword y, const sbyte *str);

sword Delete_BootMenu_Rec (BMGR *boot);
sword Bootmgr_Menu (sword begin, BMGR *boot, PARTN *partnArr);
sword Bootmgr_Edit_Menu (sword begin, BMGR *boot, PARTN *partnArr);
sword Bootmgr_Option_Menu (sword begin, BMGR *boot, PARTN *partnArr);
sword Insert_BootMenu_Rec (BMGR *boot, PARTN *partnArr);
sword Input_BootMenu_Rec (BMGR *boot, PARTN *partnArr, sword Number);
sword Move_BootMenu_Rec (BMGR *boot);
sword Modify_BootMenu_Rec (BMGR *boot, PARTN *partnArr);
sword load_file (BMGR *boot);
sword save_file (BMGR *boot);
sword Load_Menu (BMGR *boot, PARTN *partnArr);
sword read_bootmenu (DiskDT *dk, dword begin);
sword Set_Password (BMGR *boot);

sword GetBootCode_nSect (void);
sword GetBootData_nSect (void);
sword GetBootmgr_nSect (void);

/*-------------------------------------------+
|   Boot manager kernel function proto type  |
+-------------------------------------------*/
void  BootHead (void);
void  ShowNum (word val, word radix);
void  Encoder (byte *Ming, byte Seed, byte *Target);

/** void   Set_Vector (sword intr, void interrupt (*vect)()); **/
void  Set_Vector (sword intr, void (FAR *vect)(void));

/** void   interrupt (*Get_Vector(sword intr))();  **/
void (FAR *Get_Vector(sword intr))(void);

void  SetColor (sword color);

sword CompMEM (void *m1, void *m2, sword len);
sword GetPartn (byte disk, byte partn, dword *partnAddr, byte *buff);
sword Reset_Disk (sword disk);
sword Ctrl_DrvExchg (byte ctrl);
sword INT_13H (byte cmd, byte Disk, word head,
               word cyl, word sect, byte nSects, void far *buff);

void  End_of_BMGR (void);


/*=============================   w q =================================*/
/*-------------------------+
|   Ұʺ޲z{֤ߪ   |
+-------------------------*/
#define NO_TIMER                 0xffff
#define NO_WAIT                  0

#define PAGE_ITEM                5                       /** Cܪ **/
#define MENU_X                  12                       /** Ұʿ檺y **/
#define MENU_Y                   3
#define END_MENU_X              (MENU_X + 57)
#define END_MENU_Y              (MENU_Y + 14)

#define PASSWD_X                (MENU_X + 12)
#define PASSWD_Y                (MENU_Y + 9)
#define ERROR_X                 (MENU_X + 7)        /** BMGR ~Ty **/
#define ERROR_Y                 21

#if 0
   #define ERROR_X              0                   /** BMGR ~Ty **/
   #define ERROR_Y              (END_MENU_Y + 3)
   #define BG_CHAR              ''                            /** Ir **/
   #define BG_CHAR              ''                            /** Ir **/
   #define BG_CHAR              ''                            /** Ir **/
#endif

#define BG_CHAR                 ''                            /** Ir **/

#define LIGHT_BAR_BG            (CYAN << 4)                    /** Qզr **/
#define INVALID_COLOR           (BLUE << 4) + LIGHTGRAY
#define DEF_COLOR               (BLUE << 4) + WHITE            /** ũզr **/
#define PASSWD_COLOR            (BLUE << 4) + LIGHTRED
#define DEF_SELE_COLOR          (BLUE << 4) + CYAN
#define PMT_COLOR               (RED  << 4) + WHITE            /** զr **/
#define BACKGB_COLOR            (CYAN << 4) + BROWN

#if ( DISPLAY == TEXTMODE )
   #define WALL_COLOR              (BLACK << 4) + CYAN
#else
   #define WALL_COLOR              (DARKGRAY << 4) + CYAN    
                           /**  (DARKGRAY << 4) + BROWN   **/
#endif

#if ( DISPLAY == TEXTMODE )
   #define ERROR_COLOR          ((RED << 4) + WHITE)
#else
   #define ERROR_COLOR          ((WHITE << 4) + LIGHTRED)
#endif

#define CODE_SEG                0x7000
#define DATA_SEG                0x8000

#define CLK_PER_SEC             18

#endif

