/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+-----------------------------------------------------------------------------+
| Bug fix:                                                                    |
|                                                                             |
|     SPF01:   modify Access_HD(....) function, 2000.09.06                    |
|     SPF02:   modify BootHead(....)  function, 2001.03.04                    |
|     SPF03:   modify Access_HD(....) function, 2001.06.05                    |
|     SPF04:   modify Access_HD(....) function, 2001.08.17                    |
|                                                                             |
+----------------------------------------------------------------------------*/
#include <conio.h>
#include "common.h"
#include "bootmgr.h"
#include "fdisk.h"
#include "global.h"
#include "keymap.h"

#define USE_BIOSCALL_FUNC       (   1)
#define PROCESS_BEEP_CHAR       (   1)
#define SELE_REG_EVERY_DRAW     (   1)

static sword Input_PassWord (byte *SysPW, byte *ItemPW);
static sword SeleBoot (sword start);
static sword Load_Boot (sword sele, dword *begin, byte FAR *osLoader);
static sword GetExt (byte *buff, word offset, byte *dosID);
static sword KB_Hit (void);
static sword SetDiskPara (byte disk);
static sword GetCHS (PACKAGE *pkg);
static sword Access_HD (byte cmd, PACKAGE *pkg, void FAR *buff);

static word  GetKey (void);
static word  LongDIV (dword v1, word v2);
static word  LongMOD (dword v1, word v2);

static void  InitialBootMGR (sword defboot);
static byte  Asm_Init_BootMGR_Env (void);
static void  IntoOsEntry (sword disk);
static void  StartTimer (void);
static void  StopTimer (void);
static void  Chg_INT_1E (void);
static void  Chg_INT_13 (sword sele);

static void  ShowBMGR (void);
static void  ShowPict (void);
static void  ShowSelePrompt (word sec, byte sele);
static void  ShowSEC (word sec);
static void  Hidd_DEF (byte *h_partn);
static void  Save_Sele (sword sele);
static void  Hidden_off (void);
static byte  Move_Up (byte sele, byte *seleY);
static byte  Move_Down (byte sele, byte *seleY);

static void  ShowItem (sword sele, sword y, sword lightBar);
static void  Beep (void);

static byte  Hidd_Same (byte partn, byte *buff);
static sword HideOnPartnByAddr (void *addr, sword no);
static sword HideOffPartnByAddr (void *addr, sword no);
static byte  GetLogicNum (byte disk, byte partn);
static byte  Chg_Active (byte partn, byte *buff);

#if ( DISPLAY == CHINESE )
    static void  Show_Chi (byte *aWord, sword x, sword y, byte color, byte color2);
    static sword IsExtChiChar (byte *str);
    static sword Get_Chinese_Font (byte *str, byte FAR **pBuf);
    static FONT  *SearchFont (FONT *pFont, byte *key, sword begin, sword end);
#endif /* CHINESE */


#if ( DISPLAY != TEXTMODE )
    static byte  FAR *GetEnglishFontEntry (void);
    static void  Adjust_XY (sword *x, sword *y);
    static sword IsExtEngChar (sbyte ch);
    static void  CursorShow (void);
    static void  CursorHidden (void);
    static void  Draw_Cursor (word x, word y, byte color);
    static void  Draw_pixel_vram (word x, word y, byte color, sword mask);
    static void  Show_Eng (byte aChar, sword x, sword y, byte color);
    static void  Get_English_Font (byte ch, byte FAR **pBuf);
    static sword IsCtrlChar (byte chr, sword *x, sword *y);

    /* file scope variable */
    static CharData  gs_ChTmp;   /** Yo{O媺 high byte h queue  **/
    static byte      FAR *gs_EngFont;        /** English font start address **/
#endif  /* !TEXTMODE */

static void PreviewTimerIntr (void);
static void BootTimerIntr (void);

static void (FAR *gs_OldTmIntr)(void) = NULL;  /** save old timer ISR entry **/
static void (FAR *gs_MyTmIntr)(void)  = (void (FAR *)(void))PreviewTimerIntr;

static byte  gs_HiddenSW;          /** æPDΥ\ध}AwҰ **/
static byte  gs_NowDisk = -1;
static byte  gs_DiskErr = -1;
static byte  gs_DiskNum;
static word  gs_MaxHead;
static word  gs_MaxSect;

/*---------------------------- {  _ ] I -------------------------------*/
void BootHead (void)
{
    #if ( DISPLAY == CHINESE )
        sword  nFonts;
    #endif

    byte FAR *osLoader = (byte FAR *)MAKE_FP(0x07c0, 0);
    BMGR     *selePtr;
    word     *ptr;
    dword    loadSector;
    sword    partn, disk, sele, i;
    sword    defboot;

    if ( !bm_BootTime )
    {
        #if ( DISPLAY == CHINESE )
            nFonts  = g_nFont;
            g_nFont = 0;                  /** Ұʺ޲z{åw g_Font[] **/
        #endif
    }
    else
    {
        #if ( DISPLAY == TEXTMODE )
            IntoTextMode();
            Ctrl_Cursor(FALSE);                                /** ô **/
        #else
            IntoGraphicMode();
        #endif
    } /* end if */
 
    defboot = g_BootPara.def_boot;
    InitialBootMGR(defboot);        /** Iܼƪl & `t ID T **/

BOOT_MENU:
 
    /*----------------------+
    |               |
    +----------------------*/
    sele = 0;
    if ( g_BootPara.nBootREC > 1 )             /** ܤ֭nӿﶵ~X{ **/
        sele = SeleBoot(defboot) - 1;      /** ο浥ݨϥΪ̿ܶ} **/

    selePtr = &g_Boot[sele];
    disk    = selePtr->disk;
    partn   = selePtr->partn;
 
    /*---------------------------+
    |       J}qKX     |
    +---------------------------*/
    if ( (g_BootPara.sysPW[PW_LEN] || selePtr->p_wd[PW_LEN]) &&/** ]KX **/
         Input_PassWord(g_BootPara.sysPW, selePtr->p_wd) != 0 &&
         bm_BootTime )
    {
        defboot = sele + 1;
        goto BOOT_MENU;                                    /** ^} **/
    } /* end if */

    if ( !bm_BootTime )                                    /** preview mode **/
    {
        #if ( DISPLAY == CHINESE )
            g_nFont = nFonts;
        #endif
        return;
    } /* end if */

    /*----------------------------------------+
    |          Q           |
    +----------------------------------------*/
    if ( gs_HiddenSW )                                        /** } ON **/
        Hidden_off();
 
    /*--------------------------------------------+
    |  NҰʺϰϸJ 0000:7C00h ûsyҰ   |
    +--------------------------------------------*/
    if ( Load_Boot(sele, &loadSector, osLoader) )
    {
        SetColor( ERROR_COLOR );                               /** pG **/
        Clr_Block(ERROR_X - 2, ERROR_Y - 1, ERROR_X + 45, ERROR_Y + 1);
        SetXY(ERROR_X, ERROR_Y);
        ColorStr( bm_ErrorMsg );                               /** ~T **/
        GetKey();
               
        bm_Timer = NO_TIMER;                               /** pɾl **/
        goto  BOOT_MENU;
    } /* end if */
 
    /*-------------------------------------+
    |   N   }    s J     |
    +-------------------------------------*/
    sele++;
    if ( g_BootPara.nBootREC > 1 &&                    /** ﶵ`Ƥj󢰵 **/
         g_BootPara.def_save != FALSE &&               /** OdҰʿ **/
         defboot != sele )                         /** Ұʿﶵw] **/
    {
        Save_Sele(sele);
    } /* end if */
    sele--;
 
    /*----------------------------------+
    |         w      |
    +----------------------------------*/
    if ( selePtr->h_partn[0][0] )        /** VҰʶ̪۩wäθ **/
        Hidd_DEF((byte *)selePtr->h_partn);
 
    /*------------------------------------------------------------+
    |   dI INT 13h (ϺФ DOS ĤGwХHᤧwЯ})  |
    +-------------------------------------------------------------+
    |  modify by SPF02                                            |
    +------------------------------------------------------------*/
    if ( disk >= 0x80 &&
         selePtr->sysID == 7 &&
         osLoader[3] == 'O' && osLoader[4] == 'S' && osLoader[5] == '2' )
    {
        osLoader[0x24] = disk;                /** pGO OS/2 HPFS ɮרt **/
        if ( partn < 5 )                                 /** pGD **/
            osLoader[0x25] = disk;
        else
        {
            *(dword FAR *)&osLoader[0x1c] = loadSector;/** Jҩlϰ **/
            osLoader[0x25] = GetLogicNum(disk, partn); /** J޿ϺХN **/
        } /* end if */
    }
    else if ( disk > 0x80 &&
              ChkSysID(selePtr->sysID, NT_FAT12_16_32) )       /** dos, win **/
    {
        /*----------------------+
        |  ҰʺϺХN\ |
        +----------------------*/
        if ( selePtr->noSwap == 0 )
        {
            Chg_INT_13(sele);                              /** dI INT 13h **/
            Ctrl_DrvExchg( DISK_XCHG );                    /** ҥκϺиm **/
        } /* end if */
    } /* end if */
 
    /*----------------------------+
    |        MLwİ       |
    +----------------------------*/
    while ( KB_Hit() )
        GetKey();

    /*---------------------------+
    |   NJLwİ   |
    +---------------------------*/
    ptr = selePtr->v_key;
    for ( i = *ptr++ ; i > 0 ; i-- )               /** Ĥ@ word s **/
        PushKey(*ptr++);
 
    IntoTextMode();                                        /** ^rҦ **/
    IntoOsEntry(disk);
} /* end BootHead */


/*-------------------------- I      l  ------------------------*/
static void InitialBootMGR (sword defboot)
{
    byte     bootSect[512], buff[512];
    sword    offset, i;
    dword    extStart;
    word     sysID;
    BMGR     *bptr;
    PACKAGE  pkg;

    /* bm_BootTime = TRUE; */                        /** move to loader.asm **/

    gs_HiddenSW = TRUE;            /** æPDΥ\ध}AwҰ **/
    gs_NowDisk  = -1;
    gs_DiskErr  = -1;
    SetDiskPara(0x80);                             /** ]wϺаѼƦ@ܼ **/

    gs_DiskNum = Asm_Init_BootMGR_Env();
    pkg.nSects = 1;

    gs_OldTmIntr = NULL;
    if ( bm_BootTime )
    {
        extStart    = (dword)((byte *)BootTimerIntr - (byte *)BootHead);
        gs_MyTmIntr = (void (FAR *)())MAKE_FP(CODE_SEG, extStart);
    } /* end if */

    /*------------------------------------+
    |   oUﶵҫΥثet ID   |
    +------------------------------------*/
    bptr = g_Boot;
    for ( i = 0 ; i < g_BootPara.nBootREC ; i++, bptr++ )
    {
        if ( bptr->disk < 0x80 )                       /** ﶵ}Ϻ **/
            sysID = FLOPPY_ID;
        else
        {
            /*----------------- owΪ buffer ---------------*/
            offset = GetPartn(bptr->disk, bptr->partn, &extStart, buff);
            if ( offset < 0 || buff[offset + 4] == 0 )   /** pGΤsb **/
                sysID = NOT_EXIST_ID;           /** JΤsbU ID **/
            else
            {
                pkg.disk  = bptr->disk;
                pkg.start = extStart + *(dword *)&buff[offset + 8];
      
                if ( Access_HD(2, &pkg, bootSect) ||   /** ŪҰʰϺϥ **/
                     *(dword *)bootSect == 0 ||
                     *(word *)&bootSect[0x1fe] != 0xaa55 ) /** LıҰʺϰ **/
                {
                    sysID = NOT_EXIST_ID;
                }
                else
                {
                    /* modified for dos hidden ID by SPF, 2002.05.01 */
                    sysID = buff[offset + 4];            /** get system id  **/
                    if ( IsHiddenID(sysID) )
                    {
                        if ( IsHiddenWinID(sysID) )
                            sysID &= 0x0f;
                        else
                        {
                            offset = HIDD_BAK;
                            if ( bptr->partn < 5 )         /** pGOD **/
                                offset += (bptr->partn - 1);
                            sysID = ( buff[offset] ) ? buff[offset] : BAD_HIDD_ID;
                        } /* end if */
                    } /* end if */
                } /* end if */
            } /* end if */
        } /* end if */
    
        bptr->sysID = sysID;                                /** Jt ID **/
    } /* end for */
 
    if ( g_Boot[defboot - 1].sysID == NOT_EXIST_ID )
        bm_Timer = NO_TIMER;         /** Yw]}OLkҰʪhp **/
    else
        bm_Timer = g_BootPara.waitTime;                    /** pɾl **/
} /* end InitialBootMGR */


/*---------------------------- Show Background ------------------------------*/
static void ShowBMGR (void)
{
    sword  y;
    
    SetColor( BACKGB_COLOR );                        /** ܦrAզr **/
    for ( y = 0 ; y < 24 ; y++ )
    {
       SetXY(0, y);
       Repeat_Char(BG_CHAR, 80);
    } /* end for */
 
    SetColor( PMT_COLOR );                           /** ܦrAզr **/
    Clr_Block(0, 24, 79, 24);                                  /** I **/
    ColorStr( bm_Introduce );                    /** ܵ{WBΧ@ **/
    SetColor( DEF_COLOR );                                     /** ũզr **/
} /* end ShowBMGR */


/*-------------------------------   e  -------------------------------*/
static void ShowPict (void)
{
    sword  h_Line[2];
    sword  j;
 
    h_Line[0] = MENU_Y + 3;
    h_Line[1] = 0;
 
    SetColor( WALL_COLOR );
    for ( j = MENU_Y + 1 ; j <= END_MENU_Y + 1 ; j++ )
    {
       SetXY(MENU_X + 2, j);
       Repeat_Char(BG_CHAR, END_MENU_X - MENU_X + 1);
    } /* end for */
    
    SetColor( DEF_COLOR );
    Clr_Block(MENU_X, MENU_Y, END_MENU_X, END_MENU_Y);
 
    Square(MENU_X+1, MENU_Y+1, END_MENU_X+1, END_MENU_Y+1, h_Line);
    SetXY(MENU_X + 9, MENU_Y + 1);
    ColorStr( bm_BootTitle );                /** ܶ}D(Ұʿ) **/
    Repeat_Char(' ', 15);                                /**  17 Ӫť **/
    ColorStr( bm_FsTitle );                  /** ܶ}D(ɮרt) **/
} /* end ShowPict */


/*============================   w    ============================*/
void Locate_show (sword x, sword y, const sbyte *str)
{
    SetXY(x-1, y-1);
    ColorStr( str );
} /* end Locate_show */


/*------------------------------ ø s   ---------------------------------+
|  JG                                                                     |
|                       dx=Left-Up     cx=Right-Down                          |
+----------------------------------------------------------------------------*/
void Square (sword x1, sword y1, sword x2, sword y2, sword *h_line)
{
    sword  gap, i;
 
    gap = x2 - x1 - 1;
 
    x1--;  y1--;
    x2--;  y2--;
    SetXY(x1, y1);
    ColorChar('');
    Repeat_Char('', gap);                               /**  17 Ӫť **/
    ColorChar('');
 
    SetXY(x1, y2);
    ColorChar('');
    Repeat_Char('', gap);                               /**  17 Ӫť **/
    ColorChar('');
 
    for ( i = y1 + 1 ; i < y2 ; i++ )                            /** eݽu **/
    {
        SetXY(x1, i);
        if ( h_line && *h_line && (*h_line == (i + 1)) )
        {
            ColorChar('');
            Repeat_Char('', gap);                       /**  17 Ӫť **/
            ColorChar('');
            h_line++;
        }
        else                                                     /** eݽu **/
        {
            ColorChar('');
            SetXY(x2, i);
            ColorChar('');
        } /* end if */
    } /* end for */
} /* end Square */


/*------------------------------     --------------------------------*/
static sword GetMenuHead (sword start)
{
    sword  head;
 
    if ( start <= PAGE_ITEM )                                    /** Ĥ@ **/
        head = 1;
    else if ( start >= (g_BootPara.nBootREC - PAGE_ITEM + 1) ) /** ̫@ **/
        head = g_BootPara.nBootREC - PAGE_ITEM + 1;
    else
        head = start - 1;
 
    return( (head > 0) ? head : 1 );         /** Ǧ^w]Zӭt **/
} /* end GetMenuHead */


/*------------------------------  J K X ---------------------------------+
|   JG                                                                    |
|                SysPW: tαKX     ItemPW: 涵KX                         |
+-----------------------------------------------------------------------------+
|   Ǧ^ȡG                                                                  |
|               ̫U                                                |
+----------------------------------------------------------------------------*/
static sword Input_PassWord (byte *SysPW, byte *ItemPW)
{
    byte   mingText[PW_LEN], target[PW_LEN], *pwPTR;
    sword  count, comp;
    word   key;
 
    comp = 2;
    SetColor( PMT_COLOR );                                   /** զr **/
    while ( comp >= 2 )
    {
        Clr_Block(PASSWD_X - 2, PASSWD_Y - 1, PASSWD_X + 33, PASSWD_Y + 1);
        Square(PASSWD_X, PASSWD_Y, PASSWD_X + 33, PASSWD_Y + 2, NULL);
        SetXY(PASSWD_X + 1, PASSWD_Y);
        ColorStr( bm_PwPmtStr );                   /** ܱKXJܦr **/
  
        count = 0;
        while ( (key = GetKey()) != ENTER_KEY )                /** JKX **/
        {
            if ( key == ESC_KEY )                              /** Y ESC **/
                goto END_PASSWD;
   
            if ( key == BACKSPACE_KEY )
            {
                if ( count > 0 )
                {
                   ColorChar('\b');
                   ColorChar(' ');
                   ColorChar('\b');
                   count--;
                } /* end if */
            }
            else if ( count != PW_LEN )                /** JrƩ|B **/
            {
                mingText[count++] = (byte)key;
                ColorChar('');                            /** ܴܦr **/
            } /* end if */
        } /* end while */
  
        while ( count < PW_LEN )                       /**  PW_LEN Ӧr **/
            mingText[count++] = 0;                    /** J ASCII Code 0 **/
  
        pwPTR = SysPW;                                     /** VtαKX **/
        for ( comp = 0 ; comp < 2 ; comp++ )
        {
            if ( pwPTR[PW_LEN] != 0 )
            {                              /**  PW_LEN  byte sؤl **/
                Encoder(mingText, pwPTR[PW_LEN], target);
                if ( CompMEM(pwPTR, target, PW_LEN) == 0 )     /** KX **/
                    break;
            } /* end if */
   
            pwPTR = ItemPW;                                    /** 涵KX **/
        } /* end for */
  
        if ( comp == 2 )
        {
            SetXY(PASSWD_X + 1, PASSWD_Y);
            ColorStr( bm_PwErrStr );               /** ܱKXJܦr **/
            GetKey();
        } /* end if */
    } /* end while */
 
END_PASSWD:

    SetColor( DEF_COLOR );                               /** ^w]C **/
    return( key == ESC_KEY );
} /* end Input_PassWord */


/*-------------------------------    J -------------------------------*/
static sword SeleBoot (sword start)
{
    byte   seleY, sele, item, y;
    word   key;
    sword  i;

    if ( (start < 1) || (start > g_BootPara.nBootREC) )
        start = 1;

    item  = GetMenuHead(start);                              /** o **/
    sele  = start;                               /** ثeΦmVw] **/
    seleY = ((sele - item) << 1) + MENU_Y + 4;           /** pw] Y **/
    y     = MENU_Y + 4;
 
    ShowBMGR();                                                /** ܭI **/
    ShowPict();                                            /** ܪe **/
 
    /*----------------------- ܿ椺e -----------------------*/
    for ( i = 0 ; i < PAGE_ITEM && item <= g_BootPara.nBootREC ; i++ )
    {
        ShowItem(item, y, (item == start));
        item++;
        y += 2;
    } /* end for */
 
    #if 0
        /** beep in boot **/
        for ( i = 0 ; i < 5 ; i++ )
            Beep();
    #endif

    if ( bm_Timer != NO_TIMER && bm_Timer != NO_WAIT )   /** pGϥέpɾ **/
        StartTimer();                                        /** h}lp **/
                
    while ( 1 )
    {
        ShowSelePrompt(bm_Timer, sele);            /** ܬơBV䴣 **/
  
        while ( KB_Hit() == 0 )                          /** ˬdLwİ **/
        {
            ShowSEC(bm_Timer);
            if ( bm_Timer == 0 )                           /** pGɶF **/
            {
                sele     = start;                      /** ϥιw]ﶵ} **/
                bm_Timer = NO_TIMER;                           /** p **/
                goto END_SELE;
            } /* end if */
        } /* end while */

        /*-------------------------------------+
        |  pGϥέpɾA@LNp  |
        +-------------------------------------*/
        StopTimer();                                           /** p **/
        bm_Timer = NO_TIMER;
        ShowSEC(bm_Timer);                                     /** M **/

        key = GetKey();
        if ( key == UP_KEY )
            sele = Move_Up(sele, &seleY);
        else if ( key == DOWN_KEY )
            sele = Move_Down(sele, &seleY);
        else if ( bm_BootTime )
        {         
            if ( key == ENTER_KEY &&
                 g_Boot[sele - 1].sysID != NOT_EXIST_ID )
            {
                break;
            }
            else if ( key == F9_KEY )
            {
                /** åD **/
                gs_HiddenSW = (gs_HiddenSW) ? FALSE : TRUE;
                Beep();
                if ( gs_HiddenSW )
                    Beep();                /** Y}ðʧ@hA Beep @n **/
            } /* end if */
        }
        else
        {
            if ( key == ENTER_KEY || key == ESC_KEY )
                break;
        } /* end if */
    } /* end while */

END_SELE:

    StopTimer();                             /** pɡA٭줤_ 08 Vq **/
    return( sele );
} /* end SeleBoot */


/*---------------------------     r  -----------------------------*/
static void ShowSelePrompt (word sec, byte sele)
{
    ShowSEC(sec);                                              /**  **/
    SetXY(MENU_X + 2, END_MENU_Y);                         /** ̫@C **/
    if ( sele > 1 )
        ColorStr( bm_UpSym );
    if ( sele < g_BootPara.nBootREC )
        ColorStr( bm_DownSym );                            /** ܦVUŸ **/
    ColorStr( bm_PmtStr );                                 /** ܴܦr **/
} /* end ShowSelePrompt */


/*----------------------------     ----------------------------------*/
static void ShowSEC (word sec)
{
    byte  str[2];
 
    SetXY(END_MENU_X - 7, END_MENU_Y);
    if ( (sec == NO_TIMER) || (sec == 0) )
    {
        if ( bm_SecStr[2] != '' )
        {
            bm_SecStr[2] = '';
            Repeat_Char('', 6);                          /** show 6  '' **/
        } /* end if */
    }
    else
    {
        str[0] = sec / 10;
        str[1] = sec % 10;
        *(word *)str += 0x3030;
        if ( *(word *)&bm_SecStr[2] != *(word *)str )
        {
            *(word *)&bm_SecStr[2] = *(word *)str;
            ColorStr( bm_SecStr );                          /**  [ nn ] **/
        } /* end if */
    } /* end if */
} /* end ShowSEC */


/*-------------------       w   D   -------------------*/
static void Hidd_DEF (byte *h_partn)
{
    byte     buff[512], end_hd, ext, update, disk, no;
    dword    extStart;
    sword    addr;
    PACKAGE  pkg;
                   
    pkg.nSects = 1;     
    disk       = *h_partn;
    end_hd     = gs_DiskNum + 0x80;

    *(word *)(h_partn + HIDD_ITEM * 2) = 0;
 
    while ( *h_partn && (*h_partn < end_hd) )
    {
        /*-------------------+
        |  sb  |
        +-------------------*/
        if ( disk != *h_partn )                  /** pGO disk ow **/
        {
            if ( disk < *h_partn )
                disk++;                                  /** BzU@w **/
            else
                h_partn += 2;                  /** sbϺФθ **/
            continue;
        } /* end if */

        pkg.start = 0;
        pkg.disk  = disk;
  
        /*-----------------------------+
        |     oDΪ Buffer    |
        +-----------------------------*/
        if ( Access_HD(2, &pkg, buff) )
        {
            disk++;                                      /** BzU@w **/
            continue;
        } /* end if */
  
        /*-----------------------+
        |     B z D       |
        +-----------------------*/
        ext    = 0;
        addr   = 0x1c2;
        update = FALSE;                          /** OO_Lðʧ@ **/
        for ( no = 1 ; no < 5 ; no++ )
        {
            /** pGOXRΫhOνs **/
            if ( Is_Extended(buff[addr]) )
                ext = no;

            /*-------- νsκϺЬۦPh -------*/
            if ( (disk == *h_partn) && (no == *(h_partn + 1)) )
            {
                if ( ext == no )
                    ext = 0;       /** êOXRΡAh޿ΤBz **/
    
                /* modified for dos hidden ID by SPF, 2002.05.01 */
                update = HideOnPartnByAddr(buff, no - 1);
                h_partn += 2;                    /** U@ӱêθ **/
            } /* end if */
   
            addr += 0x10;
        } /* end for */
  
        if ( update )                                /** xsק᪺D **/
            Access_HD(3, &pkg, buff);
  
        if ( disk != *h_partn )              /** êΤwbثeϺ **/
            continue;
  
        /*----------------------------+
        |     B z X R         |
        +----------------------------*/
        if ( ext )                                       /** XRΦsb **/
        {
            addr = (ext << 4) + 0x1ae;            /** Get Ext field address **/
   
            pkg.start =
            extStart  = *(dword *)&buff[addr + 8];   /** XRΪҩlϰ **/
   
            no = 5;
            while ( disk == *h_partn )                 /** oU@ӤΪ **/
            {
                if ( Access_HD(2, &pkg, buff) )
                {
                    do
                    {
                        h_partn += 2;    /** YΤsbhoǤθ **/
                    } while ( *h_partn != disk );

                    break;                                     /** }j **/
                } /* end if */
    
                if ( *(h_partn + 1) == no )            /** pGνsۦP **/
                {
                    /* modified for dos hidden ID by SPF, 2002.05.01 */
                    /** äΨxs **/
                    if ( HideOnPartnByAddr(buff, 0) )
                        Access_HD(3, &pkg, buff);
                    h_partn += 2;                  /** BzUø **/
                } /* end if */
    
                /** pU@ӤΪm **/
                pkg.start = extStart + *(dword *)&buff[0x1d6];
                no++;
            } /* end while */
        } /* end if */
    } /* end while */
} /* end Hidd_DEF */


/*----------------- N     P        -------------------+
|  JȡG                                                                   |
|                buffer: VΪҩl}A  _Partn νs              |
+----------------------------------------------------------------------------*/
static byte Hidd_Same (byte partn, byte *buff)
{
    byte   isWin, update;
    sword  addr, no;
    word   sysID;
 
    sysID = buff[ (partn << 4) + 0x1b2 ];             /** Vt ID **/
    isWin = ChkSysID(sysID, NT_FAT12_16_32);          /** O_ Windows/OS2  **/
    addr  = 0x1c2;                          /** VΪĥ|t ID **/
 
    update = FALSE;                                            /** ʺX **/
    if ( sysID && !Is_Extended(sysID) && partn < 5 )   /** pGOXR **/
    {
        partn--;
        for ( no = 0 ; no < 4 ; no++, addr += 0x10 )
            if ( (no == partn) || Is_Extended(buff[addr]) )
                continue;
            else if ( (sysID == buff[addr]) ||
                      (isWin && ChkSysID(buff[addr], NT_FAT12_16_32)) ) 
                update = HideOnPartnByAddr(buff, no);          /** ä **/
    } /* end if */
 
    return( update );
} /* end Hidd_Same */


/*--------------------- Ū J     s y }    -----------------*/
static sword Load_Boot (sword sele, dword *begin, byte FAR *osLoader)
{
    byte     buff[512], partn, retry, update;
    dword    extStart;
    sword    addr;
    PACKAGE  pkg;
 
    partn      = g_Boot[sele].partn;                       /** Ұʪ **/
    pkg.disk   = g_Boot[sele].disk;                    /** o}Ϻ **/
    pkg.start  = 0;
    pkg.nSects = 1;
 
    /*-----------------------------------+
    |          @  n        |
    +-----------------------------------*/
    if ( pkg.disk < 0x80 )
        Chg_INT_1E();                         /** N INT 1Eh VnаѼƪ **/
    else if ( (addr = GetPartn(pkg.disk, partn, &extStart, buff)) < 0 )
        return(-1);
    else
    {
        if ( partn < 5 )                               /** QҰʪOD **/
        {                                            
            update = FALSE;
            if ( g_Boot[sele].hidden )                  
                update |= Hidd_Same(partn, buff);        /** æP **/
                                                      
            if ( g_BootPara.instDisk  != 0x80  ||    /** Ow˦bĤ@HD **/
                 g_BootPara.instPartn == _MBR_ ||            /** w˦b MBR **/
                 g_Boot[sele].active  != 0 )                 /** w˳nФW **/
            {                                         
                update |= Chg_Active(partn, buff);         /** ]wҰʤ **/
            } /* end if */
   
            if ( update )
                Access_HD(3, &pkg, buff);
        } /* end if */
     
        pkg.start = extStart + *(dword *)&buff[addr + 8];  /** ҰʺϰϦ} **/
    } /* end if */
 
    /*------------------------+
    |     J        |
    +------------------------*/
    for ( retry = 0 ; retry < 3 ; retry++ )              /** ~ɭդ **/
    {
        Reset_Disk( pkg.disk );                              /** mnо **/
        if ( Access_HD(2, &pkg, osLoader) == 0 )
            break;
    } /* end for */
 
    if ( retry >= 3 ||                                         /** s~ **/
         *(dword FAR *)osLoader == 0 ||                    /** LıҰʺϰ **/
         *(dword FAR *)osLoader == 0xf6f6f6f6L ||
         *(word  FAR *)&osLoader[0x1fe] != 0xaa55 )
    {
        return(-1);
    } /* end if */
 
    *begin = pkg.start;
    return(0);
} /* end Load_Boot */


/*----------------------- x s   }    ---------------------------*/
static void Save_Sele (sword sele)
{
    byte     buff[512];
    sword    tmp;
    PACKAGE  pkg;
 
    pkg.disk = g_BootPara.instDisk;
    if ( pkg.disk > 0x7f )                      /** Just HD boot could save **/
    {
        pkg.nSects = 1;
        pkg.start  = g_BootPara.dataBegin;             /** Ƭqҩlϰ **/
        if ( Access_HD(2, &pkg, buff) == 0 )                 /** Jܼư **/
        {
            tmp = &g_BootPara.def_boot - g_Magic_Str;
            buff[tmp] = sele;
            Access_HD(3, &pkg, buff);                  /** sJ} **/
        } /* end if */
    } /* end if */
} /* end Save_Sele */


/*----------------------          -------------------------*/
static void Hidden_off (void)
{
    byte     buff[512], update, no;
    dword    extStart;
    sword    addr, bak;
    word     ext;
    PACKAGE  pkg;
 
    pkg.disk = gs_DiskNum + 0x80;                /** ѳ̫@wж}lBz **/
    while ( pkg.disk > 0x80 )
    {
        pkg.disk--;
        pkg.start  = 0;
        pkg.nSects = 1;
  
        if ( Access_HD(2, &pkg, buff) )                    /** ŪJDΰ **/
            continue;
  
        ext    = 0;
        addr   = 0x1be;                                /** ĥ|檺ҩlm **/
        update = FALSE;
        bak    = HIDD_BAK;                   /** sl SYS_ID ƥm **/
  
        for ( no = 0 ; no < 4 ; no++ )
        {
            /* modified for dos hidden ID by SPF, 2002.05.01 */
            /** pGγQåBƥ ID `h **/
            update |= HideOffPartnByAddr(buff, no);

            /** pGOXRΫhO} **/
            if ( Is_Extended(buff[addr + 4]) )
                ext = addr;
  
            addr += 0x10;                                    /** U@ **/
            bak++;
        } /* end for */
  
        if ( update )
            Access_HD(3, &pkg, buff);                          /** sJw **/
  
        if ( ext )                                       /** XRΦsb **/
        {
            extStart  =
            pkg.start = *(dword *)&buff[ext + 8];              /** ҩlϰ **/
   
            do
            {
                if ( Access_HD(2, &pkg, buff) )                /** UӤ **/
                    break;
    
                /* modified for dos hidden ID by SPF, 2002.05.01 */
                /** pG޿γQåBƥ ID `hèxs **/
                if ( HideOffPartnByAddr(buff, 0) )
                    Access_HD(3, &pkg, buff);

                /** pU@ӤΪm **/
                pkg.start = extStart + *(dword *)&buff[0x1d6];

            } while ( Is_Extended(buff[0x1d2]) );

        } /* end if */
    } /* end while */
} /* end Hidden_off */


/*------------------------ D OS/2     N  ------------------------*/
static byte GetLogicNum (byte disk, byte partn)
{
    byte     buff[512], endDisk, dosID, no;
    word     logicNum;
    dword    extStart;
    sword    addr;
    PACKAGE  pkg;
 
    endDisk  = gs_DiskNum + 0x7f;                    /** ̫@ӺϺоN **/
    pkg.disk = endDisk;
    logicNum = 0x7f;                             /** s OS/2 ޿ϺХN **/
 
    do
    {
        pkg.start  = 0;
        pkg.nSects = 1;
        if ( Access_HD(2, &pkg, buff) == 0 &&              /** oDΪ **/
             *(word *)&buff[0x1fe] == 0xaa55 )             /** YOĤ **/
        {
            /*----------------------------------------------+
            |   MXRΨçP_L OS/2  DOS D   |
            +----------------------------------------------*/
            addr = GetExt(buff, 0x1be, &dosID);
            if ( dosID )
               logicNum++;                              /** psb DOS  **/
   
            /*-----------------------------------------+
            |   YWX OS/2 ҦbϺЩ޿Τsb   |
            +-----------------------------------------*/
            if ( pkg.disk <= disk && addr != 0 )
            {
                pkg.start =
                extStart  = *(dword *)&buff[addr + 8];
    
                no = 5;                            /** ثeŪJνs **/
                while ( 1 )
                {
                    /*-------------- `J޿ -------------*/
                    if ( Access_HD(2, &pkg, buff) == 0 &&
                         *(word *)&buff[0x1fe] == 0xaa55 )
                    {
                        if ( ChkSysID(buff[0x1c2], FAT12_16) )
                            logicNum++;
      
                        /*-----------------------------------+
                        |        OQҰʪΥ        |
                        +-----------------------------------*/
                        if ( pkg.disk == disk && no == partn )
                            break;
                        else
                        {
                            no++;                  /** ثeŪJνs **/
                            if ( !Is_Extended(buff[0x1d2]) )
                                break;
                            pkg.start = extStart + *(dword *)&buff[0x1d6];
                        } /* end if */
                    }
                    else
                        break;
    
                } /* end while */
            } /* end if */
        } /* end if */
  
        pkg.disk--;
    } while ( pkg.disk > 0x7f );                           /** U@Ϻ **/
 
    return( logicNum );                          /** Ǧ^Do޿ϺХN **/
} /* end GetLogicNum */


/*-------------------------  M X R   -------------------------------*/
static sword GetExt (byte *buff, word offset, byte *dosID)
{
    sword  extAddr, no;
    word   sysID;
 
    if ( dosID )
        *dosID = 0;
 
    extAddr = 0;
    for ( no = 0 ; no < 4 ; no++ )
    {
        /* modified for dos hidden ID by SPF, 2002.05.01 */
        sysID = buff[offset + 4];                         /** Get system id **/
        if ( IsHiddenID(sysID) )
            sysID = ( IsHiddenWinID(sysID) ) ? sysID & 0x0f : buff[HIDD_BAK + no];
        if ( Is_Extended(sysID) )
            extAddr = offset;                         /** O ext Ҧb} **/
        else if ( dosID && ChkSysID(buff[0x1c2], FAT12_16) )      /** DOS ? **/
            *dosID = sysID;
        offset += 0x10;
    } /* end for */
 
    return( extAddr );                                           /** Ǧ^ **/
} /* end GetExt */


/*----------------------  J   partn      ----------------------+
|   disk            wϺ                                                |
|   partn           Ūνs                                        |
|   partnAddr       oΪҩlϰ                                |
|   buff            sŪ partition table                              |
+--------------------------------------------------------------------------*/
sword GetPartn (byte disk, byte partn, dword *partnAddr, byte *buff)
{
    dword    extStart;
    sword    offset;
    PACKAGE  pkg;
    byte     i;
 
    *partnAddr =
    pkg.start  = 0;
    pkg.nSects = 1;
    pkg.disk   = disk;
 
    if ( Access_HD(2, &pkg, buff) ||                     /** ŪDΥ **/
         *(word *)&buff[0x1fe] != 0xaa55 )                   /** LĤΪ **/
    {
       return(-1);
    } /* end if */

    if ( partn > 4 )                                     /** pGO޿ **/
    {
        offset = GetExt(buff, 0x1be, NULL);              /** MDXR **/
        if ( offset == 0 )
            return(-1);
        else                                                     /** F **/
        {   
            extStart  =
            pkg.start = *(dword *)&buff[offset + 8];   /** ޿κϰ **/
            for ( i = partn - 4 ; i > 0 ; i-- )      /** `J޿Ϊh **/
            {
                if ( Access_HD(2, &pkg, buff) )
                    return(-1);                              /** s~I **/
   
                if ( i == 1 )
                    *partnAddr = pkg.start;
                else
                {
                    if ( !Is_Extended(buff[0x1d2]) )
                        return(-1);
                 
                    /*--------- oU޿Ϊ} --------*/
                    pkg.start = extStart + *(dword *)&buff[0x1d6];
                } /* end if */
            } /* end for */
   
            offset = 0x1be;
        } /* end if */
    }
    else
        offset = (partn << 4) + 0x1ae;            /** oӤҩlm **/
 
    return( offset );
} /* end GetPartn */


/*--------------------------- ] w Active   ----------------------------*/
static byte Chg_Active (byte partn, byte *buff)
{
    byte   update, fill, no;
    sword  addr;
 
    addr   = 0x1be;                                        /** ̫@ **/
    update = FALSE;
    for ( no = 1 ; no < 5 ; no++,  addr += 0x10 )
    {
        fill = ( no == partn ) ? 0x80 : 0;
        if ( buff[addr] != fill )
        {
            update     = TRUE;
            buff[addr] = fill;
        } /* end if */
    } /* end for */
 
    return( update );
} /* end Chg_Active */


/*------------ O _  DOSB OS/2B NT  DOS êt΢ע ----------------+
| ѼơG                                                                      |
|     id      System ID                                                       |
|     cond    FAT12_16 / NT_ID / LBA_FAT / EXTENDED_ID                        |
+-----------------------------------------------------------------------------+
|     pGnˬd hidden idA cond iP HIDD_ID  or BAǤJ               |
+----------------------------------------------------------------------------*/
sword ChkSysID (byte id, sword cond)
{
    sword  ret = 0;

    if ( cond & HIDD_ID )
    {
        if ( (cond == HIDD_ID) && (id == 0x26) )
            ret = HIDD_ID;
        else if ( (cond & FAT12_16) && ((id == 0x11) || (id == 0x14) || (id == 0x16)) )
            ret = HIDD_ID | FAT12_16;
        else if ( (cond & LBA_FAT) && ((id == 0x1b) || (id == 0x1c) || (id == 0x1e)) )
            ret = HIDD_ID | LBA_FAT;
        else if ( (cond & NT_ID) && (id == 0x17) )
            ret = HIDD_ID | NT_ID;
    }
    else
    {
        if ( (cond & EXTENDED_ID) && ((id == 0x05) || (id == 0x0f) || (id == 0x85)) )
            ret = EXTENDED_ID;
        else if ( (cond & FAT12_16) && ((id == 0x01) || (id == 0x04) || (id == 0x06)) )
            ret = FAT12_16;
        else if ( (cond & NT_ID) && (id == 0x07) )
            ret = NT_ID;
        else if ( (cond & LBA_FAT) && ((id == 0x0b) || (id == 0x0c) || (id == 0x0e)) )
            ret = LBA_FAT;
    } /* end if */

    return( ret );
} /* end ChkSysID */


/*--------------------------- Is Extended sysID -----------------------------*/
sword Is_Extended (byte id)
{
    return( ChkSysID(id, EXTENDED_ID) );
} /* end Is_Extended */


/*---------------------- O _  DOS    t  ID ---------------------*/
/* added for any windows hidden ID by SPF, 2002.05.01 */
sword IsHiddenWinID (sword id)
{
    return( ChkSysID(id, HIDD_ID | NT_FAT12_16_32) );
} /* end IsHiddenWinID */


/*----------------------- O _     t  ID ------------------------*/
/* added for dos hidden ID by SPF, 2002.05.01 */
sword IsHiddenID (sword id)
{
    return( ChkSysID(id, HIDD_ID) || IsHiddenWinID(id) );
} /* end IsHiddenID */


/*---------------------------- Hidden partition -----------------------------*/
/* ndx = 0 - 3, added for dos hidden ID by SPF, 2002.05.01 */
static sword HideOnPartnByAddr (void *addr, sword no)
{
    byte   *buff  = (byte *)addr;
    byte   *sysID = buff + (no << 4) + 0x1c2;               /** Vt ID **/
    sword  id;

    /* modified for dos hidden ID by SPF, 2002.05.01 */
    if ( !IsHiddenID(*sysID) )
    {
        id = (sword)*sysID;

        if ( ChkSysID(*sysID, NT_FAT12_16_32) )
            *sysID |= 0x10;
        else
        {
            buff[no + HIDD_BAK] = *sysID;
            *sysID = HIDDEN_ID;
        } /* end if */

        return( id );                              /** ]Lðʧ@ **/
    } /* end if */
    
    return( FALSE );
} /* end HideOnPartnByAddr */


/*---------------------------- Hidden partition -----------------------------*/
/* no = 0 - 3, added for dos hidden ID by SPF, 2002.05.01 */
static sword HideOffPartnByAddr (void *addr, sword no)
{
    byte  *buff  = (byte *)addr;
    byte  *sysID = buff + (no << 4) + 0x1c2;                /** Vt ID **/
    sword update = 0;

    if ( IsHiddenID(*sysID) )
    {
        if ( IsHiddenWinID(*sysID) )
        {
            *sysID &= 0x0f;
            update  = *sysID;
        }
        else if ( (update = buff[no + HIDD_BAK]) != 0 )
        {
            if ( IsHiddenWinID(update) )          /** ٭iO dos  **/
                update &= 0x0f;
            *sysID = update;
        } /* end if */
    } /* end if */
    
    return( update );
} /* end HideOffPartnByAddr */


/*-------------------------------  J   -------------------------------*/
static word GetKey (void)
{
    union Regs  regs;
    
    regs.x.ax = 0;
    BiosCall(0x16, &regs, NULL);
    return( (regs.x.ax & 0x00FF) ? regs.x.ax & 0x00FF : regs.x.ax );
} /* end GetKey */


/*-----------------------  J @    w   ------------------------*/
void PushKey (word key)
{
    union Regs regs;

    regs.x.ax = 0x0500;
    regs.x.cx = key;
    BiosCall(0x16, &regs, NULL);
} /* end PushKey */


/*-------------------------  d O _     -------------------------*/
static sword KB_Hit (void)
{   
    union Regs regs;
    
    regs.x.ax = 0x0100;
    BiosCall(0x16, &regs, NULL);
    return( !(regs.x.flags & 0x40) );                  /** 0x40 = Zero Flag **/
} /* end KB_Hit */


/*-------------------------------- ͤ@n -----------------------------------*/
static void Beep (void)
{
    ColorChar(7);
} /* end Beep */


/*-------------------------      @  ----------------------------*/
static void ShowItem (sword sele, sword y, sword lightBar)
{
    byte  color;
 
    sele--;
    color = ( ( g_Boot[sele].sysID == NOT_EXIST_ID ) ? INVALID_COLOR :
          /*  ( g_Boot[sele].p_wd[PW_LEN] ) ? PASSWD_COLOR : */ DEF_COLOR );
 
    if ( lightBar )
        color = (color & 0x0f) | LIGHT_BAR_BG;
 
    SetColor( color );
    Clr_Block(MENU_X + 2, y, END_MENU_X - 2, y);
    SetXY(MENU_X + 7, y);
    ColorStr( g_Boot[sele].label );              /** ܿﶵ(lab_name) **/
    SetXY(MENU_X + LAB_LEN + 18, y);
    ColorStr( g_SysName[ g_Boot[sele].sysID ] );           /**  id_name **/
    SetColor( DEF_COLOR );
} /* end ShowItem */


/*---------------------------   V W   -----------------------------*/
static byte Move_Up (byte sele, byte *seleY)
{
    sword  i;
    byte   y;
 
    if ( sele > 1 )                                          /** ٨S쭺 **/
    {
        y = *seleY;
        ShowItem(sele, y, FALSE);                              /** M **/
        sele--;
        if ( y > (MENU_Y + 4) )                    
            y -= 2;
        else                                             /** J檺W **/
            for ( i = 1 ; i < PAGE_ITEM ; i++ )
                ShowItem(sele + i, y + (i << 1), FALSE);
        ShowItem(sele, y, TRUE);                     /** øs(զrQ) **/
        *seleY = y;
    } /* end if */
    
    return( sele );
} /* end Move_Up */


/*---------------------------   V U   -----------------------------*/
static byte Move_Down (byte sele, byte *seleY)
{
    sword  i;
    byte   y;
 
    if ( sele != g_BootPara.nBootREC )                       /** ٨S **/
    {
        y = *seleY;
        ShowItem(sele, y, FALSE);                              /** M **/
        sele++;
        if ( y < (END_MENU_Y - 2) )
            y += 2;
        else                                             /** J檺U **/
            for ( i = 1 ; i < PAGE_ITEM ; i++ )
                ShowItem(sele - i, y - (i << 1), FALSE);
        ShowItem(sele, y, TRUE);                               /** M **/
        *seleY = y;
    } /* end if */
    
    return( sele );
} /* end Move_Down */


/*----------------------- Compute dword / word -------------------------------+
| ϥ Turbo C compile A long OתB⧡ϥγnA]NO |
| |s Turbo C  functionAקKoͳoرpAڼgݭn\ӨNC  |
+----------------------------------------------------------------------------*/
static word LongDIV (dword v1, word v2)
{
    asm push dx
    _DX = *((word *)&v1 + 1);
    _AX = (word)v1;
    asm div word ptr v2
    asm pop dx
    return( _AX );
} /* end LongDIV */


/*------------------------ Compute dword % word-------------------------------+
|                   ϥ DIV i|oͷAҥHγs覡                 |
+-----------------------------------------------------------------------------+
| ϥ Turbo C compile A long OתB⧡ϥγnA]NO |
| |s Turbo C  functionAקKoͳoرpAڼgݭn\ӨNC  |
+----------------------------------------------------------------------------*/
static word LongMOD (dword v1, word v2)
{
#if 0
    while ( v1 > v2 )
        v1 -= v2;
    return( (word)v1 );
#else
    while ( v1 > 0x0ffffUL )
        v1 -= v2;
 
    /* return( *(word *)&v1 % v2 ); */
    return( (word)v1 % v2 );
#endif
} /* end LongMOD */


/*------------------------- Comp memory content -----------------------------*/
sword CompMEM (void *m1, void *m2, sword len)
{
    byte  *ptr1 = (byte *)m1;
    byte  *ptr2 = (byte *)m2;

#if 1
    sword i;
 
    for ( i = 0 ; i < len && *ptr1 == *ptr2 ; i++ )
    {
        ptr1++;
        ptr2++;
    } /* end for */
 
    return( (i != len) ? *ptr1 - *ptr2 : 0 );

#else
    if ( len > 0 )                                           /** odd length **/
    {
        if ( (len & 1) == 1 )
        {
            if ( *ptr1 != *ptr2 )
                return( *ptr1 - *ptr2 );
            len--;
            ptr1++;
            ptr2++;
       } /* end if */
       
        while ( len > 0 && (*(word *)ptr1 == *(word *)ptr2) )
        {
            ptr1 += 2;
            ptr2 += 2;
            len  -= 2;
        } /* end while */
    } /* end if */
 
    return( ( len <= 0 ) ? 0 :
            ( *ptr1 == *ptr2 ) ? *(ptr1+1) - *(ptr2+1) : *ptr1 - *ptr2);
#endif
} /* end CompMEM */


/*------------------------------- Clear Block -------------------------------*/
/* parameter:         x = 0 - 79, y = 0 - 24                                 */
/*---------------------------------------------------------------------------*/
void Clr_Block (sword x1, sword y1, sword x2, sword y2)
{
    sword  x, y;

    for ( y = y1 ; y <= y2 ; y++ )
    {
       SetXY(x1, y);
       for ( x = x1 ; x <= x2 ; x++ )
           ColorChar(' ');
    } /* end for */

    SetXY(x1, y1);
} /* end Clr_Block */


/*---------------------------------------------------------------------------*/
void SetColor (sword color)
{
    g_CurPos.color = (byte)color;
} /* end SetColor */


/*------------------------- s X   (ͼ[Ksk) -----------------------+
|                                                                             |
|                           [ K k                |
|                 @  h s XA P   r i s X  P X            |
+----------------------------------------------------------------------------*/
void Encoder (byte *ming, byte seed, byte *target)
{
    sword  i;
 
    for ( i = 0 ; i < PW_LEN ; i++ )
    {
        /* B᪺Ȱ줣j */
        seed = (byte)((seed * 9) + 7); /** ؤlܤơAP˪r|sX@˪X **/
        target[i] = (ming[i] ^ seed) + i;                  /** XPؤlƧ@ **/
    } /* end for */
} /* end Encoder */


/*---------------------       \     ---------------------+
|   ѼơG                                                                    |
|             ctrl = DISK_XCHG                ҥκϺФ                    |
|                    PAUSE_DISK_XCHG          ȰϺФ                    |
|                    DETECT_XCHG_STATUS       O_ҥκϺиm          |
|                    RELEASE_MY_INT13          My int13h                  |
|   Ǧ^ȡG                                                                  |
|             ctrl = DETECT_XCHG_STATUSAǦ^ 0 ҥθmA1 ҥΡA      |
|                                        䥦ȫhOW MY_INT13h           | 
|             ctrl = 䥦AYOǦ^D  ܥW MY_INT13h (in int13.asm)  |
+----------------------------------------------------------------------------*/
sword Ctrl_DrvExchg (byte ctrl)
{
    union Regs regs;
    
    regs.h.al = ctrl;
    regs.h.ah = 0xd0;
    BiosCall(0x13, &regs, NULL);
    return( regs.x.ax );
} /* end Ctrl_DrvExchg */


/*--------------------------- owϺЪѼ -----------------------------+
|       pGﹳOWϥΪϺХBS~AhݭsoϺаѼ        |
+----------------------------------------------------------------------------*/
static sword SetDiskPara (byte disk)
{
#if USE_BIOSCALL_FUNC
    union Regs regs;
    
    /* static byte gs_NowDisk = -1;
       static byte gs_DiskErr = -1;  */
    
    /* gs_NowDisk and gs_DiskErr not declaration to local static variable,
       because bootmgr in boot time no initial any local static variable */
    if ( gs_NowDisk == disk && gs_DiskErr == 0 )
        regs.h.ah = 0;
    else
    {
        gs_NowDisk = disk;
        regs.h.dl  = disk;
        regs.h.ah  = 8;
        BiosCall(0x13, &regs, NULL);
  
        if ( regs.h.ah == 0 )
        {                        
            gs_MaxSect = regs.x.cx & 0x3f;               /** Get Max Sector **/
            gs_MaxHead = regs.x.dx >> 8;                   /** Get Max Head **/
            gs_DiskErr = 0;
        }
        else
            gs_DiskErr = -1;
    } /* end if */
 
    return( (sword)(word)regs.h.ah );
    
#else    
    /* static byte gs_NowDisk = -1;
       static byte gs_DiskErr = -1;  */
    
    /* gs_NowDisk and gs_DiskErr not declaration to local static variable,
       because bootmgr in boot time no initial any local static variable */
    if ( gs_NowDisk == disk && gs_DiskErr == 0 )
        _AX = 0;
    else
    {
        asm push bx
        asm push cx
        asm push dx
        asm push si
        asm push di
  
        gs_NowDisk = disk;
        _DL = disk;
        _AH = 8;
        __int__(0x13);
        _AX >>= 8;
  
        asm push ax
        if ( _AX == 0 )
        {
            gs_MaxSect = _CX & 0x3f;                     /** Get Max Sector **/
            gs_MaxHead = _DX >> 8;                         /** Get Max Head **/
            gs_DiskErr = 0;
        }
        else
            gs_DiskErr = -1;
        asm pop ax
  
        asm pop di
        asm pop si
        asm pop dx
        asm pop cx
        asm pop bx
    } /* end if */
 
    return( _AX );
#endif    
} /* end SetDiskPara */


/*-------------------- NϰϫAন ѡ֡ A -----------------------*/
static sword GetCHS (PACKAGE *pkg)
{
    word  sectPerCyl;
 
    if ( SetDiskPara(pkg->disk) )                  /** ]wϺаѼƦ@ܼ **/
        return(-1);
 
    sectPerCyl  = (gs_MaxHead + 1) * gs_MaxSect;
    /*****===================================================
    pkg->cyl    = (word)(pkg->start / sectPerCyl);
    pkg->head   = (word)((pkg->start % sectPerCyl) / gs_MaxSect);
    pkg->sector = (word)((pkg->start % gs_MaxSect) + 1);
    ====================================================*****/
                       
    pkg->cyl    = LongDIV(pkg->start, sectPerCyl);
    pkg->head   = LongMOD(pkg->start, sectPerCyl) / gs_MaxSect;
    pkg->sector = LongMOD(pkg->start, gs_MaxSect) + 1;
 
    return(0);
} /* end GetCHS */


/*--------------------------- INT 13h extension ------------------------------+
|                    INT 13h extension s                 |
+-----------------------------------------------------------------------------+
| JȡG                                                                    |
|                 cmd: lRO, pkg: c, buff: buffer                    |
|                                                                             |
+----------------------------------------------------------------------------*/
static sword Access_HD (byte cmd, PACKAGE *pkg, void FAR *buff)
{
#if USE_BIOSCALL_FUNC
    DRV_PKT  para;
    sword    ret;
    union    Regs  regs;
    struct   SRegs sregs;
 
    ReadSegRegs(&sregs);
 
    if ( cmd == 0 )
    {
        Reset_Disk( pkg->disk );                             /** mnо **/
        ret = 0;
    }
    else if ( cmd == 0x48 )
    {
        *(byte FAR *)buff = 30;              /** c׬ 30 Ӧ줸 **/
        for ( ret = 1 ; ret < 30 ; ret++ )   /** added for some BIOS, SPF04 **/
            *((byte FAR *)buff + ret) = 0;
        sregs.ds  = (word)FP_SEGM(buff);
        regs.x.si = (word)FP_OFFS(buff);
        regs.h.dl = pkg->disk;
        regs.h.ah = cmd;
        BiosCall(0x13, &regs, &sregs);
        ret = (sword)(word)regs.h.ah;
    }
    else
    {
        if ( GetCHS(pkg) )     /** N pkg->start ন C/H/S sJ pkg->C/H/S **/
        {
            ret = -1;    /* 1; */                       /** modify by SPF01 **/
        }
        else if ( pkg->cyl < 1024 || cmd == 8 )
        {
            /*-----------------------------------+
            |        INTT 13h l \    |
            +-----------------------------------*/
            cmd &= ~0x40;                           /** Transfer to General **/
            ret = INT_13H(cmd, pkg->disk, pkg->head,
                          pkg->cyl, pkg->sector, 1, buff);
        }
        else
        {
            cmd |= 0x40;                          /** Transfer to Extension **/
            para.size      = 16;
            para.reserved1 = 0;
            para.reserved2 = 0;
            
            /*
             * (StartHigh) high word no use, FIX ME
             */
            para.startHigh = 0;
            para.startLow  = pkg->start;
            para.transfer  = pkg->nSects;
            para.buff_OFF  = (word)FP_OFFS(buff);
            para.buff_SEG  = (word)FP_SEGM(buff);

            sregs.ds  = (word)FP_SEGM(&para);
            regs.x.si = (word)FP_OFFS(&para);
            regs.h.dl = pkg->disk;
            regs.h.ah = cmd;
            regs.h.al = 0;

            /* mark for AMI BIOS, SPF03 */
            #if 0
                if ( cmd == 0x43 )
                    regs.h.al = 2;
            #endif       

            BiosCall(0x13, &regs, &sregs);
            ret = (sword)(word)regs.h.ah;
        } /* end if */
    } /* end if */

    return( ret );

#else

    DRV_PKT  para;
    sword    ret;
 
    asm push ds
    asm push es
    asm push bx
    asm push cx
    asm push dx
    asm push si
    asm push di
 
    if ( cmd == 0 )
    {
        Reset_Disk( pkg->disk );                             /** mnо **/
        ret = 0;
    }
    else if ( cmd == 0x48 )
    {
        *(byte FAR *)buff = 30;              /** c׬ 30 Ӧ줸 **/
        for ( ret = 1 ; ret < 30 ; ret++ )   /** added for some BIOS, SPF04 **/
            *((byte FAR *)buff + ret) = 0;
        _DS = (word)FP_SEGM(buff);
        _SI = (word)FP_OFFS(buff);
        _DL = pkg->disk;
        _AH = cmd;
        __int__(0x13);                      /** _DS == _SS == FP_SEGS(buff) **/
        ret = _AX >> 8;
    }
    else
    {
        if ( GetCHS(pkg) )     /** N pkg->start ন C/H/S sJ pkg->C/H/S **/
        {
            ret = -1;    /* 1; */                       /** modify by SPF01 **/
        }
        else if ( pkg->cyl < 1024 || cmd == 8 )
        {
            /*-----------------------------------+
            |        INTT 13h l \    |
            +-----------------------------------*/
            cmd &= ~0x40;                           /** Transfer to General **/
            ret = INT_13H(cmd, pkg->disk, pkg->head,
                          pkg->cyl, pkg->sector, 1, buff);
        }
        else
        {
            cmd |= 0x40;                          /** Transfer to Extension **/
            para.size      = 16;
            para.reserved1 = 0;
            para.reserved2 = 0;
            
            /*
             * (StartHigh) high word no use, FIX ME
             */
            para.startHigh = 0;
            para.startLow  = pkg->start;
            para.transfer  = pkg->nSects;
            para.buff_OFF  = (word)FP_OFFS(buff);
            para.buff_SEG  = (word)FP_SEGM(buff);
   
            /* modified by SPF, 2002.07.20 */
            _DS = (word)FP_SEGM(&para);
            _SI = (word)FP_OFFS(&para);
            _DL = pkg->disk;
            _AH = cmd;
            _AL = 0;

           /* mark for AMI BIOS, SPF03 */
           #if 0
               if ( cmd == 0x43 )
                  _AL = 2;
           #endif       
  
            __int__(0x13);
            ret = _AX >> 8;
        } /* end if */
    } /* end if */

    asm pop di
    asm pop si
    asm pop dx
    asm pop cx
    asm pop bx
    asm pop es
    asm pop ds
    return( ret );
#endif    
} /* end Access_HD */


/*---------------------------------- INT 13h ---------------------------------+
|                          INT 13h s                     |
+-----------------------------------------------------------------------------+
| JȡG                                                                    |
|           cmd: lRO,  _Disk: Ϻ,     _Head: Y,    _Cyl: ϬW,        |
|           _Sect: ϰ,  nSects: ϰϼ,  buff: buffer                       |
+-----------------------------------------------------------------------------+
|  * must set _ES before call this                                            |
+----------------------------------------------------------------------------*/
sword INT_13H (byte cmd, byte disk, word head,
               word cyl, word sect, byte nSects, void FAR *buff)
{
#if USE_BIOSCALL_FUNC
    struct SRegs  sregs;
    union  Regs   regs;

    ReadSegRegs(&sregs);

    sregs.es  = (word)FP_SEGM(buff);
    regs.x.cx = ((cyl << 8) + ((cyl >> 2) & 0x00C0)) | (sect & 0x3f);
    regs.x.bx = (word)FP_OFFS(buff);
    regs.h.dh = (byte)head;
    regs.h.dl = disk;
    regs.h.al = nSects;
    regs.h.ah = cmd;
    BiosCall(0x13, &regs, &sregs);
    
    if ( (regs.h.ah == 0) && (cmd == 8) )
    {
        *( word FAR *)buff    = regs.x.cx;
        *((word FAR *)buff+1) = regs.x.dx;
    } /* end if */

    /*-----------------------+
    | added for debug by SPF |
    +-----------------------*/
    #if 0
        c_printf("[out]\n");
        getchar();
    #endif

    return( (sword)(word)regs.h.ah );

#else  /* !USE_BIOSCALL_FUNC */
    /*
     * access local variable after popa instruction,
     * the variable must declaration to volatile type
     */
    volatile word  bakAX, bakCX, bakDX;
    
    /*-----------------------+
    | added for debug by SPF |
    +-----------------------*/
    #if 0
        c_gotoxy(1, 1);
        c_printf("[INT_13H: 0x%08lX]", (dword)buff);
        c_printf("[0x%04X]", (word)*((word *)&buff + 1));
        c_printf("[0x%04X]", (word)buff);
        getchar();
    #endif

    asm pusha
    
    _ES = (word)FP_SEGM(buff);
    _CX = ((cyl << 8) + ((cyl >> 2) & 0x00C0)) | (sect & 0x3f);
    _BX = (word)buff;
    _DH = (byte)head;
    _DL = disk;
    _AL = nSects;
    _AH = cmd;
    __int__(0x13);
 
    bakAX = _AX;
    bakCX = _CX;
    bakDX = _DX;
    asm popa
    
    bakAX = (bakAX >> 8) & 0xff;
    if ( (bakAX == 0) && (cmd == 8) )
    {
        *( word FAR *)buff    = bakCX;
        *((word FAR *)buff+1) = bakDX;
    } /* end if */

    /*-----------------------+
    | added for debug by SPF |
    +-----------------------*/
    #if 0
        c_printf("[out]\n");
        getchar();
    #endif

    return( bakAX );
#endif /* !USE_BIOSCALL_FUNC */
} /* end INT_13H */


/*--------------------------- Get interrupt entry ---------------------------*/
void (FAR *Get_Vector(sword intr))(void)
{
    return( (void (FAR *)())( *(dword FAR *)(intr << 2) ) );
} /* end Get_Vector */


/*----------------------- Set new interrupt vector --------------------------*/
void Set_Vector (sword intr, void (FAR *vect)(void))
{
    dword FAR  *ptr = (dword FAR *)(intr << 2);
 
    _CLI();
    *ptr = (dword)vect;
    _STI();
} /* end SetVector */


/*---------------------- N INT 1Eh  V n     ---------------------+
|                                                                             |
|  Floppy parameter table:                                                    |
|                                                                             |
|     FP_Para DB  0AFh, 02h, 25h, 02h, 12h, 1Bh, 0FFh, 6Ch, 0F6h, 0Fh, 08h    |
+----------------------------------------------------------------------------*/
static void Chg_INT_1E (void)
{
    byte FAR  *ptr;
 
    SetDiskPara(0);                                        /** oϺаѼ **/
    _CLI();
    ptr = (byte FAR *)MAKE_FP(0, 0x1e << 2);             /** INT 1Eh _ **/
    ptr = (byte FAR *)MAKE_FP(*(word FAR *)&ptr[2], *(word FAR *)ptr);
    ptr[4] = (byte)gs_MaxSect;                           /** קϺаѼƪ **/
    ptr[9] = 0x0f;
    _STI();
 
    Reset_Disk(0);                                           /** mnо **/
} /* end Chg_INT_1E */


/*------------------------  N timer intr {  q ------------------------*/
static void CommonProcessTimer (void)
{
    if ( bm_Timer && (bm_Timer != NO_TIMER) )                    /** Second **/
    {
        bm_Counter++;
        if ( bm_Counter == CLK_PER_SEC )                  /** 18.2 @ **/
        {
            bm_Counter = 0;
            bm_Timer--;
        } /* end if */
    } /* end if */

    asm pushf
    (*gs_OldTmIntr)();                               /** call old timer ISR **/
} /* end CommonProcessTimer */


/*----------------------- w     s    _ ---------------------*/
/* void interrupt PreviewTimerIntr (bp, di, si, ds, es, dx, cx, bx, ax, ip, cs, flags) */
void PreviewTimerIntr (void)
{
    asm pusha
    asm push ds

    /* bm_BootTime dependent DS */
    asm push  ax
    asm mov ax, seg bm_Counter
    asm mov ds, ax
    asm pop  ax

    CommonProcessTimer();

    asm pop ds
    asm popa
    asm iret
} /* end PreviewTimerIntr */


/*----------------------- }     s    _ ---------------------*/
/* void interrupt BootTimerIntr (bp, di, si, ds, es, dx, cx, bx, ax, ip, cs, flags) */
void BootTimerIntr (void)
{
    asm pusha
    asm push ds

    /* bm_BootTime dependent DS */
    asm push ax
    asm mov ax, DATA_SEG
    asm mov ds, ax
    asm pop ax

    CommonProcessTimer();

    asm pop ds
    asm popa
    asm iret
} /* end BootTimerIntr */


/*-------------------------- ] m s    _ ---------------------------*/
static void StartTimer (void)
{
    gs_OldTmIntr = Get_Vector(TIMER_INTR);     /** save old timer ISR Entry **/
    Set_Vector(TIMER_INTR, gs_MyTmIntr);
} /* end StartTimer */


/*--------------------------  _     _ ---------------------------*/
static void StopTimer (void)
{
    if ( gs_OldTmIntr )
    {
        Set_Vector(TIMER_INTR, gs_OldTmIntr);         /** restore timer ISR **/
        gs_OldTmIntr = NULL;
    } /* end if */
} /* end StopTimer */


/*------------------------- d I INT_13h {  q --------------------------*/
static void Chg_INT_13 (sword sele)
{
    union Regs  regs;
    byte  FAR   *ptr;
    byte  _cs   *ptrCS;
    word        newSEG;
    sword       i;

    ptr = (byte FAR *)MAKE_FP(0, 0x0413);
    (*(word FAR *)ptr)--;                      /** bǲΰOtm@ӰϬq **/

    BiosCall(0x12, &regs, NULL);
    newSEG = regs.x.ax << 6;
 
    /*---------------------------------------------+
    |    MY_INT_13 {  q  t m     |
    +---------------------------------------------*/
    ptr = (byte FAR *)MAKE_FP(newSEG, 0); /** o~tmŶҩlq} **/
 
    ptrCS = (byte _cs *)((byte *)End_of_BMGR - (byte *)BootHead);
    i = (sword)((byte *)END_INT13 - (byte *)MY_INT_13);
    for ( ; i > 0 ; i-- )
        *ptr++ = *ptrCS++;
 
    ptr  = (byte FAR *)MAKE_FP(newSEG, (byte *)g_TDISK - (byte *)MY_INT_13);
    *ptr = g_Boot[sele].disk;                  /** xsQմOĴXw **/
 
    ptr = (byte FAR *)MAKE_FP(newSEG, (byte *)g_OldInt13 - (byte *)MY_INT_13);
 
    *(dword FAR *)ptr = (dword)Get_Vector(0x13);    /** ƥ INT 13h } **/
 
    /*-------------- V My INT 13h, xxxx:0000 ------------*/
    Set_Vector(0x13, (void (FAR *)())MAKE_FP(newSEG, 0));
 
    Reset_Disk( g_Boot[sele].disk );                       /** mnBw **/
} /* end Chg_INT_13 */


/*----------------------------- Reset a disk --------------------------------*/
sword Reset_Disk (sword disk)
{
    union Regs  regs;
    
    regs.x.ax = 0;
    regs.x.dx = (word)disk & 0x00ff;
    BiosCall(0x13, &regs, NULL);
    return( (sword)(word)regs.h.ah );
} /* end Reset_Disk */


/*-----------------------------  J ø    ---------------------------*/
#if ( DISPLAY != TEXTMODE )

void IntoGraphicMode (void)
{
    union Regs  regs;
    
    #if ( DISPLAY == CHINESE )
        bm_PreUseFont  = NULL;
        bm_Pre2UseFont = NULL;
    #endif
 
    gs_ChTmp.valid = FALSE;
    gs_EngFont     = GetEnglishFontEntry();

    regs.x.ax = 0x0012;
    BiosCall(0x10, &regs, NULL);
    
    SET_WRITE_MODE(0x02);                           /** Set VGA write mode 2 **/
    SELE_GR(8);                                                  /** Set GR8 **/
                            
    g_CurPos.graphicMode = TRUE;
    g_CurPos.cursorShow  = FALSE;
    g_CurPos.cursorStat  = FALSE;
 
    SetColor( INIT_COLOR );                                 /** ϥιw]C **/
    Clr_Block(0, 0, 79, 24);
} /* end IntoGraphicMode */

#endif  /* end not on TEXTMODE */


/*-----------------------------  J  r   ---------------------------*/
void IntoTextMode (void)
{
    union Regs regs;
    
    regs.x.ax = 3;
    BiosCall(0x10, &regs, NULL);                    /** return to text mode **/
    SetColor( INIT_COLOR );                                /** ϥιw]C **/
    g_CurPos.graphicMode = FALSE;
} /* end IntoTextMode */


/*---------------------------- Set cursor location ---------------------------+
|    x = 0 - 79,   y = 0 - 24                                                 |
+----------------------------------------------------------------------------*/
void SetXY (sword x, sword y)
{
#if ( DISPLAY == TEXTMODE )
    union Regs regs;
    
    regs.h.dh = (byte)y;
    regs.h.dl = (byte)x;
    regs.h.bh = 0;
    regs.h.ah = 2;
    BiosCall(0x10, &regs, NULL);

#else

    CursorHidden();
 
    /*------ pGms ------*/
    #if ( DISPLAY == CHINESE )
        if ( gs_ChTmp.valid && ((gs_ChTmp.x != (x - 1)) || (gs_ChTmp.y != y)) )
            Flush();                                   /** LXwİϸ̪r **/
    #endif
 
    Adjust_XY(&x, &y);
 
    g_CurPos.x = x;
    g_CurPos.y = y;

    CursorShow();
#endif
} /* end SetXY */


/*---------------------------------------------------------------------------*/
void GetXY (sword *x, sword *y)
{
#if ( DISPLAY == TEXTMODE )
    union Regs  regs;
    
    regs.h.ah = 3;
    regs.h.bh = 0;
    BiosCall(0x10, &regs, NULL);
    *x = (sword)regs.h.dl;
    *y = (sword)regs.h.dh;
#else
    *x = g_CurPos.x;
    *y = g_CurPos.y;
#endif
} /* end GetXY */


/*---------------------------------------------------------------------------*/
#if ( DISPLAY != TEXTMODE )

static sword IsCtrlChar (byte chr, sword *x, sword *y)
{
    if ( chr == '\n' )
    {
        if ( *y < 24 )
            (*y)++;
        *x = 0;
        return( TRUE );
    }
    else if ( chr == '\r' )
    {
        *x = 0;
        return( TRUE );
    }
    else if ( chr == '\b' )
    {
        if ( *x > 0 )
            (*x)--;
        return( TRUE );
    }
    else if ( chr == '\a' )
    {
        #if PROCESS_BEEP_CHAR
            union Regs  regs;
            
            regs.x.ax = 0x0e07;
            regs.x.bx = 0;
            BiosCall(0x10, &regs, NULL);
        #endif

        return( TRUE );
    }
    else if ( chr == '\t' )
    {
        sword  spc = ((*x + TAB_LEN) / TAB_LEN) * TAB_LEN - *x;
  
        Repeat_Char(' ', spc);
        *x += spc;
        return( TRUE );
    } /* end if */
 
    return( FALSE );
} /* end IsCtrlChar */

#endif  /* end no define TEXTMODE */


/*---------------------------------------------------------------------------*/
#if ( DISPLAY != TEXTMODE )

static void Adjust_XY (sword *x, sword *y)
{
    #if 1
        if ( *x < 0 )
            *x = 0;
        else if ( *x > 79 )
        {
            *y += (*x / 80);
            *x %= 80;
        } /* end if */

        if ( *y < 0 )
            *y = 0;     
        else if ( *y > 24 )
            *y = 24;

    #else     
        if ( *x > 79 )
        {
            (*y)++;
            *x = 0;
        } /* end if */
     
        if ( *y > 24 )
        {
            /**   scroll_up(0, 0, 79, 24, 1);  **/
            *y = 24;
            *x = 0;
        } /* end if */
    #endif
} /* end Adjust_XY */

#endif  /* end no define TEXTMODE */

      
/*---------------------- L X w     r  -------------------------*/
#if ( DISPLAY == CHINESE )

sword Flush (void)
{
    if ( gs_ChTmp.valid )
    {
        Show_Eng((byte)gs_ChTmp.chr, gs_ChTmp.x, gs_ChTmp.y, gs_ChTmp.color);
        gs_ChTmp.valid = FALSE;
        return( TRUE );
    } /* end if */
 
    return( FALSE );
} /* end Flush */

#endif  /* end CHINESE */


/*--------------------------   m  r  ------------------------------*/
void ColorChar (sbyte chr)
{
#if ( DISPLAY == TEXTMODE )
    sword  x, y;
 
    if ( bm_BootTime == FALSE )
    {
        c_putch(chr);
        return;
    } /* end if */
 

    #if USE_BIOSCALL_FUNC
    {
        union Regs  regs;

        if ( chr == '\n' )
            ColorChar('\r');
        else if ( chr != '\r' && chr != 7 )
        {
            regs.h.ah = 9;
            regs.h.al = chr;
            regs.h.bh = 0;
            regs.h.bl = g_CurPos.color;
            regs.x.cx = 1;
            BiosCall(0x10, &regs, NULL);
      
            GetXY(&x, &y);
            if ( x >= 79 && y >= 24 )
                goto AVOID_SCROLL;                                 /** VUD **/
        } /* end if */

        regs.h.ah = 0x0e;
        regs.h.al = chr;
        regs.x.bx = 0;
        BiosCall(0x10, &regs, NULL);
        
        AVOID_SCROLL:
            ;
    } 
    #else   /* !USE_BIOSCALL_FUNC */
        asm push ax
        asm push bx
        asm push cx
     
        if ( chr == '\n' )
            ColorChar('\r');
        else if ( chr != '\r' && chr != 7 )
        {
            _AH = 9;
            _AL = chr;
            _BH = 0;
            _BL = g_CurPos.color;
            _CX = 1;
            __int__(0x10);
      
            GetXY(&x, &y);
            if ( x >= 79 && y >= 24 )
                goto AVOID_SCROLL;                                 /** VUD **/
        } /* end if */
     
        _AH = 0x0e;
        _AL = chr;
        _BX = 0;
        __int__(0x10);
        
AVOID_SCROLL:
     
        asm pop  cx
        asm pop  bx
        asm pop  ax
    #endif   /* !USE_BIOSCALL_FUNC */        

#else                                                      /** not TEXTMODE **/
    sword  x, y;
                  
    CursorHidden();
 
    GetXY(&x, &y);

#if ( DISPLAY == CHINESE )
    if ( gs_ChTmp.valid && IS_CHINESE(gs_ChTmp.chr, chr) )
    {
        byte  aWord[2];
  
        aWord[0] = gs_ChTmp.chr;
        aWord[1] = chr;
        Show_Chi(aWord, gs_ChTmp.x, gs_ChTmp.y, gs_ChTmp.color, g_CurPos.color);
        gs_ChTmp.valid = FALSE;
        g_TextArea[y][x] = TEXTFORM(g_CurPos.color, chr);
        x++;
    }
    else
    {
        Flush();                      /** Ndb buffer ̪ High Byte LX **/
  
        if ( IS_HIGH_BYTE(chr) )
        {
            g_TextArea[y][x] = TEXTFORM(g_CurPos.color, chr);
            gs_ChTmp.color   = g_CurPos.color;
            gs_ChTmp.chr     = chr;
            gs_ChTmp.valid   = TRUE;
            gs_ChTmp.y       = y;
            gs_ChTmp.x       = x;
            x++;
        }
        else
        {
#endif  /* DISPLAY == CHINESE */
  
            if ( IsCtrlChar(chr, &x, &y) == FALSE )      /** YOr **/
            {
                g_TextArea[y][x] = TEXTFORM(g_CurPos.color, chr);
                Show_Eng((byte)chr, x, y, g_CurPos.color);
                x++;
            } /* end if */

#if ( DISPLAY == CHINESE )
        } /* end if */
    } /* end if */
#endif

    SetXY(x, y);                                            /** move cursor **/

    CursorShow();

#endif   /* end !TEXTMODE */
} /* end ColorChar */


/*---------------------------------------------------------------------------*/
void ColorStr (const sbyte *str)
{
    while ( *str )
        ColorChar(*str++);
} /* end ColorStr */


/*--------------------------     r  ------------------------------*/
void Repeat_Char (sbyte ch, sword len)
{
    sword  i;

    for ( i = 0 ; i < len ; i++ )
        ColorChar(ch);
} /* end Repeat_Char */


/*----------------------------------------------------------------------------+
|                               o ^  r                               |
+----------------------------------------------------------------------------*/
#if ( DISPLAY != TEXTMODE )

static void Get_English_Font (byte ch, byte FAR **pBuf)
{
    *pBuf = &gs_EngFont[(word)ch << 4];
} /* end Get_English_Font */

#endif  /* end no define TEXTMODE */


/*----------------------------------------------------------------------------+
|                               o   r                               |
+----------------------------------------------------------------------------*/
#if ( DISPLAY == CHINESE )

static sword Get_Chinese_Font (byte *str, byte FAR **pBuf)
{
    FONT  *pFont;
    
    if ( bm_PreUseFont && (*(word *)bm_PreUseFont->key == *(word *)str) )
    {
        *pBuf = (byte FAR *)bm_PreUseFont->font;
        return( TRUE );
    }
    else if ( bm_Pre2UseFont && (*(word *)bm_Pre2UseFont->key == *(word *)str) )
    {
        *pBuf = (byte FAR *)bm_Pre2UseFont->font;
        return( TRUE );
    } /* end if */

    if ( (pFont = SearchFont(bm_Font, str, 0, bm_nFont - 1)) == NULL &&
         (g_nFont <= 0 || (pFont = SearchFont(g_Font, str, 0, g_nFont - 1)) == NULL) )
    {
        *pBuf = NULL;
        return( FALSE );
    } /* end if */
 
    bm_Pre2UseFont = bm_PreUseFont;
    bm_PreUseFont  = pFont;
    *pBuf          = (byte FAR *)pFont->font;
    return( TRUE );
} /* Get_Chinese_Font */

#endif   /* end CHINESE */


/*---------------------------------------------------------------------------*/
#if ( DISPLAY == CHINESE )

static FONT *SearchFont (FONT *pFont, byte *key, sword begin, sword end)
{
    sword  mid, low, up;
 
    low = begin;
    up  = end;
    while ( up >= low )
    {
        mid = (up + low) >> 1;                                    /** div 2 **/
        if ( *(word *)pFont[mid].key > *(word *)key )
            up = mid - 1;
        else if ( *(word *)pFont[mid].key < *(word *)key )
            low = mid + 1;
        else
            return( &pFont[mid] );
    } /* end while */
     
    return( NULL );
} /* end SearchFont */

#endif  /* end CHINESE */


/*---------------------------------------------------------------------------*/
#if ( DISPLAY == CHINESE )

static void Show_Chi (byte *aWord, sword x, sword y, byte color, byte color2)
{
    byte FAR  *pFont;
    byte      fill[2];
    sword     endH;
 
    if ( Get_Chinese_Font(aWord, &pFont) )
    {
        x *= (E_WIDTH + H_GAP);              /** H^re׬mp⪺ **/
        y *= (E_HIGH  + V_GAP);
  
        for ( endH = y + C_HIGH ; y < endH ; y++ )
        {
            Draw_pixel_vram(x, y, color, *pFont++);
            Draw_pixel_vram(x + E_WIDTH, y, color2, *pFont++);
        } /* end for */
  
        *(word *)fill = ( IsExtChiChar(aWord) ) ? *(word *)(pFont - 2) : 0;
        for ( endH += V_GAP ; y < endH ; y++ )
        {
            Draw_pixel_vram(x, y, color, fill[0]);
            Draw_pixel_vram(x + E_WIDTH, y, color2, fill[1]);
        } /* end for */
    }
    else
    {
        Show_Eng(aWord[0], x, y, color);
        Show_Eng(aWord[1], x + 1, y, color2);
    } /* end if */
} /* end Show_Chi */

#endif  /* end CHINESE */


/*---------------------------------------------------------------------------*/
#if ( DISPLAY == CHINESE )

static sword IsExtChiChar (byte *str)
{
    return( *(word *)str == 0x78a2 );

#if 0
    if ( *str == 0xa2 )
    {
        str++;
        return( *str == 0x71 || *str >= 0x73 && *str <= 0x75 ||     /** Box **/
                *str == 0x78 || *str == 0x7a || *str == 0x7b );
    } /* end if */
 
    return( FALSE );
#endif  /* 0 */
} /* end IsExtChiChar */

#endif  /* end CHINESE */


/*---------------------------------------------------------------------------*/
#if ( DISPLAY != TEXTMODE )

static void Show_Eng (byte aChar, sword x, sword y, byte color)
{
    byte FAR  *pFont;
    byte      mask = 0;
    sword     endH;
 
    Get_English_Font(aChar, &pFont);
    x *= (E_WIDTH + H_GAP);                    /** H^rmp⪺ **/
    y *= (E_HIGH + V_GAP);
    
    for ( endH = y + E_HIGH ; y < endH ; y++ )
        Draw_pixel_vram(x, y, color, *pFont++);
 
    if ( IsExtEngChar(aChar) )
    {
        pFont -= V_GAP;
        mask   = 1;
    } /* end if */
 
    for ( endH += V_GAP ; y < endH ; y++ )
        Draw_pixel_vram(x, y, color, (mask ? *pFont++ : 0));
 
} /* end Show_Eng */

#endif  /* end no define TEXTMODE */


/*---------------------------------------------------------------------------*/
#if ( DISPLAY != TEXTMODE )

static sword IsExtEngChar (sbyte ch)
{
    return( (ch == BG_CHAR) || (ch == '') || (ch == '') || (ch == '') ||
            (ch == '') || (ch == '') || (ch == '') || (ch == '') );
} /* end IsExtEngChar */

#endif  /* end no define TEXTMODE */


/*---------------------------------------------------------------------------*/
#if ( DISPLAY != TEXTMODE )

static void Draw_pixel_vram (word x, word y, byte color, sword mask)
{
    byte FAR *vram = (byte FAR *) MAKE_FP(VRAM_SEG, (ROW_SIZE * y) + (x >> 3));
    byte     vTemp = 0;

    /*
     * äݭnC橳UDA
     * Ǵ BIOS G|bYǵ{ǫvT]wA
     * ]bܳtפάۮeʤḀunFۮeʪܡC
     */
    #if SELE_REG_EVERY_DRAW
        SET_WRITE_MODE(0x02);                         /* Set to write mode 2 */
        SELE_GR(8);
    #endif
 
    SET_GR(mask);                                 /** select foreground bit **/
    vTemp |= *vram;        /** Ū, ݪ`NPsĶ̨Τƫi|C **/
    *vram = color & 0x0f;                                          /** show **/

    SET_GR(~mask);                                /** select background bit **/
    vTemp |= *vram;        /** Ū, ݪ`NPsĶ̨Τƫi|C **/
    *vram = color >> 4;                                            /** show **/
} /* Draw_pixel_vram */

#endif  /* end no define TEXTMODE */


/*---------------------------------------------------------------------------*/
#if ( DISPLAY != TEXTMODE )

static void Draw_Cursor (word x, word y, byte color)
{
    word      mask  = 0x7E;
    byte      vTemp = 0;
    sword     i;
    byte FAR  *vram;
 
    x *= (E_WIDTH + H_GAP);                    /** H^rmp⪺ **/
    y *= (E_HIGH + V_GAP);
    y += E_HIGH;
 
    vram = (byte FAR *) MAKE_FP(VRAM_SEG, (ROW_SIZE * y) + (x >> 3));
    color  &= 0x0f;
    
    for ( i = 0 ; i < V_GAP ; i++ )
    {
        SET_GR(mask);                             /** select foreground bit **/
        vTemp |= *vram;    /** Ū, ݪ`NPsĶ̨Τƫi|C **/
        *vram = color;                                             /** show **/
        vram += ROW_SIZE;
    } /* end for */
} /* Draw_Cursor */

#endif  /* end no define TEXTMODE */


/*---------------------------------------------------------------------------*/
#if ( DISPLAY != TEXTMODE )

static void CursorShow (void)
{
    if ( !g_CurPos.cursorShow || g_CurPos.cursorStat )
        return;
    g_CurPos.cursorStat = TRUE;
    Draw_Cursor(g_CurPos.x, g_CurPos.y, g_CurPos.cursorColor);
} /* end CursorShow */

/*--------------------*/
static void CursorHidden (void)
{
    if ( !g_CurPos.cursorShow || !g_CurPos.cursorStat )
        return;
    g_CurPos.cursorStat = FALSE;
    Draw_Cursor(g_CurPos.x, g_CurPos.y,
                (g_TextArea[g_CurPos.y][g_CurPos.x] >> 12) & 0x0f);
} /* end CursorHidden */

#endif  /* end no define TEXTMODE */
     

/*--------------------------------- ЪA --------------------------------*/
sword IsCursorShow (void)
{
    return( g_CurPos.cursorShow );
} /* end IsCursorShow */


/*----------------------------- ܩ --------------------------*/
void Ctrl_Cursor (sword sw)
{

#if ( DISPLAY == TEXTMODE )
    union Regs  regs;
    
    regs.h.ah = 1;
    regs.x.cx = ( sw ) ? 0x0d0e : 0x1000;          /** sw = 1:ܡB 0: **/
    BiosCall(0x10, &regs, NULL);
#else
    g_CurPos.cursorShow = TRUE;
    if ( sw )
        CursorShow();
    else
        CursorHidden();
#endif  /* end !TEXTMODE */

    g_CurPos.cursorShow = sw;                              /** OЪA **/

} /* end Ctrl_Cursor */


/*-------------------  o BIOS ^  r   i J I --------------------*/
#if ( DISPLAY != TEXTMODE )

static byte FAR *GetEnglishFontEntry (void)
{
    /* can't declaration to stack variable,
     * because after get english font, the _BP register will be changed.
     * access local variable after popa instruction,
     * the variable must declaration to volatile type
     */
    static volatile word  eFontSEG, eFontOFF;

    /*
     * I can't promise all BIOS change ax, bx, bp only
     * so I use pusha, popa backup register
     */
    asm push  es
    asm pusha
    _BX = 0x0600;           /** o VGA BIOS Ҵ 8*16 ^rҩl} **/
    _AX = 0x1130;
    __int__(0x10);
    
    eFontOFF = _BP;
    eFontSEG = _ES;
    asm popa    
    asm pop  es

    return( (byte FAR *)MAKE_FP(eFontSEG, eFontOFF) );
} /* end GetEnglishFontEntry */

#endif  /* end no define TEXTMODE */


/*------------------------ Ұʺ޲z{lƵ{q -----------------------*/
static byte Asm_Init_BootMGR_Env (void)
{
#if USE_BIOSCALL_FUNC
    union Regs regs;
    
    /*
     *  Y SPF boot manager dI INT 13h hѰdI
     *  ps. SPF BMGR iHҰʨ䥦 SPF BMGR
     */
    if ( !bm_BootTime )
        return( g_Info.nHD );

    regs.x.ax = 0x0305;
    regs.x.bx = 0;
    BiosCall(0x16, &regs, NULL);

    Ctrl_DrvExchg( RELEASE_MY_INT13 );     /** 񤧫eW MY_INT13H **/
    Reset_Disk( 0x80 );

    regs.h.ah = 8;
    regs.h.dl = 0x80;
    BiosCall(0x13, &regs, NULL);
    
    return( regs.h.dl );

#else
    /*
     * access local variable after popa instruction,
     * the variable must declaration to volatile type
     */
    volatile byte  nHD;

    if ( !bm_BootTime )
        return( g_Info.nHD );
    
    asm pusha
 
    /*
     *  Y SPF BMGR dI INT 13h hѰdI
     */
    Ctrl_DrvExchg( RELEASE_MY_INT13 );          /** 񤧫eW MY_INT13H **/
    Reset_Disk( 0x80 );
    
    asm mov ah, 8
    asm mov dl, 80h
    asm int 13h
 
    asm mov  nHD, dl                                    /** o̤jwо **/
 
    asm mov  ax, 0305h                                    /** Keyboard speed **/
    asm mov  bx, 0
    asm int  16h
 
    asm popa
    return( nHD );
#endif   
} /* end Asm_Init_BootMGR_Env */


/*----------------------------- Jump to O.S Loader --------------------------*/
static void IntoOsEntry (sword disk)
{
    asm mov ax, 0
    asm mov es, ax
    asm mov ds, ax
    asm mov bx, 7c00h
    asm mov dx, disk                                       /** FreeBSD ݭn **/
    asm cli
    asm mov ss, ax
    asm mov sp, 7c00h
    asm sti
 
    __emit__(0xea, 0, 0x7c, 0, 0);                  /* far jump to 0000:7C00 */
} /* end IntoOsEntry */


/*---------- read segment register and restore to sregs structure -----------*/
void ReadSegRegs (struct SRegs *sregs)
{
    sregs->es = _ES;
    sregs->ds = _DS;
    sregs->cs = _CS;
    sregs->ss = _SS;
} /* end ReadSegRegs */


/*--------------------------- 椤_A int86 --------------------------*/
void BiosCall (sword intr_no, union Regs *regs, struct SRegs *sregs)
{
    void (FAR *intrEntryPtr)(void) = Get_Vector(intr_no);

    asm push ds
    asm push es
    asm pusha

    if ( sregs )
    {
        _ES = sregs->es;
        _DS = sregs->ds;
    } /* end if */

    asm mov  bx, regs

    /* set ax,bx,cx,dx,si,di */
    asm mov  ax, [bx]
    asm mov  cx, [bx+ 4]
    asm mov  dx, [bx+ 6]
    asm mov  si, [bx+ 8]
    asm mov  di, [bx+10]
    asm mov  bx, [bx+ 2]

    /* point to interrupt vector table and far call */
    asm push bp

    asm pushf
    intrEntryPtr();

    asm pop  bp
    asm push bp
    
    asm pushf
    asm mov  bp, regs
    asm mov  [bp], ax

    /* get flags */
    asm pop  ax
    asm mov  [bp+14], ax

    /* get cflags */
    asm and  ax, 1
    asm mov  [bp+12], ax

    /* get ax,bx,cx,dx,si,di */
    asm mov  [bp+ 2], bx
    asm mov  [bp+ 4], cx
    asm mov  [bp+ 6], dx
    asm mov  [bp+ 8], si
    asm mov  [bp+10], di

    asm pop  bp
    if ( sregs )
    {
        sregs->es = _ES;
        sregs->ds = _DS;
    } /* end if */

    asm popa
    asm pop  es
    asm pop  ds
} /* end BiosCall */


/*-------------------------------- Show Number ------------------------------*/
#if SPF_DEBUG

void ShowNum (word val, word radix)
{
    if ( val >= radix )
        ShowNum(val / radix, radix);
    val %= radix;
    val += ((val < 10) ? 0x30 : 55);
    ColorChar( (sbyte)val );
} /* end ShowNum */

#endif  /* end SPF_DEBUG */


/*----------------- ]禡ΥHs MY_INT_13 οѵ{ -----------------*/
void End_of_BMGR (void)
{
} /* end End_of_BMGR */


/*--------------------------- oҰʵ{X --------------------------*/
sword GetBootCode_nSect (void)
{
    dword  len = (dword)((byte *)End_of_BMGR - (byte *)BootHead) +
                        ((byte *)END_INT13 - (byte *)MY_INT_13);
    /*------------------------------------+
    |    len / 512 + (len % 512 != 0)     |
    +------------------------------------*/
    return( (sword)((len >> 9) + ((len & 0x1ff) != 0)) );
} /* end GetBootCode_nSect */


/*------------------------- oҰʵ{Ƭq ------------------------*/
sword GetBootData_nSect (void)
{
    word  len = (word)g_DataEnd - (word)g_Magic_Str;
    return( (sword)((len >> 9) + ((len & 0x1ff) != 0)) );
} /* end GetBootData_nSect */


/*--------------------------- oҰʵ{`ϰϼ --------------------------*/
sword GetBootmgr_nSect (void)
{
    return( GetBootCode_nSect() + GetBootData_nSect() + 1 );
} /* end GetBootmgr_nSect */

