/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include "bootmgr.h"
#include "selemenu.h"
#include "common.h"
#include "global.h"
#include "keymap.h"

#define ITEM_8_10   (ITEM8 | ITEM9 | ITEM10)
#define ITEM_6_10   (ITEM6 | ITEM7 | ITEM_8_10)
#define ITEM_3_10   (ITEM3 | ITEM4 | ITEM5 | ITEM_6_10)
#define ITEM_2_5    (ITEM2 | ITEM3 | ITEM4 | ITEM5)
#define ITEM_2_10   (ITEM2 | ITEM_3_10)
#define ITEM_2_11   (ITEM_2_10 | ITEM11)
    
/*==========================   D e   [ ===========================*/
void Boot_Menu_Picture (sword clrFlag)
{
    static  sword h_line[] = { 3, 22, 0 };
    sword   i;
 
    c_textattr(DEFAULT_COLOR);
    if ( clrFlag )
        c_clrscr();
 
    ShowExtra( VER_LINE );
 
    Square(1, 1, 80, 24, h_line);                                /** e **/
    c_printXY(51, 3, "");
 
    for ( i = 4 ; i < 22 ; i++ )
    {
        if ( i > 6 )
        {
            c_gotoxy( (( i < 16 ) ? 5 : 4), i);
            c_printf("%d.", i - 6);                        /** ܰOs **/
        } /* end if */
  
        c_printXY(51, i, "");
    } /* end for */
    
    c_printXY(51, 22, "");
    c_printXY(51, 8, "");
    Repeat_Char('', 28);
    c_putch('');
    c_printXY(22, 2, "SPecial FDisk = Boot Manager + FDisk");
 
    #if ( DISPLAY == CHINESE )
        c_printXY(10, 4, "          w        ");
    #else
        c_printXY(10, 4, "Menu_Description   H.D  Partition  Vkey");
    #endif
 
    c_gotoxy(3, 5);
    Repeat_Str("--", 24);
 
    #if ( DISPLAY == CHINESE )
        c_printXY(4, 23, "TCG");
    #else 
        c_printXY(4, 23, "Prompt: ");
    #endif
 
    ShowExtra( BMG_EXPERT_MODE );
} /* end Boot_Menu_Picture */


/*=============================     C ==============================*/
void ShowExtra (sword showKind)
{
    #if ( DISPLAY == CHINESE )
        #define EXPERT_MSG   "Ma"
        #define CLEAR_MSG    "    "
        #define VERSION_MSG  " SPF    z {  w   " \
                             " x sG" VERSION " x ]p̡G "
    #else
        #define EXPERT_MSG   "Expert"
        #define CLEAR_MSG    "      "
        #define VERSION_MSG  "$ SPF Boot Manager function install " \
                             " Ver:" VERSION "  Program by Hsu-Ping Feng "
    #endif
    
    switch( showKind )
    {
        case VER_LINE:
            c_textattr(PMT_LINE_COLOR);
            c_printXY(1, 25, VERSION_MSG);
            c_clreol();
            c_textattr(DEFAULT_COLOR);
            break;
  
        case BMG_EXPERT_MODE:
            c_gotoxy(3, 4);
            if ( g_Info.expertMode )
            {
                c_textattr(EXPERT_COLOR);
                c_printf(EXPERT_MSG);
                c_textattr(DEFAULT_COLOR);
            }
            else
                c_printf( CLEAR_MSG );
            break;
    } /* end switch */
} /* end ShowVerLine */


#if ( DISPLAY == CHINESE )
    static sbyte *GiveUpStr = "T w    e    ] w H";
#else
    static sbyte *GiveUpStr = "Would you like to give up bootmenu ?";
#endif

/*================================ D   =================================*/
sword Bootmgr_Menu (sword begin, BMGR *boot, PARTN *partnArr)
{
    #if ( DISPLAY == CHINESE )
        #define CREATE_BOOT_MENU    "A.    }   "
        #define APPEND_BOOT_ITEM    "A.  s W    "
        static sbyte *menu[] =
        {
            "P.  w    u ",    NULL,
            "M.  s  }   ",
            "O.  i  ] w (Dn)", "G.  i  w ",
            "S.  x s  ",          "L.   J }   ",
            "E.  M a    ",    "U.  M    ] w",
            "Q.     }"
        };
    #else
        #define CREATE_BOOT_MENU    "A.  Create Boot Menu"
        #define APPEND_BOOT_ITEM    "A.  Append Boot Item"
        static sbyte *menu[] =
        {
            "P.  Partition tools",    NULL,
            "M.  Edit Boot Menu",
            "O.  Optional Setup",     "G.  Begin install",
            "S.  Save to file",       "L.  Load Boot Menu",
            "E.  Expert mode switch", "U.  Reset Boot Menu",
            "Q.  Quit to DOS"
        };
    #endif  /* end CHINESE */
 
    extern SeleMenu g_Menu;                                /** ο檫 **/
    sword  sele, flag, i;
 
    menu[1] = ( g_BootPara.nBootREC ) ? APPEND_BOOT_ITEM : CREATE_BOOT_MENU;
 
    /*
     * οUﶵTBP]wA
     *  low bit }lU bit @ӿﶵA FALSE ̪ܸӿﶵŪ
     */
    flag = ( g_BootPara.nBootREC == 0 ) ? ITEM2 | ITEM7 | ITEM8 | ITEM10 :
           ( g_BootPara.nBootREC == 1 ) ? ITEM_2_10 :
           ( g_BootPara.nBootREC < REC_NUMBER ) ? ITEM_2_11 : ITEM_3_10;

    if ( g_Info.nHD > 0 )             /** wФ~\檺 1  **/
        flag |= 1;

    /** ]wο椺e **/
    for ( i = 0 ; i < sizeof(menu) / sizeof(sbyte *) ; i++,  flag >>= 1 )
    {
        g_Menu.itemColor( (i == 0) ? FDISK_TOOLS_COLOR   :
                          (i == 1) ? ADD_BOOT_ITEM_COLOR : DEFAULT_COLOR );
        g_Menu.prompt(54, i + 9 + (i > 0) + (i > 4) + (i > 7), menu[i], flag & 1);
    } /* end for */
    
    sele = g_Menu.select(begin);                         /** X{Φ **/
    switch( sele )
    {
        case 1:                                            /** wФΤu **/
            SwitchMenu( FDISK_TOOL_MENU );
            break;
     
        case 2:                                 /** sWҰʰO, bootrec.c **/
            g_BootPara.nBootREC++;
            if ( Input_BootMenu_Rec(boot, partnArr, g_BootPara.nBootREC) )
                g_BootPara.nBootREC--;
            else
                g_Info.bm.updated = TRUE;
            break;
  
        case 3:                                          /** iJsl **/
            SwitchMenu( BOOTMGR_EDIT_MENU );
            Clr_Block(52, 8, 77, 20);                        /** Mﶵ **/
            break;
     
        case 4:                                      /** iJi]wl **/
            SwitchMenu( BOOTMGR_OPTION_MENU );
            Clr_Block(52, 8, 77, 20);                        /** Mﶵ **/
            break;
               
        case 5:                        /** ]ww˰ϥBiw, bootinst.c **/
            Install_Boot_Menu(boot, partnArr);
            break;

        case 6:                                    /** sJɮ, bootfile.c **/
            if ( (i = save_file(boot)) == -1 )
                ShowError( 8 );
            else if ( i == 0 )
                g_Info.bm.updated = FALSE;
            break;
               
        case 7:                                    /** J, bootget.c **/
            if ( g_Info.bm.updated )
                if ( !YN_box(TALK_BOX, GiveUpStr) )
                    break;
            SetHotKeySW(F5_KEY, FALSE);                    /** Ȱ F5  **/
            if ( Load_Menu(boot, partnArr) == 0 )
                g_Info.bm.updated = FALSE;
            SetHotKeySW(F5_KEY, TRUE);                     /** _ F5  **/
            break;
               
        case 8:                                           /** MaҦ **/
            g_Info.expertMode = !g_Info.expertMode;
            ShowExtra( BMG_EXPERT_MODE );
            break;
               
        case 9:                               /** ҦO, bootrec.c  **/
            if ( YN_box(TALK_BOX, GiveUpStr) )
            {
                g_Info.bm.updated = FALSE;
                Init_BMGR(boot, &g_BootPara);
            } /* end if */
            break;
        
        case 10:                                               /** ^ DOS **/
            if ( (g_Info.bm.updated == TRUE) && !YN_box(TALK_BOX, GiveUpStr) )
                sele = 6;                            /** ëVsɿﶵ **/
            else
                sele = QUIT_TO_DOS;
            break;

        default:
            sele = ( g_Menu.lastKey() != ESC_KEY ) ? begin : 10;
            break;
    } /* end switch */
 
    return( sele );
} /* end Bootmgr_Menu */


/*================================ D   =================================*/
sword Bootmgr_Edit_Menu (sword begin, BMGR *boot, PARTN *partnArr)
{
    extern SeleMenu g_Menu;                                /** ο檫 **/
    sword  sele, flag, i;
 
    #if ( DISPLAY == CHINESE )
        static sbyte *menu[] =
        {
            "P.  w    u ",    "A.  s W    ",
            "M.    ...",            "D.  R  ...",
            "I.   J ...",            "Z.  h  ...",
            "V.  w  ...",            "U.  M    ] w",
            "E.  M a    ",    "B.  ^ D  "
        };
    #else
        static sbyte *menu[] =
        {
            "P.  Partition tools",    "A.  Append Boot Item",
            "M.  Modify ...",         "D.  Delete ...",
            "I.  Insert ...",         "Z.  Move ...",
            "V.  Preview ...",        "U.  Reset Boot Menu",
            "E.  Expert mode switch", "B.  Back to Main Menu"
        };
    #endif  /* end CHINESE */

    /*
     * οUﶵTBP]wA
     *  low bit }lU bit @ӿﶵA FALSE ̪ܸӿﶵŪ
     */
    flag = ( g_BootPara.nBootREC == 0 ) ? ITEM2 | ITEM9 | ITEM10 :
           ( g_BootPara.nBootREC == 1 ) ? ITEM_2_5 | ITEM_8_10 :
           ( g_BootPara.nBootREC < REC_NUMBER ) ? ITEM_2_10 : ITEM3 | ITEM4 | ITEM_6_10;

    if ( g_Info.nHD > 0 )             /** wФ~\檺 1  **/
        flag |= ITEM1;

    /** ]wο椺e **/
    for ( i = 0 ; i < sizeof(menu) / sizeof(sbyte *) ; i++,  flag >>= 1 )
    {
        g_Menu.itemColor( (i == 0) ? FDISK_TOOLS_COLOR   :
                          (i == 1) ? ADD_BOOT_ITEM_COLOR : DEFAULT_COLOR );
        g_Menu.prompt(54, i + 10 + (i > 0) + (i > 6), menu[i], flag & 0x0001);
    } /* end for */
    
    sele = g_Menu.select(begin);                         /** X{Φ **/
    switch( sele )
    {
        case 1:                                            /** wФΤu **/
            SwitchMenu( FDISK_TOOL_MENU );
            break;

        case 2:                                 /** sWҰʰO, bootrec.c **/
            g_BootPara.nBootREC++;
            if ( Input_BootMenu_Rec(boot, partnArr, g_BootPara.nBootREC) )
                g_BootPara.nBootREC--;
            else
                g_Info.bm.updated = TRUE;
            break;
  
        case 3:                                         /** ק, bootrec.c **/
            if ( Modify_BootMenu_Rec(boot, partnArr) == 0 )
                g_Info.bm.updated = TRUE;
            break;
     
        case 4:                                         /** R, bootrec.c **/
            if ( Delete_BootMenu_Rec(boot) == 0 )
                g_Info.bm.updated = TRUE;
            if ( g_BootPara.nBootREC == 0 )
                g_Info.bm.updated = FALSE;
            break;
  
        case 5:                                         /** J, bootrec.c **/
            if ( Insert_BootMenu_Rec(boot, partnArr) == 0 )
                g_Info.bm.updated = TRUE;
            break;

        case 6:                                         /** h, bootrec.c **/
            if ( Move_BootMenu_Rec(boot) == 0 )
                g_Info.bm.updated = TRUE;
            break;

        case 7:                                                /** we **/
            BootHead();
            g_Info.bm.clr_screen = TRUE;
            break;

        case 8:                                            /** MaҦ **/
            if ( YN_box(TALK_BOX, GiveUpStr) )
            {
                g_Info.bm.updated = FALSE;
                Init_BMGR(boot, &g_BootPara);
            } /* end if */
            break;

        case 9:
            g_Info.expertMode = !g_Info.expertMode;
            ShowExtra( BMG_EXPERT_MODE );
            break;

        /*----- ^D -----*/
        default:
            if ( g_Menu.lastKey() != ESC_KEY )
                break;
        case 10:
            SwitchMenu( MAIN_MENU );
            Clr_Block(52, 8, 77, 20);                        /** Mﶵ **/
            break;
    } /* end switch */
 
    return( sele );
} /* end Bootmgr_Edit_Menu */


/*============================== Option   ===============================*/
sword Bootmgr_Option_Menu (sword begin, BMGR *boot, PARTN *partnArr)
{
    extern SeleMenu  g_Menu;                               /** ο檫 **/
    static sbyte     *subMenu[] =
    {
        #if ( DISPLAY == CHINESE )
            "P.  w    u ",  "T.  ] w p  } ",
            "K.  ] w    ",  "W.  ] w q  K X",
            "S.    m  } ",
            "N.   w    ",  "H.  ()æPD",
            "V.  ]     ",  "B.  ^ D  "
        #else    
            "P.  Partition tools",        "T.  Set Timer Boot Item",
            "K.  Set Virtual Key",        "W.  Set Password",
            "S.  Disk Swap ON/OFF",
            "N.  Define Hidden Partn",    "H.  Hidd ON/OFF PRI-Partn",
            "V.  Set Active Partition",   "B.  Back to Main Menu"
        #endif
    };
    sword  sele, i;
    word   flag;

    /*
     * οUﶵTBP]wA
     *  low bit }lU bit @ӿﶵA FALSE ̪ܸӿﶵŪ
     */
    flag = ITEM_2_5 | ITEM7 | ITEM8 | ITEM9;

    if ( g_Info.nHD > 0 )          /** wФ~\檺 1, 6  **/
        flag |= (ITEM1 | ITEM6);

    /** ]wο椺e **/
    for ( i = 0 ; i < sizeof(subMenu) / sizeof(sbyte *) ; i++,  flag >>= 1 )
    {
        g_Menu.itemColor( (i == 0) ? FDISK_TOOLS_COLOR : DEFAULT_COLOR );
        g_Menu.prompt(54, i + 10 + (i > 0) + (i > 3) + (i > 6), subMenu[i], flag & 1);
    } /* end for */
    
    sele = g_Menu.select(begin);                         /** X{Φ **/
    switch( sele )
    {
        case 1:
            SwitchMenu( FDISK_TOOL_MENU );
            break;

        case 2:                                   /** ]ݮɶ, bootrec.c **/
            Set_Default_Boot(boot);
            break;
     
        case 3:                                 /** ]w, bootrec.c **/
            Set_Virtual_Key(boot);
            break;
     
        case 4:                                     /** ]wKX, bootrec.c **/
            if ( Set_Password(boot) )
                g_Info.bm.updated = TRUE;  
            break;
  
        case 5:                                 /** ]wmϺ, bootrec.c **/
            Set_Disk_Swap(boot);
            break;
     
        case 6:                           /** ϥΪ̦۩wä, bootrec.c **/
            User_Define_Hidden(boot, partnArr);
            break;
     
        case 7:                             /** æPD, bootrec.c **/
            Set_Hidden_OnSameKindPartn(boot);
            break;
  
        case 8:                             /** j]wҰʺX, bootrec.c **/
            Set_Active_OnBoot(boot);
            break;

        /*----- ^D -----*/
        default:
            if ( g_Menu.lastKey() != ESC_KEY )
                break;
        case 9:
            SwitchMenu( MAIN_MENU );
            Clr_Block(52, 8, 77, 20);                        /** Mﶵ **/
            break;
    } /* end switch */
 
    return( sele );
} /* end Bootmgr_Option_Menu */
