/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include "bootmgr.h" 
#include "common.h"
#include "selemenu.h"
#include "global.h"
#include "keymap.h"

/*========================== ѱҰʰŪ================================*/
sword Load_Menu (BMGR *boot, PARTN *partnArr)
{
    #if ( DISPLAY == CHINESE )
        #define MENU_SOURCE_MSG     "Ū    "
        #define WHICH_FLOPPY_READ   "Ū   X  n СH "
        #define WHICH_HD_READ       "Ū    w  H"
        #define WHICH_PARTN_READ    "Ū      H"
        static sbyte *menu[] =
        {
            "1) wбҰʺϰ", "2) ۢТ", "3) n", "4) ɮ"
        };
    #else
        #define MENU_SOURCE_MSG     "Menu Source "
        #define WHICH_FLOPPY_READ   "Which floppy disk do you want to get ? "
        #define WHICH_HD_READ       "Which hard disk do you want to get ? "
        #define WHICH_PARTN_READ    "Which partition do you want ?"
        static sbyte *menu[] =
        {
            "1. HD Boot Sector", "2. MBR", "3. Floppy", "4. File"
        };
    #endif        

    extern SeleMenu g_Menu;                                 /** ο檫 **/
    sword  disk, sele, err, i;
    dword  Sector;
    DiskDT *dk;
 
    sele   = 0;
    Sector = 0;

    ShowMSG(MENU_SOURCE_MSG);

    for ( i = 0 ; i < sizeof(menu) / sizeof(sbyte *) ; i++ )
    {
        g_Menu.prompt(i * 4 + sele + 27, 23, menu[i],
                      ((i < 2) && (g_Info.nHD > 0)) ||
                      ((i == 2) && (g_Info.nFP > 0)) || (i == 3) );
        sele += strlen(menu[i]);
    } /* end for */
 
    sele = g_Menu.select(1);                                   /** ο **/
    if ( sele < 1 )
        return(1);
 
    /*--------------------------------------+
    |             q   Ū             |
    +--------------------------------------*/
    if ( sele == 4 )
    {
        err = load_file(boot);
        if ( err < -1 )
            ShowError( (err == -2) ? 8 : 10 );
        return( err != 0 );
    }
    /*--------------------------------------+
    |             q n  Ū             |
    +--------------------------------------*/
    else if ( (sele == 3) || (g_Info.nHD == 0) )
    {
        ShowMSG (WHICH_FLOPPY_READ);
        if ( InputWORD(&disk, 1, g_Info.nFP, 2, ALLOW_ESC) == ESC_KEY )
            return(1);
        dk = GetFloppyDT(disk);
    }
    /*------------------------------+
    |      q w  MBR Ū        |
    +------------------------------*/
    else if ( sele == 2 )
    {
        dk = GetHardDiskDT(1);
    }
    /*----------------------------------------------+
    |      q w  Y       Ū       |
    +----------------------------------------------*/
    else
    {
        SaveScreen();
        g_Info.bm.clr_screen = TRUE;
        ShowMSG(WHICH_HD_READ);

        disk = Sele_HD(FALSE, 0);                       /** ܱw˪w **/
        if ( disk < 1 )
        {
            GiveupScreenBlock();
            return(1);
        } /* end if */
  
        dk = GetHardDiskDT(disk);
  
        /*-------------------------------------+
        |       Ū  w           |
        +-------------------------------------*/
        err = Get_Disk_Info(dk, partnArr, TRUE);           /** oθT **/
  
        if ( err )                                       /** Ωεw~ **/
        {
            Disk_Err_Msg( err );
            if ( (err & 0x1a) != 0 )
            {
                GiveupScreenBlock();
                return(-1);
            } /* end if */
        } /* end if */
  
        ShowMSG(WHICH_PARTN_READ);
        
        /*------------------------------------------------------*/
        /*     ܤΡA Just_id20h 禡 Partnmnu.C      */
        /*------------------------------------------------------*/
        sele = Sele_Partn(partnArr, 0, 0, Just_id20h);
  
        if ( sele < 1 )                                        /** ܤ **/
        {
            GiveupScreenBlock();
            return(1);
        } /* end if */
  
        Sector = GetStart(&partnArr[sele - 1]);            /** oҩlϰ **/
        g_Info.bm.clr_screen = FALSE;
        RestoreScreen();                                       /** ^se **/
    } /* end if */
 
    err = read_bootmenu(dk, Sector);                  /** iŪҰʿ **/
    if ( err )
        ShowError( (err == -1) ? 7 : 27 );
 
    return( err );
} /* end LoadMenu */


/*========================== ŪҰʿ椺e =============================*/
sword read_bootmenu (DiskDT *dk, dword begin)
{
    byte      buff[512], *ptr;
    KERL_LDR  *KerLDR;
    sword     i;
 
    if ( dk->drv->linearRead(dk, begin, 1, buff) )          /** J Loader **/
       return(-1);
 
    KerLDR = (KERL_LDR *)buff;
 
    /*------ ˬdO_ SPF Bootmgr ------*/
    if ( CompMEM(KerLDR->mark, "SPF_Boot", 8) || (KerLDR->magicNum != 0xaa55) )
        return(-2);
 
    if ( KerLDR->version < VER_NO )
        return(-2);
 
    /*---------------------+
    |     o   q    |
    +---------------------*/
    ptr = (byte *)&g_BootPara;
    for ( i = 0 ; ptr < g_EndLoad ; i++, ptr++ )
    {
        if ( (i & 0x1ff) == 0 )                                 /** i % 512 **/
        {
            if ( dk->drv->linearRead(dk, ++begin, 1, buff) )
                return(-1);
            if ( ptr == (byte *)&g_BootPara )
            {                          
                i = sizeof(g_Magic_Str);
                if ( CompMEM(buff, g_Magic_Str, i) )
                    return(-2);
            }
            else
               i = 0;
        } /* end if */
  
        *ptr = buff[i];
    } /* end for */
           
    if ( g_BootPara.nBootREC > REC_NUMBER )
    {  
        Init_BMGR(g_Boot, &g_BootPara);
        return(-2);
    } /* end if */
 
    return(0);
} /* end read_bootmenu */

