/*
	useful.c
	
	Copyright (c) by tom ehlert 2001-2004 - all rights reserved

	Licensed under the Artistic License version
	
	please see LICENSE.TXT for details

    */

#include "useful.h"


/*************** utility functions *********************/


int memicmp(char *s1,char *s2,int len)
{
	int c;
	
	for ( ; len; s1++,s2++,len--)
		if ((c = toupper(*s1) - toupper(*s2)) != 0)
			return c;
	return 0;			
}

int strlen (char * s)
{
    int i = 0;

    while (*s++)
       i++;

    return i;
}


char *skipWhite(char *s)
{
	while (isWhite(*s))
		s++;
	return s;		
}            

int toupper (unsigned c)
{
	if (c >= 'a' && c <= 'z')
		return c - 0x20;

	return c;
}			

/* check if a certain option is contained in the cmdline */
/* if yes, return TRUE and remove it from the cmdline */

int pascal FindCommand(char *pCmdline, char *searchstring, char **found)
{
    int searchlen = strlen(searchstring);
    int i;

    for (i = 0; *pCmdline; pCmdline++,i++) {
        if ((i == 0) || (*(pCmdline-1) == ' ')) {
            if (memicmp(pCmdline, searchstring, searchlen) == 0) {
                if (found)
                    *found = pCmdline;
            						/* now remove found string */
                memcpy( pCmdline, pCmdline+searchlen,
								strlen(pCmdline+searchlen) +1);
            
                return TRUE;
            }
		}
	}
	return FALSE;
}

/* return greater than int values */

long pascal GetValue(char *commandline, int base, char usesuffix)
{
	int len = 0 /*, result = 0 */,digit;
	long result = 0L;
	
	for(;; len++) {
		digit = toupper(commandline[len]);

		if (digit >= '0' && digit <= '9')
			digit = digit - '0';
		else if (digit >= 'A')
			digit = digit - 'A' + 10;
		else
			break;

		if (digit >= base)
			break;			
		result = result * base + digit;			
    }
			
    if (usesuffix)
        switch (toupper(commandline[len])) {
		case 'G': result *= 1024;
		case 'M': result *= 1024;
		case 'K': commandline[len]=' ';
		          break;
        }

            						/* now remove found string */
	memcpy( commandline, commandline+len,
								strlen(commandline+len) +1);

	return result;	
}

