
;--- 16 bit ASM part of Jemm

		.286
        .SEQ		;avoid DOSSEG segment order (RSEG must be first)

	include jemm.inc	
	include debug.inc

?INITRMDBG	equ 0	;log real-mode init 
?XMSRMDBG	equ	0	;log XMS calls
?EMXRMDBG	equ	0	;log EMMXXXX0 calls
?UNLRMDBG	equ 0	;log unload
?RMDBG		equ ?INITRMDBG + ?XMSRMDBG + ?EMXRMDBG + ?UNLRMDBG	; debug displays in real-mode

?KNOWNGDT	equ 0	;is location of GDT known?

if ?MASM
	option proc:private
endif

if ?INTEGRATED
NAMEEXE 	equ <"JEMMEX">
NAMEPGM		equ <"JemmEx">
else
NAMEEXE 	equ <"JEMM386">
NAMEPGM		equ <"Jemm386">
endif
NAMEGEN   	equ <"Jemm">

;--- some parts of the EMM binary are written in C.
;--- to prevent the linker from including CRT modules,
;--- some compiler helper functions are (re)implemented in ASM

ifndef ?WCC			; Open Watcom WCC
?WCC equ 0
endif
ifndef ?MSC			; MS Visual C++ 1.52 compiler
?MSC equ 0
endif
ifndef ?DMC			; Digital Mars C++
?DMC equ 0
endif

?NEARC	equ 0		; set to 1 to support TCC 3
if ?WCC
?RSEG	equ 0
else
?RSEG	equ 1		; use separate RSEG segment
endif
?ADDCONT equ 0		; currently not used

EXECMODE_SYS equ 0
EXECMODE_EXE equ 1

;--- @DefineBP: macro to define a v86-"breakpoint"

@DefineBP macro _name
if ?MASM
_name&::
else
_name&:
endif
	@BPOPC
	endm

ife ?MASM
	LOCALS
endif

if ?RSEG
RSEG SEGMENT PARA public 'CODE'	;resident code + data
RSEG ENDS
endif

if ?RSEG
_TEXT	segment	word public 'CODE'
else
_TEXT	segment	PARA public 'CODE'
endif
	extrn _TheRealMain:near

    public _memset
    public _memcpy
    public _strlen
    public __memicmp
    public _printf
    public FINDCOMMAND
    public GETVALUE
	public _TestForSystemRAM	;test if a page is RAM in upper memory
	public _EmmStatus		; display EMM status
	public _EmmUpdate		; update Jemm386 status
	public _IsProtectedMode	; proc to determine if cpu is in v86 mode
	public _emmcall			; call EMS function
	public _XMSinit			; get XMS status
ife ?INTEGRATED    
	public _xmscall			; call XMS function
	public _xmscall32		; call XMS 3.0 function with 32bit registers
else
	public _I15GetMemoryStatus
	public _I15AllocMemory
	public _EnableA20
	public _DisableA20
	public _GetA20Method
endif
	public _VMwareDetect
if ?UNLOAD    
    public _TryUnload
endif    
if ?ADDCONT    
	public _AddIfContiguousWithDosMem
endif

_TEXT	ends

if ?RSEG
_TEXT16 GROUP RSEG, _TEXT
else
_TEXT16 GROUP _TEXT
endif

_TEXT32 SEGMENT PARA public 'CODE'	;include external module Jemm32
if ?MASM
		.nolist
endif        
		include _jemm32.inc
if ?MASM
		.list
endif        
_TEXT32	ENDS

BEGDATA segment PARA public 'DATA'	;make sure DGROUP is para aligned
BEGDATA ends

_DATA	segment word public 'DATA'
		extrn _jemmini:JEMMINIT
		extrn _startup_verbose:BYTE		; more (debug) output in Init Phase
        extrn _emmfunction:byte
if ?LOAD
        extrn _bLoad:BYTE
endif
        extrn _emmreg16:near
ife ?INTEGRATED        
        extrn _xmsreg16:near
        extrn _xmsreg32:near
else
		extrn _x_option:byte
		extrn _no_above_16:byte
        extrn _xms_num_handles:word
        extrn _xms_max:dword
endif        

_XMSdriverAddress dd 0

wLow	dw RSEG_END		;resident low memory required by driver

if ?INTEGRATED

methods label byte
	db 3,"kbc"       ;0 (A20_KBC)
	db 3,"ps2"       ;1 (A20_PS2)
	db 4,"bios"      ;2
	db 8,"alwayson"  ;3
	db 4,"fast"      ;4
	db 6,"port92"    ;5
    db 0

MsgUnknownA20	db 'No Supported A20 method detected',0dh,0ah,'$'

endif

		public _szHelp
        
_szHelp db "usage: either add a line to CONFIG.SYS: DEVICE=",NAMEEXE,".EXE [ options ]",LF
        db " or run it from the command line: C:\>",NAMEEXE," [ options ]",LF
        db "available options are:",LF
if ?A20XMS or ?A20PORTS
		db "+A20/NOA20     A20-disable emulation on/off (default on)",LF
endif
if ?INTEGRATED
		db " A20METHOD:m   set A20 switch method. Possible values for <m> are",LF
		db "               KBC, PS2, BIOS, FAST, PORT92 and ALWAYSON.",LF
endif
		db " ALTBOOT       use alternate reboot strategy", LF
        db " B=####        specify lowest segment address for EMS banking (default=4000)",LF
        db " D=###         set DMA buffer size in kB (default=64, max is 128)",LF
if ?EMX
		db " EMX           increased EMX DOS extender compatibility",LF
endif
if ?FASTBOOT
		db " FASTBOOT      fast reboot. Requires ",NAMEPGM," to be loaded in CONFIG.SYS.",LF
endif        
		db " FRAME=E000    set EMS page frame (FRAME=NONE disables frame). Any value",LF
		db "               between 8000 and E000 is accepted, but not all will work.",LF
if ?INTEGRATED        
		db " HMAMIN=n      set minimum amount in Kb to allocate the HMA.",LF
endif
		db " I=D000-D7FF   force a region to be used for UMBs. Without this option",LF
		db "               range C000-EFFF is scanned for unused pages. May also be used",LF
		db "               to add (parts of) regions A000-BFFF or F000-F7FF as UMBs. Don't",LF
		db "               use this option if you don't know what you are doing!",LF
		db " I=TEST        scan ROMs for unused pages, include found regions as UMBs",LF
		db " [MAX=]#####   limit for VCPI (and EMS if < 32M) memory in kB (default 120 MB)",LF
		db " MIN=#####     reserve up to ##### kB for EMS/VCPI memory on init (default=0)",LF
		db " NOCHECK       disallow access to address space without RAM (MMIO)",LF
if ?INTEGRATED        
		db " NOE801        don't use Int 15h, E801h to get amount of ext. memory",LF
		db " NOE820        don't use Int 15h, E820h to get amount of ext. memory",LF
endif
		db " NOEMS         disable EMS handling",LF
		db " NODYN         no dynamic XMS memory allocation (use MIN= to set fix amount)",LF
		db " NOHI          don't move resident part into first UMB",LF
		db " NOINVLPG      don't use INVLPG opcode",LF
if ?PGE
        db "+PGE/NOPGE     Page Global Enable feature usage on/off (default off)",LF
endif
        db " RAM/NORAM     try to supply UMBs on/off (default on)",LF
        db " S=D000-D7FF   assume Shadow-RAM activated by UMBPCI, include it as UMB",LF
if ?SB
		db " SB            SoundBlaster driver compatibility mode",LF
endif
		db "+VCPI/NOVCPI   VCPI Support on/off (default on)",LF
        db " VDS/NOVDS     Virtual DMA Services on/off (default on)",LF
if ?VME
        db "+VME/NOVME     V86-Mode Extensions on/off (default on)",LF
endif
		db " VERBOSE       display additional details during start (abbr: /V)",LF
		db " X=D000-D7FF   exclude region from being touched or used by ",NAMEPGM,LF
		db " X=TEST        scan memory region C000-EFFF for UMB exclusion",LF
if ?INTEGRATED        
		db " X2MAX=n       max. value in Kb for XMS V2 free memory report (default=65535)",LF
		db " XMSHANDLES=n  number of available XMS handles (8<=n<=128, default=32)",LF
endif        
        db LF
        db " '+': option can be set dynamically by running ",NAMEPGM," from the command line",LF
if ?LOAD
		db LF
        db "When invoked from the command line ",NAMEPGM," additionally will understand:",LF
        db " LOAD          install",LF
endif
if ?UNLOAD
        db " UNLOAD        uninstall",LF
endif
		db 0
if ?INTEGRATED
szA20Proc db "%s A20 method selected",10,0 
szKBC	db "KBC",0
szPS2	db "PS/2",0
szFast  db "Fast",0
szBIOS  db "BIOS",0
szPort92 db "Port 92",0
szAlwaysOn db "Always On",0
endif
_DATA	ends

if ?MSC
CONST	segment word public 'CONST'
CONST	ends
endif

_BSS	segment word public 'BSS'
_BSS	ends

_STACK	segment para STACK  'STACK'
_STACK	ends

if ?MSC
DGROUP	group	BEGDATA,_DATA,CONST,_BSS,_STACK
else
DGROUP	group	BEGDATA,_DATA,_BSS,_STACK
endif

_DATA	segment

;--- _brptab is the second of two parameters for Jemm32 init
;--- the entries are offsets in RSEG
;--- the most important one is the offset to the v86 breakpoint table

if ?DMA
_brptab	RSOFS < RSEG_END, bptable, bRFlags >
else
_brptab	RSOFS < RSEG_END, bptable >
endif

if 0;?A20PORTS
wBiosA20	DW 1+2	;default: trap both kbdc + ps2 ports
endif

dLoaded 	db NAMEPGM," loaded",CR,LF,'$'
dAlreadyInstalled db NAMEGEN,' already installed',CR,LF,'$'
dEmmInstalled db 'An EMM is already installed',CR,LF,07,'$'
dUnknownInstalled db "CPU in protected mode, loading aborted",CR,LF,07,'$'
;dFailed		db 'Something failed, installation aborted',CR,LF,07,'$'
dError1		db NAMEGEN," is not installed. (Enter ",NAMEEXE," -? for help)",CR,LF,'$'
if ?UNLOAD
dError2		db NAMEGEN," cannot be unloaded.",CR,LF,'$'
dUnloaded   db NAMEGEN," unloaded",CR,LF,'$'
endif

sig1        db 'EMMXXXX0',0
sig2        db 'EMMQXXX0',0	; ID if NOEMS specified
szDispVer   db NAMEPGM," v%u.%02u installed.",LF,0
szEMSStatus db "EMS is %s",0
szEMSMemory db ", %u of max. %u pages allocated",0
szVCPIOff   db "VCPI is Off.",LF,0
szVCPIOn    db "VCPI is On, %lu of max. %lu pages allocated.",LF,0
if ?VME
szVMEStatus db "VME is %s.",LF,0
endif
szA20Status db "A20 emulation is %s.",LF,0
if ?PGE
szPGEStatus db "PGE is %s.",LF,0
endif
szOn        db "On",0
szOff       db "Off",0
szFrameNone db ", no Page Frame",0
szDotLF		db ".", 10, 0
szFrameYes  db ", Page Frame at %04X",0
szDMABuffer db "DMA buffer at %08lX, size %u kB.",LF,0
szUMB       db "UMB supplied at %04X-%04X, %s.",LF,0
szAlloced   db "allocated",0
szFree		db "free",0
szUMBErr1   db "UMB handler already installed, not installing another one",LF,0

_DATA	ends

		.386P

if ?RSEG
RSEG SEGMENT
else
_TEXT SEGMENT
endif

    ASSUME  CS:_TEXT16
	ASSUME  DS:NOTHING,ES:NOTHING,FS:NOTHING,GS:NOTHING

;******************************************************************************
; device driver header

device_header:
		dd  -1			    ; last driver in list
		dw  0c000h		    ; driver flags :
							; 8000 - character device
							; 4000 - supports IOCTL - like EMM386
pStratOfs dw offset strategy	; offset to strategy routine
pIntOfs dw offset driver_entry	; offset to interrupt handler

device_name label byte
		db  'EMMXXXX0'	    ; device driver name

;--- start of real-mode resident data area

;--- v86 breakpoint table
;--- the order must match the one of bptable in Jemm32.asm !

bptable	label byte
NEW06:            		; entry invalid opcode exception (int 06)
	@DefineBP BP06
NEW19:
	@DefineBP BP19
NEW67:					; int 67h entry real-mode
	@DefineBP BP67
if ?VDS
NEW4B:					; int 4Bh entry v86-mode (VDS)
	@DefineBP BPVDS
endif
	@DefineBP BPBACK	; BP to return to v86 monitor from a v86 far proc
	@DefineBP BPI1587
if ?DMA    
	@DefineBP BP1340	; copy out of DMA buffer
endif
	@DefineBP BPXMS		; handle XMS A20+UMB
	@DefineBP BPSTRAT	; EMMXXXX0 device strategy call
	@DefineBP BPDRV		; EMMXXXX0 device interrupt call
	@DefineBP BPRESET

if ?DMA

bRFlags	DB 0

;--- for DMA, hook int 40h (FD access)
;--- and int 13h (HD access)

NEW40 PROC FAR
	mov cs:[bRFlags],2	; tell the monitor that a new DMA op has started
	pushf
    db 09Ah
OLDINT40 dd 0    
	jmp int1340common
NEW40 ENDP

	align 4

NEW13 PROC FAR
	mov cs:[bRFlags],2	; tell the monitor that a new DMA op has started
	pushf
    db 09Ah
OLDINT13 dd 0    
NEW13 ENDP

int1340common:
	jc  iret_with_new_CY
	test cs:[bRFlags],1
    jnz BP1340
iret_with_new_CY:
	push bp
	mov	bp,sp
	rcr	byte ptr [bp+2+4],1
	rol	byte ptr [bp+2+4],1
	pop	bp
	iret

endif

;******************************************************************************
; INT15 handler:
;    handle AH=87h case (copy extended memory)
;
;        AH = 87h
;        CX = number of words to copy (max 8000h)
;        ES:SI -> GDT (4 descriptors)
;Return: CF set on error, else cleared
;        AH = status (00 == ok)
;******************************************************************************

	align 4

NEW15 PROC FAR
	CMP     AH,87H		; is it the blockmove?
	JZ      BPI1587
if ?INTEGRATED
	CMP     AH,88H		; ext memory size
	JZ      getextmem
endif
    db 0EAh
OLDINT15 dd 0    
if ?INTEGRATED
getextmem:
    xor ax,ax           ; no memory available
  ife ?DMA    
	push bp
	mov	bp,sp
	and byte ptr [bp+2+4],not 1  ;clear CF
	pop	bp
    iret
  else
	jmp iret_with_new_CY
  endif
endif
NEW15 ENDP
    
;*********************************************************
; XMS hook - required for UMBs and A20 emulation
;*********************************************************

	align 4

XMShandler proc

	jmp short @@XMSHandler	; standard XMS link chain
	nop					    ; with 3 required NOPs
	nop
	nop
@@XMSHandler:
if ?INTEGRATED
	jmp BPXMS
else    

;-- for A20 disable and enable emulation it is required to hook
;-- the XMS functions as well, even if the A20 ports (92, 60, 64)
;-- are trapped. That's because if certain conditions are true
;-- the XMS host will never access the ports and leave A20 unchanged.

if ?A20XMS
	cmp	ah,3
    jb  @@noa20
    cmp ah,6
	jbe	BPXMS
@@noa20:    
endif    

if ?MASM
XMSUMB::
else
XMSUMB:
endif
	cmp ah,10h				; 10h=alloc, 11h=free, 12=realloc
	jb  @@xms_prev
	cmp	ah,12h
	jbe BPXMS
@@xms_prev:
	db 0eah					; jmp far XMS prev handler
XMSoldhandler dd 0
endif

XMShandler endp

if ?INTEGRATED

NEW2F proc
	pushf
	cmp ah,43h
    jz is43
@@jmp_old2f:
    popf
    db 0EAh
OLDINT2F dd 0
is43:
    cmp al,00h            ; is it "Installation Check"?
    je @@get_driver_installed
    cmp al,10h            ; is it "Get Driver Address"?
    je @@get_xms_address     
    cmp al,09h            ; is it "get handle table"?
    je @@get_xms_handle_table
    cmp al,08h
    jne @@jmp_old2f
	mov	al,ah		;al==43h if function supported
machine_type label byte    
	mov	bx,0002		; bh=switch time; 0=medium, 1=fast, 2=slow
					; bl=machine type; 1=std AT (KBC), 2=PS/2 (port 92) ?
    popf 
    iret
@@get_driver_installed:    
    mov al,80h              ; yes, we are installed ;)
    popf
    iret
@@get_xms_address:
    mov bx,offset XMShandler
@@shared2f:
    push cs
    pop  es
    popf
    iret
@@get_xms_handle_table:
	mov	al,ah 		;al==43h if function supported
	mov	bx,OFFSET xms_handle_table
	jmp	@@shared2f
	
NEW2F endp
endif

if ?RMDBG

;--- print a string in real-mode (for debugging)
;--- preserves registers and flags

VPRINTSTR PROC
	push bp
    mov bp,sp
    XCHG BX,[bp+2]
    PUSHF
	PUSH AX
@@NEXTCHAR:
    MOV AL,CS:[BX]
    INC BX
    CMP AL,0
    JZ  @@DONE
    push bx
    mov bx,0007h
    cmp al,LF
	jnz @@isnotlf
    mov ax,0E0Dh
    int 10h
    mov al,LF
@@isnotlf:    
    mov ah,0Eh
    int 10h
    pop bx
    JMP @@NEXTCHAR
@@DONE:
	POP AX
	POPF
	XCHG BX,[bp+2]
    pop bp
    RET
VPRINTSTR ENDP

;--- display word in AX
;--- preserves registers and flags

VWORDOUT proc near
		push	ax
		mov 	al,ah
		call	VBYTEOUT
		pop 	ax
VWORDOUT endp
VBYTEOUT proc near
		pushf
		push	ax
        mov		ah,al
		shr 	al,4
        call    vnibout
        mov		al,ah
        call    vnibout
        pop     ax
        popf
        ret
vnibout:        
		and 	al,0Fh
		cmp 	al,10
		sbb 	al,69H
		das
        push bx
        push ax
        mov bx,0007
        mov ah,0Eh
        int 10h
        pop ax
        pop bx
        ret
VBYTEOUT endp

endif

if ?INTEGRATED

		align 2
    
xms_handle_table XMS_HANDLETABLE <01, size XMS_HANDLE, 2, xms_handle_array>
xms_handle_array XMS_HANDLE 2 dup (<4,0,0,0>)        

endif
		align 16

RSEG_END equ $ - device_header

if ?RSEG
RSEG  ends
_TEXT segment
endif

;
; installation part of the virtual Monitor, that later is given back again
; to the system.
;

	assume CS:_TEXT16
    assume FS:nothing
    assume GS:nothing
    assume DS:DGROUP

;--- FindCommand(commandline, searchstring) parses the command line
;--- for a specific command. If found, the command is removed and
;--- the address behind that command is returned. Else, 0 is returned

FINDCOMMAND	PROC NEAR
	push    bp
    mov     bp,sp
	push	di
	push	si
    
commandline equ <bp+6>
searchstring equ <bp+4>
;	searchlen = bx

	push ds
    pop es

	mov	di,[searchstring]
	push di
	call _strlen
	pop	cx
	mov	bx,ax		;searchlen
	mov	si,[commandline]
@@nextcmp:
	cmp	BYTE PTR [si],0
	je	@@FB301
	push bx
	push di
	push si
	call __memicmp
	add	sp,6
	or	ax,ax
	je	@@L384
	inc	si
	jmp	@@nextcmp
@@L384:
	push si
	mov	di,si
	add	si,bx
@@nextitem:
	lodsb
    stosb
    and al,al
    jnz @@nextitem
    pop ax
	jmp	@@EX297
@@FB301:
	xor	ax,ax
@@EX297:
	pop	si
	pop	di
	pop bp  
	ret	4

commandline equ <>
searchstring equ <>

FINDCOMMAND	ENDP

;--- GetValue(commandline, base, usesuffix)
;--- converts a string into a DWORD

GETVALUE	PROC NEAR
	push	bp
    mov		bp,sp
	push	di
	push	esi
    
commandline equ <bp+8>
base equ <bp+6>
usesuffix equ <bp+4>
;	register di = len
;	register esi = result

	xor	di,di
    xor esi, esi			;result
@@nextitem:
	mov	bx,WORD PTR [commandline]
	mov	al,BYTE PTR [bx][di]
	push ax
	call _toupper
	cmp	al,'0'
	jl	@@I317
	cmp	al,'9'
	jg	@@I317
	sub	al,'0'
	jmp	@@I318
@@I317:
	cmp	al,'A'
	jl	@@FB316
	sub	al,55	;0037H
@@I318:
    movzx ecx, WORD ptr [base]
	cmp	cl,al
	jle	@@FB316
    xchg eax,esi
    mul ecx
    xchg eax,esi
    movzx eax,al
    add esi,eax
	inc	di
	jmp	@@nextitem
    

@@FB316:
	mov	bx,[commandline]
	add	bx,di
	cmp	BYTE PTR [usesuffix],0
	je	@@I322
	mov	al,[bx]
	push ax
	call _toupper
	cmp	al,77	;004dH
	je	@@SC328
	ja	@@I322
	sub	al,71	;0047H
	je	@@SC327
	sub	al,4
	je	@@SC329
	jmp	@@I322
@@SC327:
	shl	esi,10
@@SC328:
	shl	esi,10
@@SC329:
	mov	BYTE PTR [bx],' '
@@I322:
	push esi
    mov si,bx
    mov di,[commandline]
    push ds
    pop es
@@nextchar:
    lodsb
    stosb
    and al,al
    jnz @@nextchar
    pop ax
    pop dx
	pop	esi
	pop	di
    pop bp
	ret	3*2

commandline equ <>
base equ <>
usesuffix equ <>

GETVALUE	ENDP

if ?UNLOAD

;--- try to unload Jemm386

_TryUnload proc

		push si
        push di
		push bp
        mov bp,sp
		call _IsJemmInstalled
        jc   @@nojemm
	    mov bx, ax		;EMMXXXX0 handle
		@DbgOutS <"TryUnload, Jemm installed",10>,?UNLRMDBG
        push 0
        push 4			;call function 4
        mov dx,sp
	    mov cx,4		;returns 4 byte
	    mov ax,4402h	;read ioctl (get Emm386 resident segment/size
    	int 21h
        jc @@nojemm2
        pop ax			;get Jemm's resident segment
        pop cx			;not used

		@DbgOutS <"TryUnload, read Jemm's resident segment",10>,?UNLRMDBG

;--- check if any INT hooked by jemm has been stolen
        
        push 0
        pop es
        shl eax,16
        mov si,offset intvecs
@@nextvect:
		db 2Eh
		lodsb
        cmp al,-1
        jz @@ok
        movzx di,al
        shl di,2
        db 2Eh
        lodsw
        scasd
        jnz @@nouninst
        add si,2
        jmp @@nextvect
@@ok:
		@DbgOutS <"TryUnload, no stolen ints detected",10>,?UNLRMDBG
if ?VDS
		test byte ptr es:[47Bh],20h
        jz  @@novds
		mov ax,offset NEW4B
        cmp eax,es:[4Bh*4]
        jnz @@nouninst
		@DbgOutS <"TryUnload, int 4Bh is ok",10>,?UNLRMDBG
@@novds:        
endif

;--- check if any UMB is allocated

	    sub sp, UMB_MAX_BLOCKS * size UMBBLK -2
        push 7			;call "get umbs" function
        mov dx, sp
	    mov cx,UMB_MAX_BLOCKS * size UMBBLK
	    mov ax,4402h	;read ioctl
	    int 21h
        jc @@nouninst
		@DbgOutS <"TryUnload, got UMBs from Jemm",10>,?UNLRMDBG
        xor dx,dx
        mov cx,UMB_MAX_BLOCKS
        mov si,sp
@@nextumb:        
        lodsw			;segment
        lodsw			;size + flag
        or dx,ax
        loop @@nextumb
        mov sp,si
        test dh,80h 	;any umb allocated?
        jnz @@nouninst
		@DbgOutS <"TryUnload, no allocated UMBs",10>,?UNLRMDBG
        
;-- close EMMXXXX0 handle

        mov ah,3Eh
        int 21h
        
if ?INTEGRATED

;-- get current XMS (must be Jemm386)

		call	_XMSinit
        les		si, _XMSdriverAddress
        cmp		byte ptr es:[si],0EBh	;anyone hooked into XMS?
        jnz		@@nouninst
		@DbgOutS <"TryUnload, no XMS hookers detected",10>,?UNLRMDBG

;-- check if any XMS memory is in use
        
		push	ds
		lds		si, _jemmini.jiXMSHandleTable
        mov		ax, ds
        or		ax, si
        jz		@@xmsused
        mov		cx, [si].XMS_HANDLETABLE.xht_numhandles
        lds		si, [si].XMS_HANDLETABLE.xht_pArray
        add		si, size XMS_HANDLE	;dont check first entry (is Jemm itself)
        dec		cx
@@nextxmshdl:        
        cmp		[si].XMS_HANDLE.xh_flags, XMSF_USED
        jz		@@xmsused
        add		si, size XMS_HANDLE
        loop	@@nextxmshdl
@@xmsused:        
        pop		ds
        jz		@@nouninst
		@DbgOutS <"TryUnload, no EMBs are used",10>,?UNLRMDBG
endif

;-- check if any EMS/VCPI memory is in use

		mov ah,4Bh		;get number of open handles (handle 0 is ok)
        int 67h
        cmp bx,01h	 	;any handle > 0000 allocated?
        ja @@nouninst
		@DbgOutS <"TryUnload, no EMS handles are used",10>,?UNLRMDBG
        
;-- todo: check VCPI

;-- ok to unload.

		shr eax,16		;get current Emm386 segment 
        call UnloadJemm
        jc  @@nouninst
		MOV     DX,OFFSET dUnloaded
@@exit:
		MOV     AH,9
		INT     21H
		mov sp,bp
        pop bp
        pop di
        pop si
		ret
@@nojemm2:
@@nojemm:        
		MOV     DX,OFFSET dError1
        jmp		@@exit
@@nouninst:
		MOV     DX,OFFSET dError2
        jmp		@@exit
_TryUnload endp

;--- Jemm can be unloaded. Do it!
;--- in: AX=segment of resident part of installed Jemm

UnloadJemm proc

        mov di,ax
        
		@DbgOutS <"UnloadJemm enter, CS=">,?UNLRMDBG
		@DbgOutW cs,?UNLRMDBG
		@DbgOutS <" SS=">,?UNLRMDBG
		@DbgOutW ss,?UNLRMDBG
		@DbgOutS <" res. segm=">,?UNLRMDBG
		@DbgOutW di,?UNLRMDBG
		@DbgOutS <10>,?UNLRMDBG

;--- remove EMMXXXX0 from driver chain

		mov ah,52h			;get start of driver chain
	    int 21h
	    add bx,22h
@@nextdev:        
        cmp di, es:[bx+2]
        jz @@found
        les bx, es:[bx]
        cmp bx,-1
        jnz @@nextdev
        stc
        ret
@@found:
        mov ds,di
        mov ecx, ds:[0]    ;remove driver from chain
        mov es:[bx], ecx

		@DbgOutS <"UnloadJemm: driver removed from chain",10>,?UNLRMDBG

;--- reset IVT vectors

		mov es,di
        push 0
        pop ds
        mov si, offset intvecs
@@nextvec:
		db 2Eh
		lodsb
        cmp al,-1
        jz @@ok
        movzx bx,al
        shl bx, 2
        mov di,cs:[si+2]
        cmp di,-1
        jz @@skipvec
        mov ecx, es:[di]
        mov ds:[bx],ecx
@@skipvec:
		add si,4
        jmp @@nextvec
@@ok:
		@DbgOutS <"UnloadJemm: IVT vectors restored",10>,?UNLRMDBG

;--- reset XMS hook

ife ?INTEGRATED
		mov bx,offset XMSoldhandler
        mov ecx, es:[bx]
        and ecx, ecx
        jz @@noxms

		push es        
        push es
        pop ds
        mov si,offset XMShandler
        push ecx
        pop di
        pop es
        mov cx,5
        sub di,cx
        rep movsb
        pop es
@@noxms:
		@DbgOutS <"UnloadJemm: XMS hook removed",10>,?UNLRMDBG

endif

;--- make sure jemm386's resident memory block is freed
;--- this is to be improved yet

		mov ax,es
        sub ax,10h+1	;size PSP + 10h (to get MCB)
        mov ds,ax
        mov cx,ax
        inc cx
        mov al,ds:[0]
        cmp al,'M'
        jz @@ismcb
        cmp al,'Z'
        jnz @@nopsp
@@ismcb:
        cmp cx, ds:[1]
        jnz @@nopsp
ife ?INTEGRATED        
        cmp word ptr ds:[3],10h + RSEG_END/10h
        jnz @@nopsp
else
        cmp word ptr ds:[10h+18h],-1	;check if files 0+1 are closed
        jnz @@nopsp
endif        
        cmp word ptr ds:[10h],20CDh
        jnz @@nopsp
        mov ax,cs
        sub ax,10h
        mov ds:[1],ax
@@nopsp:
		@DbgOutS <"UnloadJemm: resident segment prepared to be released",10>,?UNLRMDBG

;--- now call the installed instance of Jemm386 to
;--- do the rest of the clean-up

        push ss
		push bp
        push cs
        push offset rmtarget
        mov bp,sp
        push es
        push offset BPRESET
        call dword ptr [bp-4]

;--- Jemm386 has exited, but we are still in protected mode!
;--- GDTR no longer valid, IDTR reset to 3FF:00000000
;--- BX contains XMS handle for Jemm386's memory block for Jemm386 (not JemmEx)

		mov eax, cr0
        and eax, 7FFFFFFEh	;disable paging and protected-mode
        mov cr0, eax
        mov sp,bp
        retf				;restore CS
rmtarget:        
        pop bp
		pop ax
        mov ss,ax
        mov ds,ax
        assume ds:DGROUP
        mov es,ax
		@DbgOutS <"UnloadJemm: back from protected-mode",10>,?UNLRMDBG
ife ?INTEGRATED        
        mov dx,bx
        mov ah, 0Dh		;unlock block
        call dword ptr [_XMSdriverAddress]
        mov ah, 0Ah		;free block
        call dword ptr [_XMSdriverAddress]
else        
		call _DisableA20
endif        
		@DbgOutS <"UnloadJemm exit",10>,?UNLRMDBG
		clc
        ret
UnloadJemm endp        

endif

;
; check, if this program runs after all on a 386-Computer (o.ae.)
; (... you never know)
;

IS386 PROC NEAR
	PUSHF
	mov     AX,7000h
	PUSH    AX
	POPF                        ; on a 80386 in real-mode, bits 15..12
	PUSHF                       ; should be 7, on a 8086 they are F,
	POP     AX                  ; on a 80286 they are 0
	POPF
    and		ah,0F0h
	cmp     AH,70H
    stc
	JNZ     @@NO_386
    clc
@@NO_386:
	RET
IS386 ENDP

;--- test if CPU is 386, display error if not
;--- returns C and modifies DS in case of error
;--- other registers preserved

TestCPU proc near
	push ax
	call IS386
    jnc @@is386
    push dx
    push cs
    pop ds
    mov ah,9
    mov dx,offset _TEXT16:dErrCpu
    int 21h
    pop dx
    stc
@@is386:    
    pop ax
    ret
TestCPU endp

dErrCpu  db NAMEPGM,": at least a 80386 cpu is required",13,10,'$'

;--- TestForSystemRAM(void *, int, int *);
;--- 1. argument is "SystemMemory" array (256 * BYTE)
;--- 2. argument is index for "SystemMemory" where to start scan

_TestForSystemRAM proc
	push bp
    mov bp,sp
    push 0
    push si
    push di
    xor di, di
    mov si, [bp+4]
    mov dx, [bp+6]
    add si, dx
    mov cx, 100h
    sub cx, dx
    jbe @@done
@@nextpage:
	lodsb
    cmp al,'U'
    jz @@testitem
    cmp al,'I'			;'I' is also tested, but not modified
    jnz @@skipitem		;so a warning can be displayed 
@@testitem:    
    mov ax, dx
    shl ax, 8
    mov es, ax
    cli
    mov ax, es:[0]
    mov bx, ax
    xor ax, 055AAh
    mov es:[0], ax
    cmp ax, es:[0]
    jnz @@noram
    xor ax, 0AA55h
    mov es:[0], ax
    cmp ax, es:[0]
    jnz @@noram
    
    cmp byte ptr [si-1], 'U'
    jnz @@nochange
	mov byte ptr [si-1], 'R'    
@@nochange:
	and di,di
    jnz  @@notstart
    mov di, es
@@notstart:    
    add word ptr [bp-2], 100h	;in paragraphs
    jmp @@shared
    
@@noram:
    and di, di
    jz @@shared	;skip test now, found a region
    mov cx,1
@@shared:
	cmp bx, es:[0]
    jz  @@unchanged
	mov es:[0],bx
@@unchanged:    
    sti
@@skipitem:
	inc dx
	loop @@nextpage
@@done:    
    mov bx, [bp+8]
    mov cx, [bp-2]
    mov [bx],cx
    mov ax, di
    pop di
    pop si
    mov sp,bp
    pop bp
	ret 
_TestForSystemRAM endp

_IsJemmInstalled proc
	@DbgOutS <"IsJemmInstalled enter",10>,?EMXRMDBG
	mov bx, -1
	mov dx, offset sig1
    mov ax, 3D00h
    int 21h
    jnc @@found
    mov dx, offset sig2
    mov ax, 3D00h
    int 21h
    jc @@nojemm
@@found:
	@DbgOutS <"EMM device found",10>,?EMXRMDBG
    mov bx,ax
    xor ax,ax
    push ax
    push ax
    push ax
    mov cx,6		;read 6 bytes
    mov dx,sp
    mov ax,4402h	;read ioctl
    int 21h
    pop ax			;version
    pop cx			;API entry offs
    pop cx			;API entry segm
    jc  @@nojemm
    cmp ax,0028h	;this is JEMM386!
    jnz @@nojemm
    mov ax,bx		;return the file handle
	@DbgOutS <"Jemm found",10>,?EMXRMDBG
    clc
	ret
@@nojemm:
	@DbgOutS <"Jemm not found",10>,?EMXRMDBG
	cmp bx,-1
    jz  @@noclose
    mov ah,3Eh
    int 21h
@@noclose:    
	stc
    ret
_IsJemmInstalled endp

	assume DS:DGROUP

if UMB_MAX_BLOCKS le 8
buff equ <bp-(2+size UMBBLK * 8)>
else
buff equ <bp-(2+size UMBBLK * UMB_MAX_BLOCKS)>
endif

_EmmStatus proc
    push di
    push si
	push bp
    mov bp,sp
    push -1
if UMB_MAX_BLOCKS le 8    
    sub sp,8              * size UMBBLK
else
    sub sp,UMB_MAX_BLOCKS * size UMBBLK
endif
	call _IsJemmInstalled
    jc  @@nojemm
    mov [bp-2],ax
    mov bx, ax
    lea dx, [buff]	;get version
	mov byte ptr [buff],2
    mov cx,2
    mov ax,4402h	;read ioctl (get version) [Emm386 compatible call]
    int 21h
    jc  @@nojemm
	@DbgOutS <"EmmStatus: read ioctl(2) ok",10>,?EMXRMDBG
    movzx ax, byte ptr [buff+0]
    movzx cx, byte ptr [buff+1]
    push cx
    push ax
    push offset szDispVer
    call _printf
    add sp,3*2

;--- get EMS, VCPI, UMB, VME, A20 infos

    lea dx, [buff]
	mov byte ptr [buff],6
    mov cx,24
	mov bx, [bp-2]
    mov ax,4402h	;read ioctl
    int 21h
    jc  @@close
	@DbgOutS <"EmmStatus: read ioctl(6) ok",10>,?EMXRMDBG

    mov di, ax

    mov dx, offset szOff
    lea si, [buff]
    cmp [si].EMX06.e06_NoEMS, 0
	jnz @@emsflag
    mov dx, offset szOn
@@emsflag:    
    push dx
    push offset szEMSStatus
    call _printf 
    pop cx
    pop cx

	cmp [si].EMX06.e06_NoEMS,0
    jnz @@nodispframe			;dont display FRAME status if no EMS

    mov ah,42h
    int 67h
    mov ax, dx
    sub ax, bx
	push dx
    push ax
    push offset szEMSMemory
    call _printf
    add sp,3*2

	mov ax, offset szFrameNone
    mov cx, [si].EMX06.e06_Frame
	jcxz @@noframe
	mov ax, offset szFrameYes
@@noframe:
    push cx
    push ax
    call _printf
    pop cx
    pop cx

@@nodispframe:
	push offset szDotLF
    call _printf
    pop cx

    cmp [si].EMX06.e06_NoVCPI, 0            	;_NoVCPI flag
	jnz @@vcpioff
    push [si].EMX06.e06_VCPITotal
    push [si].EMX06.e06_VCPIUsed
    push offset szVCPIOn
    call _printf
    add sp,2+4+4
    jmp @@vcpidone
    
@@vcpioff:
	push offset szVCPIOff
    call _printf
    pop cx
@@vcpidone:

	mov ax, 64		;default DMA buffer size
    cmp di, 16		;could the DMA buffer size be read?
    jb  @@nodmasize
    mov ax, [si].EMX06.e06_DMASize
@@nodmasize:    
    mov ecx, [si].EMX06.e06_DMABuff
    push ax
    push ecx
    push offset szDMABuffer
    call _printf
    add sp,2+4+2

if ?A20PORTS or ?A20XMS
	mov ax, offset szOff
    cmp [si].EMX06.e06_NoA20, 0
	jnz @@a20flag
	mov ax, offset szOn
@@a20flag:
    push ax
    push offset szA20Status
    call _printf
    pop cx
    pop cx
endif

if ?VME
	mov ax, offset szOff
    cmp [si].EMX06.e06_NoVME, 0
	jnz @@vmeflag
	mov ax, offset szOn
@@vmeflag:
    push ax
    push offset szVMEStatus
    call _printf
    pop cx
    pop cx
endif

if ?PGE
	mov ax, offset szOff
    cmp [si].EMX06.e06_NoPGE, 0
	jnz @@pgeflag
	mov ax, offset szOn
@@pgeflag:
    push ax
    push offset szPGEStatus
    call _printf
    pop cx
    pop cx
endif

    lea dx, [buff]
	mov byte ptr [buff],7
    mov cx, UMB_MAX_BLOCKS * 4
	mov bx, [bp-2]
    mov ax,4402h	;read ioctl
    int 21h
    jc  @@close
	@DbgOutS <"EmmStatus: read ioctl(7) ok",10>,?EMXRMDBG

	lea si,[buff]
    mov cx, UMB_MAX_BLOCKS
@@nextumb:
    mov ax, [si].UMBBLK.wSegm
    and ax, ax
	jz @@umbdone    
    push cx
    mov dx, [si].UMBBLK.wSize
    mov cx, offset szAlloced
    test dh,80h
    jnz @@isalloced
    mov cx, offset szFree
@@isalloced:    
    and dh, 7Fh ;reset highest flag
    add dx, ax
    dec dx
    push cx
    push dx
    push ax
    push offset szUMB
    call _printf
    add sp, 4*2
    pop cx
    add si, size UMBBLK
    loop @@nextumb
@@umbdone:
@@noumbs:

@@close:
	mov bx, [bp-2]
	cmp bx, -1
    jz  @@exit
    mov ah, 3Eh
    int 21h
@@exit:
	mov	sp,bp
    pop bp
	pop si
	pop di
    ret
@@nojemm:
	@DbgOutS <"EmmStatus: Jemm not found",10>,?EMXRMDBG
	MOV     DX,OFFSET dError1
	MOV     AH,9
	INT     21H
	jmp		@@close
_EmmStatus endp

request_ptr dd 0

;--- the original strategy proc, must be 8086 compatible
;--- will be replaced by a v86 BP once Jemm386 is installed

strategy:
	mov word ptr cs:[request_ptr+0],bx
	mov word ptr cs:[request_ptr+2],es
	retf

;**********************************************
; driver init part
; this code is only necessary on init and    
; will not go resident. It must however be
; in the same physical segment as the
; resident part. The proc must be declared far.
;**********************************************

;request_hdr struc	
;  req_size	db	?		;+0 number of bytes stored
;  unit_id	db	?		;+1 unit ID code
;  cmd		db	?		;+2 command code
;  status	dw	?		;+3 status word
;  rsvd		db	8 dup (?)	;+5 reserved
;request_hdr ends	

;init_strc struc	
;  init_hdr	db	size request_hdr dup (?)
;  units		db	?	;+13 number of supported units
;  end_addr		dd	?	;+14 end address of resident part
;  cmd_line		dd	?	;+18 address of command line
;init_strc ends	

driver_entry proc far

	push ds
    push di
	lds di, cs:[request_ptr]        ; load address of request header
	mov word ptr ds:[di+3],8103h
	cmp byte ptr ds:[di+2],0 		; command == 0 : do we have to initialize?
	jne @@noinit
    call TestCPU
    jnc @@cpuok
@@noinit:    
    pop di
	pop ds
	ret
@@cpuok:
	mov word ptr ds:[di+3],0100h	; set STATUS_OK
	pushad
    mov		cx,ss
    mov		bx,sp
	mov     ax, DGROUP
	mov     ss, ax
	mov     sp, offset DGROUP:exe_stacktop
    push	cx
    push	bx
	push 	es
	push 	ds
	push 	di
	les     si, ds:[di+18]	; fetch driver commandline
	mov     ds, ax
    assume	DS:DGROUP
    call	EmmInstallcheck
    jnc		@@noemm
	mov 	dx, OFFSET DGROUP:dEmmInstalled
    mov		ah, 9
    int		21h
    xor		ax,ax
    jmp 	@@driver_exit
@@noemm:
    sub sp,128
    mov di,sp
    push ds
    push es
    pop ds
    push ss
    pop es

	cld
if 0
	push si
nextchar:    
    lodsb
    cmp al,0
    jz donex
    cmp al,13
    jz donex
    cmp al,10
    jz donex
    mov dl,al
    mov ah,2
    int 21h
    jmp nextchar
donex:   
	mov dl,13
    mov ah,2
    int 21h
    mov dl,10
    mov ah,2
    int 21h
    pop si
endif

@@nxtchar1:    			;skip program name
    lodsb
    and al,al
    jz done
    cmp al,13
    jz done
    cmp al,10
    jz done
	cmp al,20h
    ja @@nxtchar1
@@nxtchar2:    
	lodsb
    and al,al
    jz done
    cmp al,13
    jz done
    cmp al,10
    jz done
    stosb
    jmp @@nxtchar2
done:
	mov al,0
    stosb
    pop ds
	push sp				; startup_driver(char far *cmdLine)
    push EXECMODE_SYS
	call _TheRealMain
	add sp,128+2*2
;	MOV DX,OFFSET DGROUP:dFailed
	or 	ax,ax			; error occured?
    mov ax,0
	jnz @@driver_exit
	mov ax, [wLow]
@@driver_exit:
    pop	di
    pop	ds
    pop es
	mov ds:[di+0eh+0],ax  			; if ax == 0, driver won't be installed
	mov ds:[di+0eh+2],cs			; set end address
	pop	bx
    pop	ss
    mov	sp,bx
	popad
    pop di
	pop ds
	ret
    
driver_entry ENDP

if ?LOAD

;--- check if there is already an EMM installed
;--- DS=DGROUP

EmmInstallcheck proc
	push	es
    pusha
	MOV     AX,3567H         ; get INT 67h
	INT     21H
	MOV     AX,ES            ; EMM already installed ?
	OR      AX,BX
	JZ      @@ok
	MOV     DI,10
	MOV     SI,OFFSET sig1
	CLD
	MOV     CX,8
	REPZ    CMPSB
	je @@error      	; matched 1st ID string
	mov	di, 10			; didn't match, check 2nd ID (NOEMS version)
	mov	si, OFFSET sig2
	mov	cl, 8
	repz cmpsb
    clc
	jne @@ok	   		; did match 2nd ID string?
@@error:
	stc
@@ok:
	popa
	pop es
	ret
EmmInstallcheck endp    

endif

;*********************************************
; startpoint when executing as EXE
;*********************************************

GO_EXE proc

	mov     ax, DGROUP
	mov     ds,ax
    assume	ds:DGROUP
	mov     ss,ax
	mov     sp, offset DGROUP:exe_stacktop
    call	TestCPU
    jc		@@exit
	@DbgOutS <"Jemm386 enter",10>,?INITRMDBG

	sub sp,128
    mov di,sp
    push ds
    push es
    pop ds
    mov si,0080h
    lodsb
    movzx cx,al
    push ss
    pop es
    rep movsb
    mov al,0
    stosb
    pop ds
    
	push  sp
    push EXECMODE_EXE
	call  _TheRealMain	;returns 0 if everything ok
    add sp,128+2*2

if ?LOAD
    and	 ax,ax
    jnz	 @@exit
    cmp  [wLow],0
    jz   @@exit
    mov  ah,51h
    int  21h
    mov  es,bx
    mov  es,es:[002Ch]
    mov  ah,49h
    int  21h
    mov  bx,0
@@nextfile:    
    mov	 ah,3Eh
    int  21h
    inc  bx
    cmp  bx,5
    jb   @@nextfile 
    mov  dx,[wLow]
    shr  dx, 4
    add  dx, 10h
    mov	 ax,3100h
    int  21h
endif

@@exit:    
	@DbgOutS <"Jemm386 exit",10>,?INITRMDBG
	mov     ah,04ch         ; that was all
	int 	21h
GO_EXE endp

;--- monitor installation
;--- expects on entry:
;--- SS=DS=DGROUP
;--- ES:SI=cmdline if running as driver
;--- out: AX=resident size (or NULL on errors)
;--- may modify all registers except SS:SP and CS

_InitJemm PROC public

	push	si
    push	di
    push	bp
    
if 0; ?A20PORTS			;this info is unreliable, don't activate!
    mov		ax,2403h	;get A20 gate support
    int		15h
    cmp		ah,00		;ignore carry flag, it is not reliable
    jnz		@@noi1524
    mov		wBIOSA20,bx	
@@noi1524:    
endif

if ?INTEGRATED
    mov cx, _xms_num_handles
    mov [xms_handle_table.xht_numhandles], cx
    mov ax,size XMS_HANDLE
    mul cx
    add ax,offset xms_handle_array + 15
    and al,0F0h
    mov [_brptab.wSizeRes],ax
endif

;--- store interrupt vectors in resident memory

	mov		si,offset _TEXT16:intvecs
@@nextint:
    mov		al,cs:[si].INTMOD.bInt
    cmp		al,-1
    jz		@@intmoddone
    mov		di,cs:[si].INTMOD.wOld
    cmp		di,-1
    jz		@@nooldsave
    mov		ah,35h
    int		21h
    mov		cs:[di+0],bx
    mov		cs:[di+2],es
@@nooldsave:
    add		si,size INTMOD
    jmp		@@nextint
@@intmoddone:

;-- set new interrupt routine offset in the driver header, so any further
;-- access to device EMMXXXX0 is handled by the monitor

    mov 	[pIntOfs],offset BPDRV
    mov 	[pStratOfs],offset BPSTRAT

;--- prepare running Jemm32
;--- set a GDTR on the stack

	MOV     AX, _TEXT32
    mov		ES, AX				; ES=_TEXT32
	MOVZX   EAX,AX
	SHL     EAX,4
ife ?KNOWNGDT
	xor		cx,cx
	push	dword ptr 00CF9200h
    push	cx
    push	-1
	push	dword ptr 00CF9A00h
    push	cx
    push	-1
    push	cx
    push	cx
    push	cx
    push	cx
    mov		dx,ss
    movzx	edx,dx
    shl		edx,4
    movzx	esp,sp
    add		edx,esp
    push	edx
	push	3*8-1
else
    lea		edx, [eax+?GDTOFS]	; assumed GDT position
    push	edx
	push	4*8-1
endif

FLAT_CODE_SEL equ 1*8

    push	FLAT_CODE_SEL
    push	eax
    mov		bp,sp
    mov		di, offset _jemmini	; DI=first parameter
    mov		bx, offset _brptab	; BX=second parameter
	CLI
	LGDT    FWORD PTR [bp+6]
    push	cs
    pop		ds					; DS=_TEXT16

	MOV     EAX,CR0			    ; Set the Protected-Mode-Enable-Bit in
	OR      AL,1			    ; CR0
	MOV     CR0,EAX			    ; In Protected-Mode !
    call	fword ptr [bp]		; expects ES=_TEXT32, DS=_TEXT16, SS=DGROUP
ife ?KNOWNGDT
	add		sp,6+6+3*8
else
	add		sp,6+6
endif    

; In case the switch was successful, the remaining commands are
; already executed in virtual 8086-mode

;--- the virtual monitor init code has returned with
;--- SS:SP = unchanged
;--- CS, DS, ES, FS, GS = unchanged
;--- EAX = physical address of start of EMS/VCPI memory
;--- interrupts are still disabled

	push	ss
    pop		ds
	assume	DS:DGROUP
	assume	ss:DGROUP
    
    push	eax 				; FIRSTPAGE value

	call	GetRes
    mov		bx,ax
	push	es
if ?INTEGRATED
	mov		es,bx
	mov		word ptr es:[xms_handle_table.xht_pArray+2],bx	
endif    
if ?VDS
    push	0
    pop		es
    mov		ax,cs
    cmp		ax,word ptr es:[4Bh*4+2]
	jnz		@@novds
    mov		es:[4Bh*4+2],bx
@@novds:
endif
	pop		es

    sti

	mov		si,offset _TEXT16:intvecs
@@nextint2:
    mov		al,cs:[si].INTMOD.bInt
    cmp		al,-1
    jz		@@intmoddone2
	mov		ah,25h
    mov		dx,cs:[si].INTMOD.wNew
	push	ds
    mov		ds,bx
    int		21h
    pop		ds
    add		si,size INTMOD
    jmp		@@nextint2

INTMOD struc
bInt	db ?
wNew	dw ?
wOld	dw ?
INTMOD ends

intvecs label INTMOD
	INTMOD <15h,offset NEW15, offset OLDINT15>
if ?INTEGRATED
	INTMOD <2Fh,offset NEW2F, offset OLDINT2F>
endif
if ?DMA    
	INTMOD <13h,offset NEW13, offset OLDINT13>
	INTMOD <40h,offset NEW40, offset OLDINT40>
endif
	INTMOD <67h,offset NEW67, -1>
	INTMOD <06h,offset NEW06, -1>
	INTMOD <19h,offset NEW19, -1>
    db -1

@@intmoddone2:

    call	endinit

ife ?INTEGRATED    
    call	InstallXMSHandler
endif

    mov dx, offset DGROUP:dLoaded
    mov ah, 9
    int 21h

	pop		ax
    pop		dx
    pop		bp
    pop		di
    pop		si
    ret


_InitJemm ENDP

    assume ss:nothing
	assume es:nothing
	assume ds:DGROUP

_IsProtectedMode proc near
	SMSW    AX
	AND    AX,0001H             ; PE-Bit (Protect Enable) set ?
	ret
_IsProtectedMode ENDP

if 1
	public _IsDPMI 			; DPMI host installed?
_IsDPMI proc near
	push	si
    push	di
	mov		ax,1687h
    int		2Fh
    and		ax,ax
    setz	al
    mov		ah,0
    pop		di
    pop		si
	ret
_IsDPMI ENDP
endif

if ?ADDCONT

;--- this will eventually make segment A000-AFFF (and B000-B7FF)
;--- part of conventional DOS memory if option RAM=A000-AFFF is given

_AddIfContiguousWithDosMem proc 
	push bp
    mov bp,sp
    push si
    push es
if 0    
    mov ah, 52h
    int 21h
	mov es, es:[bx-2]
@@nextblock:
    mov al, es:[0]
    cmp al,'Z'
    jz @@endfound
    cmp al,'M'
    jnz @@error
    mov ax, es:[3]
    mov cx, es
    add ax, cx
    inc ax
    mov es, ax
    jmp @@nextblock
@@endfound:
	mov ax, es:[3]
    inc ax
    mov cx, es	;save last Z block in cx
    add ax, cx
    mov es, ax
    cmp word ptr es:[1],8
    jnz @@error
    cmp word ptr es:[8],"CS"
    jnz @@error
    inc ax
    mov si, [bp+4]
    cmp ax, si
    jnz @@error

	mov si, [bp+6]
    
;--- ok, found and contiguous
    
@@error:    
endif
    xor ax, ax
    pop es
    pop si
    pop bp
    ret
_AddIfContiguousWithDosMem endp    

endif

_memcpy proc
	push bp
    mov bp,sp
    push si
    push di
    push ds
    pop es
    mov di,[bp+4]
    mov si,[bp+6]
    mov cx,[bp+8]
    rep movsb
    pop di
    pop si
    pop bp
    ret
_memcpy endp

_memset proc
	push bp
    mov bp,sp
	push di
    push ds
    pop es
    mov di,[bp+4]
    mov ax,[bp+6]
    mov cx,[bp+8]
    rep stosb
    pop di
    pop bp
	ret
_memset endp

;--- convert long to string
;--- stdcall ltob(long n, char * s, int base);

_ltob	PROC

n	equ <bp+4>
s	equ <bp+8>
base equ <bp+10>

	push	bp
    mov		bp,sp
	push	edi
	push	si
;	n = 4
;	s = 8
;	base = 10
;	u = -4
;	register si = p
	mov ch,0
	movzx edi,WORD PTR [base]
	mov	eax,[n]
	cmp	di,-10
	jne	@@ispositive
	mov	di,10
    and eax,eax
    jns @@ispositive
    neg eax
    mov ch,'-'
@@ispositive:
	mov	bx,[s]
	lea	si,[bx+10]
	mov	BYTE PTR [si],0
	dec	si
@@nextdigit:
	xor edx, edx
    div edi
	add dl,'0'
    cmp dl,'9'
    jbe @@isdigit
    add dl,7+20h
@@isdigit:    
	mov	[si],dl
	dec	si
    and eax, eax
	jne	@@nextdigit
    cmp ch,0
	je	@@nosign
	mov	[si],ch
	dec	si
@@nosign:
	inc si
	mov	ax,si
	pop	si
	pop	edi
	pop bp
	ret	4+2+2

n	equ <>
s	equ <>
base equ <>

_ltob	ENDP


_IsEmmInstalled proc public
	call _IsJemmInstalled
    mov dx,offset dAlreadyInstalled
    jnc @@printandexit
	call EmmInstallcheck
    mov dx,offset dEmmInstalled
    jc @@printandexit
    mov dx,offset dUnknownInstalled
@@printandexit:    
    mov ah,9
    int 21h
    ret
_IsEmmInstalled endp

buff equ <bp-16>

_EmmUpdate proc
	@DbgOutS <"EmmUpdate enter",10>,?EMXRMDBG
    push di
    push bp
	mov bp, sp
    sub sp,16
    xor di,di
    call _IsJemmInstalled
    jnc @@jemmok
	MOV     DX,OFFSET dError1
	MOV     AH,9
	INT     21H
    jmp		@@exit
@@jemmok:    
    mov bx, ax
    mov byte ptr [buff+0],15
    mov ax,_TEXT32
    mov es,ax
    assume es:_TEXT32
    
;--- create a EMX15W variable to send to installed Jemm386    
    
?IOCTLBUFFSIZ = 5
if ?VME    
    mov al, [_jemmini.jiNoVME]
else
	mov al,-1
endif    
    mov [buff+1],al
if ?A20PORTS or ?A20XMS
    mov al, [_jemmini.jiNoA20]
else
	mov al,-1
endif    
    mov [buff+2],al
    mov al, [_jemmini.jiNoVCPI]
    mov [buff+3],al
if ?PGE
    mov al, [_jemmini.jiNoPGE]
else
	mov al,-1
endif    
    mov [buff+4],al
    assume es:nothing

    mov cx,?IOCTLBUFFSIZ
    lea dx,[buff]
    mov ax,4403h	;write ioctl
    int 21h
    jc @@noioctlwrite
	@DbgOutS <"EmmUpdate: write ioctl(15) ok",10>,?EMXRMDBG
    inc di
@@noioctlwrite:    
    mov ah,3Eh
    int 21h
@@exit:
	@DbgOutS <"EmmUpdate exit",10>,?EMXRMDBG
	mov ax,di
    mov sp,bp
    pop bp
    pop di
    ret
_EmmUpdate endp

buff equ <>

GetRes proc
    mov ah,_jemmini.jiResUMB
    and ah,ah
    jz @@nomovehigh
    mov al,0
    ret
@@nomovehigh:
	mov ax,cs
	stc
    ret
GetRes endp

;--- end of initialization
;--- 1. init XMS handle table for integrated version
;--- 2. link resident part in driver chain if moved high

endinit proc

if ?INTEGRATED
	mov di, offset xms_handle_array + size XMS_HANDLE * 2
    mov cx, _xms_num_handles
    dec cx
    dec cx
    call GetRes
    mov es,ax
@@nexthandle:    
    mov ax, XMSF_INPOOL
    stosw
    xor eax, eax
    stosd
    stosd
    loop @@nexthandle
    mov ax, di
    add ax, 16-1
    and al, 0F0h
    mov [wLow], ax
endif    

if ?MOVEHIGH
    call GetRes
    jc @@nomovehigh
    mov [wLow],0
	mov ah,52h			;add the EMMXXXX0 driver to the driver chain
    int 21h				;if we moved high
    push ds
    push 0
    pop ds
    mov ax,ds:[67h*4+2]
    mov ds,ax
    add bx,22h
    shl eax,16
    xchg eax,es:[bx]
	mov ds:[0],eax
    pop ds
@@nomovehigh:
endif
    ret
endinit endp

;--- InstallXMSHandler

ife ?INTEGRATED

InstallXMSHandler proc
	push bp
    mov bp,sp
ife ?A20XMS      				;if there is no XMS A20 trapping
    cmp _jemmini.jiNumUMBs,0	;XMS hook is needed *only* for UMBs.
    jz @@umbdone				;dont install if no UMBs are supplied
endif    
    mov ax,4300h
    int 2Fh
    cmp al,80h
    jnz @@noxms
    mov ax,4310h
    int 2Fh
    push es
    push bx
    mov dx, -1
    mov ah, 10h
    call dword ptr [bp-4]
    and ax, ax
    jnz @@umbalreadythere
    les bx,[bp-4]
@@nexttest:
	mov al,es:[bx]
    cmp al,0EBh
    jz  @@endofchain
    les bx,es:[bx+1]
    cmp al,0EAh
    jz @@nexttest
;--- unexpected pattern found in XMS hook chain
    jmp @@umbdone
@@endofchain:
	cli
    mov byte ptr es:[bx+0],0EAh
    mov word ptr es:[bx+1],offset XMShandler
    push ds
if ?MOVEHIGH    
    push 0
    pop ds
    mov ax,ds:[67h*4+2]
else
	mov ax, cs
endif
    mov es:[bx+3], ax
    add bx,5
    mov ds, ax
    assume DS:_TEXT16
    mov word ptr ds:[XMSoldhandler+0],bx
    mov word ptr ds:[XMSoldhandler+2],es
if ?A20XMS
    mov ax, [bp+4]
    and ax, ax
    jnz @@xmswithumb
    mov byte ptr ds:[XMSUMB], 0EAh
    mov word ptr ds:[XMSUMB+1], bx
    mov word ptr ds:[XMSUMB+3], es
@@xmswithumb:
endif
	pop ds
    assume DS:DGROUP
	sti
    jmp @@umbdone
@@umbalreadythere:
	push offset DGROUP:szUMBErr1
    call _printf
    pop cx
@@noxms:
@@umbdone:
	mov sp,bp
    pop bp
	ret
InstallXMSHandler endp

endif

handle_char proc

	pop cx
    pop dx
    push cx
    cmp dl,10
    jnz @@isnotlf
    push dx
    mov dl,13
    mov ah,2
    int 21h
    pop dx
@@isnotlf:    
    mov ah,2
	int 21h
    ret
    
handle_char endp

;--- C compiler helper procs. Avoids to need the C runtime libs

divprocs proc

ife (?WCC + ?MSC + ?DMC)
?TCC equ 1
else
?TCC equ 0
endif

if ?TCC

	public	LDIV@			; the procs which were in LIBM.LIB
    public	LUDIV@			; are now implemented here
	public	LMOD@
    public	LUMOD@
	public	LXLSH@
	public	LXRSH@
	public	LXURSH@
	public	LXMUL@
if ?NEARC    
    public	N_LUDIV@
	public	N_LXLSH@
	public	N_LXRSH@
	public	N_LXURSH@
endif    

;--- [bp+6] mod|div [bp+10]
;--- clears stack!


if ?MASM
LMOD@::
LUMOD@::
else
LMOD@:
LUMOD@:
endif
		mov bl,1
        jmp @@common
if ?MASM
LDIV@::
LUDIV@::
else
LDIV@:
LUDIV@:
endif
		mov bl,0
@@common:        
    	push BP
		mov	BP,SP
        mov eax, [bp+6]
        mov ecx, [bp+10]
        cdq
        div ecx
        test bl,1
        jz @@isdiv
        mov eax, edx
@@isdiv:        
        push eax
        pop ax
        pop dx
        pop bp
        retf 8
if ?NEARC        
if ?MASM
N_LDIV@::
N_LUDIV@::
else
N_LDIV@:
N_LUDIV@:
endif
		mov bl,0
    	push BP
		mov	BP,SP
        mov eax, [bp+6]
        mov ecx, [bp+10]
        cdq
        div ecx
        test bl,1
        jz @@n_isdiv
        mov eax, edx
@@n_isdiv:        
        push eax
        pop ax
        pop dx
        pop bp
        ret 8
endif

;--- shl DX:AX CL bits

if ?MASM
LXLSH@::
else
LXLSH@:
endif
		push dx
        push ax
        pop eax
        shl eax, cl
        push eax
        pop ax
        pop dx
        retf

if ?NEARC
if ?MASM
N_LXLSH@::
else
N_LXLSH@:
endif
		push dx
        push ax
        pop eax
        shl eax, cl
        push eax
        pop ax
        pop dx
        ret
endif

;--- shr DX:AX CL bits

if ?MASM
LXURSH@::
LXRSH@::
else
LXURSH@:
LXRSH@:
endif
		push dx
        push ax
        pop eax
        shr eax, cl
        push eax
        pop ax
        pop dx
		retf
if ?NEARC
if ?MASM
N_LXURSH@::
N_LXRSH@::
else
N_LXURSH@:
N_LXRSH@:
endif
		push dx
        push ax
        pop eax
        shr eax, cl
        push eax
        pop ax
        pop dx
		ret
endif

;--- mul DX:AX with CX:BX, result in DX:AX

if ?MASM
LXMUL@::
else
LXMUL@:
endif
		push dx
		push ax
        pop eax
        push cx
        push bx
        pop ecx
        mul ecx
        push eax
        pop ax
        pop dx
		retf
endif

if ?WCC        
        public __U4D	;used by WCC (dx:ax / cx:bx = dx:ax, remainder in cx:bx)
        public __I4M	;used by WCC (dx:ax * cx:bx = dx:ax)
if ?MASM
__U4D::
else
__U4D:
endif
		push dx
		push ax
        pop eax
        push cx
        push bx
        pop ecx
        cdq
        div ecx
        push edx	;remainder into CX:BX
        pop bx
        pop cx
        push eax
        pop ax
        pop dx
		ret
if ?MASM
__I4M::
else
__I4M:
endif
		push dx
		push ax
        pop eax
        push cx
        push bx
        pop ecx
        cdq
        mul ecx
        push eax
        pop ax
        pop dx
		ret
endif

if ?MSC

;--- some publics for MS C 1.5

		public __aNulrem
		public __aNuldiv
		public __aNulshr
		public __aNlmul
		public __aNlshl

if ?MASM
__aNulrem::
else
__aNulrem:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        cdq
        div ecx
        push edx
        pop ax
        pop dx
		ret
if ?MASM        
__aNuldiv::
else
__aNuldiv:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        cdq
        div ecx
        push eax
        pop ax
        pop dx
		ret
if ?MASM        
__aNlmul::
else
__aNlmul:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        mul ecx
        push eax
        pop ax
        pop dx
		ret
if ?MASM
__aNulshr::
else
__aNulshr:
endif
		push dx
        push ax
        pop eax
        shr eax, cl
        push eax
		pop ax
        pop dx
		ret
if ?MASM        
__aNlshl::
else
__aNlshl:
endif
		push dx
        push ax
        pop eax
        shl eax, cl
        push eax
		pop ax
        pop dx
		ret

endif

if ?DMC

;--- some publics for DMC

		public __ULREM@
		public __ULDIV@
		public __ULSHR@
		public __aNlmul
		public __aNlshl

if ?MASM
__ULREM@::
else
__ULREM@:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        cdq
        div ecx
        push edx
        pop ax
        pop dx
		ret
if ?MASM        
__ULDIV@::
else
__ULDIV@:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        cdq
        div ecx
        push eax
        pop ax
        pop dx
		ret
if ?MASM        
__aNlmul::
else
__aNlmul:
endif
		pop dx
        pop eax
        pop ecx
        push dx
        mul ecx
        push eax
        pop ax
        pop dx
		ret
if ?MASM
__ULSHR@::
else
__ULSHR@:
endif
		push dx
        push ax
        pop eax
        shr eax, cl
        push eax
		pop ax
        pop dx
		ret
if ?MASM        
__aNlshl::
else
__aNlshl:
endif
		push dx
        push ax
        pop eax
        shl eax, cl
        push eax
		pop ax
        pop dx
		ret

endif

divprocs endp

REG16 struc
st_ax	dw ?
st_bx	dw ?
st_cx	dw ?
st_dx	dw ?
REG16 ends

        
_emmcall proc
		push bp
        mov bp,sp
        push si
        mov si,offset DGROUP:_emmreg16
        mov ax,[si].REG16.st_ax
        mov ah, [bp+4]
        mov _emmfunction, ah
        mov bx,[si].REG16.st_bx
        mov cx,[si].REG16.st_cx
        mov dx,[si].REG16.st_dx
        int 67h
        mov [si].REG16.st_ax,ax
        mov [si].REG16.st_bx,bx
        mov [si].REG16.st_cx,cx
        mov [si].REG16.st_dx,dx
        movzx ax,ah
        pop si
        pop bp
		ret
_emmcall endp

_XMSinit proc
	    mov ax, 4300h
		int 2fh
		cmp al, 80h
		jne @@not_detected
		mov ax, 4310h
		int 2fh
		mov word ptr _XMSdriverAddress+0, bx
		mov word ptr _XMSdriverAddress+2, es

		mov ax, 4309h		;  XMS get xms handle table
		int 2fh
		cmp al,43h
		jne @@no_table
		mov word ptr _jemmini.jiXMSHandleTable+0, bx
		mov word ptr _jemmini.jiXMSHandleTable+2, es
@@no_table:
		mov ax,1
		ret
@@not_detected:
if ?INTEGRATED        
		mov word ptr _XMSdriverAddress+0, offset XMShandler
		mov word ptr _XMSdriverAddress+2, cs
		mov word ptr _jemmini.jiXMSHandleTable+0, offset xms_handle_table
		mov word ptr _jemmini.jiXMSHandleTable+2, cs
endif        
		xor ax,ax
        ret
_XMSinit endp

ife ?INTEGRATED

_xmscall proc
		push bp
        mov bp,sp
        push si
        mov si,offset DGROUP:_xmsreg16
        mov bx,[si].REG16.st_bx
        mov dx,[si].REG16.st_dx
        mov ah, [bp+4]
if ?XMSRMDBG
		@DbgOutS <"xms call: ax=">,1
        @DbgOutW ax,1
		@DbgOutS <" bx=">,1
        @DbgOutW bx,1
		@DbgOutS <" dx=">,1
        @DbgOutW dx,1
		@DbgOutS <10>,1
endif
        call dword ptr ds:[_XMSdriverAddress]
        mov [si].REG16.st_ax,ax
        mov [si].REG16.st_bx,bx
        mov [si].REG16.st_dx,dx
if ?XMSRMDBG
		@DbgOutS <"xms ret : ax=">,1
        @DbgOutW ax,1
		@DbgOutS <" bx=">,1
        @DbgOutW bx,1
		@DbgOutS <" dx=">,1
        @DbgOutW dx,1
		@DbgOutS <10>,1
endif
        pop si
        pop bp
		ret
_xmscall endp

REG32 struc
st_eax	dd ?
st_ebx	dd ?
st_ecx	dd ?
st_edx	dd ?
REG32 ends

_xmscall32 proc
		push bp
        mov bp,sp
        push si
        mov si,offset DGROUP:_xmsreg32
        mov ebx,[si].REG32.st_ebx
        mov edx,[si].REG32.st_edx
        mov ah, [bp+4]
        call dword ptr ds:[_XMSdriverAddress]
        mov [si].REG32.st_eax,eax
        mov [si].REG32.st_ebx,ebx
        mov [si].REG32.st_ecx,ecx
        mov [si].REG32.st_edx,edx
        pop si
        pop bp
		ret
_xmscall32 endp

else

E820MAP struc 
baselow  dd ?
basehigh dd ?
lenlow   dd ?
lenhigh  dd ?
type_    dd ?
E820MAP ends

SMAP equ 534d4150h

_I15GetMemoryStatus proc

    push ebp
    push ebx
	push esi
    push edi

    
    cmp [_x_option],0
    jne @@e801_check   ; cannot use 0e820h, per user /X command

	@DbgOutS <"I15GetMemoryStatus: get extended memory with int 15, E820",13,10>,?INITRMDBG

; try 0e820h first

    xor ebx,ebx
    mov esi,ebx
    mov ebp,ebx
    
    push ss
    pop es
    sub sp, size E820MAP

; ebx offset is updated with each successive int 15h
@@e820_loop:
    mov edx,SMAP
    mov ecx,20                     ; size E820MAP
    mov di,sp
    xor eax,eax
    mov [di].E820MAP.baselow,eax   ; insurance against buggy BIOS
    mov [di].E820MAP.type_,eax
    mov [di].E820MAP.lenlow,eax
    mov ax,0e820h
    int 15h
    setc dl         ; keep carry flag status
    cmp eax,SMAP
    jne @@e820_bad  ; failure
    cmp dl,1
    je  @@e820_done ; CF doesn't have to signal fail, can just mean done

    cmp ebx,0
    je  @@e820_done ; finished
    cmp ecx,20      ; didn't return all the info needed, assume done
    jb  @@e820_done

    cmp [di].E820MAP.type_,1    ; memory available to OS
    jne @@e820_loop
    mov eax,[di].E820MAP.baselow
    cmp eax,100000h ; has to live in extended memory
    setz dl
    jb  @@e820_loop

    cmp esi,0
    jne @@e820_checkhole

; we're not able to handle extended base start not exactly at 100000h
;  not big deal to add support later (does this happen, though?)
    cmp dl,1
    jne @@e820_done
    mov ebp,eax
    jmp @@e820_matchcrit

; check that there isn't a hole in memory, stop at the hole if detected
;  this presumes the map will return contiguous addresses rather than a spray
@@e820_checkhole:
    mov eax,ebp
    add eax,esi
    cmp eax,[di].E820MAP.baselow
    jne @@e820_done ; current base plus memory length not equal to this base

; matched all the criteria, add to the memory count
@@e820_matchcrit:
    add esi,[di].E820MAP.lenlow
    jnc @@e820_loop
    mov esi,-1  ; wow, we overflowed a 4G counter, force a limit
    jmp @@e820_done

@@e820_bad:
    xor esi,esi     ; force failure

@@e820_done:
	add sp,size E820MAP
    mov eax,esi
    shr eax,10      ; convert from bytes to 1K blocks
    cmp eax,64      ; only use if useful amount
    ja  @@exit

; try 0e801h, but set up the registers to fail status because not
;  all BIOS's properly return the carry flag on failure
@@e801_check:
    cmp [_no_above_16],0
    jne @@try_88h   ; cannot use 0e801h, per user /NOABOVE16 command

	@DbgOutS <"geti15mem: get extended memory with int 15, E801",13,10>,?INITRMDBG

    xor ax,ax
    mov bx,ax
    mov cx,ax
    mov dx,ax
    mov ax,0e801h
    int 15h
    jc  @@try_88h
    mov ax,cx
    or  ax,dx
    je  @@try_88h

; if dx is > 0, then cx should be 3c00h since that's full 1-16M range
;  if cx != 3c00h use cx and not dx
    cmp cx,3c00h
    je  @@e801_compute
    cmp dx,0
    je  @@e801_compute
    xor dx,dx

@@e801_compute:
    movzx edx,dx
    shl edx,6           ; convert 64K blocks to 1K
    movzx eax,cx
    add eax,edx
    cmp eax,64      ; only use if useful amount
    ja  @@exit

; e801h didn't do the trick, fall back to old 88h with 64M max
@@try_88h:

	@DbgOutS <"geti15mem: get extended memory with int 15, 88",13,10>,?INITRMDBG

    clc
    mov ah,88h
    int 15h
    movzx eax,ax
    jnc @@exit
    xor ax,ax
@@exit:
	pop edi
    pop esi
    pop ebx
    pop ebp
	mov	edx,[_xms_max]
	or	edx,edx
	je	@@nolimit
	cmp	eax,edx
	jbe	@@nolimit
	mov	eax,edx				; above max, limit to maximum
@@nolimit:
    cmp eax, 64
    jbe @@nomem
    mov ecx, eax
    sub ecx, 64
    mov [xms_handle_array.xh_flags],XMSF_FREE
    mov [xms_handle_array.xh_baseK],1024+64
    mov [xms_handle_array.xh_sizeK],ecx
@@nomem:    
    push eax
    pop ax
    pop dx
	ret
_I15GetMemoryStatus endp

;--- I15AllocMemory(int dummy, long kbneeded);

_I15AllocMemory proc
	
	push bp
    mov bp, sp
    push ds
    xor ax,ax
    push cs
    pop ds
    mov bx,offset xms_handle_array
    cmp [bx].XMS_HANDLE.xh_flags,XMSF_FREE
	jnz @@fail
    mov ecx, [bp+6]	;kbneeded
    mov edx, [bx].XMS_HANDLE.xh_sizeK
    sub edx,ecx
    jb  @@fail
    mov [bx].XMS_HANDLE.xh_sizeK, ecx
    mov [bx].XMS_HANDLE.xh_locks, 1
    mov [bx].XMS_HANDLE.xh_flags, XMSF_USED
    add ecx, [bx].XMS_HANDLE.xh_baseK
    mov [bx + size XMS_HANDLE].XMS_HANDLE.xh_flags, XMSF_FREE
    mov [bx + size XMS_HANDLE].XMS_HANDLE.xh_sizeK, edx
    mov [bx + size XMS_HANDLE].XMS_HANDLE.xh_baseK, ecx
	mov ax,bx
@@fail:
	pop ds
    pop bp
	ret
_I15AllocMemory endp

;--- get A20 method

_GetA20Method  PROC

cmdline	equ <bp+4>

	push	bp
    mov		bp,sp
	push	si
    push    di
	mov     si,[cmdline]
    mov		di,offset DGROUP:methods
    xor		bx,bx
    push ds
    pop es
    cld
@@nextitem:    
    mov		cl,[di]
    mov		ch,0
    jcxz	@@done
    inc		di
    pusha
@@nextchar:    
    lodsb
    or al,20h
    scasb
    loopz @@nextchar
    popa
    jz @@found
    add di,cx
    inc bx
    jmp @@nextitem
@@found:
    mov di,si
    add si,cx
@@nextchar2:
    lodsb
    stosb
    and al,al
    jnz @@nextchar2
@@done:
	mov ax,bx
    pop di
	pop	si
	pop bp
	ret	2

cmdline equ <>

_GetA20Method	ENDP

;--- there are 3 A20 switch procs:
;--- 1. KBC (port 64h/60h)
;--- 2. fast, ps2, port92 (port 92h)
;--- 3. BIOS (int 15h, ax=240xh)

; try turning A20 on or off from current to see if it works
; KBC HIMEM method
; entry: ah == 0 A20 turn off, ah == 2 turn on, ax on stack
;
disable_enable_a20_KBC:
	push	cx
	pushf
	cli				; shut off interrupts while we twiddle

	call Sync8042	; check keyboard controller ready
	mov	al,0D1h		; Send D1h
	out	64h,al
	call Sync8042
	mov	al,0ddh		; or df=dd+2
	or	al,ah		; disable/enable A20 command (DDh/DFh)
	out	60h,al
	call Sync8042

; wait up to 20 microseconds for A20 line to settle
	mov	al,0FFh		; pulse output port NULL
	out	64h,al
	call Sync8042
	popf
	pop	cx
	ret

Sync8042:
	xor	cx,cx
InSync:
	in	al,64h
	and	al,2
	loopnz InSync
	ret

; the so-called 'fast' A20 method replacement code
; entry: ah == 0 A20 turn off, ah == 2 turn on, ax on stack
;
disable_enable_a20_fast:
	pushf
    in  al,92h
	or	ah,ah
	jne	deaf_on		; turning on A20
	test al,2
	je	deaf_done	; already flagged off, don't do it again, might upset something
	and	al,NOT 2	; set A20 bit off
	jmp	deaf_out

; ah == 2
deaf_on:
	test al,ah
	jne	deaf_done	; already flagged on
	or al,ah		; set A20 bit on

deaf_out:
	out	92h,al

; wait until it gets on or off, possibly superfluous, code opinion differs
	push cx
    xor cx,cx
deaf_wait:
    in  al,92h
    and al,2
    cmp al,ah
    loopne deaf_wait
	pop	cx

deaf_done:
	popf
    ret

; BIOS A20 method
; entry: ah == 0 A20 turn off, ah == 2 turn on, ax on stack
; don't check for errors, assume BIOS works more than once on same call,
;  if it doesn't, not much we can do about it anyway
;
disable_enable_a20_BIOS:
	pushf
	sub	sp,10	; give buggy BIOS some stack to chew on without causing problems
				; one word might suffice, but let's be really safe
	cli
	shr	ah,1	; ah to 0 or 1
	mov	al,24h
	xchg ah,al	; ax == 2400h to turn off, 2401h to turn on
	int	15h

	add	sp,10	; restore potentially gnawed-on stack
	popf
    ret
    
disable_enable_a20_dummy:
	or ah,ah
	ret

flag_kbc:
	mov	si,offset disable_enable_a20_KBC
    ret
flag_bios:
	mov	si,offset disable_enable_a20_BIOS
    ret
flag_port92:
flag_ps2:
flag_fast:
    mov si, offset disable_enable_a20_fast
    ret
flag_dummy:
	mov	si,offset disable_enable_a20_dummy
    ret

; check if BIOS flags port 92h fast method supported

detect_fast proc 
	stc
	mov	ax,2403h
	int	15h
	jc	@@fail_test
	or ah,ah
	jne	@@fail_test
	test bl,2		;PS/2 supported?
	je	@@fail_test

	mov	si,OFFSET disable_enable_a20_fast
    call test_A20_proc
	ret
@@fail_test:
	stc			; flag failure
	ret
detect_fast endp 

; check if BIOS flags PS/2 present, to try port 92h fast method used by PS/2's
;  shares enable/disable code with fast

detect_PS2 proc 

	mov	ah,0c0h		; get system description vector
	stc
	int	15h
	jc	@@fail_test	; not a PS/2

; test feature information byte 1, micro channel implemented bit
	test BYTE ptr es:[bx+5],2
	jz @@fail_test	; not micro channel

	mov	si,OFFSET disable_enable_a20_fast
    call test_A20_proc
    ret

@@fail_test:
	stc			; flag failure
	ret

detect_PS2 endp 

; check if port 92h fast method supported without BIOS or PS/2 test
;  shares enable/disable code with fast and PS/2

detect_port92 proc 

	mov	si,OFFSET disable_enable_a20_fast
    call test_A20_proc
    ret

detect_port92 endp 


detect_BIOS proc 
	stc				; preset carry flag
	mov	ax,2402h	; get gate status
	int	15h
	jc	@@fail_test
	or	ah,ah
	jne	@@fail_test
	mov	cl,al	; save status

	mov	si,OFFSET disable_enable_a20_BIOS
    call test_A20_proc
    ret
@@fail_test:
	stc			; flag failure
	ret

detect_BIOS endp 


detect_KBC proc 

	mov	si,OFFSET disable_enable_a20_KBC
    call test_A20_proc
    ret

detect_KBC endp 

test_a20 proc    
	push ds
	push es
	push cx
    push si
    push di
    mov cx,-1
    mov es,cx
    mov si,10h
    inc cx
    mov ds,cx
    mov di,20h
	mov cl,4
    repz cmpsd
    pop di
    pop si
    pop cx
	pop	es
	pop	ds
	ret
test_a20 endp    

; upon entry si->disable/enable routine for a20 method being tested
; return carry set if failed, reset if success
;
test_A20_proc proc	
	call test_a20
    setnz cl
	jz @@dah_2		; A20 disabled on entry
	mov ah,0
	call si         ; try to disable A20
	call test_a20
	jnz	@@dah_fail	; A20 not disabled
@@dah_2:

; try to enable A20 (always disabled at this point)

	mov ah,2
	call si
	call test_a20
	jz	@@dah_fail		; A20 not enabled
	or	cl,cl
	jne	@@dah_success	; A20 was enabled on entry, done
	mov ah,0
	call si
	call test_a20
	jnz	@@dah_fail		; A20 not disabled
@@dah_success:
	clc
	ret
@@dah_fail:
	stc
	ret
    
test_A20_proc endp	

;--- get the A20 proc to use

geta20proc proc    

	push si
	mov al, _jemmini.jiA20Method
	cmp	al,A20_ALWAYSON
	je	@@is_alwayson
	cmp	al,A20_BIOS
	je	@@is_bios
	cmp	al,A20_FAST
	je	@@is_fast
	cmp	al,A20_PS2
	je	@@is_ps2
	cmp	al,A20_KBC
	je	@@is_kbc
	cmp	al,A20_PORT92
	je	@@is_port92

	and ah,ah               ;ignore A20 current state?
    jz @@check_A20_method
    
; check if the A20 line is on, if so assume it's always on

	call test_a20
	jz	@@check_A20_method		; not on, try other methods

; use A20 always on code (dummy enable/disable A20 routine)
@@is_alwayson:
	@DbgOutS <"getA20proc: ALWAYSON",13,10>,?INITRMDBG
	call flag_dummy
    push offset DGROUP:szAlwaysOn
	jmp	@@got_type

@@check_A20_method:

    call detect_fast; see if port 92h (2403h BIOS call) handler supported 	
	jnc	@@is_fast

    call detect_PS2	; see if port 92h (PS/2 signature) handler supported
	jnc	@@is_ps2

    call detect_KBC	; see if KBC handler supported
	jnc	@@is_kbc

; try BIOS here, demoted from first in line because unreliable BIOS
;  versions of A20 control exist

    call detect_BIOS	; see if BIOS A20 handler supported
	jnc	@@is_bios

; see if fast port 92h handler supported without BIOS or PS/2 signature
;  leave this test until last because messing with port 92h is
;  reported to crash some machines which don't support that method
    call detect_port92
	jnc	@@is_port92

; out of options to try, return error

	mov	dx,OFFSET MsgUnknownA20
    mov ah,9
    int 21h
    pop si
    stc
    ret
    
@@is_bios:    
	@DbgOutS <"getA20proc: BIOS",13,10>,?INITRMDBG
	call flag_bios
    push offset DGROUP:szBIOS
	jmp	@@got_type
@@is_fast:
	@DbgOutS <"getA20proc: FAST",13,10>,?INITRMDBG
	call flag_fast
    push offset DGROUP:szFast
	jmp	@@got_type
@@is_ps2:
	@DbgOutS <"getA20proc: PS2",13,10>,?INITRMDBG
	call flag_ps2
    push offset DGROUP:szPS2
	jmp	@@got_type
@@is_kbc:
	@DbgOutS <"getA20proc: KBC",13,10>,?INITRMDBG
	call flag_kbc
    push offset DGROUP:szKBC
	jmp	@@got_type
@@is_port92:
	@DbgOutS <"getA20proc: PORT92",13,10>,?INITRMDBG
	call flag_port92
    push offset DGROUP:szPort92
@@got_type:
    push offset DGROUP:szA20Proc
	call _printf
    pop cx
    pop cx
    
	mov ax,si
    pop si
	clc
	ret
    
geta20proc endp

_EnableA20 proc
	@DbgOutS <"EnableA20",13,10>,?INITRMDBG
    mov ah,1
	call geta20proc
	jc @@fail
    mov bx,ax
    mov ah,2
    call bx
@@fail:
	ret
_EnableA20 endp

_DisableA20 proc
	@DbgOutS <"DisableA20",13,10>,?INITRMDBG
    mov ah,0
	call geta20proc
	jc @@fail
    mov bx,ax
    mov ah,0
    call bx
@@fail:
	ret
_DisableA20 endp

endif

_VMwareDetect proc
		
		mov eax, 564D5868h	;/* mov eax,564d5856h */
		mov ecx, 0000000ah
		mov ebx,ecx
		mov dx, 5658h
		in eax,dx
		cmp ebx, 564D5868h
		jne @@failed
        mov ax,1
        ret
@@failed:
		xor ax, ax
        ret
_VMwareDetect endp

_strlen proc NEAR
	push bp
	mov	bp,sp
    push di
    mov cx,-1
    mov di,[bp+4]
    push ds
    pop es
    mov al,0
    cld
    repnz scasb
    mov ax,cx
    inc ax
    not ax
    pop di
    pop bp
    ret
_strlen endp    

__memicmp proc NEAR
	push bp
	mov	bp,sp
    push di
    push si
    mov cx,[bp+8]
    mov si,[bp+6]
    mov di,[bp+4]
    cld
@@nextitem:    
    lodsb
    mov ah,[di]
    inc di
    or al,20h
    or ah,20h
    sub al,ah
    loopz @@nextitem
    cbw
    pop si
    pop di
    pop bp
    ret
__memicmp endp    

;--- toupper(char) returns uppercase character

_toupper PROC NEAR
	pop cx
    pop ax
    push cx
	cmp	al,'a'
	jb	@@I290
	cmp	al,'z'
	ja	@@I290
	sub	al,20h
@@I290:
	ret

_toupper	ENDP

;--- simple printf() implementation

_printf	PROC NEAR

	enter	18,0
	push	di
	push	si
    
fmt     equ <bp+4>
flag    equ <bp-1>
longarg equ <bp-2>
size_   equ <bp-4>
fill    equ <bp-6>
szTmp   equ <bp-18>
;	register di = args
	
    push ds
    pop es
	lea	di,[fmt+2]
@@L335:
	mov	si,[fmt]
@@FC244:
	lodsb
	or	al,al
	je	@@SC257
	cmp	al,'%'
	je	@@I246
	push ax
	call handle_char
	jmp	@@FC244
    
@@I246:
	xor	dx,dx
	mov	[longarg],dl
	mov	bl,1
	mov	cl,' '
	cmp	BYTE PTR [si],'-'
	jne	@@I247
	dec	bx
	inc	si
@@I247:
	mov	[flag],bl
	cmp	BYTE PTR [si],'0'
	jne	@@L355
	mov	cl,'0'
	inc	si
@@L355:
	mov	[fill],cx
	mov	[size_],dx
	mov	bx,dx
	jmp	@@L358
@@FC250:
	cmp	BYTE PTR [si],'9'
	jg	@@L362
	lodsb
	sub	al,'0'
	cbw	
	imul cx,bx,10       ;cx = bx * 10
	add	ax,cx
	mov	bx,ax
@@L358:
	cmp	BYTE PTR [si],'0'
	jge	@@FC250
@@L362:
	mov	[size_],bx
	cmp	BYTE PTR [si],'l'
	jne	@@I252
	mov	BYTE PTR [longarg],1
	inc	si
@@I252:
	lodsb
	mov	[fmt],si
	cbw	
	cmp	al,78h      ;'x'
	je	@@SC264
	ja	@@SD279
	or	al,al
	je	@@SC257     ;\0
	sub	al,58h		;'X'	
	je	@@SC264
	sub	al,11
	je	@@SC258     ;'c'
	dec	al
	je	@@SC261
	sub	al,5
	je	@@SC261
	sub	al,10
	je	@@SC259
	sub	al,2
	je	@@SC263
@@SD279:                      ;default
	push ax
	push 63	;'?'
	call handle_char
	jmp	@@L359
@@SC258:                      ;'c'
	push WORD PTR [di]
	add	di,2
@@L359:
	call handle_char
	jmp	@@L335
@@SC259:                      ;'s'
	mov	si,[di]
	add	di,2
	jmp	@@do_outputstring260
@@SC264:                      ;'X' + 'x'
	mov	bx,16
	jmp	@@lprt262
@@SC261:                      ;'d' + 'i'
	mov	bx,-10
	jmp	@@lprt262
@@SC263:                      ;'u'
	mov	bx,10
@@lprt262:
	cmp	BYTE PTR [longarg],0
	je	@@I265
	mov	ax,[di+0]
	mov	dx,[di+2]
	add	di,4
	jmp	@@L341
@@I265:
	mov	ax,[di]
	add	di,2
	cmp	bx,0
	jge	@@I267
	cwd	
	jmp	@@L341
@@I267:
	sub	dx,dx
@@L341:
	push bx
	lea	cx,[szTmp]
	push cx
    push dx
    push ax
	call _ltob
	mov	si,ax
@@do_outputstring260:
	push si
	call _strlen
	pop	bx
	sub	[size_],ax
	cmp	BYTE PTR [flag],1
	jne	@@L360
	mov	bx,[size_]
	jmp	@@L363
@@F270:
	push word ptr [fill]
	call handle_char
	dec	bx
@@L363:
	or	bx,bx
	jg	@@F270
	mov	[size_],bx
	jmp	@@L360
@@F273:
	mov	al,[si]
	push ax
	call handle_char
	inc	si
@@L360:
	cmp	BYTE PTR [si],0
	jne	@@F273
	mov	bx,[size_]
@@F276:
	or	bx,bx
	jle	@@L335
	push word ptr [fill]
	call handle_char
	dec	bx
	jmp	@@F276
@@SC257:
	xor	ax,ax
	pop	si
	pop	di
	leave	
	ret	

fmt     equ <>
flag    equ <>
longarg equ <>
size_   equ <>
fill    equ <>
szTmp   equ <>

_printf	ENDP


if ?WCC
		public _small_code_	;required by Open Watcom WCC
_small_code_ label byte

endif

_TEXT ENDS

_STACK	segment

		db 1024 dup(?)       ; stack for the C - things

exe_stacktop label byte

_STACK	ends

		end GO_EXE
