
; I15, ah=87 extended memory move 
; Public Domain
; to be assembled with MASM 6.1 or TASM 4.1/5.0

		.486P

		include jemm.inc		;common declarations
		include jemm32.inc		;declarations for Jemm32
		include debug.inc

ife ?MASM
		LOCALS
else
		option proc:private
endif

;--- equates

;--- assembly time constants

;--- segment definitions

if ?FLAT
		.model FLAT
else
  if ?MASM
  		option dotname
  endif      
endif

;--- publics/externals

		include external.inc
        
;--- start

ife ?MASM
		assume CS:FLAT
endif      
		assume SS:FLAT,DS:FLAT,ES:FLAT

;--- expected GDT structure pointed to by ES:SI for int 15h, ah=87

I15MOVE struc
	dq ?
	dq ?
src	descriptor <?>
dst	descriptor <?>
I15MOVE ends

.text$01 SEGMENT
.text$01 ends

.text$03 segment

;************************************************************
; simulate INT15/87
;
;INT 15 - SYSTEM - COPY EXTENDED MEMORY (by RBIL)
;		 AH = 87h
;		 CX = number of words to copy (max 8000h)
;		 ES:SI -> GDT (see I15MOVE)
;Return: CF set on error
;		 CF clear if successful
;		 AH = status 
;
;Values for extended-memory copy status (RBIL):
; 00h	 source copied into destination
; 01h	 parity error
; 02h	 interrupt error
; 03h	 address line 20 gating failed
; 80h	 invalid command (PC,PCjr)
; 86h	 unsupported function (XT,PS30)
;************************************************************

I15_Simulate87 proc public

	call	Simulate_Iret
	movzx	ecx,word ptr [ebp].Client_Reg_Struc.Client_ECX

    cld

;-- MS Emm386 returns with error AH=2 if CX > 8000h!

	cmp cx, 8000h	
	ja @@error02
	or	ecx,ecx
	je	@@ok			; nothing to do
    shl ecx,1
    
	MOVZX	edi,WORD PTR [ebp].Client_Reg_Struc.Client_ES	; make edi = linear address of command
	MOVZX	esi,WORD PTR [ebp].Client_Reg_Struc.Client_ESI
	SHL 	edi,4
	add 	esi,edi

	mov	eax,ecx			; verify that src and dst descriptors are ok.
    dec eax             ; we don't care about segment access rights
						
	cmp	ax, [esi].I15MOVE.src.wLimit; 16-bit overflow not an issue (0->ffff)
	ja	@@error80
	cmp	ax, [esi].I15MOVE.dst.wLimit
	ja	@@error80

	mov al,[esi].I15MOVE.src.bA1623
	mov ah,[esi].I15MOVE.src.bA2431	; get linear source address
	mov dl,[esi].I15MOVE.dst.bA1623
	mov dh,[esi].I15MOVE.dst.bA2431	; get linear destination address
	shl eax,16
	shl edx,16
	mov ax,[esi].I15MOVE.src.wA0015
	mov dx,[esi].I15MOVE.dst.wA0015
	mov esi,eax
	mov edi,edx

;--- here we have: esi=src, edi=dst, ecx=size

if ?I15DBG
	@DbgOutS <"Int 15h, ah=87h, src=">,1
	@DbgOutD esi,1
	@DbgOutS <", dst=">,1
	@DbgOutD edi,1
	@DbgOutS <", siz=">,1
	@DbgOutD ecx,1
	@DbgOutS <10>,1
endif

;-- NOCHECK -> moves for addresses not backuped with RAM/ROM will fail
;-- (cause an exception)

	test [bV86Flags], V86F_NOCHECK
	je	@@memcheck

	lea eax, [esi+ecx]
	lea edx, [edi+ecx]
	cmp	eax, [dwTotalMemory]
	jae	@@fail
	cmp	edx, [dwTotalMemory]
	jae	@@fail

@@memcheck:
	call MoveMemoryPhys
@@ok:
	mov AH,0	; everything OK and finished
	and	[ebp].Client_Reg_Struc.Client_EFlags, not 1	;CF=0
@@i1587_exit:
	mov byte ptr [ebp].Client_Reg_Struc.Client_EAX+1, ah
    ret
@@error02:
	mov ah,02h
	or	[ebp].Client_Reg_Struc.Client_EFlags, 1	;CF=1
	jmp @@i1587_exit
@@error80:
	mov ah,80h
	or	[ebp].Client_Reg_Struc.Client_EFlags, 1	;CF=1
    jmp @@i1587_exit
@@fail:
	jmp V86_Exc0D

    align 4
    
I15_Simulate87 endp


.text$03 ends

		END
