/* dynstr.h -- dynamic string library for edline

  AUTHOR: Gregory Pietsch <GKP1@flash.net>

  DESCRIPTION:

  This file is a dynamic string library for edline, an edlin-style line editor.

  COPYRIGHT NOTICE AND DISCLAIMER:

  Copyright (C) 2003 Gregory Pietsch

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

*/

#ifndef DYNSTRING_H
#define DYNSTRING_H

/* includes */
#if defined(__STDC__) || defined(HAVE_STDDEF_H)
#include <stddef.h>
#elif defined(HAVE_SYS_TYPES_H)
#include <sys/types.h>
#else
#define size_t unsigned
#endif

/* macros */
#define NPOS ((size_t)-1)

/* typedefs */

typedef struct DYNSTRING_T {
    char *ptr;
    size_t len;
    size_t res;
} DYNSTRING_T;

typedef struct DYNARRAYSTRING_T {
    DYNSTRING_T **ptr;
    size_t len;
    size_t res;
} DYNARRAYSTRING_T;

/* function definitions */

/* DAScreate - create a new DYNARRAYSTRING_T */
DYNARRAYSTRING_T *DAScreate(void);
/* DASdestroy - return a DYNARRAYSTRING_T to the void */
void DASdestroy(DYNARRAYSTRING_T * ds);
/* insert copies of strings into a DAS */
DYNARRAYSTRING_T *DASinsert(DYNARRAYSTRING_T * ds, size_t p,
                            DYNSTRING_T ** s, size_t n, size_t d);
/* remove a bunch of lines */
DYNARRAYSTRING_T *DASremove(DYNARRAYSTRING_T * ds, size_t p, size_t n);
/* get the string at position i */
DYNSTRING_T *DASgetat(DYNARRAYSTRING_T * ds, size_t i);
/* put a string at position i */
void DASputat(DYNARRAYSTRING_T * ds, size_t i, DYNSTRING_T * x);
/* get however many lines are in the DAS */
size_t DASlength(DYNARRAYSTRING_T * ds);

/* append char c to the end of ds nr times */
DYNSTRING_T *DSappendchar(DYNSTRING_T * ds, int c, size_t nr);
/* DScopy - return a copy of a DYNSTRING_T */
DYNSTRING_T *DScopy(DYNSTRING_T * orig);
/* DScreate - create a new DYNSTRING_T */
DYNSTRING_T *DScreate(void);
/* get a string's char pointer */
char *DScstr(DYNSTRING_T * ds);
/* DSdestroy - return a DYNSTRING_T to the void */
void DSdestroy(DYNSTRING_T * ds);
/* find a substring */
size_t DSfind(DYNSTRING_T * ds, const char *s, size_t p, size_t n);
/* get a string's length */
size_t DSlength(DYNSTRING_T * ds);
/* remove a substring */
DYNSTRING_T *DSremove(DYNSTRING_T * ds, size_t p, size_t nr);
/* replace a substring with a string */
DYNSTRING_T *DSreplace(DYNSTRING_T * ds, size_t p, size_t n, const char *s,
                       size_t ns);
/* resize a string */
void DSresize(DYNSTRING_T * ds, size_t n, int c);

#endif

/* END OF FILE */
