/*
   DISKCOPY.EXE, floppy diskette duplicator similar to MSDOS Diskcopy.
   Copyright (C) 1998, Matthew Stanford.
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have recieved a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


   If you have any questions, comments, suggestions, or fixes please
   email me at:  matthewstanford@usa.net

   [Be sure to run this from your hard drive as it creates a temp file.]
*/




#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>



int main(int argc, char *argv[])
{
   struct fatinfo sfat;
   char buf[32768];
   char tempfile[128];
   char loop1, loop2;
   char src, tgt;
   enum { A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z } sdrive, tdrive;
   int fsdrive;
   int handle;
   unsigned long drivesize, sector, total;



   if (argc != 3)//if no drive arguements, print usage instructions
   {
      printf("\nDISKCOPY [DRIVE 1] [DRIVE 2]\n");
      exit(0);
   }

   if (strlen(argv[1]) > 1)
   {
      printf("\nDISKCOPY [DRIVE 1] [DRIVE 2]\n");
      exit(0);
   }

   if (strlen(argv[2]) > 2)
   {
      printf("\nDISKCOPY [DRIVE 1] [DRIVE 2]\n");
      exit(0);
   }

   loop1 = 'Y';   //initialize loop1
   loop2 = 'Y';   //initialize loop2
   setcbrk(1);   //set control-break to ON

   sscanf(argv[1], "%1s", &src);
   sdrive = toupper(src);
   if (sdrive > 64) (sdrive = sdrive - 65);
   fsdrive = sdrive + 1;

   sscanf(argv[2], "%1s", &tgt);
   tdrive = toupper(tgt);
   if (tdrive > 64) (tdrive = tdrive - 65);

   while (loop1 != 'N') //loop1
   {
      strcpy(tempfile, "\\");
      handle = creattemp(tempfile, 0);

      printf("\nInsert SOURCE diskette into drive %s \n", argv[1]);
      printf("\nPress any key to continue . . .\n");
      getch();
      getfat(fsdrive, &sfat);
      total = (sfat.fi_nclus * sfat.fi_sclus);
      drivesize = (total * sfat.fi_bysec);
      printf(	"\nCopying %d clusters, %d sectors per cluster, %d bytes per sector\n"
		"Drive size is %ld bytes.  Disk ID is %d.\n",
      sfat.fi_nclus, sfat.fi_sclus, sfat.fi_bysec,
      drivesize, sfat.fi_fatid);
      printf("\nReading SOURCE diskette . . .\n");

      handle = open(tempfile, O_WRONLY | O_BINARY);
      for(sector = 0; sector < total; sector = sector + 64)
      {
	 absread(sdrive, 64, sector, buf);
	 write(handle, buf, 32768);
      }
      close(handle);

      while (loop2 != 'N') //loop2
      {
	 printf("\nInsert TARGET diskette into drive %s \n", argv[2]);
	 printf("\nPress any key to continue . . .\a\n");
	 getch();
	 printf("\nWriting to TARGET diskette in drive . . .\n");

	 handle = open(tempfile, O_RDONLY | O_BINARY);
	 for(sector = 0; sector < total; sector = sector + 64)
	 {
	    read(handle, buf, 32768);
	    abswrite(tdrive, 64, sector, buf);
	 }
	 close(handle);

	 loop2 = 'X';
	 while (loop2 != 'N')
	 {
	    printf("\nDo you want another copy of this disk (Y/N)?\n");
	    loop2 = toupper(getch());
	 }

      }//end loop2
      remove(tempfile);

      loop1 = 'X';
      while (loop1 != 'N')
      {
	 printf("\nCopy another disk (Y/N)?\n");
	 loop1 = toupper(getch());
      }
   }//end loop1

   return 0;
}
