/*
 * read.c      absolute disk read for DJGPP
 *
 *	Copyright (C) 1998, Gregg Jennings
 *
 * This file is from the D_DISK library and has been modified for
 * DISKED. The number of sectors passed to these functions, `nsecs',
 * _must_ _always_ be one (1), which is the case for DISKED.
 *
 * The DOS buffers here are allocated at first call and are never
 * freed.
 *
 * I used dosmalloc() for two reasons; using DJGPP's go32 information
 * block data (the macros __tb and _dos_ds) precludes using two DOS
 * buffers during a single DOS call, and many of DJGPP's library calls
 * use __tb and _dos_ds which can inadvertantly overwrite your data.
 *
 * With D_DISK I allocated and freed the memory for each call to the
 * disk read and write functions -- a bit wasteful. Allocating just
 * once only works, though, if the sector size and the number of
 * sectors to be read will always be the same.
 *
 */

#include <stdlib.h>

#include "gcc_dpmi.h"
#include "dosio.h"

/*
 * disk_read      absolute disk read (INT 25h)
 *
 */

extern int disk_read(int disk, long sector, void *buffer, int nsecs,
                     int secsize)
{
static int seg = -1,sel;
__dpmi_regs regs;

   if (seg == -1 && (seg = dosmalloc(secsize,&sel)) == -1)
      abort();

   regs.x.ax = disk;
   regs.x.dx = sector;
   regs.x.cx = nsecs;
   regs.x.ds = seg;
   regs.x.bx = 0;

   __dpmi_int(0x25,&regs);

   if (regs.x.flags & 1)
      return regs.h.al;

   getdosmem(buffer,secsize*nsecs,sel);

   return -1;
}

/*
 * disk_read_ext  absolute disk read (INT 25h), > 32MB
 *
 */

extern int disk_read_ext(int disk, long sector, void *buffer, int nsecs,
                         int secsize)
{
static int seg = -1 ,sel;
static int bseg = -1,bsel;
__dpmi_regs regs;
struct _DCB dcb;

   if (seg == -1 && (seg = dosmalloc(sizeof(struct _DCB),&sel)) == -1)
      abort();

   if (bseg == -1 && (bseg = dosmalloc(secsize*nsecs,&bsel)) == -1)
      abort();

   regs.x.ax = disk;
   regs.x.cx = 0xffff;
   dcb.sector = sector;
   dcb.number = nsecs;
   dcb.buffer = _MK_FP(bseg);
   setdosmem((void *)&dcb,sizeof(struct _DCB),sel);
   regs.x.ds = seg;
   regs.x.bx = 0;

   __dpmi_int(0x25,&regs);

   if (regs.x.flags & 1)
      return regs.h.al;

   getdosmem(buffer,secsize*nsecs,bsel);

   return -1;
}
