/***
*error.c - errno extension
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Error messages.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions:

   1.4   07-Mar-1997    comments and MSGLEN for set_err_arg()
   1.3   17-Nov-1995    added another ' ' (after error.arg)
   1.2   20-Dec-1994    added the "set" functions
   1.1   11-Sep-1994    removed the DISKED ifdefs

   Release Notes:

   The main idea behind this module is that I didn't what to just
   strew printf's throughout the Program, but to place the error
   information in a common are for displaying when appropriate,
   like during idle.

   Errors HAVE to be instructional! Giving the User uninformative
   messages, such as just a number or aborting, is stupid.

   Programming Notes:

*/

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <assert.h>

#include "error.h"
#include "console.h"       /* for print() & output() */


/* NO globals referenced here */

/* globals defined here */

struct error_t error;

const char *err_msg[NUM_ERR_MSG] = {   /* see enum ERROR_MSG in ERROR.H */
   "",
   "Requires DOS 3+",
   "Not Enough Memory",
   "FAT Phase Error",
   "Bad Cluster No.",
   "Bad Start Cluster No.",
   "More files than FAT",
   "Alloc size of zero",
   "Free NULL pointer",
   "Alloc failure",
   "Corrupt heap",
};

extern void printerror(int ext)
{
   if (error.num == -1)       /* no error */
   {
      print("no error error");
      return;
   }

   if (ext && error.mod)      /* if extened error info and module named */
   {
      print(error.mod);

      /* if function name and not same as module */

      if (error.func && strcmp(error.mod,error.func))
      {
         output(':');
         print(error.func);
      }
      output(' ');
      error.mod = NULL;
   }
   if (error.msg)
   {
      print(error.msg);
      output(' ');
      error.msg = NULL;
   }
   if (error.arg)
   {
      print(error.arg);
      output(' ');
      error.arg = NULL;
   }
   if (error.info)
   {
      print("(%s)",error.info);
      error.info = NULL;
   }
   error.num = -1;
}


/* error setting functions, sets error number, messages etc. */


/***
*set_err_num - Just to eliminate the global reference.
*              It can easily be turned into a macro to
*              remove the funtion call overhead. Speed is
*              not an issue, but size maybe if error.num
*              is set many times. error.num is referenced
*              in ~5 modules, set_err_num() in 1.
****/

extern void set_err_num(int e)
{
   error.num = e;
}

extern void
set_error(const char *msg, const char *mod, int err, const char *func)
{
   error.msg = (msg) ? msg : err_msg[err];
   error.mod = mod;
   error.num = err;
   error.func = func;
}

/***
*set_err_arg - set any error argument
*
****/

#define MSGLEN 41

extern void set_err_arg(const char *fmt, ...)
{
va_list arglist;
static char buf[MSGLEN];

   /*
      The caller must make sure that the vsprint() converted string
      is NOT longer than buf[].

      To accomodate an assertion, a large temporary buffer must be
      used; which I don't do.

      Of course, the size of buf can just be increased at the
      expense of the available heap.

      Note: Watcom (at least v11.0) does not check for fmt==NULL.
   */

   va_start(arglist,fmt);
#if defined(_MSC_VER) && (_MSC_VER > 600) /* others dont have the n ver. */
   _vsnprintf(buf,MSGLEN-1,fmt,arglist);  /*  array overrun protection */
#else
   vsprintf(buf,fmt,arglist);
#endif
   va_end(arglist);
   error.arg = buf;
}

extern void set_err_info(const char *fmt, ...)
{
va_list arglist;
static char buf[MSGLEN];

   va_start(arglist,fmt);
#if defined(_MSC_VER) && (_MSC_VER > 600)
   _vsnprintf(buf,MSGLEN-1,fmt,arglist);
#else
   vsprintf(buf,fmt,arglist);
#endif
   va_end(arglist);
   error.info = buf;
}
