/***
*direct.c - file I/O on directories
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Directory I/O.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions:

   1.4   02-Jul-1998    get_volume has drive argument
   1.3   28-Nov-1997    bug fix in get_volume(); added data types and
                        DOS size macros (DOSIO.H)
   1.2   25-Nov-1995    removed global reference
   1.1   04-Sep-1994    filesize()
   1.0   14-Jan-1994

   Release Notes:

   A bit sloppy looking, but it works.

   Programming Notes:

   Heavily dependent on DOS.

*/

#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include <dos.h>

#include "general.h"
#include "diskio.h"           /* dir_sector and clustertosector() */
#include "direct.h"           /* dDIR, xDIR, FCB, xFCB */
#include "dirent.h"
#include "dosio.h"

#ifndef __LARGE__
#error requires large data model
#endif

/* NO globals referenced here */


/***
*cwdstart() - get starting sector number of current directory
*
****/

extern UINT32 cwdstart(void)
{
int i;
char cwd[_MAX_DIR],tbuf[_MAX_DIR];

   if (_getcwd(cwd,_MAX_DIR))    /* get current directory */
   {
      if (strlen(cwd) > ROOTDIRLEN)  /* i.e. not "C:\" */
      {
         char *p,*t;             /* temps */
         _chdir("..");           /* set to parrent directory */
         strcpy(tbuf,cwd);       /* make modifiable copy */

         /* get last token (this directory name) */

         t = p = strtok(tbuf,"\\");
         while (p && (p = strtok(NULL,"\\")) != NULL)
            t = p;

         i = file_start(t);      /* get starting cluster of the dir */
         _chdir(cwd);            /* set back to right directory */

         return clustertosector((UINT16)i); /* convert to sector */
      }
   }
   return 0;
}

/***
*filestart() - get starting sector number of file
*
****/

extern int file_start(char *file)
{
DOSDIR dir;

   if (direntry(file,&dir))
      return dir.start;
   else
      return 0;
}

/***
*filesize() - get size of file, returns -1 not found
*
****/

extern long file_size(char *file)
{
DOSDIR dir;

   if (direntry(file,&dir))
      return (long)dir.size;
   else
      return -1L;
}

/***
*direntry() - get directory entry of file
*             returns 1 ok, 0 not found  
*
*  Note: There are _far pointers here (a requirement for the
*        DOS DTA pointer).  The explicit _far references are to
*        enable this module to be used in SMALL memory models
*        for non-DISKED use..
****/

extern int direntry(char *name, DOSDIR *dir)
{
int i;
DOSEXTFCB xfcb;                    /* extended FCB */
DOSEXTDIR *xdir;                   /* temp extended DIR */

   memset(&xfcb.name[0],' ',FILELEN);  /* pad with spaces */
   xfcb.ff = 0xff;                     /* extended FCB flag */
   xfcb.a = 0x3f;                      /* ATTRIB */
   xfcb.drive = 0;                     /* current drive */

   /* put in name */

   for (i = 0; i < FILENAM && *name != '.' && *name != '\0'; i++)
      xfcb.name[i] = *name++;
   if (*name == '.')
      for (name++, i = 0; i < FILETYP && *name != '\0'; i++)
         xfcb.ext[i] = *name++;

   /* force DOSEXTDIR pointer to DTA */

   xdir = (DOSEXTDIR *)_dos_getdta();

   /* make the call */

   if (_dos_xfcb_find(&xfcb) == 0)
   {
      memcpy((void *)dir,&xdir->name,sizeof(DOSDIR));
      return 1;
   }
   return 0;
}

/***
*get_volume() - get volume label
*
****/

extern void get_volume(int drv, char *v)
{
int i,cdisk;
struct _find_t fi;
char cwd[_MAX_DIR];

   _dos_getdrive(&cdisk);              /* get current drive */
   _dos_setdrive(drv,&i);

   if (_getcwd(cwd,_MAX_DIR))          /* get current directory */
   {
      _chdir("\\");                    /* set root directory */
      if (_dos_findfirst("*.*",_A_VOLID,&fi) == 0)
      {
         for (i = 0; i < FILELEN+2; i++)        /* copy all but the '.' */
         {
            if (fi.name[i] != '.' && i <= FILELEN)
               *v++ = fi.name[i];
            if (fi.name[i] == '\0')             /* stop, a NUL! */
               break;
         }
      }
      _chdir(cwd);
   }
   _dos_setdrive(cdisk,&i);
}

/***
*_dos_xfcb_find() - fills DOS DTA with Extended DIR, INT 21/11
*                   returns 0 ok, 0xff for not found
*
*  ver   2.0 13-Jan-1994   save DS
****/

#ifdef _QC

extern int _dos_xfcb_find(DOSEXTFCB *xfcb)
{
int r;
   _asm  mov   dx, WORD PTR [xfcb]
   _asm  push  ds
   _asm  mov   ds, WORD PTR [xfcb+2]
   _asm  mov   ah,0x11
   _asm  int   0x21
   _asm  pop   ds
   _asm  sub   ah,ah
   _asm  mov   r,ax
   return r;
}

#else    /* _QC */

#ifdef _MSC_VER
#pragma optimize("gle",off)
#pragma warning(disable:4035)
#endif

#ifdef __BORLANDC__
#pragma warn -rvl
#endif

extern int _dos_xfcb_find(DOSEXTFCB *xfcb)
{
#ifdef _ASM_DEFINED
   _asm  mov   dx,WORD PTR [xfcb]
   _asm  push  ds
   _asm  mov   ds,WORD PTR [xfcb+2]
   _asm  mov   ah,0x11
   _asm  int   0x21
   _asm  pop   ds
   _asm  sub   ah,ah
#else
union _REGS r;
struct _SREGS s;

   _segread(&s);
   r.x.dx = _FP_OFF(xfcb);
   s.ds = _FP_SEG(xfcb);
   r.h.ah = 0x11;
   return _intdosx(&r,&r,&s) & 0xff;
#endif
}

#endif   /* !_QC */

/***
*_dos_getdta() - returns address of DOS DTA (far)
*
****/

#ifdef _QC

extern void *_dos_getdta(void)
{
char *dta;

   _asm  mov   ah,0x2f
   _asm  int   0x21
   _asm  mov   WORD PTR [dta+2],es
   _asm  mov   WORD PTR [dta],bx
   return dta;
}

#else    /* not _QC (QuickC) */

extern void *_dos_getdta(void)
{
#ifdef _ASM_DEFINED
   _asm  mov   ah,0x2f
   _asm  int   0x21
   _asm  mov   ax,bx
   _asm  mov   dx,es
#else
union _REGS r;
struct _SREGS s;
char *dta;

   r.h.ah = 0x2f;
   _intdosx(&r,&r,&s);
   dta = _MK_FP(s.es,r.x.bx);
   return dta;
#endif
}

#endif      /* !_QC */
