/***
*arrays.h - misc. array handling
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   General purpose array handling.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions

   0.1   15-Dec-1994
*/


extern int arraymax(int __huge *array,size_t max,int n);
extern int arraymin(int __huge *array,size_t max,int n);
extern int arraycnt(int __huge *array,size_t max,int n);
extern size_t arrayfirst(int __huge *array,size_t max,int n);
extern size_t arraylast(int __huge *array,size_t max,int n);
extern size_t arrayfind(int __huge *array, size_t max, int n);
extern size_t arraytrav(int __huge *array,size_t max,size_t n,int dir);
extern size_t arraysub(int __huge *array, int *sub, size_t max, int n);
extern int arraymap(int __huge *array,size_t max,int n,int base);

extern void plist(long *array, size_t max, int base);
