/*
 *  win32\get.c         get disk parameters
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "win32.h"
#include "../d_disk.h"
#include "../d_lib.h"       /* disk_read() */

static int boot_parameters(int disk, int secsize, struct DEVICEPARAMS *dp);

/*
 * disk_get_parameters      get disk (DOS) parameters
 *
 */

extern int disk_get_parameters(int disk, struct d_stat *ds)
{
struct DEVICEPARAMS dp;
struct FREESPACE fs;
struct MID mid;

    ++disk;

    ds->d_media = 0;

    /* check for remote */
    /* check for removable */

    if (disk_free_space(disk,&fs) != -1) {
        return 0;
    }

    if (win32_ioctl(DOS_MINOR_GET_DEVICE,disk,&dp) != -1) {
        ds->d_media = 1;
        if (boot_parameters(disk-1,fs.sec_size,&dp) != -1) {
            return(0);
        }
    }

    if (win32_ioctl(DOS_MINOR_GET_MEDIA,disk,&mid) != -1) {

        /* read volume label and determine FAT12 or 16 based on number of
            clusters */

        if (ds->d_media == 0) {
            return 0;
        }
    }

    ds->d_ptracks = dp.cylinders;
    ds->d_pheads = dp.num_heads;
    ds->d_psecs = dp.secs_track;
    ds->d_bsize = dp.sec_size;
    ds->d_bnum = (dp.num_sectors) ? dp.num_sectors : dp.total_sectors;
    ds->d_bres = dp.reserved_secs;
    ds->d_bhid = dp.hidden_sectors;
    ds->d_size = ds->d_bnum * dp.sec_size;
    ds->d_ftables = dp.num_fats;
    ds->d_ftsize = dp.secs_fat;
    ds->d_ndir = dp.dir_entries;
    ds->d_usize = dp.secs_cluster;

    ds->d_usize = fs.secs_cluster;
    ds->d_ufree = fs.avail_clusters;
    ds->d_units = fs.num_clusters;

    memset(ds->d_fsid,' ',D_FSID_LEN);
    memset(ds->d_dev,' ',D_DEV_LEN);
    memcpy(ds->d_fsid,mid.filesys,8);   /* file system id */
    memcpy(ds->d_dev,mid.vollabel,11);  /* disk ID */
    ds->d_fsid[D_FSID_LEN-1] = '\0';
    ds->d_dev[D_DEV_LEN-1] = '\0';
    ds->d_ino = mid.serialnum;      /* disk serial number */

    return -1;
}

/*
 * boot_parameters      get disk (BOOT) parameters
 *
 */

static int boot_parameters(int disk, int secsize, struct DEVICEPARAMS *dp)
{
int i;
char *buf;
struct BOOT boot;

    if ((buf = malloc(secsize)) == NULL)
        return 0;

    i = disk_read(disk,0,buf,1,secsize);

    if (i == -1) {
        memcpy(&boot,buf,sizeof(struct BOOT));
        memcpy(&dp->sec_size,&boot.sec_size,sizeof(struct BPB));
    }

    free(buf);
    return i;
}
