/*
 *  win32\device.c      WIN32 device driver I/O
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include "win32.h"

int win32_device_io(DWORD control, DIOC_REGISTERS *regs)
{
BOOL i;
DWORD cb;
static HANDLE VxDevice = 0;

    if (!VxDevice) {
        VxDevice = CreateFile("\\\\.\\VWIN32", 0, 0, NULL, 0, 0, NULL);
        if (VxDevice == INVALID_HANDLE_VALUE) {
            VxDevice = 0;
            return 0;
        }
    }

    i = DeviceIoControl(VxDevice, control,
                        regs, sizeof(DIOC_REGISTERS),
                        regs, sizeof(DIOC_REGISTERS), &cb, 0);
    if (i == FALSE)
        return 0;

    return -1;
}
