/*
 *	dos\dosio.h 	DOS data definitions
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#ifndef DOSIO_H
#define DOSIO_H

#ifndef TYPES_H
#include "../types.h"
#endif

/* DOS Disk structure definitions */

#pragma pack(1)

/* Format of a Boot Sector */
/* This is verbatim MS-DOS Technical Referance for DOS 3.3 */

struct BOOT {
   BYTE     jump[3];           /* 3 byte Near Jump to boot code */
   BYTE     name[8];           /* 8 byte OEM name and version */
   UINT16   sec_size; /*BPB*/  /* WORD Bytes per sector */
   BYTE     secs_cluster;      /* BYTE Sectors per allocation unit */
   UINT16   reserved_secs;     /* WORD Reserved sectors (note 1) */
   BYTE     num_fats;          /* BYTE Number of FATs */
   UINT16   dir_entries;       /* WORD Number of root dir entries */
   UINT16   num_sectors;       /* WORD Number of sectors in logical
                                       image or 0 (note 2) */
   BYTE     media_desc;        /* BYTE Media descriptor */
   UINT16   secs_fat; /*BPB*/  /* WORD Number of FAT sectors */
   UINT16   secs_track;        /* WORD Sectors per track */
   UINT16   num_heads;         /* WORD Number of heads */
/* UINT16   hidden_sectors; */ /* WORD Number of hidden sectors (note 3) */
   /* end DOS 2.0 */
/* UINT16   large_sectors; */  /* WORD High order number of hidden sectors */
/* UINT32   total_sectors; */  /* DWORD Number of logical sectors */
   /* end DOS 3.0 */
   UINT32   hidden_sectors;    /* DW Number of hidden sectors (note 3) */
   UINT32   huge_sectors;/*BPB*/ /* DW Number of sectors if num_sectors == 0 */
   BYTE     drive_number;
   BYTE     reserved1;
   BYTE     signature;
   UINT32   volume_id;
   BYTE     volume_label[11];
   BYTE     file_system[8];
   /* end DOS 6.0 */

   /*
      NOTE how sometime between 3.0 and 6.0 the WORD hidden_sectors
      entry merged with WORD large_sectors and became a DWORD. And
      also that the BPB grew.
   */

};

/* BIOS Parameter Block definition */

struct BPB {
   UINT16   sec_size;
   BYTE     secs_cluster;
   UINT16   reserved_secs;
   BYTE     num_fats;
   UINT16   dir_entries;
   UINT16   num_sectors;
   BYTE     media_desc;
   UINT16   secs_fat;
   UINT16   secs_track;
   UINT16   num_heads;
   UINT32   hidden_sectors;
   UINT32   total_sectors;
};

/* Disk Parameter Block */
/* IOCTL Int 21 440D/60 - Get Device Parameters */

struct DPB {
   BYTE     special;
   BYTE     dev_type;
   UINT16   dev_attrib;
   UINT16   cylinders;
   BYTE     media;
   struct BPB      bpb;
};

/* Disk Parameter Block */
/* IOCTL Int 21 440D/60 - Get Device Parameters */
/* same as DPB but without the embedded BPB structure */

struct DEVICEPARAMS {
   BYTE     special;
   BYTE     dev_type;
   UINT16   dev_attrib;
   UINT16   cylinders;
   BYTE     media;
   UINT16	sec_size;
   BYTE     secs_cluster;
   UINT16   reserved_secs;
   BYTE     num_fats;
   UINT16   dir_entries;
   UINT16   num_sectors;
   BYTE     media_desc;
   UINT16   secs_fat;
   UINT16   secs_track;
   UINT16   num_heads;
   UINT32   hidden_sectors;
   UINT32   total_sectors;
};


/* Disk Control Block */
/* For drives larger than 32M */

struct DCB {
     UINT32 sector;
     UINT16 number;
	 BYTE	*buffer;
};

/* Media ID structure */
/* INT 21 Function 440D/66 - Get Media ID */

struct MID {
   UINT16   infolevel;
   UINT32   serialnum;
   char 	vollabel[11];
   char 	filesys[8];
};

/* Read/Write Block */
/* INT 21 Function 440D/41/61 - Write/Read Track on Logical Drive */

struct RWBLOCK {
   BYTE     special;
   UINT16   head;
   UINT16   track;
   UINT16   sector;
   UINT16   nsecs;
   BYTE 	*buffer;
};

/* Free Space */
/* INT 21 Function 36 - Get Disk Free Space */

struct FREESPACE {
   UINT16   secs_cluster;
   UINT16   avail_clusters;
   UINT16   sec_size;
   UINT16   num_clusters;
};

#pragma pack()

/* typedefs for constants and function numbers */

typedef enum {
   DOS_OK,              /* Error 0  (not an error)  */
   DOS_EINVFNC,         /* Invalid function number  */
   DOS_ENOFILE,         /* File not found           */
   DOS_ENOPATH,         /* Path not found           */
   DOS_ECONTR,          /* Memory blocks destroyed  */
   DOS_EMFILE,          /* Too many open files      */
   DOS_EACCES,          /* Permission denied        */
   DOS_EBADF,           /* Bad file number          */
   DOS_ENOMEM,          /* Not enough core          */
   DOS_EINVMEM,         /* Invalid memory block address */
   DOS_EINVENV,         /* Invalid environment      */
   DOS_EINVFMT,         /* Invalid format           */
   DOS_EINVACC,         /* Invalid access code      */
   DOS_EINVDAT,         /* Invalid data             */
   DOS_EFAULT,          /* Unknown error            */
   DOS_EINVDRV,         /* Invalid drive specified  */
   DOS_ECURDIR,         /* Attempt to remove CurDir */
   DOS_ENOTSAM,         /* Not same device          */
   DOS_ENMFILE,         /* No more files            */
   DOS_EWRITE,          /* Write protect            */
   DOS_EBADU,           /* Bad unit                 */
   DOS_ENREADY          /* Drive not ready          */
} DOS_ERROR;

typedef enum {
   DOS_READ = 0x25,                 /* absolute disk read */
   DOS_WRITE = 0x26,                /* absolute disk write */
   /* normal functions (as AX) */
   DOS_GET_VER = 0x3000,
   DOS_GET_VER_5 = 0x3306,
   DOS_GET_FREE_SPACE = 0x3600
} DOS_FUNCTION;

typedef enum {
   DOS_DEV_REMOVE = 0x08,
   DOS_DRV_REMOTE = 0x09,
   DOS_DEV_IOCTL = 0x0D
} DOS_SUBFUNCTION;

typedef enum {
   DOS_MINOR_NONE = 0,
   DOS_MINOR_WRITE_TRACK = 0x41,
   DOS_MINOR_GET_DEVICE = 0x60,
   DOS_MINOR_READ_TRACK = 0x61,
   DOS_MINOR_GET_MEDIA = 0x66
} DOS_MINOR_CODE;


int disk_free_space(int disk, struct FREESPACE *fs);
int disk_getparams(int disk, struct DEVICEPARAMS *dp);
int disk_getmedia(int disk, struct MID *mid);
int dos_ioctl(DOS_SUBFUNCTION subfunc, DOS_MINOR_CODE code, int device, void *data);

#endif
