/*
 *  d_error.c   DOS/BIOS to d_errno translations
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include <assert.h>
#include <errno.h>

#include "d_disk.h"
#include "d_error.h"
#include "d_lib.h"

static D_ERROR emapint25[] = {
/* 1-7 */   D_EUNIT, D_ENREADY, D_EINVCMD, D_ECRC, D_EREQ, D_ESEEK, D_ETYPE,
/* 8-13 */  D_ESECNO, D_EUNKNOWN, D_EWRITE, D_EREAD, D_EGENF, D_EUNKNOWN,
/* 14-15 */ D_EUNKNOWN, D_EINVCH
};

static D_ERROR emapint13[] = {
/* 1-6 */   D_EINVCMD, D_EADDR, D_EWPROT, D_ESECNO, D_ERESET, D_EINVCH,
/* 7-13 */  D_EINVCMD, D_EDMA, D_EDMA, D_EBAD, D_EBAD, D_EINVMED, D_EINVMED,
/* 14-20 */ D_EADDR, D_EDMA, D_ECRC, D_ECRC, D_EUNKNOWN, D_EUNKNOWN, D_ECONTRL
};

int dskerr_to_errno(int err, int iotype)
{
    if (err == 0) {
        return D_EDOS;
    }

    if (iotype == INT25 || iotype == INT25X) {
        if (err >= 0 && err < sizeof(emapint25)/sizeof(emapint25[0]))
            return emapint25[err];
    }
    else if (iotype == INT13) {
        if (err >= 0 && err < sizeof(emapint13)/sizeof(emapint13[0]))
            return emapint13[err];
        switch (err) {
            case 0x31: return D_ENREADY;
            case 0x32: return D_EINVMED;
            case 0x40: return D_ESEEKF;
            case 0x80: return D_ENREADY;
            case 0xAA: return D_ENREADY;
            case 0xCC: return D_EWRITE;
            case 0xE0: return D_EINVCMD;
        }
    }
    else if (iotype == IOCTL) {
        return errno;
    }
    else {
        assert(0);
    }
    return D_EUNKNOWN;
}
