/*
 *  disk_get_parameters      create a struct d_stat
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 *  29-Dec-1998 prozac  #ifdef DISKLIB; removed the `++disk'
 *
 */

#include <string.h>

#ifdef DISKLIB
#include "..\..\disklib\dosio.h"
#endif
#include "..\d_disk.h"

extern int disk_get_parameters(int disk, struct d_stat *ds)
{
struct MID mid;
struct FREESPACE fs;
struct DEVICEPARAMS dp;

    ds->d_media = 0;

    /* TODO: check for remote */
    /* TODO: check for removable */

    if (disk_free_space(disk,&fs) != DISK_OK)
        return 0;

    if (disk_getparams(disk,&dp) != DISK_OK)
        return 0;

    if (disk_getmedia(disk,&mid) != DISK_OK) {

        /*
            TODO: read volume label and determine FAT12 or 16 based on
            number of clusters
        */

        if (ds->d_media == 0)
            return 0;
    }

    ds->d_ptracks = dp.cylinders;
    ds->d_pheads = dp.num_heads;
    ds->d_psecs = dp.secs_track;
    ds->d_bsize = dp.sec_size;
    ds->d_bnum = (dp.num_sectors) ? dp.num_sectors : dp.total_sectors;
    ds->d_bres = dp.reserved_secs;
    ds->d_bhid = dp.hidden_sectors;
    ds->d_size = ds->d_bnum * dp.sec_size;
    ds->d_ftables = dp.num_fats;
    ds->d_ftsize = dp.secs_fat;
    ds->d_ndir = dp.dir_entries;
    ds->d_usize = dp.secs_cluster;

    /* is true for LFNs?!?!? */
    ds->d_dsecs = ds->d_ndir / (ds->d_bsize / 32);

    ds->d_dsec = (ds->d_ftsize * ds->d_ftables) + ds->d_dsecs + ds->d_bres;

    ds->d_usize = fs.secs_cluster;
    ds->d_ufree = fs.avail_clusters;
    ds->d_units = fs.num_clusters;

    memset(ds->d_fsid,' ',D_FSID_LEN);
    memset(ds->d_dev,' ',D_DEV_LEN);
    memcpy(ds->d_fsid,mid.filesys,8);   /* file system id */
    memcpy(ds->d_dev,mid.vollabel,11);  /* disk ID */
    ds->d_fsid[D_FSID_LEN-1] = '\0';
    ds->d_dev[D_DEV_LEN-1] = '\0';
    ds->d_ino = mid.serialnum;          /* disk serial number */

    return -1;
}
