/***
*mylib.h - definitions/declarations for library functions.
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Fast printing routines, user inputs, and miscelaneous
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

#ifndef GENERAL_H
#include "general.h"    /* machine dependent and compiler */
#endif                  /*  specific stuff */

/* user input type definitions (ctype stuff) */

#ifndef __WATCOMC__

#ifndef _PUNCT          /* use MSC equates */
#define _UPPER    0x1   /* upper case letter */
#define _LOWER    0x2   /* lower case letter */
#define _DIGIT    0x4   /* digit[0-9] */
#define _SPACE    0x8   /* tab, carriage return, newline, */
                        /* vertical tab or form feed */
#define _PUNCT    0x10  /* punctuation character */
#define _CONTROL  0x20  /* control character */
#define _BLANK    0x40  /* space char */
#define _HEX      0x80  /* hexadecimal digit */

#endif

#else

#define _HEX      _XDIGT
#define _CONTROL  _CNTRL
#define _BLANK    _SPACE
#endif

#define _SIGN     0x100                      /* - + */
#define _FILE     0x200

#define _ALPHA (_UPPER|_LOWER)
#define _ALNUM (_UPPER|_LOWER|_DIGIT)
#define _TEXT  (_ALNUM|_PUNCT|_BLANK)
#define _FILEN (_UPPER|_LOWER|_DIGIT|_FILE)

/* number output */

extern unsigned char hexbyte(int a,int b);

extern int getlen(unsigned int n,int base);
extern int getlength(unsigned long i,int base);
extern int getnum(unsigned int max,unsigned int *num,int base);
extern int getnumber(unsigned long max,void *num,int base);

/* string input */

enum GETVER_MODE { NONE, MOV_YN, MOV_ARG, CLR=4, CLR_YN=5, CLR_ARG };
extern int getstr(char *s,unsigned int len,int mask);
extern int getver(char *s, enum GETVER_MODE mode);
extern int getfver(char *s, enum GETVER_MODE mode);
extern int convert(char *a);

/* misc. */

extern void directory(void );
extern void pname(char *s);
extern int search(unsigned char *s,unsigned char *t,size_t size,size_t len);
extern int isearch(unsigned char *s,unsigned char *t,size_t size,size_t len);
extern int change(unsigned char *buffer,unsigned int bufend,int base);
extern void dispval(int x,int len,int base,int c);
extern int dump(unsigned char *buffer,unsigned int bfptr,unsigned int bufend,unsigned int len,int base);
extern void dumpf(register unsigned char *buffer,int size, int base);
extern void pauseinp(void);
#define pause pauseinp
extern void viewfile(char *filename, int display);


/* macros to make displaying of numbers easier to implement */

#if !defined DISKED && !defined Radix  /* Radix is a global variable */
#define Radix   10                     /* DISKED uses a structure entry */
#endif                                 /* This is here for non-DISKED usage */
                                       /* define Radix for you own use */

#define getbyte(n)   getnum(255,n,Radix)
#define getint(n)    getnum(32767,n,Radix)
#define getuint(n)   getnum(65535,n,Radix)
#define getlong(n)   getnumber(2147483647L,n,Radix)
#define getnumb(m,n) getnum(m,n,Radix)
#define getlnumb(m,n) getnumber((unsigned long)(m),n,Radix)
#define len(n)       getlen(n,Radix)
#define length(n)    getlength((unsigned long)(n),Radix)

#define putbyte(n)   print("%r",n)
#define puthex(n)    print("%04x",n)
#define putint(n)    print("%r",n)
#define putlong(n)   print("%lr",n)
#define zputbyte(n)  print("%03r",n)
