/*

 *  win32\free.c      get disk free space
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include <dos.h>

#include "win32.h"
#include "dosio.h"

/*
 * disk_free_space      get disk free space, unit and sector sizes
 *
 */

int disk_free_space(int disk, struct FREESPACE *fs)
{
struct _diskfree_t df;

    if (_getdiskfree(disk,&df) != 0)
        return 0;

    fs->secs_cluster =   (unsigned short)df.sectors_per_cluster;
    fs->avail_clusters = (unsigned short)df.avail_clusters;
    fs->sec_size =       (unsigned short)df.bytes_per_sector;
    fs->num_clusters =   (unsigned short)df.total_clusters;

    return -1;
}

#if 0
int disk_free_space(int disk, struct FREESPACE *fs)
{
char root[4];
DWORD secsclus,secsize,availclus,numclus;

    root[0] = (char)(disk+'@');
    root[1] = ':';
    root[2] = '\\';
    root[3] = '\0';

    if (GetDiskFreeSpace(root,&secsclus,&secsize,&availclus,&numclus) == FALSE) {
        DBG_err_dump("free");
        return 0;
    }
    fs->secs_cluster = (unsigned short)secsclus;
    fs->avail_clusters = (unsigned short)availclus;
    fs->sec_size = (unsigned short)secsize;
    fs->num_clusters = (unsigned short)numclus;

    return -1;
}
#endif
