/*
 *  disklib.h       OS dependent disk functions
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

int disk_read(int drv, long sec, void *buf, unsigned int nsecs, int secsiz);
int disk_read_ext(int drv, long sec, void *buf, unsigned int nsecs, int secsiz);
int disk_write(int drv, long sec, void *buf, unsigned int nsecs, int secsiz);
int disk_write_ext(int drv, long sec, void *buf, unsigned int nsecs, int secsiz);
int disk_read_p(int disk, unsigned trk, unsigned sec, unsigned head,
                void *buf, int nsecs, int secsiz);
int disk_write_p(int disk, unsigned trk, unsigned sec, unsigned head,
                 void *buf, int nsecs, int secsiz);

int disk_get_parameters(int disk, struct d_stat *buf);
int disk_get_physical(int disk, int *t, int *s, int *h);

extern long clustersector(long sector, struct d_stat *ds);
extern long clustertosector(long cluster, struct d_stat *ds);
extern long sectortocluster(long sector, struct d_stat *ds);
