/*
   ovlimpl.c - overlay implementation for command line interface.
   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@vub.ac.be
*/

#include <stdlib.h>

#include "..\..\overlays\expected.h"
#include "..\dosio\dosio.h"
#include "..\main\chkargs.h"

void UpdateInterfaceState(void){}

void SmallMessage(char* buffer)
{
   if (GiveFullOutput())
   {
      DOSout(buffer);
      DOSout("\r\n");
   }
}

void LargeMessage(char* buffer)
{
   DOSout(buffer);
   DOSout("\r\n");
}

void DrawDriveMap(unsigned maxcluster)
{
   char buffer[5];                    /* max. 16 bit integer length. */
   
   if (GiveFullOutput())
   {
      itoa(maxcluster, buffer, 10);

      DOSout("The disk has ");
      DOSout(buffer);
      DOSout(" clusters.\r\n");
   }
}

void DrawOnDriveMap(int cluster, int symbol)
{
#if 0   
   char buffer[5];                    /* max. 16 bit integer length. */

   itoa(cluster, buffer, 10);
     
   if (GiveFullOutput())
      switch (symbol)
      {
         case WRITESYMBOL:
              DOSout("Write on cluster ");
              DOSout(buffer);
              DOSout("\r\n");
              break;

         case READSYMBOL:
              DOSout("Read from cluster ");
              DOSout(buffer);
              DOSout("\r\n");
              break;
       
         case USEDSYMBOL:
              DOSout("Cluster ");
              DOSout(buffer);
              DOSout(" is used.\r\n");
              break;   
            
         case UNUSEDSYMBOL:
              DOSout("Cluster ");
              DOSout(buffer);
              DOSout(" is not used.\r\n");
              break;

         case BADSYMBOL:
              DOSout("Bad cluster at ");
              DOSout(buffer);
              DOSout("\r\n");
              break;
        
         case UNMOVABLESYMBOL:
              DOSout("Cluster ");
              DOSout(buffer);
              DOSout(" is not movable.\r\n");
              break;

         case OPTIMIZEDSYMBOL:
              DOSout("Cluster ");
              DOSout(buffer);
              DOSout(" is optimized.\r\n");
              break;
      }
#endif
}
