
;	Main data table for the assembler.

asmtab	db	16,249,255,248,65,225,255,248,65,146,255,19,113,255,6,45
	db	245,178,97,245,180,216,245,4,244,5,147,255,1,61,245,177
	db	195,245,180,58,245,0,4,0,163,255,11,29,245,178,255,245
	db	181,118,245,9,228,10,131,255,240,30,147,255,239,30,69,255
	db	241,137,12,255,241,137,91,255,249,242,140,193,255,241,129,87
	db	241,183,247,255,245,241,136,191,245,241,184,228,255,245,241,134
	db	71,245,241,184,149,255,245,241,131,207,245,241,184,70,255,71
	db	164,185,239,186,35,47,147,255,249,46,232,255,76,136,255,77
	db	196,255,77,38,255,240,80,218,255,75,155,255,244,100,241,255
	db	244,99,181,255,244,99,102,255,244,100,162,255,244,99,102,255
	db	244,100,4,255,244,103,105,255,244,102,203,255,244,102,124,255
	db	244,103,26,255,244,100,162,255,244,99,102,255,244,99,181,255
	db	244,100,241,255,244,99,181,255,244,100,83,255,244,103,26,255
	db	244,102,124,255,244,102,203,255,244,103,105,255,244,99,23,255
	db	244,102,45,255,244,101,143,255,244,100,83,255,244,98,200,255
	db	244,101,222,255,244,101,222,255,244,102,45,255,244,101,64,255
	db	244,100,4,255,18,133,179,236,182,99,17,76,17,235,255,51
	db	58,255,249,51,137,255,245,242,133,84,255,243,187,254,255,243
	db	128,254,255,249,47,55,255,12,9,255,14,129,255,254,255,252
	db	255,22,73,245,190,119,245,194,122,255,253,255,239,61,202,255
	db	66,247,240,255,66,247,225,255,158,19,159,80,66,189,192,67
	db	250,192,255,68,153,192,68,130,193,255,158,182,159,243,255,170
	db	35,255,175,19,255,66,247,224,255,250,67,149,226,255,244,67
	db	170,208,255,244,67,170,192,255,244,67,91,192,255,244,67,91
	db	208,255,244,67,91,200,255,244,67,91,208,255,244,67,91,192
	db	255,244,67,170,192,255,244,67,170,208,255,244,67,170,200,255
	db	244,67,170,216,255,244,67,170,200,255,244,67,91,216,255,244
	db	67,91,200,255,163,3,164,64,66,196,208,66,168,209,255,244
	db	67,177,240,244,67,149,241,255,244,68,237,240,244,68,209,241
	db	255,165,123,166,184,66,196,216,66,168,217,255,68,130,217,255
	db	241,66,247,255,255,66,247,246,255,250,67,149,225,255,172,227
	db	174,32,66,189,240,67,250,248,255,68,153,248,68,130,249,255
	db	173,134,174,195,255,175,91,176,152,66,189,248,67,250,240,255
	db	68,153,240,68,130,241,255,175,254,177,59,255,250,67,149,224
	db	255,68,78,192,255,163,166,164,227,255,166,30,167,91,255,159
	db	5,160,66,172,144,255,66,247,247,255,250,67,149,227,255,163
	db	245,165,50,255,166,109,167,170,177,128,255,158,98,159,159,171
	db	95,67,18,192,255,66,247,232,255,66,247,233,255,66,247,234
	db	255,66,247,235,255,66,247,236,255,66,247,237,255,66,247,238
	db	255,250,170,192,255,168,76,255,160,139,161,200,66,189,200,67
	db	250,200,255,68,153,200,68,130,201,255,161,46,162,107,255,66
	db	247,208,255,66,247,243,255,66,247,248,255,241,66,247,245,255
	db	66,247,242,255,66,247,252,255,169,136,255,250,174,120,255,66
	db	247,253,255,250,240,67,149,228,255,241,66,247,254,255,241,66
	db	247,251,255,66,247,250,255,163,82,164,143,68,78,208,255,165
	db	202,167,7,176,79,68,78,216,255,250,175,176,255,250,173,60
	db	255,250,68,239,224,176,236,255,167,243,169,48,66,189,224,67
	db	250,232,255,68,153,232,68,130,233,255,168,150,169,211,255,170
	db	107,171,168,66,189,232,67,250,224,255,68,153,224,68,130,225
	db	255,171,14,172,75,255,66,247,228,255,241,68,79,224,241,68
	db	51,225,255,244,67,177,232,244,67,149,233,255,244,68,237,232
	db	244,68,209,233,255,241,68,79,232,241,68,51,233,255,241,67
	db	70,233,255,47,213,255,66,247,229,255,67,19,200,66,247,201
	db	255,66,247,244,255,66,247,241,255,66,247,249,255,75,76,255
	db	194,201,255,194,43,241,133,9,239,33,36,239,33,37,239,32
	db	136,239,32,137,255,70,127,72,248,255,19,209,245,190,40,245
	db	239,33,84,255,249,239,33,163,255,63,25,63,105,255,63,146
	db	255,242,81,120,255,242,197,78,255,249,63,225,255,36,224,241
	db	120,181,255,35,164,241,119,121,255,35,85,241,119,42,255,36
	db	145,241,120,102,255,35,85,241,119,42,255,249,70,52,255,35
	db	243,241,119,200,255,39,88,241,123,45,255,38,186,241,122,143
	db	255,38,107,241,122,64,255,39,9,241,122,222,255,36,145,241
	db	120,102,255,35,85,241,119,42,255,35,164,241,119,121,255,36
	db	224,241,120,181,255,35,164,241,119,121,255,36,66,241,120,23
	db	255,39,9,241,122,222,255,38,107,241,122,64,255,38,186,241
	db	122,143,255,39,88,241,123,45,255,35,6,241,118,219,255,38
	db	28,241,121,241,255,37,126,241,121,83,255,36,66,241,120,23
	db	255,34,183,241,118,140,255,37,205,241,121,162,255,37,205,241
	db	121,162,255,38,28,241,121,241,255,37,47,241,121,4,255,35
	db	243,241,119,200,255,72,172,71,243,186,141,186,193,72,67,255
	db	49,17,255,240,79,166,255,60,210,255,241,133,245,255,60,131
	db	255,241,134,147,255,241,134,226,255,43,138,255,239,62,7,255
	db	240,195,195,255,240,196,18,255,240,198,72,255,240,197,12,255
	db	246,240,53,20,255,249,53,99,255,249,69,230,69,229,255,249
	db	69,151,69,150,255,249,69,151,69,150,255,249,69,72,69,71
	db	255,249,69,72,69,71,255,240,79,245,255,240,198,151,255,49
	db	141,50,44,41,252,42,155,43,95,43,254,54,127,56,248,199
	db	250,241,89,39,241,89,198,241,89,120,241,90,23,241,90,103
	db	241,91,6,255,50,156,255,249,50,235,255,241,137,211,241,138
	db	35,255,241,135,91,241,135,171,255,193,220,255,245,193,141,255
	db	44,112,255,245,193,62,255,3,181,245,178,18,245,180,137,245
	db	2,124,3,27,255,251,255,71,45,73,166,255,239,33,242,255
	db	249,239,34,65,255,202,165,27,57,9,202,2,95,7,81,241
	db	128,233,241,131,98,255,249,239,29,239,255,249,48,115,255,24
	db	193,187,43,239,32,243,239,32,84,4,137,7,2,9,123,2
	db	16,241,128,154,241,131,19,255,249,239,29,160,255,249,48,36
	db	255,205,196,208,61,239,210,182,255,206,19,208,140,239,211,5
	db	255,205,38,207,159,239,210,24,255,205,117,207,238,239,210,103
	db	255,243,94,110,255,246,243,246,243,246,242,60,45,60,31,255
	db	249,62,165,62,151,255,243,131,118,255,48,194,255,206,98,208
	db	219,239,211,84,255,207,79,209,200,239,212,65,255,11,240,14
	db	105,16,226,19,91,31,22,31,102,255,247,38,247,46,247,54
	db	247,62,247,100,247,101,206,98,208,219,239,211,84,255,206,177
	db	209,42,239,211,163,255,8,165,245,178,176,245,181,39,245,7
	db	108,8,11,255,53,178,255,249,54,1,255,241,125,219,255,241
	db	124,159,255,241,124,80,255,241,125,140,255,241,124,80,255,241
	db	124,238,255,241,128,83,255,241,127,181,255,241,127,102,255,241
	db	128,4,255,241,125,140,255,241,124,80,255,241,124,159,255,241
	db	125,219,255,241,124,159,255,241,125,61,255,241,128,4,255,241
	db	127,102,255,241,127,181,255,241,128,83,255,241,124,1,255,241
	db	127,23,255,241,126,121,255,241,125,61,255,241,123,178,255,241
	db	126,200,255,241,126,200,255,241,127,23,255,241,126,42,255,241
	db	124,238,255,240,195,37,255,240,195,116,255,241,129,223,241,130
	db	47,255,241,132,87,241,132,167,255,240,197,169,255,240,196,109
	db	255,76,215,255,78,19,255,77,117,255,52,118,255,249,52,197
	db	255,240,197,249,255,13,149,245,179,78,245,181,197,245,12,92
	db	12,251,255,51,217,192,146,40,192,40,193,255,240,198,230,255
	db	240,199,53,255,47,213,255,242,81,199,255,243,93,208,255,245
	db	242,138,68,255,44,181,44,182,245,41,94,245,41,95,255,66
	db	89,255,66,89,255,16,13,245,179,157,245,182,20,245,14,212
	db	15,115,255

;	Data on groups (for the assembler).

agroups	dw	131,128,442,255,455,254,246,257,256,198,143,208,210,192

;	This is the list of assembler mnemonics.

mnlist	db	1,1,"AAA",0,1,4,"AAD",0,1,8,"AAM",0,1,12,"AAS",0
	db	1,15,"ADC",0,1,29,"ADD",0,1,43,"AND",0,1,57,"ARPL",0
	db	1,61,"BOUND",0,1,65,"BSF",0,1,69,"BSR",0
	db	1,73,"BSWAP",0,1,78,"BT",0,1,85,"BTC",0,1,94,"BTR",0
	db	1,103,"BTS",0,1,112,"CALL",0,1,122,"CBW",0,2,37,"CDQ",0
	db	1,125,"CLC",0,1,128,"CLD",0,1,131,"CLI",0,1,134,"CLTS",0
	db	1,138,"CMC",0,1,141,"CMOVA",0,1,145,"CMOVAE",0
	db	1,149,"CMOVB",0,1,153,"CMOVBE",0,1,157,"CMOVC",0
	db	1,161,"CMOVE",0,1,165,"CMOVG",0,1,169,"CMOVGE",0
	db	1,173,"CMOVL",0,1,177,"CMOVLE",0,1,181,"CMOVNA",0
	db	1,185,"CMOVNAE",0,1,189,"CMOVNB",0,1,193,"CMOVNBE",0
	db	1,197,"CMOVNC",0,1,201,"CMOVNE",0,1,205,"CMOVNG",0
	db	1,209,"CMOVNGE",0,1,213,"CMOVNL",0,1,217,"CMOVNLE",0
	db	1,221,"CMOVNO",0,1,225,"CMOVNP",0,1,229,"CMOVNS",0
	db	1,233,"CMOVNZ",0,1,237,"CMOVO",0,1,241,"CMOVP",0
	db	1,245,"CMOVPE",0,1,249,"CMOVPO",0,1,253,"CMOVS",0
	db	2,2,"CMOVZ",0,2,6,"CMP",0,2,17,"CMPSB",0
	db	2,20,"CMPSD",0,2,21,"CMPSW",0,2,24,"CMPXCHG",0
	db	2,29,"CMPXCHG8B",0,2,33,"CPUID",0,6,194,"CS",0
	db	2,38,"CWD",0,1,121,"CWDE",0,2,41,"DAA",0,2,44,"DAS",0
	db	2,47,"DB",0,2,49,"DD",0,2,51,"DEC",0,2,57,"DIV",0
	db	6,198,"DS",0,2,60,"DW",0,2,62,"ENTER",0,6,192,"ES",0
	db	2,66,"F2XM1",0,2,70,"FABS",0,2,74,"FADD",0
	db	2,85,"FADDP",0,2,97,"FBLD",0,2,100,"FBSTP",0
	db	2,103,"FCHS",0,2,107,"FCLEX",0,2,112,"FCMOVA",0
	db	2,117,"FCMOVAE",0,2,122,"FCMOVB",0,2,127,"FCMOVBE",0
	db	2,132,"FCMOVE",0,2,137,"FCMOVNA",0,2,142,"FCMOVNAE",0
	db	2,147,"FCMOVNB",0,2,152,"FCMOVNBE",0,2,157,"FCMOVNE",0
	db	2,162,"FCMOVNU",0,2,167,"FCMOVNZ",0,2,172,"FCMOVU",0
	db	2,177,"FCMOVZ",0,2,182,"FCOM",0,2,193,"FCOMI",0
	db	2,202,"FCOMIP",0,2,211,"FCOMP",0,2,222,"FCOMPP",0
	db	2,226,"FCOS",0,2,231,"FDECSTP",0,2,235,"FDISI",0
	db	2,240,"FDIV",0,2,251,"FDIVP",0,3,8,"FDIVR",0
	db	3,19,"FDIVRP",0,3,31,"FENI",0,3,36,"FFREE",0
	db	2,92,"FIADD",0,3,40,"FICOM",0,3,45,"FICOMP",0
	db	3,3,"FIDIV",0,3,26,"FIDIVR",0,3,50,"FILD",0
	db	3,141,"FIMUL",0,3,57,"FINCSTP",0,3,61,"FINIT",0
	db	3,66,"FIST",0,3,71,"FISTP",0,3,253,"FISUB",0
	db	4,21,"FISUBR",0,3,78,"FLD",0,3,88,"FLD1",0
	db	3,116,"FLDCW",0,3,120,"FLDENV",0,3,96,"FLDL2E",0
	db	3,92,"FLDL2T",0,3,104,"FLDLG2",0,3,108,"FLDLN2",0
	db	3,100,"FLDPI",0,3,112,"FLDZ",0,3,123,"FMUL",0
	db	3,134,"FMULP",0,2,108,"FNCLEX",0,2,236,"FNDISI",0
	db	3,32,"FNENI",0,3,62,"FNINIT",0,3,117,"FNLDCW",0
	db	3,146,"FNOP",0,3,175,"FNSAVE",0,3,183,"FNSETPM",0
	db	3,221,"FNSTCW",0,3,225,"FNSTENV",0,3,229,"FNSTSW",0
	db	3,150,"FPATAN",0,3,154,"FPREM",0,3,158,"FPREM1",0
	db	3,163,"FPTAN",0,3,167,"FRNDINT",0,3,171,"FRSTOR",0
	db	6,200,"FS",0,3,174,"FSAVE",0,3,178,"FSCALE",0
	db	3,182,"FSETPM",0,3,188,"FSIN",0,3,193,"FSINCOS",0
	db	3,198,"FSQRT",0,3,202,"FST",0,3,220,"FSTCW",0
	db	3,224,"FSTENV",0,3,210,"FSTP",0,3,228,"FSTSW",0
	db	3,235,"FSUB",0,3,246,"FSUBP",0,4,3,"FSUBR",0
	db	4,14,"FSUBRP",0,4,26,"FTST",0,4,30,"FUCOM",0
	db	4,39,"FUCOMI",0,4,48,"FUCOMIP",0,4,57,"FUCOMP",0
	db	4,66,"FUCOMPP",0,4,71,"FWAIT",0,4,74,"FXAM",0
	db	4,78,"FXCH",0,4,85,"FXTRACT",0,4,89,"FYL2X",0
	db	4,93,"FYL2XP1",0,6,202,"GS",0,4,97,"HLT",0
	db	4,100,"IDIV",0,4,103,"IMUL",0,4,121,"IN",0,4,126,"INC",0
	db	4,132,"INSB",0,4,136,"INSD",0,4,137,"INSW",0
	db	4,141,"INT",0,4,146,"INTO",0,4,149,"INVD",0
	db	4,153,"INVLPG",0,4,158,"IRET",0,4,157,"IRETD",0
	db	4,161,"JA",0,4,167,"JAE",0,4,173,"JB",0,4,179,"JBE",0
	db	4,185,"JC",0,4,192,"JCXZ",0,4,195,"JE",0,4,191,"JECXZ",0
	db	4,201,"JG",0,4,207,"JGE",0,4,213,"JL",0,4,219,"JLE",0
	db	5,90,"JMP",0,4,225,"JNA",0,4,231,"JNAE",0,4,237,"JNB",0
	db	4,243,"JNBE",0,4,249,"JNC",0,4,255,"JNE",0,5,6,"JNG",0
	db	5,12,"JNGE",0,5,18,"JNL",0,5,24,"JNLE",0
	db	5,30,"JNO",0,5,36,"JNP",0,5,42,"JNS",0,5,48,"JNZ",0
	db	5,54,"JO",0,5,60,"JP",0,5,66,"JPE",0,5,72,"JPO",0
	db	5,78,"JS",0,5,84,"JZ",0,5,101,"LAHF",0,5,104,"LAR",0
	db	5,108,"LDS",0,5,126,"LEA",0,5,129,"LEAVE",0
	db	5,115,"LES",0,5,118,"LFS",0,5,133,"LGDT",0,5,122,"LGS",0
	db	5,137,"LIDT",0,5,141,"LLDT",0,5,145,"LMSW",0
	db	5,149,"LOCK",0,5,151,"LODSB",0,5,154,"LODSD",0
	db	5,155,"LODSW",0,5,159,"LOOP",0,5,158,"LOOPD",0
	db	5,165,"LOOPE",0,5,164,"LOOPED",0,5,177,"LOOPNE",0
	db	5,176,"LOOPNED",0,5,183,"LOOPNZ",0,5,182,"LOOPNZD",0
	db	5,171,"LOOPZ",0,5,170,"LOOPZD",0,5,188,"LSL",0
	db	5,111,"LSS",0,5,192,"LTR",0,5,196,"MOV",0
	db	5,233,"MOVSB",0,5,236,"MOVSD",0,5,237,"MOVSW",0
	db	5,240,"MOVSX",0,5,247,"MOVZX",0,5,254,"MUL",0
	db	6,2,"NEG",0,6,6,"NOP",0,6,9,"NOT",0,6,13,"OR",0
	db	6,27,"ORG",0,6,29,"OUT",0,6,34,"OUTSB",0
	db	6,38,"OUTSD",0,6,39,"OUTSW",0,6,43,"POP",0
	db	6,61,"POPA",0,6,60,"POPAD",0,6,66,"POPF",0
	db	6,65,"POPFD",0,6,69,"PUSH",0,6,95,"PUSHA",0
	db	6,94,"PUSHAD",0,6,100,"PUSHF",0,6,99,"PUSHFD",0
	db	6,103,"RCL",0,6,111,"RCR",0,6,135,"RDMSR",0
	db	6,139,"REP",0,6,141,"REPE",0,6,143,"REPNE",0
	db	6,145,"RET",0,6,151,"RETF",0,6,150,"RETFD",0
	db	6,119,"ROL",0,6,127,"ROR",0,6,156,"RSM",0,6,160,"SAHF",0
	db	6,163,"SAL",0,6,171,"SAR",0,6,220,"SBB",0
	db	6,234,"SCASB",0,6,237,"SCASD",0,6,238,"SCASW",0
	db	6,179,"SEG",0,6,241,"SETA",0,6,245,"SETAE",0
	db	6,249,"SETB",0,6,253,"SETBE",0,7,2,"SETC",0
	db	7,6,"SETE",0,7,10,"SETG",0,7,14,"SETGE",0
	db	7,18,"SETL",0,7,22,"SETLE",0,7,26,"SETNA",0
	db	7,30,"SETNAE",0,7,34,"SETNB",0,7,38,"SETNBE",0
	db	7,42,"SETNC",0,7,46,"SETNE",0,7,50,"SETNG",0
	db	7,54,"SETNGE",0,7,58,"SETNL",0,7,62,"SETNLE",0
	db	7,66,"SETNO",0,7,70,"SETNP",0,7,74,"SETNS",0
	db	7,78,"SETNZ",0,7,82,"SETO",0,7,86,"SETP",0
	db	7,90,"SETPE",0,7,94,"SETPO",0,7,98,"SETS",0
	db	7,102,"SETZ",0,7,106,"SGDT",0,6,204,"SHL",0
	db	7,114,"SHLD",0,6,212,"SHR",0,7,121,"SHRD",0
	db	7,110,"SIDT",0,7,128,"SLDT",0,7,132,"SMSW",0
	db	6,196,"SS",0,7,136,"STC",0,7,139,"STD",0,7,142,"STI",0
	db	7,145,"STOSB",0,7,148,"STOSD",0,7,149,"STOSW",0
	db	7,152,"STR",0,7,156,"SUB",0,7,170,"TEST",0
	db	7,179,"VERR",0,7,183,"VERW",0,7,187,"WAIT",0
	db	7,190,"WBINVD",0,7,194,"WRMSR",0,7,198,"XADD",0
	db	7,203,"XCHG",0,7,214,"XLAT",0,7,217,"XLATB",0
	db	7,220,"XOR",0
end_mnlist:

;	These are equates to refer to the above mnemonics.

MNEM_BSWAP	EQU	71
MNEM_DB	EQU	506
MNEM_LOCK	EQU	1819
MNEM_REP	EQU	2163
MNEM_REPE	EQU	2169
MNEM_REPNE	EQU	2176
MNEM_SEG	EQU	2272
MNEM_WAIT	EQU	2646

;	Number of entries in the following array.

ASMMOD	EQU	79

;	This is an array of indices into the oplists array (below).
;	It is used by the assembler to save space.

opindex	db	0,1,4,7,10,13,16,19,22,25,27,30,33,35,37,39,41
	db	43,45,48,50,52,55,58,62,64,66,68,70,73,75,77,81
	db	85,89,93,96,99,101,103,105,108,110,112,115,118,121,124,127
	db	130,134,138,141,144,146,148,150,152,154,156,158,161,164,167,170
	db	173,175,177,181,185,188,191,194,197,200,203,206,209,212

;	These are the lists of operands for the various instruction types.

oplists	db	0	;simple instruction
	db	OP_ALL+OP_AX, OP_ALL+OP_IMM, 0
	db	OP_ALL+OP_RM, OP_ALL+OP_IMM, 0
	db	OP_1632+OP_RM, OP_IMMS8, 0
	db	OP_ALL+OP_RM, OP_ALL+OP_R, 0
	db	OP_ALL+OP_R, OP_ALL+OP_RM, 0
	db	OP_16+OP_RM, OP_16+OP_R, 0
	db	OP_1632+OP_R, OP_1632+OP_M, 0
	db	OP_1632+OP_R, OP_1632+OP_RM, 0
	db	OP_32+OP_R_ADD, 0
	db	OP_1632+OP_RM, OP_1632+OP_R, 0
	db	OP_1632+OP_RM, OP_IMM8, 0
	db	OP_REL1632, 0
	db	OP_FARP, 0
	db	OP_FARMEM, 0
	db	OP_M64, 0
	db	OP_ALL+OP_RM, 0
	db	OP_1632+OP_R_ADD, 0
	db	OP_16+OP_IMM, OP_IMM8, 0
	db	OP_MFLOAT, 0
	db	OP_MDOUBLE, 0
	db	OP_ST, OP_STI, 0
	db	OP_STI, OP_ST, 0
	db	OP_1CHK, OP_STI, OP_ST, 0
	db	OP_32+OP_M, 0
	db	OP_16+OP_M, 0
	db	OP_M80, 0
	db	OP_STI, 0
	db	OP_1CHK, OP_STI, 0
	db	OP_MXX, 0
	db	OP_16+OP_AX, 0
	db	OP_1632+OP_R, OP_1632+OP_RM, OP_IMMS8, 0
	db	OP_1632+OP_R_MOD, OP_1632+OP_R, OP_IMMS8, 0
	db	OP_1632+OP_R, OP_1632+OP_RM, OP_1632+OP_IMM, 0
	db	OP_1632+OP_R_MOD, OP_1632+OP_R, OP_1632+OP_IMM, 0
	db	OP_ALL+OP_AX, OP_IMM8, 0
	db	OP_ALL+OP_AX, OP_DX, 0
	db	OP_3, 0
	db	OP_IMM8, 0
	db	OP_REL8, 0
	db	OP_ECX, OP_REL8, 0
	db	OP_1632+OP_RM, 0
	db	OP_16+OP_RM, 0
	db	OP_16+OP_RM, OP_SEGREG, 0
	db	OP_SEGREG, OP_16+OP_RM, 0
	db	OP_ALL+OP_AX, OP_ALL+OP_MOFFS, 0
	db	OP_ALL+OP_MOFFS, OP_ALL+OP_AX, 0
	db	OP_8+OP_R_ADD, OP_8+OP_IMM, 0
	db	OP_1632+OP_R_ADD, OP_1632+OP_IMM, 0
	db	OP_1632+OP_R, OP_SHOSIZ, OP_8+OP_RM, 0
	db	OP_1632+OP_R, OP_SHOSIZ, OP_16+OP_RM, 0
	db	OP_IMM8, OP_ALL+OP_AX, 0
	db	OP_DX, OP_ALL+OP_AX, 0
	db	OP_1632+OP_M, 0
	db	OP_ES, 0
	db	OP_CS, 0
	db	OP_SS, 0
	db	OP_DS, 0
	db	OP_FS, 0
	db	OP_GS, 0
	db	OP_SHOSIZ, OP_1632+OP_IMM, 0
	db	OP_SHOSIZ, OP_IMM8, 0
	db	OP_ALL+OP_RM, OP_1, 0
	db	OP_ALL+OP_RM, OP_CL, 0
	db	OP_ALL+OP_RM, OP_IMM8, 0
	db	OP_16+OP_IMM, 0
	db	OP_8+OP_RM, 0
	db	OP_1632+OP_RM, OP_1632+OP_R, OP_IMM8, 0
	db	OP_1632+OP_RM, OP_1632+OP_R, OP_CL, 0
	db	OP_1632+OP_AX, OP_1632+OP_R_ADD, 0
	db	OP_1632+OP_R_ADD, OP_1632+OP_AX, 0
	db	OP_32+OP_R_MOD, OP_CR, 0
	db	OP_CR, OP_32+OP_R_MOD, 0
	db	OP_32+OP_R_MOD, OP_DR, 0
	db	OP_DR, OP_32+OP_R_MOD, 0
	db	OP_32+OP_R_MOD, OP_TR, 0
	db	OP_TR, OP_32+OP_R_MOD, 0
	db	OP_STI, OP_R_MOD, 0
	db	OP_R_MOD, OP_STI, 0

OPTYPES_BASE	EQU	12

OPLIST_Z	EQU	113
OPLIST_ES	EQU	158

;	Here is the compressed table of the opcode types.

optypes	db	 22, 22, 25, 25, 13, 13,158,158	; 00 - 07 (main opcode part)
	db	 22, 22, 25, 25, 13, 13,160,  2	; 08 - 0f
	db	 22, 22, 25, 25, 13, 13,162,162	; 10 - 17
	db	 22, 22, 25, 25, 13, 13,164,164	; 18 - 1f
	db	 22, 22, 25, 25, 13, 13, 10, 12	; 20 - 27
	db	 22, 22, 25, 25, 13, 13, 10, 12	; 28 - 2f
	db	 22, 22, 25, 25, 13, 13, 10, 12	; 30 - 37
	db	 22, 22, 25, 25, 13, 13, 10, 12	; 38 - 3f
	db	 55, 55, 55, 55, 55, 55, 55, 55	; 40 - 47
	db	 55, 55, 55, 55, 55, 55, 55, 55	; 48 - 4f
	db	 55, 55, 55, 55, 55, 55, 55, 55	; 50 - 57
	db	 55, 55, 55, 55, 55, 55, 55, 55	; 58 - 5f
	db	 12, 12, 31, 28, 10, 10, 10, 10	; 60 - 67
	db	170, 97,173, 89, 12, 12, 12, 12	; 68 - 6f
	db	115,115,115,115,115,115,115,115	; 70 - 77
	db	115,115,115,115,115,115,115,115	; 78 - 7f
	db	  4,  4,  0,  4, 22, 22, 25, 25	; 80 - 87
	db	 22, 22, 25, 25,124, 31,127,  4	; 88 - 8f
	db	 12,197,197,197,197,197,197,197	; 90 - 97
	db	 12, 12, 47, 12, 12, 12, 12, 12	; 98 - 9f
	db	130,130,133,133, 12, 12, 12, 12	; a0 - a7
	db	 13, 13, 12, 12, 12, 12, 12, 12	; a8 - af
	db	136,136,136,136,136,136,136,136	; b0 - b7
	db	139,139,139,139,139,139,139,139	; b8 - bf
	db	  4,  4,185, 12, 31, 31,  4,  4	; c0 - c7
	db	 57, 12,185, 12,111,113, 12, 12	; c8 - cf
	db	  4,  4,  4,  4,113,113,  0, 12	; d0 - d7
	db	  6,  6,  6,  6,  6,  6,  6,  6	; d8 - df
	db	117,117,117,115,105,105,150,150	; e0 - e7
	db	 45, 45, 47,115,108,108,153,153	; e8 - ef
	db	 10,  0, 10, 10, 12, 12,  4,  4	; f0 - f7
	db	 12, 12, 12, 12, 12, 12,  4,  4	; f8 - ff
	db	 16, 16, 16, 16, 16, 16, 16, 16	; 100 - 107 (Intel group 1)
	db	 19, 19, 19, 19, 19, 19, 19, 19	; 108 - 10f
	db	176,176,176,176,176,176,  0,176	; 110 - 117 (Intel group 2)
	db	179,179,179,179,179,179,  0,179	; 118 - 11f
	db	182,182,182,182,182,182,  0,182	; 120 - 127 (Intel group 2a)
	db	 16,  0, 53, 53, 53, 53, 53, 53	; 128 - 12f (Intel group 3)
	db	 53, 53,120, 49,120, 49,120,  0	; 130 - 137 (Intel group 5)
	db	120,122,122,122,122,122,  0,  0	; 138 - 13f (Intel group 6)
	db	 85, 85, 85, 85,120,  0,122, 85	; 140 - 147 (Intel group 7)
	db	 60, 60, 60, 60, 60, 60, 60, 60	; 148 - 14f (Coprocessor d8)
	db	 64, 64, 82, 82, 64, 64, 64, 64	; 150 - 157
	db	 60,  0, 60, 60, 85, 76, 85, 76	; 158 - 15f (Coprocessor d9)
	db	 80, 82,  8,  0,  8,  8,  8,  8	; 160 - 167
	db	 74, 74, 74, 74, 74, 74, 74, 74	; 168 - 16f (Coprocessor da)
	db	 64, 64, 64, 64,  0,  8,  0,  0	; 170 - 177
	db	 74,  0, 74, 74,  0, 78,  0, 78	; 178 - 17f (Coprocessor db)
	db	 64, 64, 64, 64,  8, 82, 82,  0	; 180 - 187
	db	 62, 62, 62, 62, 62, 62, 62, 62	; 188 - 18f (Coprocessor dc)
	db	 67, 67,  0,  0, 67, 67, 67, 67	; 190 - 197
	db	 62,  0, 62, 62, 85,  0, 85, 76	; 198 - 19f (Coprocessor dd)
	db	 80,  0, 80, 80, 82, 82,  0,  0	; 1a0 - 1a7
	db	 76, 76, 76, 76, 76, 76, 76, 76	; 1a8 - 1af (Coprocessor de)
	db	 70, 70,  0,  8, 70, 70, 70, 70	; 1b0 - 1b7
	db	 76,  0, 76, 76, 78, 51, 78, 51	; 1b8 - 1bf (Coprocessor df)
	db	  0,  0,  0,  0,  8, 82, 82,  0	; 1c0 - 1c7
	db	 12, 12, 12, 12, 12, 12, 12,  0	; 1c8 - 1cf (Coprocessor groups)
	db	 12, 12, 12, 12, 12, 12, 12, 12	; 1d0 - 1d7
	db	 12, 12, 12, 12, 12, 12, 12, 12	; 1d8 - 1df
;	The rest of these are squeezed.
	db	 0,  4,  4, 34, 34, 12, 12, 12
	db	203,209,206,212,215,218, 12, 12
	db	 34, 34, 34, 34, 34, 34, 34, 34
	db	 34, 34, 34, 34, 34, 34, 34, 34
	db	 45, 45, 45, 45, 45, 45, 45, 45
	db	 45, 45, 45, 45, 45, 45, 45, 45
	db	187,187,187,187,187,187,187,187
	db	187,187,187,187,187,187,187,187
	db	166,166, 12, 39,189,193,168,168
	db	 12, 39,189,193, 34, 22, 22, 31
	db	 39, 31, 31,142,146,  4, 39, 34
	db	 34,142,146, 22, 22,  4, 37, 37
	db	 37, 37, 37, 37, 37, 37, 53, 53
	db	 42, 42, 42, 42, 51,156, 16, 12
	db	 12, 12, 12, 12, 12, 12, 12, 12
	db	 12, 12, 12, 87

;	And here is the compressed table of additional information.

opinfo	dw	00020h,00020h,00020h,00020h,00020h,00020h,00836h,00812h	; 00
	dw	007e9h,007e9h,007e9h,007e9h,007e9h,007e9h,00836h,001e0h	; 08
	dw	0001ah,0001ah,0001ah,0001ah,0001ah,0001ah,00836h,00812h	; 10
	dw	008c2h,008c2h,008c2h,008c2h,008c2h,008c2h,00836h,00812h	; 18
	dw	00026h,00026h,00026h,00026h,00026h,00026h,00001h,001eeh	; 20
	dw	00a3bh,00a3bh,00a3bh,00a3bh,00a3bh,00a3bh,00101h,001f4h	; 28
	dw	00a8bh,00a8bh,00a8bh,00a8bh,00a8bh,00a8bh,00201h,00002h	; 30
	dw	001a0h,001a0h,001a0h,001a0h,001a0h,001a0h,00301h,00014h	; 38
	dw	005c2h,005c2h,005c2h,005c2h,005c2h,005c2h,005c2h,005c2h	; 40
	dw	00204h,00204h,00204h,00204h,00204h,00204h,00204h,00204h	; 48
	dw	00836h,00836h,00836h,00836h,00836h,00836h,00836h,00836h	; 50
	dw	00812h,00812h,00812h,00812h,00812h,00812h,00812h,00812h	; 58
	dw	0183dh,01818h,01033h,0202ch,03401h,03501h,03010h,03020h	; 60
	dw	01836h,015b6h,01836h,015b6h,015c8h,015d6h,017fah,0180ah	; 68
	dw	006ach,00694h,00614h,0060eh,006c7h,006a6h,00619h,00609h	; 70
	dw	006c2h,006a0h,006b6h,006bch,00643h,0063dh,00648h,00638h	; 78
	dw	00100h,00100h,00000h,00108h,00a41h,00a41h,00a75h,00a75h	; 80
	dw	007a3h,007a3h,007a3h,007a3h,007a3h,006dfh,007a3h,002f8h	; 88
	dw	007ddh,00a75h,00a75h,00a75h,00a75h,00a75h,00a75h,00a75h	; 90
	dw	0006dh,001e1h,00066h,00a56h,0084eh,00827h,008afh,006cch	; 98
	dw	007a3h,007a3h,007a3h,007a3h,007a9h,007b9h,001a6h,001b6h	; a0
	dw	00a41h,00a41h,00a1dh,00a2dh,00722h,00732h,008c8h,008d8h	; a8
	dw	007a3h,007a3h,007a3h,007a3h,007a3h,007a3h,007a3h,007a3h	; b0
	dw	007a3h,007a3h,007a3h,007a3h,007a3h,007a3h,007a3h,007a3h	; b8
	dw	00120h,00120h,00888h,00888h,006edh,006d9h,00300h,00300h	; c0
	dw	0121ah,016e5h,0088eh,0088eh,005ddh,005ddh,005e3h,005fah	; c8
	dw	00110h,00110h,00118h,00118h,0000eh,00008h,00000h,00a83h	; d0
	dw	00148h,00158h,00168h,00178h,00188h,00198h,001a8h,001b8h	; d8
	dw	0076dh,00780h,0073ah,00624h,005bdh,005bdh,007f4h,007f4h	; e0
	dw	00066h,0064eh,0064eh,0064eh,005bdh,005bdh,007f4h,007f4h	; e8
	dw	00008h,00000h,00002h,00006h,005a9h,00092h,00128h,00128h	; f0
	dw	00079h,00a0bh,00085h,00a17h,0007fh,00a11h,002e0h,00130h	; f8
	dw	00020h,007e9h,0001ah,008c2h,00026h,00a3bh,00a8bh,001a0h	; 100
	dw	00020h,007e9h,0001ah,008c2h,00026h,00a3bh,00a8bh,001a0h	; 108
	dw	0089dh,008a3h,0085fh,00865h,009d7h,009e4h,00000h,008bch	; 110
	dw	0089dh,008a3h,0085fh,00865h,009d7h,009e4h,00000h,008bch	; 118
	dw	0189dh,018a3h,0185fh,01865h,019d7h,019e4h,00000h,018bch	; 120
	dw	00a41h,00000h,007e3h,007d7h,007d1h,005b6h,0020ah,005afh	; 128
	dw	005c2h,00204h,00066h,00066h,0064eh,0064eh,00836h,00000h	; 130
	dw	029f8h,02a35h,0270dh,0279dh,02a48h,02a4fh,00000h,00000h	; 138
	dw	029d0h,029f1h,026f9h,02706h,029ffh,00000h,02714h,045f1h	; 140
	dw	00236h,00419h,002ech,00304h,0051dh,0052ch,0032eh,0033dh	; 148
	dw	00236h,00419h,002ech,00304h,0051dh,0052ch,0032eh,0033dh	; 150
	dw	003c8h,00000h,004f7h,0050eh,003ddh,0044bh,00477h,0046eh	; 158
	dw	003c8h,00581h,00308h,00000h,00310h,001c8h,001d0h,001d8h	; 160
	dw	0035dh,0038eh,00365h,0036dh,003b7h,003bfh,00376h,0037eh	; 168
	dw	06276h,06289h,0627fh,062dah,00000h,00318h,00000h,00000h	; 170
	dw	00387h,00000h,003a8h,003afh,00000h,003c8h,00000h,0050eh	; 178
	dw	062a7h,062bch,062b1h,062c6h,00320h,0654ch,062f3h,00000h	; 180
	dw	00236h,00419h,002ech,00304h,0051dh,0052ch,0032eh,0033dh	; 188
	dw	00236h,00419h,00000h,00000h,0052ch,0051dh,0033dh,0032eh	; 190
	dw	003c8h,00000h,004f7h,0050eh,004b6h,00000h,0045bh,00481h	; 198
	dw	00355h,00000h,004f7h,0050eh,03544h,0355fh,00000h,00000h	; 1a0
	dw	0035dh,0038eh,00365h,0036dh,003b7h,003bfh,00376h,0037eh	; 1a8
	dw	0023dh,00420h,00000h,00328h,00534h,00524h,00345h,00335h	; 1b0
	dw	00387h,00000h,003a8h,003afh,00245h,00387h,0024ch,003afh	; 1b8
	dw	00000h,00000h,00000h,00000h,00330h,06555h,062fbh,00000h	; 1c0
	dw	003ceh,003efh,003e6h,0040ah,003f8h,00401h,00412h,00000h	; 1c8
	dw	00227h,00592h,004a4h,0048ah,00588h,0349bh,0031ch,00396h	; 1d0
	dw	00493h,0059ah,004efh,034e5h,004ach,004cch,034deh,03315h	; 1d8
;	The rest of these are squeezed.
	dw	     0,00138h,00140h,026d3h,02791h,0208bh,045eah,04a5dh
	dw	037a3h,037a3h,037a3h,037a3h,037a3h,037a3h,05a66h,0586bh
	dw	0616eh,0614ah,060a9h,060a0h,06198h,06165h,060b1h,06098h
	dw	06190h,0615ch,0617eh,06187h,060dbh,060d2h,060e3h,060cah
	dw	036ach,03694h,03614h,0360eh,036c7h,036a6h,03619h,03609h
	dw	036c2h,036a0h,036b6h,036bch,03643h,0363dh,03648h,03638h
	dw	039a4h,03984h,038f5h,038edh,039c9h,0399ch,038fch,038e6h
	dw	039c2h,03994h,039b2h,039bah,03921h,03919h,03928h,03912h
	dw	03836h,03812h,051d4h,0304fh,039ddh,039ddh,03836h,03812h
	dw	058a9h,03060h,039eah,039eah,035b6h,041beh,041beh,03797h
	dw	0305ah,036f3h,03700h,037c9h,037c9h,002e8h,03054h,0303bh
	dw	03041h,037c1h,037c1h,04a6eh,04a6eh,002f0h,04047h,04047h
	dw	04047h,04047h,04047h,04047h,04047h,04047h,005c2h,00204h
	dw	0304fh,03060h,0305ah,03054h,051c8h,00812h,007a3h,00454h
	dw	00254h,0022fh,0053dh,0057ah,03568h,0043ah,00431h,00428h
	dw	00442h,02464h,0030ch,00481h

;	This table converts unsqueezed numbers to squeezed.

sqztab	db	  1,  2,  3,  4,  0,  0,  5,  0
	db	  6,  7,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  8,  9, 10, 11, 12,  0, 13,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	 14,  0, 15,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	 16, 17, 18, 19, 20, 21, 22, 23
	db	 24, 25, 26, 27, 28, 29, 30, 31
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	 32, 33, 34, 35, 36, 37, 38, 39
	db	 40, 41, 42, 43, 44, 45, 46, 47
	db	 48, 49, 50, 51, 52, 53, 54, 55
	db	 56, 57, 58, 59, 60, 61, 62, 63
	db	 64, 65, 66, 67, 68, 69,  0,  0
	db	 70, 71, 72, 73, 74, 75,  0, 76
	db	 77, 78, 79, 80, 81, 82, 83, 84
	db	  0,  0, 85, 86, 87, 88, 89, 90
	db	 91, 92,  0,  0,  0,  0,  0, 93
	db	 94, 95, 96, 97, 98, 99,100,101
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,  0,  0,  0,  0
	db	102,103,  0,  0,  0,  0,  0,  0
	db	  0,  0,  0,  0,104,105,106,107
	db	  0,108,  0,  0,  0,  0,  0,  0
	db	109,  0,  0,  0,  0,  0,  0,  0
	db	110,  0,  0,  0,  0,  0,  0,  0
	db	111,  0,  0,  0,  0,  0,  0,  0
	db	112,113,  0,  0,114,115,  0,  0
	db	  0,116,  0,  0,  0,  0,  0,  0
	db	117,118,119,120,121,  0,  0,  0
	db	  0,122,  0,  0,  0,  0,  0,  0
	db	123,  0,  0,  0,  0,  0,  0,  0

;	This is the table of mnemonics that change in the presence of a WAIT
;	instruction.

wtab1	dw	0322h,0321h,0320h,0323h,015dh,019eh,0324h,015fh
	dw	015eh,0330h,019fh
wtab2	dw	025bh,0326h,034eh,03a0h,03d5h,04c4h,04d5h,04fdh
	dw	0505h,0515h,0515h
N_WTAB	equ	11

;	This is the table for operands which have a different mnemonic for
;	their 32 bit versions (66h prefix).

ltab1	dw	098h,0a7h,099h,06dh,0cfh,0adh,0a5h,06fh
	dw	061h,09dh,060h,09ch,0cbh,0cah,0afh,0abh
ltab2	dw	01e7h,01aeh,073h,05cfh,0601h,072ah,07b1h,0802h
	dw	081fh,082eh,0845h,0856h,0895h,0895h,08d0h,0a25h
N_LTAB	equ	16

;	This is the table for operands which have a different mnemonic for
;	their 32 bit versions (67h prefix).

ltab1X	dw	0e3h,0e2h,0e2h,0e1h,0e1h,0e1h,0e1h,0e0h
	dw	0e0h,0e0h,0e0h
ltab2X	dw	0630h,0741h,0741h,0751h,0751h,0788h,0788h,0763h
	dw	0763h,0776h,0776h
N_LTABX	equ	11

;	This is the table of lockable instructions

locktab	dw	010ah,0102h,010h,011h,0108h,0100h,00h,01h
	dw	010ch,0104h,020h,021h,029bh,02efh,0293h,02eeh
	dw	028bh,02edh,0290h,0291h,02e1h,0131h,02e0h,0130h
	dw	012bh,012ah,0109h,0101h,08h,09h,010bh,0103h
	dw	018h,019h,010dh,0105h,028h,029h,02a0h,02a1h
	dw	086h,087h,010eh,0106h,030h,031h
N_LOCK	equ	46

;	Equates used in the assembly-language code.

SPARSE_BASE	equ	480

SFPGROUP3	equ	800

