/* Compile with Turbo C or Borland C */
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
/* #pragma option -N- */

/*===================================================================*/

#if defined __STDC__ || defined __TURBOC__

#  define far
#  define near
#  define cdecl

#  define SMALL_
#  define FAST_
#  define STD_
#  define NSMALL_
#  define NFAST_
#  define NSTD_
#  define FSMALL_
#  define FFAST_
#  define FSTD_

#else

#  define SMALL_	_pascal
#  define FAST_		__fastcall
#  define STD_		cdecl
#  define NSMALL_	near _pascal
#  define NFAST_	near __fastcall
#  define NSTD_		near cdecl
#  define FSMALL_	far _pascal
#  define FFAST_	far __fastcall
#  define FSTD_		far cdecl

#endif

typedef unsigned char	byte;
typedef unsigned short	word;
typedef const char	CStr[], *PCStr;

#ifdef USE_TASM
#define INT10		asm int 10h;
#define INT16		asm int 16h;
#define INT33		asm int 33h;
#else
#define INT10		__emit__(0xcd); __emit__(0x10);
#define INT16		__emit__(0xcd); __emit__(0x16);
#define INT33		__emit__(0xcd); __emit__(0x33);
#endif

/*-------------------------------------------------------------------*/

#if defined(__LARGE__) || defined(__HUGE__) || defined(__COMPACT__)
#define FARDATA
#endif

enum CPU_FLAGS { Carry = 1, Parity = 4, Auxcarry = 0x10,
		 Zero = 0x40, Equal = Zero, Sign = 0x80, Trap = 0x100,
		 IEnable = 0x200, Direct = 0x400, Overflow = 0x800
};

#define isFLAG(mask) (_FLAGS & (mask))

/*-------------------------------------------------------------------*/

#ifdef USE_BORLAND
volatile const word far &NSTD_ _wscreen = *((const word far*)MK_FP(0, 0x44A));
volatile const byte far &NSTD_ _hscreen = *((const byte far*)MK_FP(0, 0x484));
#define scrwidth	(_wscreen)
#define scrheight	(_hscreen ? _hscreen + 1 : 25)
#else
#define scrwidth	(peek(0x40,0x4a))
#define scrheight	(peekb(0x40,0x84) ? (peekb(0x40,0x84)+1) : 25)
#define _loadds
#endif

/*===================================================================*/

word AX, BX, CX, DX, SI, DI;
word cnt = 0;

char butstatus[3*8] = "lmrLmrlmRLmRlMrLMrlMRLMR";

#ifdef USE_BORLAND
void _loadds NSMALL_ handler_(word AX_){
	AX = AX_, BX = _BX, CX = _CX, DX = _DX, SI = _SI, DI = _DI; cnt++;
}
void far handler() { handler_(_AX); }
#else
void far pascal handler(void) {
	AX = _AX, BX = _BX, CX = _CX, DX = _DX, SI = _SI, DI = _DI; cnt++;
}
#endif

void NSMALL_ sethandler(word mask){
#ifdef FARDATA
	_ES = FP_SEG(handler),
#else
	_ES = _CS,
#endif
	_DX = FP_OFF(handler), _CX = mask, _AX = 0xC; INT33;
}

/*-------------------------------------------------------------------*/
void NSMALL_ gotorc(byte row, byte col){
	_DH = row, _DL = col, _BH = 0, _AH = 2; INT10;
}

/* void fillscreen(void); */
void fillscreen(void) {
	int row, col, color;
	for (row = 1; row < scrheight; row++){
		for (col = 0, color = 2; col < scrwidth; col++){
			gotorc(row, col);
			_AL = (row + col) % 10u + (int)('0'), _BH = 0,
			_BL = color, _CX = 1, _AH = 9; INT10;
			color++, color &= 0x0F;
}	}	}

void NSMALL_ showstatus(word BX, word CX, word DX){
	int wheel = BX >> 8;
	gotorc(0, scrwidth - 18); printf("%-18.3s", &butstatus[(BX&7)*3]);
	gotorc(0, scrwidth - 14); printf("%3d,%-d", CX, DX);
	if (wheel!=0) {
		gotorc(0, scrwidth - 4); printf("%c%d",((wheel>0) ? '+' : '-'),
			((wheel<0) ? (-wheel) : wheel) );
	}
}

void NFAST_ pause(CStr s){
	int oldcnt;
	gotorc(0,0); printf("%s    ",s);
	_AX = 3; INT33; showstatus(_BX, _CX, _DX);
	for (oldcnt = cnt;;){
		__emit__(0xf4); /* asm hlt; */
		if (oldcnt != cnt) { showstatus(BX, CX, DX); oldcnt = cnt; }
		_AH = 1; INT16; if (!isFLAG(Zero)) break;
	}
	_AH = 0; INT16;
}

void NFAST_ font_pause(word fno, CStr s){
	/**/ fno = fno;
	_AX = fno, _AX += 0x1110; _BL = 0; INT10; fillscreen();
	_AX = 0x21; INT33; sethandler(0xFFFF);
	_AX = 1; INT33; pause(s);
}

/*-------------------------------------------------------------------*/
int main(int argc, char *argv[]){
	int wheel1 = 0;
	int wheel2 = 0;
	int mode = -1;
	if (argc < 2) {
		printf("Syntax: mousetst <decimal video mode>\n"
			"Standard text modes: 0-3, 7\n"
			"Standard graphics modes: 4-6, 13-19\n"
			"Note: mode 7 only for monochrome systems\n");
		return 1;
	}
	if (argv[1][0]>='0' && argv[1][0]<='9') {
		mode = argv[1][0]-'0';
	}
	if (argv[1][0]!=0 && argv[1][2]==0 && argv[1][1]>='0' && argv[1][1]<='9') {
		mode = (10*mode) + (argv[1][1]-'0');
	}
	if (mode<0 || mode>19) {
		printf("Invalid mode value\n");
		return 1;
	}
	printf("Mode: %d",mode);
	
				sethandler(0xFFFF);
	_AX = 0x11; INT33; /* test if wheel supported */
	wheel1 = _AX;
	wheel2 = _CX;
	if (wheel1==0x574d) { /* "WM" */
		if ((wheel2 & 1) == 1) {
				pause("start: wheel active    ");
		} else {
				pause("start: no wheel found  ");
		}
	} else {
				pause("start: no wheel driver ");
	}
	_AX = 1; INT33;		pause("enabled mouse cursor   ");
	_AX = 0xd; _AX = mode; INT10;
	fillscreen();		pause("set selected int10 mode");

	_CX = -40, _DX = 680, _AX = 7; INT33;
	_CX = -40, _DX = 500, _AX = 8; INT33;
	_AX = 1; INT33;		pause("enabled cursor / range ");

/*	_CX = 21*8 + 5, _DX = 10*8 + 5, _SI = 41*8 - 4, _DI = 15*8 - 4,	*/
/*	_AX = 0x10; INT33; pause("/region 173-85/324-116");		*/

	if (mode < 4) {
		font_pause(2, "setmode/show 8x8      ");
		font_pause(1, "setmode/show 8x14");
		font_pause(4, "setmode/show 8x16");
	}

	_AX = 0; INT33;		sethandler(0xFFFF);
				pause("reset mouse driver     ");
	_AX = 1; INT33;		pause("reset, enabled cursor  ");
	_AX = 3; INT10;		sethandler(0);
	return 0;
}
