
/************************************************************************/
/*                                                                      */
/* FILE: batch.c                                                        */
/* command.com Batch support                                            */
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* This file is part of G-COM.                                          */
/* G-COM is derived from DOS-C source (GPL).                            */
/*                                                                      */
/* (C) Copyright 1999-2000  Roberto Gordo Saez   (GCOM)                 */
/* (C) Copyright 1995-1998  Pasquale J. Villani  (DOSC)                 */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option)  */
/* any later version.                                                   */
/*                                                                      */
/* This program is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     */
/* General Public License for more details.                             */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.                  */
/*                                                                      */
/************************************************************************/


#include "globals.h"


/* -- Function prototypes --------------------------------------------- */

BYTE batch (char*, int, char*);
static DWORD file_parse (char*, DWORD, int, char*);
static void label_bat (char*);
static void shift_bat (char**, unsigned int);
BOOL cmd_call_bat (char*, int, char*);
BOOL cmd_goto_bat (char*, int, char*);
BOOL cmd_rem_bat (char*, int, char*);
BOOL cmd_shift_bat (char*, int, char*);


/* -- Global variables ------------------------------------------------ */

char next_fname[FNAME_MAX+1];
DWORD next_file = -1;
DWORD current_file;
int next_argc;
char *next_arguments;
unsigned int shift_offset;
BOOL call_flag = FALSE;


/* -------------------------------------------------------------------- */
/* batch                                                                */
/* -------------------------------------------------------------------- */

BYTE batch(char *file, int argc, char *arguments)
{
    DWORD file_handle;
    BOOL end_batch;

    if((file_handle = DosOpen((char FAR *)file, O_RDONLY)) < 0)
    {
        if(file_handle == DE_TOOMANY)
        {
            error_message(TOO_FILES_OPEN);
            return -1;
        }
        return 0;
    }

    if(batch_flag && !call_flag)
    {
        strcpy(next_fname, file);
        next_file = file_handle;
        next_argc = argc;
        next_arguments = arguments;
        return 1;
    }

    batch_flag = TRUE;
    end_batch = !call_flag;
    call_flag = FALSE;

    do
    {
        next_file = -1;
        file_handle = file_parse(file, file_handle, argc, arguments);
        if(file_handle < 0)
        {
            if(file_handle == DE_TOOMANY)
            {
                error_message(TOO_FILES_OPEN);
                return -1;
            }
            return 0;
        }

        if(next_file > 0)
        {
            DosClose((UWORD)file_handle);
            file = next_fname;
            file_handle = next_file;
            argc = next_argc;
            arguments = next_arguments;
        }
    }
    while(next_file > 0);

    DosClose((UWORD)file_handle);
    if(end_batch)
        batch_flag = FALSE;

    return 1;
}


static DWORD file_parse(char *file_name, DWORD file_handle, int argc, char *arguments)
{
    char *posparam[10];
    int idx;
    char *p;
    char buffer[MAX_CMDBUFFER];
    static char line[MAX_CMDBUFFER];
    BOOL eol, eof = FALSE;
    unsigned int nread;
    BOOL at_flag;
    unsigned int argc_tail;
    DWORD current_pos;

    shift_offset = 0;
    argc_tail = argc > 9 ? argc - 9 : 0;
    strcpy(buffer, arguments);

    posparam[0] = p = file_name;
    while(*p != '\0')
    {
        if(*p++ == '\\')
            posparam[0] = p;
    }
    p = buffer;
    for(idx = 1; idx < 10; idx++)
    {
        if(idx > argc)
            posparam[idx] = "";
        else
        {
            p = skipwh(p);
            posparam[idx] = p;
            while(*p != '\0' && *p != ' ' && *p != '\t')
                p++;
            if(*p != '\0')
                *p++ = '\0';
        }
    }
    idx = 9;
    while(idx < argc)
    {
        p = skipwh(p);
        while(*p != '\0' && *p != ' ' && *p != '\t')
            p++;
        if(*p != '\0')
            *p++ = '\0';
        idx++;
    }

    do
    {
        nread = 0;
        p = line;
        eol = FALSE;

        while(!eol && nread < MAX_CMDBUFFER)
        {
            if(DosRead((UWORD)file_handle, (char FAR *)p, 1) != 1)
            {
                eof = TRUE;
                break;
            }
            switch(*p)
            {
            case CTL_Z:
            case '\r':
            case '\n':
                *p = '\0';
                eol = TRUE;
                break;

            default:
                ++nread;
                ++p;
            }
        }

        if(nread > 0)
        {
            p = skipwh(line);
            if(!expand(p, posparam) || nread == MAX_CMDBUFFER)
            {
                error_message(CMDLINE_LONG);
                continue;
            }

            if(echo_flag && *p != '@')
            {
                put_prompt(prompt_string);
                if(*cmd_buffer != '\0')
                    DosWrite(STDOUT, (char FAR *)cmd_buffer, strlen(cmd_buffer));
                DosWrite(STDOUT, (char FAR *)newline, 2);
            }

            at_flag = FALSE;

            switch(*p)
            {
            case ':':
                label_bat(skipwh(++p));
                break;

            case '@':
                p = skipwh(++p);
                at_flag = TRUE;

            default:
                current_file = file_handle;
                current_pos = DosSeek((UWORD)file_handle, S_CURRENT, 0L);
                do_command(cmd_buffer);
                if(current_file < 0)
                {
                    if((file_handle = DosOpen((char FAR *)file_name, O_RDONLY)) < 0)
                        return file_handle;
                    DosSeek((UWORD)file_handle, S_START, current_pos);
                }
                if(!at_flag && echo_flag)
                    DosWrite(STDOUT, (char FAR *)newline, 2);
                if(shift_offset > 0)
                {
                    shift_bat(posparam, argc_tail);
                    if(argc_tail > 0)
                        argc_tail -= shift_offset;
                }
                if(next_file > 0)
                    return file_handle;
            }
        }
    }
    while(!eof);

    return file_handle;
}


static void label_bat(char *label)
{
    if(*label == '\0')
        error_message(INV_LABEL);
    /* FIXME */
}


static void shift_bat(char **posparam, unsigned int argc)
{
    char *p;
    unsigned int idx = 0;

    while(posparam[idx+shift_offset] != '\0')
    {
        posparam[idx] = posparam[idx+shift_offset];
        ++idx;
    }

    p = posparam[10]+strlen(posparam[10]);
    for(; idx < 10; idx++)
    {
        if(idx > argc)
            posparam[idx] = "";
        else
        {
            p = skipwh(p);
            posparam[idx] = p;
            while(*p != '\0' && *p != ' ' && *p != '\t')
                p++;
            if(*p == '\0')
                p++;
        }
    }

    shift_offset = 0;
}


/* -------------------------------------------------------------------- */
/* cmd_call_bat - CALL command                                          */
/* -------------------------------------------------------------------- */

BOOL cmd_call_bat(char *cmd_name, int argc, char *arguments)
{
    BOOL prev_batch;

    prev_batch = batch_flag;
    call_flag = TRUE;

    if(prev_batch)
        DosClose((UWORD)current_file);

    do_command(arguments);

    call_flag = FALSE;
    batch_flag = prev_batch;
    current_file = -1;

    return TRUE;
}


/* -------------------------------------------------------------------- */
/* cmd_goto_bat - GOTO command                                          */
/* -------------------------------------------------------------------- */

BOOL cmd_goto_bat(char *cmd_name, int argc, char *arguments)
{
    /* FIXME */
    return TRUE;
}


/* -------------------------------------------------------------------- */
/* cmd_rem_bat - REM command                                            */
/* -------------------------------------------------------------------- */

BOOL cmd_rem_bat(char *cmd_name, int argc, char *arguments)
{
    return TRUE;
}


/* -------------------------------------------------------------------- */
/* cmd_shift_bat - SHIFT command                                        */
/* -------------------------------------------------------------------- */

BOOL cmd_shift_bat(char *cmd_name, int argc, char *arguments)
{
    if(batch_flag)
        ++shift_offset;

    return TRUE;
}
