
/************************************************************************/
/*                                                                      */
/* FILE: struct.h                                                       */
/* DOS data structures and declarations                                 */
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* This file is part of G-COM.                                          */
/* G-COM is derived from DOS-C source (GPL).                            */
/*                                                                      */
/* (C) Copyright      1999  Roberto Gordo Saez   (GCOM)                 */
/* (C) Copyright 1995-1998  Pasquale J. Villani  (DOSC)                 */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option)  */
/* any later version.                                                   */
/*                                                                      */
/* This program is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     */
/* General Public License for more details.                             */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.                  */
/*                                                                      */
/************************************************************************/


/* -------------------------------------------------------------------- */
/* Internal DOS system error return codes (negative)                    */
/* -------------------------------------------------------------------- */

#define DE_SUCCESS      0               /* Function was successful      */
#define DE_INVLDFUNC    -1              /* Invalid function number      */
#define DE_FILENOTFND   -2              /* File not found               */
#define DE_PATHNOTFND   -3              /* Path not found               */
#define DE_TOOMANY      -4              /* Too many open files          */
#define DE_ACCESS       -5              /* Access denied                */
#define DE_INVLDHNDL    -6              /* Invalid handle               */
#define DE_MCBDLOST     -7              /* Memory control block lost    */
#define DE_NOMEM        -8              /* Insufficient memory          */
#define DE_INVLDMCB     -9              /* Invalid memory control block */
#define DE_INVLDENV     -10             /* Invalid environment          */
#define DE_INVLDFMT     -11             /* Invalid format               */
#define DE_INVLDACC     -12             /* Invalid access               */
#define DE_INVLDDATA    -13             /* Inavalid data                */
#define DE_INVLDDRV     -15             /* Invalid drive                */
#define DE_RMVCUDIR     -16             /* Can not remove current dir   */
#define DE_DEVICE       -17             /* Not same device              */
#define DE_NFILES       -18             /* No more files                */
#define DE_WRTPRTCT     -19             /* Disk write protect           */
#define DE_SEEK         -25             /* Error on file seek           */
#define DE_DSKFULL      -39             /* Disk full                    */


/* -------------------------------------------------------------------- */
/* FAT file name constants                                              */
/* -------------------------------------------------------------------- */

#define FNAME_MAX       13


/* -------------------------------------------------------------------- */
/* Open and Create - DOS file mode flags                                */
/* -------------------------------------------------------------------- */

#define O_RDONLY        0x0000          /* Read only                    */
#define O_WRONLY        0x0001          /* Write only                   */
#define O_RDWR          0x0002          /* Read and write               */


/* -------------------------------------------------------------------- */
/* Seek - origin of move                                                */
/* -------------------------------------------------------------------- */

#define S_START         0x00            /* Start of file                */
#define S_CURRENT       0x01            /* Current position             */
#define S_END           0x02            /* End of file                  */


/* -------------------------------------------------------------------- */
/* FAT file system attribute bits                                       */
/* -------------------------------------------------------------------- */

#define F_NORMAL        0x00            /* Normal                       */
#define F_RDONLY        0x01            /* Read-only file               */
#define F_HIDDEN        0x02            /* Hidden                       */
#define F_SYSTEM        0x04            /* System                       */
#define F_LABEL         0x08            /* Volume label                 */
#define F_DIR           0x10            /* Directory                    */
#define F_ARCHIVE       0x20            /* Archive bit                  */

#define F_ALL F_RDONLY | F_HIDDEN | F_SYSTEM | F_DIR | F_ARCHIVE


/* -------------------------------------------------------------------- */
/* File Control Block (FCB)                                             */
/* -------------------------------------------------------------------- */

typedef struct
{
    UBYTE   fcb_drive;                  /* Drive number (1 = A)         */
    char    fcb_fname[8];               /* File name                    */
    char    fcb_fext[3];                /* File extension               */
    UBYTE   fcb_unused1[4];
    UDWORD  fcb_fsize;                  /* File size in bytes           */
    UWORD   fcb_date;                   /* Date of last write           */
    UWORD   fcb_time;                   /* Time of last write           */
    UBYTE   fcb_unused2[13];
}
fcb;


/* -------------------------------------------------------------------- */
/* Command tail data structure                                          */
/* -------------------------------------------------------------------- */

#define MAX_TAILSIZE    127

typedef struct
{
    UBYTE   ctCount;                    /* Number of bytes              */
    char    ctBuffer[127];              /* The buffer itself            */
}
tail;


/* -------------------------------------------------------------------- */
/* exec_block                                                           */
/* -------------------------------------------------------------------- */

typedef struct
{
    UWORD   env_seg;                    /* Environment for new process  */
    tail    FAR *cmd_line;              /* Command line for new process */
    fcb     FAR *fcb_1;                 /* First fcb                    */
    fcb     FAR *fcb_2;                 /* Second fcb                   */
    UBYTE   unused[8];
}
exec_block;


/* -------------------------------------------------------------------- */
/* Program Segment Prefix                                               */
/* -------------------------------------------------------------------- */

typedef struct
{
    UBYTE   ps_unused1[22];
    UWORD   ps_parent;                  /* Parent psp segment           */
    UBYTE   ps_unused2[20];
    UWORD   ps_environ;                 /* Environment segment          */
    UBYTE   ps_unused3[46];
    UBYTE   ps_fcb1[16];                /* First FCB */
    UBYTE   ps_fcb2[16];                /* Second FCB */
    UBYTE   unused4[4];
    UBYTE   ps_cmd_count;               /* Command tail size            */
    char    ps_cmd[127];                /* Command tail buffer          */
}
psp;


/* -------------------------------------------------------------------- */
/* info - Country information                                           */
/* -------------------------------------------------------------------- */

#define DATE_MDY        0x0000
#define DATE_DMY        0x0001
#define DATE_YMD        0x0002

#define TIME_12H        0x00
#define TIME_24H        0x00

typedef struct
{
    UWORD   date_format;                /* Date format                  */
    UBYTE   unused1[5];
    char    num_sep[2];                 /* Thousands separator          */
    UBYTE   unused2[2];
    char    date_sep[2];                /* Date separator               */
    char    time_sep[2];                /* Time separator               */
    UBYTE   unused3[2];
    UBYTE   time_format;                /* Time format                  */
    UBYTE   unused4[16];
}
info;
