/*
 *  TYPE.C - type internal command
 *
 *  Comments:
 *
 *  07/08/1998 (John P. Price)
 *    started.
 *
 * 07/12/98 (Rob Lake)
 *    - Changed error messages
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 10-Aug-1998 ska
 * - added ^Break checking
 *
 * 1999/01/24 ska
 * add: support for CP/M style device names (openf.h)
 */

#include "config.h"

#ifdef INCLUDE_CMD_TYPE

#include <stdio.h>
#include <string.h>

#include "command.h"
#include "strings.h"

#include "openf.h"

#pragma argsused
int cmd_type(char *rest)
{
  char buf[256];
  FILE *f;

  if (!*rest)
  {
    error_req_param_missing();
    return 1;
  }

  if (strchr(rest, ' '))
  {
    display_string(TEXT_ERROR_TOO_MANY_PARAMETERS);
    return 1;
  }

  if ((f = fdevopen(rest, "r")) == NULL)
  {
    error_sfile_not_found(rest);
    return 1;
  }

  while (!cbreak && fgets(buf, sizeof(buf), f))
  {
    fputs(buf, stdout);
  }
  fclose(f);

  return 0;
}

#endif
