/* COMMAND.H
 * header file for the modules in COMMAND.COM
 * Tim Norman
 * 7-15-95
 *
 * 06/29/98 (Rob Lake)
 *  - Moved error messages in here
 *
 * 07/12/98 (Rob Lake)
 *  - Moved more error messages here
 *
 * 30-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - Added compile date to version
 *
 * 12-Aug-1998 ska
 * - added: prototypes getEnv(), putEnv(), chgEnv(), chgEnv1()
 *    see environ.c for more details
 */

#define MAX_INTERNAL_COMMAND_SIZE 256
#define MAX_EXTERNAL_COMMAND_SIZE 128

#define EnvSeg (*(unsigned far*)MK_FP(_psp, 0x2c))
#define OwnerPSP (*(unsigned far *)MK_FP(_psp, 0x16))

#define BREAK_BATCHFILE 1
#define BREAK_ENDOFBATCHFILES 2
#define BREAK_INPUT 3
#define BREAK_IGNORE 4
#define BREAK_FORCMD 5

#define cbreak chkCBreak(0)

extern char *shellver;
extern char *shellname;

#define FINDFIRST(path,attrib,ffblk) findfirst(path,attrib,ffblk)
#define FINDNEXT(ffblk)  findnext(ffblk)
#define FINDSTOP(ffblk)

enum
{
  FALSE, TRUE
};

/* prototypes for COMMAND.C */
extern int ctrlBreak;
extern int exitflag;
extern int errorlevel;
extern int forceLow;
extern unsigned far *maxx;
extern unsigned char far *maxy;
extern char *ComDir;            //this is the directory command.com is in.

void fatal_error(char *);
char is_delim(char);
void execute(char *, char *);
void command(char *);
void parsecommandline(char *);
int c_brk(void);
int initialize(int, char *[], char *);
void short_version(void);

/* prototypes for INTERNAL.C */
/* int set_env(char *s);  no longer necessary - 1998/10/12 ska */
int cmd_break(char *);
int cmd_chdir(char *);
int cmd_cls(char *);            /*JPP 07/27/1998 */
int cmd_copy(char *);
int cmd_ctty(char *);           /* - 1998/10/12 ska */
int cmd_date(char *);           /*JPP 07/08/1998 */
int cmd_del(char *);
int cmd_dir(char *);
int cmd_doskey(char *);
int cmd_history(char *);        /*JPP 14-Aug-1998 */
int cmd_loadfix(char *);
int cmd_loadhigh(char *);
int cmd_mkdir(char *);
int cmd_path(char *);
int cmd_prompt(char *);
int cmd_rem(char *);
int cmd_rename(char *);
int cmd_rmdir(char *);
int cmd_set(char *);
int cmd_time(char *);           /*JPP 07/08/1998 */
int cmd_truename(char *);       /*RL 07/14/1998 */
int cmd_type(char *);           /*JPP 07/08/1998 */
int cmd_ver(char *);
int cmd_verify(char *);         /*JPP 31-Jul-1998 */
int cmd_vol(char *);
int internal_exit(char *);

/* prototypes for ENVIRON.C */
char *getEnv(char *);
int putEnv(char[]);
int chgEnv(const char[], const char[]);
int chgEnv1(const char[], const char[]);

/* prototypes of TMPNAM.C */
char *tmpfn(void);
char *mktempfile(char *path, char *ext);
void killtmpfn(char *);

/* prototypes from PROMPT.C */
void printprompt(void);

/* prototypes for CMDINPUT.C */
void readcommand(char *, int);

/* prototypes for BATCH.C */
/* int batch(char *, char *); - HBP */
int _getch(void);

/* prototypes for WHERE.C */
char *find_which(char *);

/* prototypes for EXEC.C */
int exec(const char *, char *, const unsigned);

/* prototypes for REDIR.C */

/* prototypes for ALIAS.C */
void aliasexpand(char *, int);
int aliasswapout(void);
int aliasswapin(void);
int cmd_alias(char *);

/* Prototypes for ERR_HAND.C */
void init_error_handler(void);
void printstring(char *);
char *get_err(unsigned);
void interrupt far dos_critical_error(unsigned, unsigned, unsigned, unsigned,
                       unsigned, unsigned, unsigned, unsigned, unsigned);

/* Prototypes for MISC.C */
#define MAXARGS 20
#define MAXLEN  256
int exist(const char *);
int chkCBreak(int);
int cgetchar(void);
int vcgetchar(void);
int vcgetcstr(const char *const legalCh);
char **split(char *s, int *args);
//int split(char *, char **);
void freep(char **);
char *parse_firstarg(char *);

/* Prototypes for ERROR.C */
void error_no_pipe(void);
void error_bad_command(void);
void error_invalid_drive(void);
void error_req_param_missing(void);
void error_sfile_not_found(char *);
void error_file_not_found(void);
void error_path_not_found(void);
void error_too_many_parameters(char *);
void error_invalid_switch(char);
void error_out_of_memory(void);
void error_syntax(char *);
void error_long_batchline(char *fnam, long linenr);
void error_bfile_vanished(char *fnam);
void error_bfile_no_such_label(char *fnam, char *label);
void error_env(void);
void error_env_var(char *);
void error_filename_too_long(char *fname);
void error_command_too_long(void);
void error_line_too_long(void);
void error_env_var_not_found(char *var);

void error_tempfile(void);
void error_close_quote(int);
void msg_pause(void);

/* [ HBP 16 Jul 1998   */

/* use the first line for debugging messages.  2nd for none. */
#ifdef DEBUG
#define dprintf(p)  printf p
#else
#define dprintf(p)
#endif

#define D_ON         "on"
#define D_OFF        "off"

/* Flags used in CMDTABLE */

#define CMD_SPECIAL     1
#define CMD_BATCHONLY   2

struct CMD
{
  char *name;
  int flags;
  int (*func) (char *);
  unsigned help_id;
};

/* New procs in BATCH.C */

char *readbatchline(int *, char *, int);
char *find_arg(int);

/* The MSDOS Batch Commands [MS-DOS 5.0 User's Guide and Reference p359] */
int cmd_call(char *);
int cmd_echo(char *);
int cmd_for(char *);
int cmd_goto(char *);
int cmd_if(char *);
int cmd_pause(char *);
int cmd_shift(char *);

int cmd_beep(char *);

int get_redirection(char *, char **, char **, int *);

int batch(char *, char *, char *);

void beep(void);
void beep_low(void);

/* functions to handle external strings */
void display_string(unsigned id,...);
int loadMsgs(void);
void uninitModuleStrings(void);
char *fetchString(unsigned id);
char *getMessage(unsigned id);

int showcmds(char *);

/* parse numbers */
char *parsenum(char *s, int maxCnt, int *cnt, int nums[]);
