/*
 *  TYPE.C - type internal command
 *
 *  Comments:
 *
 *  07/08/1998 (John P. Price)
 *    started.
 *
 *
 */

#include <stdio.h>
#include <string.h>

#include "command.h"

int
cmd_type(char *first, char *rest)
{
  char buf[128];
  FILE *f;

  if (strcmp(rest, "/?") == 0)
  {
    puts(
          "Displays the contents of text files.\n\n"
          "TYPE [drive:][path]filename"
        );
    return 0;
  }

  if (!*rest)
  {
    printf("Required parameter missing.\n");
    return 1;
  }

  if (strchr(rest, ' '))
  {
    printf("Too many parameters.\n");
    return 1;
  }

  if ((f = fopen(rest, "r")) == NULL)
  {
    printf("File not found - %s\n", rest);
    return 1;
  }

  while (fgets(buf, sizeof(buf), f))
  {
    fputs(buf, stdout);
  }
  fclose(f);

  return 0;
}
